/**
 * @file meta-object.h MetaObject API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_META_OBJECT_H_
#define _GALAGOD_META_OBJECT_H_

typedef struct _GalagodMetaObject      GalagodMetaObject;
typedef struct _GalagodMetaObjectClass GalagodMetaObjectClass;

#include <libgalago/galago.h>

#define GALAGOD_TYPE_META_OBJECT (galagod_meta_object_get_type())
#define GALAGOD_META_OBJECT(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGOD_TYPE_META_OBJECT, GalagodMetaObject))
#define GALAGOD_META_OBJECT_CLASS(klass) \
	(G_TYPE_CHECK_CLASS_CAST((klass), GALAGOD_TYPE_META_OBJECT, GalagodMetaObjectClass))
#define GALAGOD_IS_OBJECT(obj) \
	(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGOD_TYPE_META_OBJECT))
#define GALAGOD_IS_OBJECT_CLASS(klass) \
	(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGOD_TYPE_META_OBJECT))
#define GALAGOD_OBJECT_GET_CLASS(obj) \
	(G_TYPE_INSTANCE_GET_CLASS((obj), GALAGOD_TYPE_META_OBJECT, GalagodMetaObjectClass))

struct _GalagodMetaObject
{
	GalagoObject parent_object;

	GalagoObject *main_object;

	GList *children;
};

struct _GalagodMetaObjectClass
{
	GalagoObjectClass parent_class;

	void (*add_filter)(GalagoObject *object);
	void (*remove_filter)(GalagoObject *object);
};

void *galagod_meta_account_get_main_object(
	const GalagodMetaObject *meta_object);

const GList *galagod_meta_objects_get_children(
	const GalagodMetaObject *meta_object);

void galagod_meta_object_add_child(GalagodMetaObject *meta_object,
								   void *object);

void galagod_meta_object_remove_child(GalagodMetaObject *meta_object,
									  void *object);

#endif /* _GALAGOD_META_OBJECT_H_ */
