/* GADMIN-DHCPD - An easy to use GTK+ frontend for ISC DHCPD.
 * Copyright (C) 2004 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"

/* Wether or not to let the scope section expand */
#define EXPAND_SCOPE_SECTION FALSE

/* Wether or not to let the range section expand */
#define EXPAND_RANGE_SECTION FALSE

#include "scope_treeview_row_clicked.h"
#include "add_scope.h"
#include "delete_scope_from_btn.h"
#include "apply_scope_settings.h"
#include "loadbalance_window.h"



void create_scope_tab(struct w *widgets)
{
    GtkCellRenderer *scope_cell_renderer;
    GtkWidget *treeview_vbox;
    GtkWidget *scrolled_window;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Create the scopes treeview in a scrolled window */
    treeview_vbox = gtk_vbox_new(FALSE, 0);

    /* Add the scope treeview to the first stretchable vpaned widget */
    GtkWidget *vpaned = gtk_vpaned_new();
    gtk_paned_pack1(GTK_PANED(vpaned), treeview_vbox, 1, 1);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), vpaned, EXPAND_SCOPE_SECTION, FALSE, 0);

    scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(treeview_vbox), scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Set scrolled window size */
    gtk_widget_set_size_request(scrolled_window, -1, 80);

    widgets->scope_store = gtk_list_store_new(4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);

    widgets->scope_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_MODEL(widgets->scope_store));

    gtk_container_add(GTK_CONTAINER(scrolled_window), widgets->scope_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->scope_treeview), TRUE);

    /* Set the column labels in the treeview */
    scope_cell_renderer = gtk_cell_renderer_text_new();

    GtkTreeViewColumn *eth_col = gtk_tree_view_column_new_with_attributes(_("Network card"), scope_cell_renderer, "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(eth_col));

    GtkTreeViewColumn *subnet_col = gtk_tree_view_column_new_with_attributes(_("Network address"), scope_cell_renderer, "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(subnet_col));

    GtkTreeViewColumn *netmask_col = gtk_tree_view_column_new_with_attributes(_("Subnet mask"), scope_cell_renderer, "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(netmask_col));

    GtkTreeViewColumn *failover_col = gtk_tree_view_column_new_with_attributes(_("Loadbalancing server"), scope_cell_renderer, "text", 3, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->scope_treeview), GTK_TREE_VIEW_COLUMN(failover_col));

    /* Make the treeview sortable */
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(eth_col), 0);
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(subnet_col), 1);
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(netmask_col), 2);
    gtk_tree_view_column_set_sort_column_id(GTK_TREE_VIEW_COLUMN(failover_col), 3);

    g_signal_connect((gpointer)widgets->scope_treeview, "button_press_event",  
		      G_CALLBACK(scope_treeview_row_clicked), widgets);

    g_signal_connect(GTK_WINDOW(widgets->main_window), "delete_event", 
		     G_CALLBACK (gtk_main_quit), NULL);


    /* The add scope entries and the add, delete and apply buttons */
    GtkWidget *add_del_hbox = gtk_hbox_new(FALSE, FALSE);
    gtk_box_pack_start(GTK_BOX(treeview_vbox), add_del_hbox, FALSE, FALSE, 0);

    widgets->scope_add_nic_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->scope_add_nic_entry, FALSE, FALSE, 0);
    gtk_widget_set_size_request(widgets->scope_add_nic_entry, 85, -1);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_nic_entry, "eth0", NULL);

    widgets->scope_add_subnet_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->scope_add_subnet_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_subnet_entry, "192.168.0.0", NULL);

    widgets->scope_add_netmask_entry = gtk_entry_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), widgets->scope_add_netmask_entry, TRUE, TRUE, 0);
    gtk_tooltips_set_tip(tooltips, widgets->scope_add_netmask_entry, "255.255.255.0", NULL);


    /* A hbutton box for the add and delete scope buttons */
    GtkWidget *scope_add_hbuttonbox = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(add_del_hbox), scope_add_hbuttonbox, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(scope_add_hbuttonbox), GTK_BUTTONBOX_SPREAD);

    /* The add scope button */
    GtkWidget *scope_add_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    g_signal_connect_swapped(G_OBJECT(scope_add_button), "clicked", 
                             G_CALLBACK(add_scope), widgets);
    gtk_tooltips_set_tip(tooltips, scope_add_button, _("Add a new scope"), NULL);
    gtk_container_add(GTK_CONTAINER(scope_add_hbuttonbox), scope_add_button);

    /* The delete scope button */
    GtkWidget *scope_del_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    g_signal_connect_swapped(G_OBJECT(scope_del_button), "clicked", 
                             G_CALLBACK(delete_scope_from_btn), widgets);
    gtk_tooltips_set_tip(tooltips, scope_del_button, _("Delete the selected scope"), NULL);
    gtk_container_add(GTK_CONTAINER(scope_add_hbuttonbox), scope_del_button);

    /* Apply button */
    GtkWidget *scope_apply_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_container_add(GTK_CONTAINER(scope_add_hbuttonbox), scope_apply_button);
    g_signal_connect_swapped(G_OBJECT(scope_apply_button), "clicked", 
                                     G_CALLBACK(apply_scope_settings), widgets);

    /* A spacer at the end */
    GtkWidget *scope_spacer_label_del2 = gtk_label_new("");
    gtk_box_pack_start(GTK_BOX(add_del_hbox), scope_spacer_label_del2, FALSE, FALSE, 9);



    /* Range settings */
    widgets->range_vbox = gtk_vbox_new(TRUE, 0);

    /* Add the range settings to the second stretchable vpaned widget */
    gtk_paned_pack2(GTK_PANED(vpaned), widgets->range_vbox, 1, 1);

    GtkWidget *scrolled_range_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->range_vbox), scrolled_range_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_range_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

    /* Set scrolled window size */
    gtk_widget_set_size_request(scrolled_range_window, -1, 90);

    widgets->range_viewport = gtk_viewport_new(NULL, NULL);
    gtk_container_add(GTK_CONTAINER(scrolled_range_window), widgets->range_viewport);

    /* So it can be destroyed initially */
    widgets->range_scrolled_vbox = gtk_vbox_new(TRUE, 0);

    /* Scope and client settings */
    widgets->scope_set_vbox = gtk_vbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox1), widgets->scope_set_vbox, TRUE, TRUE, 0);

    GtkWidget *scope_set_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(widgets->scope_set_vbox), scope_set_scrolled_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scope_set_scrolled_window), 
								GTK_POLICY_AUTOMATIC, 
								GTK_POLICY_ALWAYS);

    widgets->scope_set_viewport = gtk_viewport_new(NULL, NULL);
    gtk_container_add(GTK_CONTAINER(scope_set_scrolled_window), widgets->scope_set_viewport);

    /* So it can be destroyed initially */
    widgets->scope_set_scrolled_vbox = gtk_vbox_new(TRUE, 0);
}
