/*
 * gAcc_print.c
 * Thomas Nemeth, le 09.02.2000
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <gtk/gtk.h>
#include "defines.h"
#include "structs.h" 
#include "gAcc_print.h"
#include "print_system.h"
#include "acclists.h"
#include "operations.h"
#include "gAcc_nyi.h"
#include "gAcc_opelist.h"

/*** Create the "Print" dialog box ****************************/

void print_ok_cb (GtkWidget *widget, void *data) {
    MY_LIST   *list = (MY_LIST *) data;
    ACCOUNT   *account;
    OPE_ELT   *ope_list;
    GtkWidget *dest_printer;
    GtkWidget *dest_printer_name;
    GtkWidget *dest_file_name;
    GtkWidget *type_ps;
    GtkWidget *colr;
    char      *method    = NULL;
    int        direction = PRINT_TO_PRINTER;

    account           = (ACCOUNT *)   my_list_get_element (list, 1);
    ope_list          = (OPE_ELT *)   my_list_get_element (list, 2);
    dest_printer      = (GtkWidget *) my_list_get_element (list, 3);
    dest_printer_name = (GtkWidget *) my_list_get_element (list, 4);
    dest_file_name    = (GtkWidget *) my_list_get_element (list, 5);
    type_ps           = (GtkWidget *) my_list_get_element (list, 6);
    colr              = (GtkWidget *) my_list_get_element (list, 7);
    #ifdef DEBUG_GACC
        if (GTK_TOGGLE_BUTTON (dest_printer) -> active ) {
            printf ("Printing to PRINTER %s, ",
                    gtk_entry_get_text (GTK_ENTRY (dest_printer_name) ) );
        } else {
            printf ("Printing to FILE %s, ",
                    gtk_entry_get_text (GTK_ENTRY (dest_file_name) ) );
        }
        if (GTK_TOGGLE_BUTTON (type_ps) -> active ) {
            printf ("format POSTSCRIPT %s.\n",
                    GTK_TOGGLE_BUTTON (colr) -> active ?
                    "(COLOR)" : "(GREYSCALE)");
        } else {
            printf ("format ASCII.\n");
        }
        if (ope_list != NULL) {
            char      *line;
            line = create_line_from_operation (ope_list->operation);
            printf ("first operation to be printed :\n");
            printf ("%s", line);
            free (line);
        } else {
            char      *line;
            line = create_line_from_operation (
                        account->ope_list_head->operation);
            printf ("first operation to be printed :\n");
            printf ("%s", line);
            free (line);
        }
    #endif
    if (GTK_TOGGLE_BUTTON (dest_printer) -> active ) {
        /* Printing to PRINTER */
        method    = gtk_entry_get_text (GTK_ENTRY (dest_printer_name) );
        direction = PRINT_TO_PRINTER;
    } else {
        /* Printing to FILE    */
        method    = gtk_entry_get_text (GTK_ENTRY (dest_file_name) );
        direction = PRINT_TO_FILE;
    }
    if (GTK_TOGGLE_BUTTON (type_ps) -> active ) {
        /* Format POSTSCRIPT   */
        /* NOT YET IMPLEMENTED ! */
        GtkWidget *nyi_dialog = create_nyi_dialog ();

        gtk_window_set_modal (GTK_WINDOW (nyi_dialog), TRUE);
        gtk_widget_show (GTK_WIDGET (nyi_dialog) );
        gtk_clist_unselect_all (GTK_CLIST (ope_clist) );
    } else {
        /* Format ASCII        */
        if (ope_list != NULL) {
            print_ascii_ope_list (direction, method, ope_list);
        } else {
            print_ascii_account (direction, method, account);
        }
    }
}

void print_cancel_cb (GtkWidget *widget, void *data) {
    gtk_widget_destroy ( (GtkWidget *) my_list_get_element (
                         (MY_LIST *) data, 0) );
    my_list_free ( (MY_LIST *) data);
}

void radio_my_dest_cb (GtkWidget *widget, GtkWidget *data) {
    #ifdef DEBUG_GACC
        printf ("Dans radio_my_dest_cb !\n");
    #endif
    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        gtk_widget_set_sensitive (data, TRUE);
    } else {
        gtk_widget_set_sensitive (data, FALSE);
    }
}

void radio_other_dest_cb (GtkWidget *widget, GtkWidget *data) {
    #ifdef DEBUG_GACC
        printf ("Dans radio_other_dest_cb !\n");
    #endif
    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        gtk_widget_set_sensitive (data, FALSE);
    } else {
        gtk_widget_set_sensitive (data, TRUE);
    }
}

void radio_printer_cb (GtkWidget *widget, GtkWidget *data) {
    char *print_command = NULL;
    char *prn_cmd;
    char *prn_opt;
    int   size = 0;
    #ifdef DEBUG_GACC
        printf ("Dans radio_printer_cb !\n");
    #endif
    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        /*gtk_entry_set_text (GTK_ENTRY (data), "lpr -Plp");*/
        prn_cmd = config.ps_prn_cmd;
        prn_opt = config.ps_prn_opt;
    } else {
        /*gtk_entry_set_text (GTK_ENTRY (data), "lpr -Pascii");*/
        prn_cmd = config.asc_prn_cmd;
        prn_opt = config.asc_prn_opt;
    }
    if (prn_cmd != NULL)
        size = strlen (prn_cmd);
    else
        printf (_("No print command defined !\n"));

    if (prn_opt != NULL) size = size + strlen (prn_cmd);

    MY_ALLOC (print_command, size + 2, char);
    strcpy (print_command, prn_cmd);
    strcat (print_command, " ");
    if (prn_opt != NULL) strcat (print_command, prn_opt);
    gtk_entry_set_text (GTK_ENTRY (data), print_command);
    free (print_command);
}

void radio_file_cb (GtkWidget *widget, GtkWidget *data) {
    char *filename = NULL;
    char *Home;
    #ifdef DEBUG_GACC
        printf ("Dans radio_file_cb !\n");
    #endif
    Home = getenv ("HOME");
    if (GTK_TOGGLE_BUTTON (widget) -> active) {
        MY_ALLOC (filename, (MAXSTRLEN + 1), char);
		sprintf (filename, "%s/%s",Home, "gacc.ps");
    } else {
        MY_ALLOC (filename, (MAXSTRLEN + 1), char);
		sprintf (filename, "%s/%s",Home, "gacc.txt");
    }
    gtk_entry_set_text (GTK_ENTRY (data), filename);
    free (filename);
}

GtkWidget *create_print_dialog (MY_LIST *inlist) {
    GtkWidget *Print_Dialog;
    GtkWidget *bouton;
    GtkWidget *hbox;
    GtkWidget *vbox;
    GtkWidget *frame;
    GtkWidget *printer_entry;
    GtkWidget *file_entry;
    GtkWidget *radio;
    GtkWidget *printer_radio;
    GtkWidget *file_radio;
    GtkWidget *check;
    ACCOUNT   *account         = (ACCOUNT *) my_list_get_element (inlist, 0);
    OPE_ELT   *operations_list = (OPE_ELT *) my_list_get_element (inlist, 1);
    MY_LIST   *list            = NULL;
    char      *print_command   = NULL;
    char      *filename        = NULL;
    char      *Home;

    Print_Dialog = gtk_dialog_new ();
    gtk_window_set_title (GTK_WINDOW (Print_Dialog), _("Print") );
    gtk_signal_connect (GTK_OBJECT (Print_Dialog), "delete_event",
                        GTK_SIGNAL_FUNC (gtk_widget_destroy),
                        NULL);
    gtk_signal_connect (GTK_OBJECT (Print_Dialog), "destroy", 
		                GTK_SIGNAL_FUNC (gtk_widget_destroy), 
		                NULL);

    list = my_list_add (list, Print_Dialog);
    list = my_list_add (list, account);
    list = my_list_add (list, operations_list);

    gtk_container_set_border_width (GTK_CONTAINER (GTK_DIALOG (Print_Dialog)->vbox), 6);

    /* Destination */
    frame = gtk_frame_new (_(" Destination : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* Printer */
    hbox = gtk_hbox_new (TRUE, 6);
    printer_radio = gtk_radio_button_new_with_label (
                            NULL, 
                            _("Printer : ") );
    gtk_box_pack_start (GTK_BOX (hbox), printer_radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printer_radio), TRUE);
    gtk_widget_show (printer_radio);

    printer_entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), printer_entry, TRUE, TRUE, 6);
    /*gtk_entry_set_text (GTK_ENTRY (printer_entry), "lpr -Plp");*/
    MY_ALLOC (print_command,  strlen (config.ps_prn_cmd)
                            + strlen (config.ps_prn_opt)
                            + 2, char);
    strcpy (print_command, config.ps_prn_cmd);
    strcat (print_command, " ");
    strcat (print_command, config.ps_prn_opt);
    gtk_entry_set_text (GTK_ENTRY (printer_entry), print_command);
    free (print_command);
    gtk_widget_show (printer_entry);

    list = my_list_add (list, printer_radio);
    list = my_list_add (list, printer_entry);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* File */
    hbox = gtk_hbox_new (TRUE, 6);
    file_radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (printer_radio) ),
                            _("File : ") );
    gtk_box_pack_start (GTK_BOX (hbox), file_radio, TRUE, TRUE, 6);
    gtk_widget_show (file_radio);

    file_entry = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox), file_entry, TRUE, TRUE, 6);
    /*gtk_entry_set_text (GTK_ENTRY (file_entry), "gacc.ps");*/
    Home = getenv ("HOME");
    MY_ALLOC (filename, (MAXSTRLEN + 1), char);
    sprintf (filename, "%s/%s",Home, "gacc.ps");
    gtk_entry_set_text (GTK_ENTRY (file_entry), filename);
    free (filename);
    gtk_widget_set_sensitive (GTK_WIDGET (file_entry), FALSE);
    gtk_widget_show (file_entry);

    list = my_list_add (list, file_entry);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    gtk_signal_connect (GTK_OBJECT (printer_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_dest_cb),
                        GTK_OBJECT (printer_entry) );
    gtk_signal_connect (GTK_OBJECT (printer_radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_other_dest_cb),
                        GTK_OBJECT (file_entry) );

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Print_Dialog)->vbox), frame,
                        TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    /* Format */
    frame = gtk_frame_new (_(" Format : ") );
    vbox  = gtk_vbox_new (TRUE, 6);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 6);

    /* PostScript */
    hbox = gtk_hbox_new (TRUE, 6);
    radio = gtk_radio_button_new_with_label (
                            NULL, 
                            _("PostScript") );
    gtk_box_pack_start (GTK_BOX (hbox), radio, TRUE, TRUE, 6);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radio), TRUE);
    gtk_widget_show (radio);

    check = gtk_check_button_new_with_label (_("Color") );
    gtk_box_pack_start (GTK_BOX (hbox), check, TRUE, TRUE, 6);
    gtk_widget_set_sensitive (GTK_WIDGET (check), FALSE);
    gtk_widget_show (check);

    gtk_signal_connect (GTK_OBJECT (radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_printer_cb),
                        GTK_OBJECT (printer_entry) );
    gtk_signal_connect (GTK_OBJECT (radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_file_cb),
                        GTK_OBJECT (file_entry) );
    gtk_signal_connect (GTK_OBJECT (radio), "clicked",
                        GTK_SIGNAL_FUNC (radio_my_dest_cb),
                        GTK_OBJECT (check) );

    list = my_list_add (list, radio);
    list = my_list_add (list, check);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    /* Text/ASCII */
    hbox = gtk_hbox_new (TRUE, 6);
    radio = gtk_radio_button_new_with_label (
                            gtk_radio_button_group (
                                GTK_RADIO_BUTTON (radio) ),
                            _("Text") );
    gtk_box_pack_start (GTK_BOX (hbox), radio, TRUE, TRUE, 6);
    gtk_widget_show (radio);

    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 6);
    gtk_widget_show (hbox);
    /* */

    gtk_container_add (GTK_CONTAINER (frame), vbox);
    gtk_widget_show (vbox);

    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Print_Dialog)->vbox), frame,
                        TRUE, TRUE, 6);
    gtk_widget_show (frame);
    /* - */

    bouton = gtk_button_new_with_label ( _("Print") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (print_ok_cb),
                        list);
    /*
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Print_Dialog) );
    */
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Print_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_grab_default (GTK_WIDGET (bouton) );
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);

    bouton = gtk_button_new_with_label ( _("Close") );
    gtk_signal_connect (GTK_OBJECT (bouton), "clicked",
                        GTK_SIGNAL_FUNC (print_cancel_cb),
                        list);
    /*
    gtk_signal_connect_object (GTK_OBJECT (bouton), "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (Print_Dialog) );
    */
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (Print_Dialog)->action_area), 
                        bouton, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (GTK_WIDGET (bouton), GTK_CAN_DEFAULT);
    gtk_widget_draw_default (GTK_WIDGET (bouton) );
    gtk_widget_show (bouton);


    my_list_free( inlist);

    return Print_Dialog;
}
