/* 

                          Firewall Builder

                 Copyright (C) 2006 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: AddressTableDialog.cpp,v 1.12 2007/04/14 00:18:43 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "config.h"
#include "global.h"
#include "utils.h"

#include "AddressTableDialog.h"
#include "SimpleTextView.h"
#include "ObjectManipulator.h"
#include "FWBSettings.h"
#include "FWWindow.h"

#include "fwbuilder/Library.h"
#include "fwbuilder/AddressTable.h"
#include "fwbuilder/Interface.h"
#include "fwbuilder/FWException.h"

#include <qlineedit.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qtextedit.h>
#include <qcombobox.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qcursor.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h> 
#include <qdir.h>


#include <iostream>

using namespace std;
using namespace libfwbuilder;

void AddressTableDialog::loadFWObject(FWObject *o)
{
    obj=o;
    AddressTable *s = dynamic_cast<AddressTable*>(obj);
    assert(s!=NULL);
    
    
    init=true;

    fillLibraries(libs,obj);

    obj_name->setText( QString::fromUtf8(s->getName().c_str()) );
    comment->setText( QString::fromUtf8(s->getComment().c_str()) );

    filename->setText( s->getSourceName().c_str() );
    r_compiletime->setChecked(s->isCompileTime() );
    r_runtime->setChecked(s->isRunTime() );

    //BrowseButton->setEnabled(s->isCompileTime() );
    
    //apply->setEnabled( false );

    obj_name->setEnabled(!o->isReadOnly());
    setDisabledPalette(obj_name);

    libs->setEnabled(!o->isReadOnly());
    setDisabledPalette(libs);

    filename->setEnabled(!o->isReadOnly());
    setDisabledPalette(filename);

    comment->setReadOnly(o->isReadOnly());
    setDisabledPalette(comment);

    init=false;
}
    
void AddressTableDialog::changed()
{
    //BrowseButton->setEnabled(r_compiletime->isChecked() );
    //apply->setEnabled( true );
    emit changed_sign();

}

void AddressTableDialog::validate(bool *res)
{
    *res=true;
    AddressTable *s = dynamic_cast<AddressTable*>(obj);
    assert(s!=NULL);

    if (!isTreeReadWrite(this,obj)) { *res=false; return; }
    if (!validateName(this,obj,obj_name->text())) { *res=false; return; }
}

void AddressTableDialog::isChanged(bool *res)
{
    //*res=(!init && apply->isEnabled());
}

void AddressTableDialog::libChanged()
{
    changed();
}

void AddressTableDialog::applyChanges()
{
    AddressTable *s = dynamic_cast<AddressTable*>(obj);
    assert(s!=NULL);

    string oldname=obj->getName();
    obj->setName( string(obj_name->text().utf8()) );
    obj->setComment( string(comment->text().utf8()) );
    QCString cs=filename->text().local8Bit();
    s->setSourceName( (const char *)cs );
    s->setRunTime(r_runtime->isChecked() );

    om->updateObjName(obj,QString::fromUtf8(oldname.c_str()));

    init=true;

/* move to another lib if we have to */
    if ( ! Interface::isA( obj->getParent() ) &&
         libs->currentText() != QString(obj->getLibrary()->getName().c_str()))
        om->moveObject(libs->currentText(), obj);

    init=false;

    //apply->setEnabled( false );
    om->updateLastModifiedTimestampForAllFirewalls(obj);
}

void AddressTableDialog::discardChanges()
{
    loadFWObject(obj);
}


void AddressTableDialog::closeEvent(QCloseEvent *e)
{
    if (fwbdebug)
        qDebug("AddressTableDialog::closeEvent  got close event: %p",e);
    emit close_sign(e);
}

void AddressTableDialog::browse()
{

    QString dir;
    dir=st->getWDir();
    if (dir.isEmpty())  dir=st->getOpenFileDir();
    if (dir.isEmpty())  dir="~";
    
    QString s = QFileDialog::getOpenFileName(
                    dir,
                    "All files (*.*)",
                    this,
                    "open file dialog",
                    "Choose a file" );
    
    if (!s.isEmpty())
    {
        filename->setText(s);
    }
}
void AddressTableDialog::preview( void )
{
    SimpleTextView tv(this);
    tv.setName(obj_name->text());
    
    QFile f;
    QTextStream ts;
    QString filePath = filename->text();

    if (QDir::isRelativePath(filePath))
        f.setName(getFileDir(mw->getCurrentFileName()) + "/" + filePath);
    else
        f.setName(filePath);

    if (f.exists())
    {
        if(f.open(IO_ReadOnly ))
        {
            ts.setDevice(&f);
            tv.setText(ts.read());
            f.close();
        }
    }
    else
    {
        tv.setText("File not found.");
    }
    tv.exec();
}

