#
#  fmt_info.pl
#
#  $Id: fmt_info.pl,v 1.1.1.1 1999/02/25 19:57:34 cvs Exp $
#
#  GNU Info-specific driver stuff
#
#   Copyright 1996, Cees de Groot
#
package SGMLTools::fmt_info;
use strict;

use SGMLTools::CharEnts;
use SGMLTools::Vars;

use File::Copy;

my $info = {};
$info->{NAME} = "info";
$info->{HELP} = "";
$info->{OPTIONS} = [
];
$info->{preNSGMLS} = sub {
  $global->{NsgmlsOpts} .= " -ifmtinfo ";
  $global->{NsgmlsPrePipe} = "sed 's/\@/\@\@/g' $global->{file}";
};

$Formats{$info->{NAME}} = $info;

# TeXi escape sub.  this is called-back by `parse_data' below in
# `texi_preASP' to properly escape `<' and `&' characters coming from
# the SGML source.
my %texi_escapes;

my $texi_escape = sub {
    my ($data) = @_;

    # replace the char with it's TeXi equivalent
    $data =~ s|([&<])|$texi_escapes{$1}|ge;

    return ($data);
};


#
#  Translate character entities and escape TeXi special chars.
#
$info->{preASP} = sub
{
  my ($infile, $outfile) = @_;
  # note the conversion of `sdata_dirs' list to an anonymous array to
  # make a single argument
  my $char_maps = load_char_maps ('.2texi', [ Text::EntityMap::sdata_dirs() ]);

  while (<$infile>)
    {
      if (/^-/)
        {
	    my ($str) = $';
	    chop ($str);
	    print $outfile "-" . parse_data ($str, $char_maps, $texi_escape) . "\n";
        }
      elsif (/^A/)
        {
	  /^A(\S+) (IMPLIED|CDATA|NOTATION|ENTITY|TOKEN)( (.*))?$/
	      || die "bad attribute data: $_\n";
	  my ($name,$type,$value) = ($1,$2,$4);
	  if ($type eq "CDATA")
	    {
	      # CDATA attributes get translated also
	      $value = parse_data ($value, $char_maps, $texi_escape);
	    }
	  print $outfile "A$name $type $value\n";
        }
      else
        {
	  print $outfile $_;
        }
    }
  return 0;
};

#
#  Take the sgmlsasp output, and make something
#  useful from it.
#
$info->{postASP} = sub
{
  my $infile = shift;
  my $outfile = new FileHandle ">$global->{tmpbase}.info.1";

  copy ($infile, $outfile); 
  $outfile->close;
  system ("gawk -v INFO=$global->{filename}.info -f $main::MyLibDir/info.awk $global->{tmpbase}.info.1 >$global->{tmpbase}.info.2");
  system ("makeinfo $global->{tmpbase}.info.2 -o $global->{filename}.info");

  return 0;
};

1;
