/*  FSLView - 2D/3D Interactive Image Viewer

    Authors:    Rama Aravind Vorray
		James Saunders
		David Flitney 
		Mark Jenkinson
		Stephen Smith

    FMRIB Image Analysis Group

    Copyright (C) 2002-2005 University of Oxford  */

/*  CCOPYRIGHT */

#include "preferences.h"
#include <stdlib.h>

using namespace std;

struct Preferences::Implementation
{
  Implementation() 
  {
    m_fsldir =   string(getenv("FSLDIR")      ? getenv("FSLDIR")      : "/usr/local/fsl");
    m_atlaspath = string(getenv("FSLATLASPATH") ? getenv("FSLATLASPATH") :  m_fsldir + "/data/atlases");
    m_mni = m_fsldir + "/data/standard/MNI152_T1_2mm.nii.gz";
  }
  
  std::string m_atlaspath;
  std::string m_fsldir;
  std::string m_mni;
};

Preferences::Handle Preferences::m_instance;

Preferences::Preferences(): m_impl(new Preferences::Implementation())
{
}

//! @brief Access Preferences singleton
//!
//! @return a handle to be used as a pointer to a Preferences object
Preferences::Handle Preferences::instance()
{
  if(!m_instance)
    m_instance = Preferences::Handle(new Preferences());

  return m_instance;
}

//! @brief Prefered value of FSLATLASPATH
//!
//! Returns vector of the prefered values of FSLATLASPATH or FSLDIR/lib/atlases
//!
//! @return The locations to look for atlas data sets
vector<string> Preferences::atlasPath() const
{
  vector<string> result;
  string delimiters(":");

  string str(m_impl->m_atlaspath);
  string::size_type lastPos = str.find_first_not_of(delimiters, 0);
  string::size_type pos = str.find_first_of(delimiters, lastPos);

  while (string::npos != pos || string::npos != lastPos)
    {
      result.push_back( str.substr(lastPos, pos - lastPos) );
      lastPos = str.find_first_not_of(delimiters, pos);
      pos = str.find_first_of(delimiters, lastPos);
    }
  
  return result;
}
   
//! @brief Prefered value of FSLDIR
//!
//! Returns the prefered value of FSLDIR
//!
//! @return The users prefered value of FSLDIR
string Preferences::FSLDir() const 
{
  return m_impl->m_fsldir; 
}

//! @brief Prefered location of mni152T1_brain
//!
//! Return the prefered location where we can find mni152T1_brain image
//!
//! @return The users prefered location for the mni152T1_brain image
string Preferences::mni152() const
{
  return m_impl->m_mni;
}

