/*  volume.h

    Mark Woolrich - FMRIB Image Analysis Group

    Copyright (C) 2002 University of Oxford  */

/*  CCOPYRIGHT  */

#if !defined(__volume_h)
#define __volume_h

#include <iostream>
#include <fstream>
#define WANT_STREAM
#define WANT_MATH

#include "newmatap.h"
#include "newmatio.h"
#include "volumeinfo.h"
#include <string>

using namespace NEWMAT;

namespace MISCMATHS { 
  
  class Volume : public ColumnVector
    {
    public:

      Volume() : ColumnVector() {}
      Volume(const VolumeInfo& pvolinfo, const ColumnVector& in) : 
	ColumnVector(),
	volinfo(pvolinfo),
	preThresholdPositions(in)
	{}
      Volume(int psize) : ColumnVector (psize) {}
      Volume(int psize,const VolumeInfo& pvolinfo, const ColumnVector& in) : 
	ColumnVector (psize), 
	volinfo(pvolinfo),
	preThresholdPositions(in){}
      Volume& operator=(const Volume& vol) {
	ColumnVector::operator=(vol);
	preThresholdPositions = vol.preThresholdPositions;
	volinfo = vol.volinfo;
	return *this;
      }
      Volume& operator=(const ColumnVector& pvec) { 
	ColumnVector::operator=(pvec); 
	return *this;
      }
      Volume& operator=(float pin) { 
	ColumnVector::operator=(pin); 
	return *this;
      }

      Volume(const ColumnVector& pvec) {ColumnVector::operator=(pvec);}
     
	  void read(const std::string& fname);

      void threshold(float thresh);
      void threshold();
      void unthreshold();
      void unthreshold(const VolumeInfo& pvolinfo, const ColumnVector& in);

      void writeAsInt(const std::string& fname);
      void writeAsFloat(const std::string& fname);

      const VolumeInfo& getInfo() const { return volinfo; }
      void setInfo(const VolumeInfo& pvolinfo) { volinfo = pvolinfo; }

      int getUnthresholdSize() const { return volinfo.x*volinfo.y*volinfo.z; }

      int getVolumeSize() const { return Nrows(); }

      const ColumnVector& getPreThresholdPositions() const { return preThresholdPositions; } 
      void setPreThresholdPositions(const ColumnVector& in) { preThresholdPositions = in; } 
    
    protected:
      VolumeInfo volinfo;
      ColumnVector preThresholdPositions;       
    };

}

#endif




