////////////////////////////////////////////////////////////////////////////
//	GENERATED FILE
//	INPUT FILE: src/HttpSessionBindingListener.java
//	TAGS USED: SERVLET_2_2
//
//	DO NOT EDIT!
////////////////////////////////////////////////////////////////////////////

/*
 * HttpSessionBindingListener.java -- Object wants to keep tabs on its values
 *                                    maintained by HttpSession
 *
 * Copyright (c) 1998, 1999 by Free Software Foundation, Inc.
 * Written by Paul Siegmann (pauls@euronet.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published
 * by the Free Software Foundation, version 2. (see COPYING.LIB)
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307 USA
 */

package javax.servlet.http;

import java.util.EventListener;

/**
 * Objects that implement this interface will be called when they are bound or
 * unbound into a <code>HttpSession</code> with a
 * <code>HttpSessionBindingEvent</code>.
 *
 * @see javax.servlet.http.HttpSession
 * @see javax.servlet.http.HttpSession#putValue(java.lang.String, java.lang.Object)
 * @see javax.servlet.http.HttpSession#removeValue(java.lang.String)
 * @see javax.servlet.http.HttpSession#invalidate()
 * @see javax.servlet.http.HttpSessionBindingEvent
 *
 * @version Servlet API 2.2
 * @since Servlet API 2.0
 */

public interface HttpSessionBindingListener
	extends EventListener
{
	/**
	 * Called when the object is bound to a session.
	 *
	 * @since Servlet API 2.0
	 *
	 * @param event The event object containing the name and session
	 */
    void	valueBound	(HttpSessionBindingEvent event);

	/**
	 * Called when the object is unbound from a session.
	 *
	 * @since Servlet API 2.0
	 *
	 * @param event The event object containing the name and session
	 */
    void	valueUnbound	(HttpSessionBindingEvent event);
}
