package freenet.support.test;
import junit.framework.*;
import freenet.support.Comparable;
import freenet.support.Heap;
import freenet.support.Heap.Element;
/**
 * A test class for the Heap.
 *
 */

public class HeapTest extends TestCase {

    public static final void main(String[] args) {
        SimpleTestRunner.main(
            new String[] { HeapTest.class.getName() }
        );
    }
    

    public HeapTest(String name) {
        super(name);
    }

    public void testHeap() {
        Heap hp = new Heap();
        int[] ints = { -6, -50, -45, 92, 36, 95, 9, -63, -52, 24, -76, 6, 71, 
                       43, 48, 71, -95, -73, -38, -80, -20, -21, 4, 34, -45, 
                       39, -19, 70, -17, 22, -46, 36 };
        for (int i = 0 ; i < ints.length ; i++) {
            hp.put(new IntElement(ints[i]));
        }
        assertEquals("Testing the heap size",hp.size(), 32);
        //        System.out.println(hp.toString());
        Comparable last = hp.pop();
        for (int i = 1 ; i < ints.length ; i++) {
            IntElement el = (IntElement) hp.pop();
            assertTrue("Testing heap order",last.compareTo(el) > -1);
            last = el;
        }

    }

    private class IntElement extends Heap.Element {
        private int i;
        public IntElement(int i) { IntElement.this.i = i; }
        public int compareTo(Object o) {
            int j = ((IntElement) o).i;
            return i == j ? 0 : (i > j ? 1 : -1); }
        public String toString() {
            return Integer.toString(i);
        }
    }




}
