package freenet.node.states.announcing;

import freenet.*;
import freenet.node.*;
import freenet.node.states.request.FeedbackToken;
import freenet.support.Logger;
import java.io.OutputStream;

/**
 * Logs the results of the initial request process after
 * announcing has completed.
 */
public class AnnouncementRequestToken implements FeedbackToken {

    private int attempts;
    private volatile int succeeded = 0,
                         failed = 0;

    AnnouncementRequestToken(int attempts) {
        this.attempts = attempts;
    }
    
    public void restarted(Node n, long millis) {}
    
    public void insertReply(Node n, long millis) {}
    
    public OutputStream dataFound(Node n, Storables sto, long ctLength) {
        return null;
    }
    
    public void queryRejected(Node n, int htl, String reason, FieldSet fs,
                              int unreachable, int restarted, int rejected) {
        ++failed;
        n.logger.log(this, "Failed "+failed+" of "+attempts
                           +" initial requests: "+reason, Logger.MINOR);
    }

    public void dataNotFound(Node n, long toq) {
        ++failed;
        n.logger.log(this, "Failed "+failed+" of "+attempts
                           +" initial requests: data not found", Logger.MINOR);
    }
    
    public void storeData(Node n, NodeReference nr, long rate) {
        ++succeeded;
        n.logger.log(this, "Succeeded with "+succeeded+" of "+attempts
                           +" initial requests", Logger.MINOR);
    }
}
    


