package freenet.message;
import freenet.*;
import freenet.node.*;
import freenet.support.*;
import java.lang.reflect.*;
/*
  This code is part of the Java Adaptive Network Client by Ian Clarke. 
  It is distributed under the GNU General Public Licence (GPL) 
  version 2.  See http://www.gnu.org/ for further details of the GPL.
 */

/**
 * This message is sent by a node which cannot locate a piece of data.
 * If received by a node, it should either forward it back to whichever
 * node sent the request to it, or should send another request to find
 * the data.
 *
 * @author <A HREF="mailto:I.Clarke@strs.co.uk">Ian Clarke</A>
 * @author <A HREF="mailto:author2@email.addr">Author 2</A>
 **/

public class QueryRejected extends NodeMessage {

    // Public Fields
    
    public final static String messageName = "QueryRejected";

 
    public long hopsToLive;
    // Amount the recieving node should attenuate routing to the
    // sending node. 
    // 0 means not at all.
    public long attenuation;
    public String reason;

    // Constructors

    public QueryRejected(ConnectionHandler source, 
                         RawMessage m) throws InvalidMessageException {
	super(source, m);
	String hopsString = otherFields.get("HopsToLive");
	if (hopsString == null || hopsString.equals("")) 
	    throw new InvalidMessageException("Can't find Hops To Live field");
	try {
	    hopsToLive = Fields.stringToLong(hopsString);
	} catch (NumberFormatException e) {
	    throw new InvalidMessageException("Failed to read number " + e);
	}

        // REDFLAG: get rid of backwards compatibility once the 
        //          required version number is bumped.
        // Backwards compatible.
        attenuation = 0;
        String attenuationString = otherFields.get("Attenuation");
	if (attenuationString != null) {
            try {
                attenuation = Fields.stringToLong(attenuationString);
            } catch (NumberFormatException e) {
                throw new InvalidMessageException("Failed to read number " + e);
            }
        }

        reason = otherFields.get("Reason");
        otherFields.remove("HopsToLive");
        otherFields.remove("Reason");
        otherFields.remove("Attenuation");
    }

    public QueryRejected(long idnum, long htl, FieldSet otherfields) {
	super(idnum ,otherfields);
	hopsToLive = htl;
        this.attenuation = 0;
    }

    public QueryRejected(long idnum, long htl, String reason,
                         FieldSet otherFields) {
        super(idnum, otherFields);
        hopsToLive = htl;
        this.attenuation = 0;
        this.reason = reason;
    }

    public QueryRejected(long idnum, long htl, long attenuation, String reason,
                         FieldSet otherFields) {
        super(idnum, otherFields);
        hopsToLive = htl;
        this.attenuation = attenuation;
        this.reason = reason;
    }


    // Public Methods

    public RawMessage toRawMessage(Presentation t) {
	RawMessage raw=super.toRawMessage(t);
	raw.fs.add("HopsToLive",Fields.longToString(hopsToLive));
	raw.fs.add("Attenuation",Fields.longToString(attenuation));
        if (reason != null)
            raw.fs.add("Reason",reason);
	//raw.messageType=messageName;
	return raw;
    }

    public String getMessageName() {
        return messageName;
    }

}


