package freenet.client.listeners;
import java.util.Vector;
import java.util.Enumeration;
import freenet.client.ClientEventListener;
import freenet.client.ClientEvent;
/**
 * A ClientEventListener that collects the events and returns them as an
 * enumeration.
 *
 * @author oskar
 */

public class CollectingEventListener implements ClientEventListener {

    private Vector events;

    public CollectingEventListener() {
        events = new Vector();
    }

    public void receive(ClientEvent ce) {
        events.addElement(ce);
    }

    public Enumeration events() {
        return events.elements();
    }
}
