package freenet.client;
import freenet.client.listeners.DoneListener;
import freenet.client.metadata.Metadata;
import freenet.client.metadata.DocumentCommand;
import freenet.client.metadata.InvalidPartException;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.ArrayBucket;
import freenet.client.events.GeneratedURIEvent;
import java.io.IOException;
/**
 * Handeles a series of requests to fill a bucket by traversing down
 * metadata redirections.
 *
 * @author oskar
 */
public class GetRequestProcess extends ControlRequestProcess {

    private Bucket metadataBucket;

    public GetRequestProcess(FreenetURI uri, int htl, Bucket data,
                             BucketFactory ptBuckets, int recursionLevel,
                             boolean follow) {
        super(uri, htl, data, ptBuckets, recursionLevel, follow);
    }


    public GetRequestProcess(FreenetURI uri, int htl, Bucket data,
                             BucketFactory ptBuckets, int recursionLevel) {
        super(uri, htl, data, ptBuckets, recursionLevel, true);
    }

    public synchronized Request getNextRequest() {
        if (aborted || failed)
            return null;
        if (dl == null) {
            metadataBucket = new ArrayBucket();
            //System.err.println("LALA REQUESTING URI: " + uri);
            r = new GetRequest(htl, uri, metadataBucket, data);
            dl = new DoneListener();
            r.addEventListener(dl);
            return r;
        } else {
            if (!nextLevel) {
                dl.strongWait();
                nextLevel = true;
                if (r.state() == r.DONE) {
                    try {
                        metadata = 
                            new Metadata(metadataBucket.getInputStream());
                        //System.err.println("LALA GOT MD: " + metadata);
                        if (follow) {
                            DocumentCommand d = 
                                (uri.getMetaString() == null ? 
                                 null : 
                                 metadata.getDocument(uri.getMetaString()));
                            FreenetURI nuri;
                            if (d != null) {
                                nuri = uri.popMetaString();
                            } else {
                                d = metadata.getDefaultDocument();
                                nuri = uri;
                            }
                            if (d != null)
                                next = d.getGetProcess(nuri, htl, data, 
                                                       ptBuckets, 
                                                       recursionLevel);
                        }
                    } catch (IOException e) {
                        return null;
                    } catch (InvalidPartException e) {
                        return null;
                    } 
                } else {
                    failed = true;
                    return null;
                }
            }
            if (next != null) {
                Request rr = next.getNextRequest();
                failed = next.failed();
                return rr;
            } else
                return null;
        }
    }

}

