/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SELECTIONRECTANGLE_H
#define SELECTIONRECTANGLE_H

#include <qcanvas.h>
#include <qtooltip.h>
#include "defs.h"
#include "pics/icons.h"
#include "qbuffer.h"
#include "qpicture.h"
/**
@author Predrag Viceic
*/
class SelectionRectangle : public QCanvasRectangle
{
public:
    SelectionRectangle(QCanvas* canvas);
    SelectionRectangle(long,int, int, int, int,QCanvas*,bool);

    ~SelectionRectangle();
    void setResizing(bool);
    bool getResizing();
    void setLeftSideResizing(bool);
    bool getLeftSideResizing();
    void setStartSamplePosition(long);
    long getStartSamplePosition();
    void setEndSamplePosition(long);
    long getEndSamplePosition();
    void setDisplayInfo(bool);
    void setMoving(bool);
    bool getMoving();
    QRect* getCenterRect();
    void setDrawHandles(bool tf);
    QRect* getLeftRect();
    QRect* getRightRect();
    QPointArray areaPoints() const;
    void computeText();
    void init(long,int,int,int,int);


protected:
    bool resizing;
    long start_sample_position;
    long end_sample_position;
    bool displayInfo;
    bool leftSideResizing;
    bool moving;
    void drawShape( QPainter & );
    QColor colorClear;
    QColor colorDark;
    QColor handleColor;
    QRect* centerRect;
    QRect* leftRect;
    QRect* rightRect;
    bool drawHandles;
    int areaPointsWidth;
    QString text;
    QFont font;
    QPicture pict;

};

#endif
