//
//	Mini modplug play example
//
//	(c) Copyright 2001,2002 by Lutz Sammer
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; only
//	version 2.1 of the License (not v2.2 or v3.x or whatever).
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	$Id: minimodplay.c,v 1.3 2002/03/20 22:39:06 johns Exp $

#include <stdio.h>
#include <stdlib.h>
#include "stdafx.h"
#include "sndfile.h"
#include "modplug.h"

/*
**	Converts a mod (or any from modplug supported) file from stdin to
**	stdout. The output format is raw PCM 16bit 44100khz stereo.
**
**	Usage:
**		./minimodplay < my.mod | rawplay
**
**	FIXME:	support command line options for the settings.
*/
int main(int argc __attribute__((unused)), char** argv __attribute__((unused)))
{
    char* buffer;
    int i;
    int size;
    ModPlug_Settings settings;
    ModPlugFile* file;

    ModPlug_GetSettings(&settings);
    settings.mFrequency=44100;
    settings.mBits=16;
    settings.mLoopCount=0;
    ModPlug_SetSettings(&settings);

    buffer=malloc(8192);
    size=0;

    while( (i=fread(buffer+size,1,8192,stdin))==8192 ) {
	size+=8192;
	buffer=realloc(buffer,size+8192);
    }
    size+=i;
    buffer=realloc(buffer,size);

    file=ModPlug_Load(buffer,size);
    if( !file ) {
	fprintf(stderr,"No mod file\n");
	exit(-1);
    }

    buffer=realloc(buffer,8192);
    do {
	i=ModPlug_Read(file,buffer,8192);
	fwrite(buffer,1,8192,stdout);
    } while( i==8192 );

    exit(0);
}
