# This file was generated by fedex_python.  You probably don't want to edit
# it since your modifications will be lost if fedex_plus is used to
# regenerate it.
import sys

from SCL.SCLBase import *
from SCL.SimpleDataTypes import *
from SCL.ConstructedDataTypes import *
from SCL.AggregationDataTypes import *
from SCL.TypeChecker import check_type
from SCL.Builtin import *
from SCL.Rules import *

schema_name = 'config_control_design'

schema_scope = sys.modules[__name__]

# SELECT TYPE characterized_definition
characterized_definition = SELECT(
	'characterized_product_definition',
	'shape_definition',
	scope = schema_scope)
# Defined datatype parameter_value
class parameter_value(REAL):
	def __init__(self,*kargs):
		pass

# Defined datatype plane_angle_measure
class plane_angle_measure(REAL):
	def __init__(self,*kargs):
		pass

# SELECT TYPE change_request_item
change_request_item = SELECT(
	'product_definition_formation',
	scope = schema_scope)
# Defined datatype text
class text(STRING):
	def __init__(self,*kargs):
		pass

# Defined datatype year_number
class year_number(INTEGER):
	def __init__(self,*kargs):
		pass

# SELECT TYPE characterized_product_definition
characterized_product_definition = SELECT(
	'product_definition',
	'product_definition_relationship',
	scope = schema_scope)
# SELECT TYPE reversible_topology_item
reversible_topology_item = SELECT(
	'edge',
	'path',
	'face',
	'face_bound',
	'closed_shell',
	'open_shell',
	scope = schema_scope)
# SELECT TYPE axis2_placement
axis2_placement = SELECT(
	'axis2_placement_2d',
	'axis2_placement_3d',
	scope = schema_scope)
set_of_reversible_topology_item = SET(0,None,'reversible_topology_item', scope = schema_scope)
# Defined datatype week_in_year_number
class week_in_year_number(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((1  <=  self)  and  (self  <=  53))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# Defined datatype knot_type
class knot_type(ENUMERATION):
	def __init__(self,*kargs):
		pass

# SELECT TYPE specified_item
specified_item = SELECT(
	'product_definition',
	'shape_aspect',
	scope = schema_scope)
# Defined datatype minute_in_hour
class minute_in_hour(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((0  <=  self)  and  (self  <=  59))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# Defined datatype transition_code
class transition_code(ENUMERATION):
	def __init__(self,*kargs):
		pass

# Defined datatype identifier
class identifier(STRING):
	def __init__(self,*kargs):
		pass

# SELECT TYPE measure_value
measure_value = SELECT(
	'length_measure',
	'mass_measure',
	'plane_angle_measure',
	'solid_angle_measure',
	'area_measure',
	'volume_measure',
	'parameter_value',
	'context_dependent_measure',
	'descriptive_measure',
	'positive_length_measure',
	'positive_plane_angle_measure',
	'count_measure',
	scope = schema_scope)
# SELECT TYPE person_organization_select
person_organization_select = SELECT(
	'person',
	'organization',
	'person_and_organization',
	scope = schema_scope)
# Defined datatype preferred_surface_curve_representation
class preferred_surface_curve_representation(ENUMERATION):
	def __init__(self,*kargs):
		pass

# Defined datatype dimension_count
class dimension_count(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = (self  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# SELECT TYPE pcurve_or_surface
pcurve_or_surface = SELECT(
	'pcurve',
	'surface',
	scope = schema_scope)

# Defined datatype length_measure
class length_measure(REAL):
	def __init__(self,*kargs):
		pass


# Defined datatype positive_length_measure
class positive_length_measure(length_measure):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = (self  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# Defined datatype b_spline_curve_form
class b_spline_curve_form(ENUMERATION):
	def __init__(self,*kargs):
		pass

# Defined datatype hour_in_day
class hour_in_day(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((0  <=  self)  and  (self  <  24))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# SELECT TYPE classified_item
classified_item = SELECT(
	'product_definition_formation',
	'assembly_component_usage',
	scope = schema_scope)
# Defined datatype si_unit_name
class si_unit_name(ENUMERATION):
	def __init__(self,*kargs):
		pass

# Defined datatype day_in_month_number
class day_in_month_number(INTEGER):
	def __init__(self,*kargs):
		pass

# SELECT TYPE founded_item_select
founded_item_select = SELECT(
	'founded_item',
	'representation_item',
	scope = schema_scope)
# Defined datatype trimming_preference
class trimming_preference(ENUMERATION):
	def __init__(self,*kargs):
		pass

# SELECT TYPE vector_or_direction
vector_or_direction = SELECT(
	'vector',
	'direction',
	scope = schema_scope)
# SELECT TYPE wireframe_model
wireframe_model = SELECT(
	'shell_based_wireframe_model',
	'edge_based_wireframe_model',
	scope = schema_scope)
# Defined datatype volume_measure
class volume_measure(REAL):
	def __init__(self,*kargs):
		pass

# SELECT TYPE geometric_set_select
geometric_set_select = SELECT(
	'point',
	'curve',
	'surface',
	scope = schema_scope)
# Defined datatype positive_plane_angle_measure
class positive_plane_angle_measure(plane_angle_measure):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = (self  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# SELECT TYPE start_request_item
start_request_item = SELECT(
	'product_definition_formation',
	scope = schema_scope)
# Defined datatype b_spline_surface_form
class b_spline_surface_form(ENUMERATION):
	def __init__(self,*kargs):
		pass

# SELECT TYPE person_organization_item
person_organization_item = SELECT(
	'change',
	'start_work',
	'change_request',
	'start_request',
	'configuration_item',
	'product',
	'product_definition_formation',
	'product_definition',
	'contract',
	'security_classification',
	scope = schema_scope)
# SELECT TYPE date_time_item
date_time_item = SELECT(
	'product_definition',
	'change_request',
	'start_request',
	'change',
	'start_work',
	'approval_person_organization',
	'contract',
	'security_classification',
	'certification',
	scope = schema_scope)
# SELECT TYPE shell
shell = SELECT(
	'vertex_shell',
	'wire_shell',
	'open_shell',
	'closed_shell',
	scope = schema_scope)
# SELECT TYPE transformation
transformation = SELECT(
	'item_defined_transformation',
	'functionally_defined_transformation',
	scope = schema_scope)
# Defined datatype day_in_week_number
class day_in_week_number(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((1  <=  self)  and  (self  <=  7))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# SELECT TYPE boolean_operand
boolean_operand = SELECT(
	'solid_model',
	scope = schema_scope)
# SELECT TYPE certified_item
certified_item = SELECT(
	'supplied_part_relationship',
	scope = schema_scope)
# SELECT TYPE date_time_select
date_time_select = SELECT(
	'date',
	'local_time',
	'date_and_time',
	scope = schema_scope)
# Defined datatype solid_angle_measure
class solid_angle_measure(REAL):
	def __init__(self,*kargs):
		pass

# SELECT TYPE curve_on_surface
curve_on_surface = SELECT(
	'pcurve',
	'surface_curve',
	'composite_curve_on_surface',
	scope = schema_scope)
# SELECT TYPE trimming_select
trimming_select = SELECT(
	'cartesian_point',
	'parameter_value',
	scope = schema_scope)
# Defined datatype ahead_or_behind
class ahead_or_behind(ENUMERATION):
	def __init__(self,*kargs):
		pass

# SELECT TYPE contracted_item
contracted_item = SELECT(
	'product_definition_formation',
	scope = schema_scope)
# Defined datatype day_in_year_number
class day_in_year_number(INTEGER):
	def __init__(self,*kargs):
		pass

# Defined datatype mass_measure
class mass_measure(REAL):
	def __init__(self,*kargs):
		pass

# Defined datatype descriptive_measure
class descriptive_measure(STRING):
	def __init__(self,*kargs):
		pass

# Defined datatype area_measure
class area_measure(REAL):
	def __init__(self,*kargs):
		pass

# Defined datatype month_in_year_number
class month_in_year_number(INTEGER):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((1  <=  self)  and  (self  <=  12))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# Defined datatype source
class source(ENUMERATION):
	def __init__(self,*kargs):
		pass

# SELECT TYPE unit
unit = SELECT(
	'named_unit',
	scope = schema_scope)
# SELECT TYPE reversible_topology
reversible_topology = SELECT(
	'reversible_topology_item',
	'list_of_reversible_topology_item',
	'set_of_reversible_topology_item',
	scope = schema_scope)
# SELECT TYPE work_item
work_item = SELECT(
	'product_definition_formation',
	scope = schema_scope)
# SELECT TYPE shape_definition
shape_definition = SELECT(
	'product_definition_shape',
	'shape_aspect',
	'shape_aspect_relationship',
	scope = schema_scope)
# Defined datatype second_in_minute
class second_in_minute(REAL):
	def __init__(self,*kargs):
		pass
		self.wr1()

	def wr1(self):
		eval_wr1_wr = ((0  <=  self)  and  (self  <  60))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

# Defined datatype label
class label(STRING):
	def __init__(self,*kargs):
		pass

# Defined datatype context_dependent_measure
class context_dependent_measure(REAL):
	def __init__(self,*kargs):
		pass

# SELECT TYPE supported_item
supported_item = SELECT(
	'action_directive',
	'action',
	'action_method',
	scope = schema_scope)
# Defined datatype si_prefix
class si_prefix(ENUMERATION):
	def __init__(self,*kargs):
		pass


# SELECT TYPE approved_item
approved_item = SELECT(
	'product_definition_formation',
	'product_definition',
	'configuration_effectivity',
	'configuration_item',
	'security_classification',
	'change_request',
	'change',
	'start_request',
	'start_work',
	'certification',
	'contract',
	scope = schema_scope)
# Defined datatype count_measure
class count_measure(NUMBER):
	def __init__(self,*kargs):
		pass

# SELECT TYPE surface_model
surface_model = SELECT(
	'shell_based_surface_model',
	scope = schema_scope)
list_of_reversible_topology_item = LIST(0,None,'reversible_topology_item', scope = schema_scope)

####################
 # ENTITY representation_item #
####################
class representation_item(BaseEntityClass):
	'''Entity representation_item definition.

	:param name
	:type name:label
	'''
	def __init__( self , name, ):
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(using_representations(self))  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY geometric_representation_item #
####################
class geometric_representation_item(representation_item):
	'''Entity geometric_representation_item definition.

	:param dim
	:type dim:dimension_count
	'''
	def __init__( self , inherited0__name ,  ):
		representation_item.__init__(self , inherited0__name , )

	@apply
	def dim():
		def fget( self ):
			attribute_eval = dimension_of(self)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument dim is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY functionally_defined_transformation #
####################
class functionally_defined_transformation(BaseEntityClass):
	'''Entity functionally_defined_transformation definition.

	:param name
	:type name:label

	:param description
	:type description:text
	'''
	def __init__( self , name,description, ):
		self.name = name
		self.description = description

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY cartesian_transformation_operator #
####################
class cartesian_transformation_operator(geometric_representation_item,functionally_defined_transformation):
	'''Entity cartesian_transformation_operator definition.

	:param axis1
	:type axis1:direction

	:param axis2
	:type axis2:direction

	:param local_origin
	:type local_origin:cartesian_point

	:param scale
	:type scale:REAL

	:param scl
	:type scl:REAL
	'''
	def __init__( self , inherited0__name , inherited1__name , inherited2__description , axis1,axis2,local_origin,scale, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		functionally_defined_transformation.__init__(self , inherited1__name , inherited2__description , )
		self.axis1 = axis1
		self.axis2 = axis2
		self.local_origin = local_origin
		self.scale = scale

	@apply
	def axis1():
		def fget( self ):
			return self._axis1
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._axis1 = direction(value)
				else:
					self._axis1 = value
			else:
				self._axis1 = value
		return property(**locals())

	@apply
	def axis2():
		def fget( self ):
			return self._axis2
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._axis2 = direction(value)
				else:
					self._axis2 = value
			else:
				self._axis2 = value
		return property(**locals())

	@apply
	def local_origin():
		def fget( self ):
			return self._local_origin
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument local_origin is mantatory and can not be set to None')
			if not check_type(value,cartesian_point):
				self._local_origin = cartesian_point(value)
			else:
				self._local_origin = value
		return property(**locals())

	@apply
	def scale():
		def fget( self ):
			return self._scale
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,REAL):
					self._scale = REAL(value)
				else:
					self._scale = value
			else:
				self._scale = value
		return property(**locals())

	@apply
	def scl():
		def fget( self ):
			attribute_eval = NVL(self.scale,1)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument scl is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.scl  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY cartesian_transformation_operator_3d #
####################
class cartesian_transformation_operator_3d(cartesian_transformation_operator):
	'''Entity cartesian_transformation_operator_3d definition.

	:param axis3
	:type axis3:direction

	:param u
	:type u:LIST(3,3,'direction', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__name , inherited2__description , inherited3__axis1 , inherited4__axis2 , inherited5__local_origin , inherited6__scale , axis3, ):
		cartesian_transformation_operator.__init__(self , inherited0__name , inherited1__name , inherited2__description , inherited3__axis1 , inherited4__axis2 , inherited5__local_origin , inherited6__scale , )
		self.axis3 = axis3

	@apply
	def axis3():
		def fget( self ):
			return self._axis3
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._axis3 = direction(value)
				else:
					self._axis3 = value
			else:
				self._axis3 = value
		return property(**locals())

	@apply
	def u():
		def fget( self ):
			attribute_eval = base_axis(3,self.self.cartesian_transformation_operator.self.axis1,self.self.cartesian_transformation_operator.self.axis2,self.axis3)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument u is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.geometric_representation_item.self.dim  ==  3)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY versioned_action_request #
####################
class versioned_action_request(BaseEntityClass):
	'''Entity versioned_action_request definition.

	:param id
	:type id:identifier

	:param version
	:type version:label

	:param purpose
	:type purpose:text

	:param description
	:type description:text
	'''
	def __init__( self , id,version,purpose,description, ):
		self.id = id
		self.version = version
		self.purpose = purpose
		self.description = description

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def version():
		def fget( self ):
			return self._version
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument version is mantatory and can not be set to None')
			if not check_type(value,label):
				self._version = label(value)
			else:
				self._version = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument purpose is mantatory and can not be set to None')
			if not check_type(value,text):
				self._purpose = text(value)
			else:
				self._purpose = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY representation #
####################
class representation(BaseEntityClass):
	'''Entity representation definition.

	:param name
	:type name:label

	:param items
	:type items:SET(1,None,'representation_item', scope = schema_scope)

	:param context_of_items
	:type context_of_items:representation_context
	'''
	def __init__( self , name,items,context_of_items, ):
		self.name = name
		self.items = items
		self.context_of_items = context_of_items

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'representation_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

	@apply
	def context_of_items():
		def fget( self ):
			return self._context_of_items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument context_of_items is mantatory and can not be set to None')
			if not check_type(value,representation_context):
				self._context_of_items = representation_context(value)
			else:
				self._context_of_items = value
		return property(**locals())

####################
 # ENTITY shape_representation #
####################
class shape_representation(representation):
	'''Entity shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )

####################
 # ENTITY manifold_surface_shape_representation #
####################
class manifold_surface_shape_representation(shape_representation):
	'''Entity manifold_surface_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >  0)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr

	def wr8(self):
		eval_wr8_wr = (SIZEOF(None)  ==  0)
		if not eval_wr8_wr:
			raise AssertionError('Rule wr8 violated')
		else:
			return eval_wr8_wr

	def wr9(self):
		eval_wr9_wr = (SIZEOF(None)  ==  0)
		if not eval_wr9_wr:
			raise AssertionError('Rule wr9 violated')
		else:
			return eval_wr9_wr

	def wr10(self):
		eval_wr10_wr = (SIZEOF(None)  ==  0)
		if not eval_wr10_wr:
			raise AssertionError('Rule wr10 violated')
		else:
			return eval_wr10_wr

	def wr11(self):
		eval_wr11_wr = (SIZEOF(None)  ==  0)
		if not eval_wr11_wr:
			raise AssertionError('Rule wr11 violated')
		else:
			return eval_wr11_wr

	def wr12(self):
		eval_wr12_wr = (SIZEOF(None)  ==  0)
		if not eval_wr12_wr:
			raise AssertionError('Rule wr12 violated')
		else:
			return eval_wr12_wr

	def wr13(self):
		eval_wr13_wr = (SIZEOF(None)  ==  0)
		if not eval_wr13_wr:
			raise AssertionError('Rule wr13 violated')
		else:
			return eval_wr13_wr

	def wr14(self):
		eval_wr14_wr = (SIZEOF(None)  ==  0)
		if not eval_wr14_wr:
			raise AssertionError('Rule wr14 violated')
		else:
			return eval_wr14_wr

	def wr15(self):
		eval_wr15_wr = (SIZEOF(None)  ==  0)
		if not eval_wr15_wr:
			raise AssertionError('Rule wr15 violated')
		else:
			return eval_wr15_wr


####################
 # ENTITY certification #
####################
class certification(BaseEntityClass):
	'''Entity certification definition.

	:param name
	:type name:label

	:param purpose
	:type purpose:text

	:param kind
	:type kind:certification_type
	'''
	def __init__( self , name,purpose,kind, ):
		self.name = name
		self.purpose = purpose
		self.kind = kind

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument purpose is mantatory and can not be set to None')
			if not check_type(value,text):
				self._purpose = text(value)
			else:
				self._purpose = value
		return property(**locals())

	@apply
	def kind():
		def fget( self ):
			return self._kind
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument kind is mantatory and can not be set to None')
			if not check_type(value,certification_type):
				self._kind = certification_type(value)
			else:
				self._kind = value
		return property(**locals())

####################
 # ENTITY product_definition_relationship #
####################
class product_definition_relationship(BaseEntityClass):
	'''Entity product_definition_relationship definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text

	:param relating_product_definition
	:type relating_product_definition:product_definition

	:param related_product_definition
	:type related_product_definition:product_definition
	'''
	def __init__( self , id,name,description,relating_product_definition,related_product_definition, ):
		self.id = id
		self.name = name
		self.description = description
		self.relating_product_definition = relating_product_definition
		self.related_product_definition = related_product_definition

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def relating_product_definition():
		def fget( self ):
			return self._relating_product_definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument relating_product_definition is mantatory and can not be set to None')
			if not check_type(value,product_definition):
				self._relating_product_definition = product_definition(value)
			else:
				self._relating_product_definition = value
		return property(**locals())

	@apply
	def related_product_definition():
		def fget( self ):
			return self._related_product_definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument related_product_definition is mantatory and can not be set to None')
			if not check_type(value,product_definition):
				self._related_product_definition = product_definition(value)
			else:
				self._related_product_definition = value
		return property(**locals())

####################
 # ENTITY product_definition_usage #
####################
class product_definition_usage(product_definition_relationship):
	'''Entity product_definition_usage definition.
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition ,  ):
		product_definition_relationship.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , )
	def wr1(self):
		eval_wr1_wr = acyclic_product_definition_relationship(self,[self.self.product_definition_relationship.self.related_product_definition],'CONFIG_CONTROL_DESIGN.PRODUCT_DEFINITION_USAGE')
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY assembly_component_usage #
####################
class assembly_component_usage(product_definition_usage):
	'''Entity assembly_component_usage definition.

	:param reference_designator
	:type reference_designator:identifier
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , reference_designator, ):
		product_definition_usage.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , )
		self.reference_designator = reference_designator

	@apply
	def reference_designator():
		def fget( self ):
			return self._reference_designator
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,identifier):
					self._reference_designator = identifier(value)
				else:
					self._reference_designator = value
			else:
				self._reference_designator = value
		return property(**locals())

####################
 # ENTITY quantified_assembly_component_usage #
####################
class quantified_assembly_component_usage(assembly_component_usage):
	'''Entity quantified_assembly_component_usage definition.

	:param quantity
	:type quantity:measure_with_unit
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , quantity, ):
		assembly_component_usage.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , )
		self.quantity = quantity

	@apply
	def quantity():
		def fget( self ):
			return self._quantity
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument quantity is mantatory and can not be set to None')
			if not check_type(value,measure_with_unit):
				self._quantity = measure_with_unit(value)
			else:
				self._quantity = value
		return property(**locals())

####################
 # ENTITY solid_model #
####################
class solid_model(geometric_representation_item):
	'''Entity solid_model definition.
	'''
	def __init__( self , inherited0__name ,  ):
		geometric_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY manifold_solid_brep #
####################
class manifold_solid_brep(solid_model):
	'''Entity manifold_solid_brep definition.

	:param outer
	:type outer:closed_shell
	'''
	def __init__( self , inherited0__name , outer, ):
		solid_model.__init__(self , inherited0__name , )
		self.outer = outer

	@apply
	def outer():
		def fget( self ):
			return self._outer
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument outer is mantatory and can not be set to None')
			if not check_type(value,closed_shell):
				self._outer = closed_shell(value)
			else:
				self._outer = value
		return property(**locals())

####################
 # ENTITY faceted_brep #
####################
class faceted_brep(manifold_solid_brep):
	'''Entity faceted_brep definition.
	'''
	def __init__( self , inherited0__name , inherited1__outer ,  ):
		manifold_solid_brep.__init__(self , inherited0__name , inherited1__outer , )

####################
 # ENTITY action_directive #
####################
class action_directive(BaseEntityClass):
	'''Entity action_directive definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param analysis
	:type analysis:text

	:param comment
	:type comment:text

	:param requests
	:type requests:SET(1,None,'versioned_action_request', scope = schema_scope)
	'''
	def __init__( self , name,description,analysis,comment,requests, ):
		self.name = name
		self.description = description
		self.analysis = analysis
		self.comment = comment
		self.requests = requests

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def analysis():
		def fget( self ):
			return self._analysis
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument analysis is mantatory and can not be set to None')
			if not check_type(value,text):
				self._analysis = text(value)
			else:
				self._analysis = value
		return property(**locals())

	@apply
	def comment():
		def fget( self ):
			return self._comment
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument comment is mantatory and can not be set to None')
			if not check_type(value,text):
				self._comment = text(value)
			else:
				self._comment = value
		return property(**locals())

	@apply
	def requests():
		def fget( self ):
			return self._requests
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument requests is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'versioned_action_request', scope = schema_scope)):
				self._requests = SET(value)
			else:
				self._requests = value
		return property(**locals())

####################
 # ENTITY named_unit #
####################
class named_unit(BaseEntityClass):
	'''Entity named_unit definition.

	:param dimensions
	:type dimensions:dimensional_exponents
	'''
	def __init__( self , dimensions, ):
		self.dimensions = dimensions

	@apply
	def dimensions():
		def fget( self ):
			return self._dimensions
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument dimensions is mantatory and can not be set to None')
			if not check_type(value,dimensional_exponents):
				self._dimensions = dimensional_exponents(value)
			else:
				self._dimensions = value
		return property(**locals())

####################
 # ENTITY plane_angle_unit #
####################
class plane_angle_unit(named_unit):
	'''Entity plane_angle_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  0)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY measure_with_unit #
####################
class measure_with_unit(BaseEntityClass):
	'''Entity measure_with_unit definition.

	:param value_component
	:type value_component:measure_value

	:param unit_component
	:type unit_component:unit
	'''
	def __init__( self , value_component,unit_component, ):
		self.value_component = value_component
		self.unit_component = unit_component

	@apply
	def value_component():
		def fget( self ):
			return self._value_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument value_component is mantatory and can not be set to None')
			if not check_type(value,measure_value):
				self._value_component = measure_value(value)
			else:
				self._value_component = value
		return property(**locals())

	@apply
	def unit_component():
		def fget( self ):
			return self._unit_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument unit_component is mantatory and can not be set to None')
			if not check_type(value,unit):
				self._unit_component = unit(value)
			else:
				self._unit_component = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = valid_units(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY area_measure_with_unit #
####################
class area_measure_with_unit(measure_with_unit):
	'''Entity area_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.AREA_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY effectivity #
####################
class effectivity(BaseEntityClass):
	'''Entity effectivity definition.

	:param id
	:type id:identifier
	'''
	def __init__( self , id, ):
		self.id = id

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

####################
 # ENTITY serial_numbered_effectivity #
####################
class serial_numbered_effectivity(effectivity):
	'''Entity serial_numbered_effectivity definition.

	:param effectivity_start_id
	:type effectivity_start_id:identifier

	:param effectivity_end_id
	:type effectivity_end_id:identifier
	'''
	def __init__( self , inherited0__id , effectivity_start_id,effectivity_end_id, ):
		effectivity.__init__(self , inherited0__id , )
		self.effectivity_start_id = effectivity_start_id
		self.effectivity_end_id = effectivity_end_id

	@apply
	def effectivity_start_id():
		def fget( self ):
			return self._effectivity_start_id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument effectivity_start_id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._effectivity_start_id = identifier(value)
			else:
				self._effectivity_start_id = value
		return property(**locals())

	@apply
	def effectivity_end_id():
		def fget( self ):
			return self._effectivity_end_id
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,identifier):
					self._effectivity_end_id = identifier(value)
				else:
					self._effectivity_end_id = value
			else:
				self._effectivity_end_id = value
		return property(**locals())

####################
 # ENTITY surface #
####################
class surface(geometric_representation_item):
	'''Entity surface definition.
	'''
	def __init__( self , inherited0__name ,  ):
		geometric_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY offset_surface #
####################
class offset_surface(surface):
	'''Entity offset_surface definition.

	:param basis_surface
	:type basis_surface:surface

	:param distance
	:type distance:length_measure

	:param self_intersect
	:type self_intersect:LOGICAL
	'''
	def __init__( self , inherited0__name , basis_surface,distance,self_intersect, ):
		surface.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.distance = distance
		self.self_intersect = self_intersect

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def distance():
		def fget( self ):
			return self._distance
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument distance is mantatory and can not be set to None')
			if not check_type(value,length_measure):
				self._distance = length_measure(value)
			else:
				self._distance = value
		return property(**locals())

	@apply
	def self_intersect():
		def fget( self ):
			return self._self_intersect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument self_intersect is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._self_intersect = LOGICAL(value)
			else:
				self._self_intersect = value
		return property(**locals())

####################
 # ENTITY placement #
####################
class placement(geometric_representation_item):
	'''Entity placement definition.

	:param location
	:type location:cartesian_point
	'''
	def __init__( self , inherited0__name , location, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.location = location

	@apply
	def location():
		def fget( self ):
			return self._location
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument location is mantatory and can not be set to None')
			if not check_type(value,cartesian_point):
				self._location = cartesian_point(value)
			else:
				self._location = value
		return property(**locals())

####################
 # ENTITY axis2_placement_2d #
####################
class axis2_placement_2d(placement):
	'''Entity axis2_placement_2d definition.

	:param ref_direction
	:type ref_direction:direction

	:param p
	:type p:LIST(2,2,'direction', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__location , ref_direction, ):
		placement.__init__(self , inherited0__name , inherited1__location , )
		self.ref_direction = ref_direction

	@apply
	def ref_direction():
		def fget( self ):
			return self._ref_direction
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._ref_direction = direction(value)
				else:
					self._ref_direction = value
			else:
				self._ref_direction = value
		return property(**locals())

	@apply
	def p():
		def fget( self ):
			attribute_eval = build_2axes(self.ref_direction)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument p is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.geometric_representation_item.self.dim  ==  2)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY product_category #
####################
class product_category(BaseEntityClass):
	'''Entity product_category definition.

	:param name
	:type name:label

	:param description
	:type description:text
	'''
	def __init__( self , name,description, ):
		self.name = name
		self.description = description

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,text):
					self._description = text(value)
				else:
					self._description = value
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY product_related_product_category #
####################
class product_related_product_category(product_category):
	'''Entity product_related_product_category definition.

	:param products
	:type products:SET(1,None,'product', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__description , products, ):
		product_category.__init__(self , inherited0__name , inherited1__description , )
		self.products = products

	@apply
	def products():
		def fget( self ):
			return self._products
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument products is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'product', scope = schema_scope)):
				self._products = SET(value)
			else:
				self._products = value
		return property(**locals())

####################
 # ENTITY curve #
####################
class curve(geometric_representation_item):
	'''Entity curve definition.
	'''
	def __init__( self , inherited0__name ,  ):
		geometric_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY conic #
####################
class conic(curve):
	'''Entity conic definition.

	:param position
	:type position:axis2_placement
	'''
	def __init__( self , inherited0__name , position, ):
		curve.__init__(self , inherited0__name , )
		self.position = position

	@apply
	def position():
		def fget( self ):
			return self._position
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument position is mantatory and can not be set to None')
			if not check_type(value,axis2_placement):
				self._position = axis2_placement(value)
			else:
				self._position = value
		return property(**locals())

####################
 # ENTITY hyperbola #
####################
class hyperbola(conic):
	'''Entity hyperbola definition.

	:param semi_axis
	:type semi_axis:positive_length_measure

	:param semi_imag_axis
	:type semi_imag_axis:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , semi_axis,semi_imag_axis, ):
		conic.__init__(self , inherited0__name , inherited1__position , )
		self.semi_axis = semi_axis
		self.semi_imag_axis = semi_imag_axis

	@apply
	def semi_axis():
		def fget( self ):
			return self._semi_axis
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument semi_axis is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._semi_axis = positive_length_measure(value)
			else:
				self._semi_axis = value
		return property(**locals())

	@apply
	def semi_imag_axis():
		def fget( self ):
			return self._semi_imag_axis
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument semi_imag_axis is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._semi_imag_axis = positive_length_measure(value)
			else:
				self._semi_imag_axis = value
		return property(**locals())

####################
 # ENTITY address #
####################
class address(BaseEntityClass):
	'''Entity address definition.

	:param internal_location
	:type internal_location:label

	:param street_number
	:type street_number:label

	:param street
	:type street:label

	:param postal_box
	:type postal_box:label

	:param town
	:type town:label

	:param region
	:type region:label

	:param postal_code
	:type postal_code:label

	:param country
	:type country:label

	:param facsimile_number
	:type facsimile_number:label

	:param telephone_number
	:type telephone_number:label

	:param electronic_mail_address
	:type electronic_mail_address:label

	:param telex_number
	:type telex_number:label
	'''
	def __init__( self , internal_location,street_number,street,postal_box,town,region,postal_code,country,facsimile_number,telephone_number,electronic_mail_address,telex_number, ):
		self.internal_location = internal_location
		self.street_number = street_number
		self.street = street
		self.postal_box = postal_box
		self.town = town
		self.region = region
		self.postal_code = postal_code
		self.country = country
		self.facsimile_number = facsimile_number
		self.telephone_number = telephone_number
		self.electronic_mail_address = electronic_mail_address
		self.telex_number = telex_number

	@apply
	def internal_location():
		def fget( self ):
			return self._internal_location
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._internal_location = label(value)
				else:
					self._internal_location = value
			else:
				self._internal_location = value
		return property(**locals())

	@apply
	def street_number():
		def fget( self ):
			return self._street_number
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._street_number = label(value)
				else:
					self._street_number = value
			else:
				self._street_number = value
		return property(**locals())

	@apply
	def street():
		def fget( self ):
			return self._street
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._street = label(value)
				else:
					self._street = value
			else:
				self._street = value
		return property(**locals())

	@apply
	def postal_box():
		def fget( self ):
			return self._postal_box
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._postal_box = label(value)
				else:
					self._postal_box = value
			else:
				self._postal_box = value
		return property(**locals())

	@apply
	def town():
		def fget( self ):
			return self._town
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._town = label(value)
				else:
					self._town = value
			else:
				self._town = value
		return property(**locals())

	@apply
	def region():
		def fget( self ):
			return self._region
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._region = label(value)
				else:
					self._region = value
			else:
				self._region = value
		return property(**locals())

	@apply
	def postal_code():
		def fget( self ):
			return self._postal_code
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._postal_code = label(value)
				else:
					self._postal_code = value
			else:
				self._postal_code = value
		return property(**locals())

	@apply
	def country():
		def fget( self ):
			return self._country
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._country = label(value)
				else:
					self._country = value
			else:
				self._country = value
		return property(**locals())

	@apply
	def facsimile_number():
		def fget( self ):
			return self._facsimile_number
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._facsimile_number = label(value)
				else:
					self._facsimile_number = value
			else:
				self._facsimile_number = value
		return property(**locals())

	@apply
	def telephone_number():
		def fget( self ):
			return self._telephone_number
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._telephone_number = label(value)
				else:
					self._telephone_number = value
			else:
				self._telephone_number = value
		return property(**locals())

	@apply
	def electronic_mail_address():
		def fget( self ):
			return self._electronic_mail_address
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._electronic_mail_address = label(value)
				else:
					self._electronic_mail_address = value
			else:
				self._electronic_mail_address = value
		return property(**locals())

	@apply
	def telex_number():
		def fget( self ):
			return self._telex_number
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._telex_number = label(value)
				else:
					self._telex_number = value
			else:
				self._telex_number = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (((((((((((EXISTS(self.internal_location)  or  EXISTS(self.street_number))  or  EXISTS(self.street))  or  EXISTS(self.postal_box))  or  EXISTS(self.town))  or  EXISTS(self.region))  or  EXISTS(self.postal_code))  or  EXISTS(self.country))  or  EXISTS(self.facsimile_number))  or  EXISTS(self.telephone_number))  or  EXISTS(self.electronic_mail_address))  or  EXISTS(self.telex_number))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY organizational_address #
####################
class organizational_address(address):
	'''Entity organizational_address definition.

	:param organizations
	:type organizations:SET(1,None,'organization', scope = schema_scope)

	:param description
	:type description:text
	'''
	def __init__( self , inherited0__internal_location , inherited1__street_number , inherited2__street , inherited3__postal_box , inherited4__town , inherited5__region , inherited6__postal_code , inherited7__country , inherited8__facsimile_number , inherited9__telephone_number , inherited10__electronic_mail_address , inherited11__telex_number , organizations,description, ):
		address.__init__(self , inherited0__internal_location , inherited1__street_number , inherited2__street , inherited3__postal_box , inherited4__town , inherited5__region , inherited6__postal_code , inherited7__country , inherited8__facsimile_number , inherited9__telephone_number , inherited10__electronic_mail_address , inherited11__telex_number , )
		self.organizations = organizations
		self.description = description

	@apply
	def organizations():
		def fget( self ):
			return self._organizations
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument organizations is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'organization', scope = schema_scope)):
				self._organizations = SET(value)
			else:
				self._organizations = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY bounded_surface #
####################
class bounded_surface(surface):
	'''Entity bounded_surface definition.
	'''
	def __init__( self , inherited0__name ,  ):
		surface.__init__(self , inherited0__name , )

####################
 # ENTITY b_spline_surface #
####################
class b_spline_surface(bounded_surface):
	'''Entity b_spline_surface definition.

	:param u_degree
	:type u_degree:INTEGER

	:param v_degree
	:type v_degree:INTEGER

	:param control_points_list
	:type control_points_list:LIST(2,None,LIST(2,None,'cartesian_point', scope = schema_scope))

	:param surface_form
	:type surface_form:b_spline_surface_form

	:param u_closed
	:type u_closed:LOGICAL

	:param v_closed
	:type v_closed:LOGICAL

	:param self_intersect
	:type self_intersect:LOGICAL

	:param u_upper
	:type u_upper:INTEGER

	:param v_upper
	:type v_upper:INTEGER

	:param control_points
	:type control_points:ARRAY(0,u_upper,ARRAY(0,v_upper,'cartesian_point', scope = schema_scope))
	'''
	def __init__( self , inherited0__name , u_degree,v_degree,control_points_list,surface_form,u_closed,v_closed,self_intersect, ):
		bounded_surface.__init__(self , inherited0__name , )
		self.u_degree = u_degree
		self.v_degree = v_degree
		self.control_points_list = control_points_list
		self.surface_form = surface_form
		self.u_closed = u_closed
		self.v_closed = v_closed
		self.self_intersect = self_intersect

	@apply
	def u_degree():
		def fget( self ):
			return self._u_degree
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_degree is mantatory and can not be set to None')
			if not check_type(value,INTEGER):
				self._u_degree = INTEGER(value)
			else:
				self._u_degree = value
		return property(**locals())

	@apply
	def v_degree():
		def fget( self ):
			return self._v_degree
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_degree is mantatory and can not be set to None')
			if not check_type(value,INTEGER):
				self._v_degree = INTEGER(value)
			else:
				self._v_degree = value
		return property(**locals())

	@apply
	def control_points_list():
		def fget( self ):
			return self._control_points_list
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument control_points_list is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,LIST(2,None,'cartesian_point', scope = schema_scope))):
				self._control_points_list = LIST(value)
			else:
				self._control_points_list = value
		return property(**locals())

	@apply
	def surface_form():
		def fget( self ):
			return self._surface_form
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument surface_form is mantatory and can not be set to None')
			if not check_type(value,b_spline_surface_form):
				self._surface_form = b_spline_surface_form(value)
			else:
				self._surface_form = value
		return property(**locals())

	@apply
	def u_closed():
		def fget( self ):
			return self._u_closed
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_closed is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._u_closed = LOGICAL(value)
			else:
				self._u_closed = value
		return property(**locals())

	@apply
	def v_closed():
		def fget( self ):
			return self._v_closed
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_closed is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._v_closed = LOGICAL(value)
			else:
				self._v_closed = value
		return property(**locals())

	@apply
	def self_intersect():
		def fget( self ):
			return self._self_intersect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument self_intersect is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._self_intersect = LOGICAL(value)
			else:
				self._self_intersect = value
		return property(**locals())

	@apply
	def u_upper():
		def fget( self ):
			attribute_eval = (SIZEOF(self.control_points_list) - 1)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument u_upper is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def v_upper():
		def fget( self ):
			attribute_eval = (SIZEOF(self.control_points_list[1]) - 1)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument v_upper is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def control_points():
		def fget( self ):
			attribute_eval = make_array_of_array(self.control_points_list,0,self.u_upper,0,self.v_upper)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument control_points is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (((('CONFIG_CONTROL_DESIGN.UNIFORM_SURFACE'  ==  TYPEOF(self))  or  ('CONFIG_CONTROL_DESIGN.QUASI_UNIFORM_SURFACE'  ==  TYPEOF(self)))  or  ('CONFIG_CONTROL_DESIGN.BEZIER_SURFACE'  ==  TYPEOF(self)))  or  ('CONFIG_CONTROL_DESIGN.B_SPLINE_SURFACE_WITH_KNOTS'  ==  TYPEOF(self)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY uniform_surface #
####################
class uniform_surface(b_spline_surface):
	'''Entity uniform_surface definition.
	'''
	def __init__( self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect ,  ):
		b_spline_surface.__init__(self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , )

####################
 # ENTITY geometrically_bounded_surface_shape_representation #
####################
class geometrically_bounded_surface_shape_representation(shape_representation):
	'''Entity geometrically_bounded_surface_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >  0)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  >  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr


####################
 # ENTITY axis1_placement #
####################
class axis1_placement(placement):
	'''Entity axis1_placement definition.

	:param axis
	:type axis:direction

	:param z
	:type z:direction
	'''
	def __init__( self , inherited0__name , inherited1__location , axis, ):
		placement.__init__(self , inherited0__name , inherited1__location , )
		self.axis = axis

	@apply
	def axis():
		def fget( self ):
			return self._axis
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._axis = direction(value)
				else:
					self._axis = value
			else:
				self._axis = value
		return property(**locals())

	@apply
	def z():
		def fget( self ):
			attribute_eval = NVL(normalise(self.axis),self.dummy_gri  ==  direction([0,0,1]))
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument z is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.geometric_representation_item.self.dim  ==  3)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY bounded_curve #
####################
class bounded_curve(curve):
	'''Entity bounded_curve definition.
	'''
	def __init__( self , inherited0__name ,  ):
		curve.__init__(self , inherited0__name , )

####################
 # ENTITY b_spline_curve #
####################
class b_spline_curve(bounded_curve):
	'''Entity b_spline_curve definition.

	:param degree
	:type degree:INTEGER

	:param control_points_list
	:type control_points_list:LIST(2,None,'cartesian_point', scope = schema_scope)

	:param curve_form
	:type curve_form:b_spline_curve_form

	:param closed_curve
	:type closed_curve:LOGICAL

	:param self_intersect
	:type self_intersect:LOGICAL

	:param upper_index_on_control_points
	:type upper_index_on_control_points:INTEGER

	:param control_points
	:type control_points:ARRAY(0,upper_index_on_control_points,'cartesian_point', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , degree,control_points_list,curve_form,closed_curve,self_intersect, ):
		bounded_curve.__init__(self , inherited0__name , )
		self.degree = degree
		self.control_points_list = control_points_list
		self.curve_form = curve_form
		self.closed_curve = closed_curve
		self.self_intersect = self_intersect

	@apply
	def degree():
		def fget( self ):
			return self._degree
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument degree is mantatory and can not be set to None')
			if not check_type(value,INTEGER):
				self._degree = INTEGER(value)
			else:
				self._degree = value
		return property(**locals())

	@apply
	def control_points_list():
		def fget( self ):
			return self._control_points_list
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument control_points_list is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'cartesian_point', scope = schema_scope)):
				self._control_points_list = LIST(value)
			else:
				self._control_points_list = value
		return property(**locals())

	@apply
	def curve_form():
		def fget( self ):
			return self._curve_form
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument curve_form is mantatory and can not be set to None')
			if not check_type(value,b_spline_curve_form):
				self._curve_form = b_spline_curve_form(value)
			else:
				self._curve_form = value
		return property(**locals())

	@apply
	def closed_curve():
		def fget( self ):
			return self._closed_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument closed_curve is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._closed_curve = LOGICAL(value)
			else:
				self._closed_curve = value
		return property(**locals())

	@apply
	def self_intersect():
		def fget( self ):
			return self._self_intersect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument self_intersect is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._self_intersect = LOGICAL(value)
			else:
				self._self_intersect = value
		return property(**locals())

	@apply
	def upper_index_on_control_points():
		def fget( self ):
			attribute_eval = (SIZEOF(self.control_points_list) - 1)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument upper_index_on_control_points is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def control_points():
		def fget( self ):
			attribute_eval = list_to_array(self.control_points_list,0,self.upper_index_on_control_points)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument control_points is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (((('CONFIG_CONTROL_DESIGN.UNIFORM_CURVE'  ==  TYPEOF(self))  or  ('CONFIG_CONTROL_DESIGN.QUASI_UNIFORM_CURVE'  ==  TYPEOF(self)))  or  ('CONFIG_CONTROL_DESIGN.BEZIER_CURVE'  ==  TYPEOF(self)))  or  ('CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE_WITH_KNOTS'  ==  TYPEOF(self)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY rational_b_spline_curve #
####################
class rational_b_spline_curve(b_spline_curve):
	'''Entity rational_b_spline_curve definition.

	:param weights_data
	:type weights_data:LIST(2,None,'REAL', scope = schema_scope)

	:param weights
	:type weights:ARRAY(0,upper_index_on_control_points,'REAL', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , weights_data, ):
		b_spline_curve.__init__(self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , )
		self.weights_data = weights_data

	@apply
	def weights_data():
		def fget( self ):
			return self._weights_data
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument weights_data is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'REAL', scope = schema_scope)):
				self._weights_data = LIST(value)
			else:
				self._weights_data = value
		return property(**locals())

	@apply
	def weights():
		def fget( self ):
			attribute_eval = list_to_array(self.weights_data,0,self.upper_index_on_control_points)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument weights is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.weights_data)  ==  SIZEOF(self.self.b_spline_curve.self.control_points_list))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = curve_weights_positive(self)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY action_request_assignment #
####################
class action_request_assignment(BaseEntityClass):
	'''Entity action_request_assignment definition.

	:param assigned_action_request
	:type assigned_action_request:versioned_action_request
	'''
	def __init__( self , assigned_action_request, ):
		self.assigned_action_request = assigned_action_request

	@apply
	def assigned_action_request():
		def fget( self ):
			return self._assigned_action_request
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_action_request is mantatory and can not be set to None')
			if not check_type(value,versioned_action_request):
				self._assigned_action_request = versioned_action_request(value)
			else:
				self._assigned_action_request = value
		return property(**locals())

####################
 # ENTITY topological_representation_item #
####################
class topological_representation_item(representation_item):
	'''Entity topological_representation_item definition.
	'''
	def __init__( self , inherited0__name ,  ):
		representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY face_bound #
####################
class face_bound(topological_representation_item):
	'''Entity face_bound definition.

	:param bound
	:type bound:loop

	:param orientation
	:type orientation:BOOLEAN
	'''
	def __init__( self , inherited0__name , bound,orientation, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.bound = bound
		self.orientation = orientation

	@apply
	def bound():
		def fget( self ):
			return self._bound
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument bound is mantatory and can not be set to None')
			if not check_type(value,loop):
				self._bound = loop(value)
			else:
				self._bound = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

####################
 # ENTITY length_measure_with_unit #
####################
class length_measure_with_unit(measure_with_unit):
	'''Entity length_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.LENGTH_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY dated_effectivity #
####################
class dated_effectivity(effectivity):
	'''Entity dated_effectivity definition.

	:param effectivity_start_date
	:type effectivity_start_date:date_and_time

	:param effectivity_end_date
	:type effectivity_end_date:date_and_time
	'''
	def __init__( self , inherited0__id , effectivity_start_date,effectivity_end_date, ):
		effectivity.__init__(self , inherited0__id , )
		self.effectivity_start_date = effectivity_start_date
		self.effectivity_end_date = effectivity_end_date

	@apply
	def effectivity_start_date():
		def fget( self ):
			return self._effectivity_start_date
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument effectivity_start_date is mantatory and can not be set to None')
			if not check_type(value,date_and_time):
				self._effectivity_start_date = date_and_time(value)
			else:
				self._effectivity_start_date = value
		return property(**locals())

	@apply
	def effectivity_end_date():
		def fget( self ):
			return self._effectivity_end_date
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,date_and_time):
					self._effectivity_end_date = date_and_time(value)
				else:
					self._effectivity_end_date = value
			else:
				self._effectivity_end_date = value
		return property(**locals())

####################
 # ENTITY direction #
####################
class direction(geometric_representation_item):
	'''Entity direction definition.

	:param direction_ratios
	:type direction_ratios:LIST(2,3,'REAL', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , direction_ratios, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.direction_ratios = direction_ratios

	@apply
	def direction_ratios():
		def fget( self ):
			return self._direction_ratios
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument direction_ratios is mantatory and can not be set to None')
			if not check_type(value,LIST(2,3,'REAL', scope = schema_scope)):
				self._direction_ratios = LIST(value)
			else:
				self._direction_ratios = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY next_assembly_usage_occurrence #
####################
class next_assembly_usage_occurrence(assembly_component_usage):
	'''Entity next_assembly_usage_occurrence definition.
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator ,  ):
		assembly_component_usage.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , )

####################
 # ENTITY edge #
####################
class edge(topological_representation_item):
	'''Entity edge definition.

	:param edge_start
	:type edge_start:vertex

	:param edge_end
	:type edge_end:vertex
	'''
	def __init__( self , inherited0__name , edge_start,edge_end, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.edge_start = edge_start
		self.edge_end = edge_end

	@apply
	def edge_start():
		def fget( self ):
			return self._edge_start
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument edge_start is mantatory and can not be set to None')
			if not check_type(value,vertex):
				self._edge_start = vertex(value)
			else:
				self._edge_start = value
		return property(**locals())

	@apply
	def edge_end():
		def fget( self ):
			return self._edge_end
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument edge_end is mantatory and can not be set to None')
			if not check_type(value,vertex):
				self._edge_end = vertex(value)
			else:
				self._edge_end = value
		return property(**locals())

####################
 # ENTITY oriented_edge #
####################
class oriented_edge(edge):
	'''Entity oriented_edge definition.

	:param edge_element
	:type edge_element:edge

	:param orientation
	:type orientation:BOOLEAN

	:param edge_edge_start
	:type edge_edge_start:vertex

	:param edge_edge_end
	:type edge_edge_end:vertex
	'''
	def __init__( self , inherited0__name , inherited1__edge_start , inherited2__edge_end , edge_element,orientation, ):
		edge.__init__(self , inherited0__name , inherited1__edge_start , inherited2__edge_end , )
		self.edge_element = edge_element
		self.orientation = orientation

	@apply
	def edge_element():
		def fget( self ):
			return self._edge_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument edge_element is mantatory and can not be set to None')
			if not check_type(value,edge):
				self._edge_element = edge(value)
			else:
				self._edge_element = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def edge_edge_start():
		def fget( self ):
			attribute_eval = boolean_choose(self.self.orientation,self.self.edge_element.self.edge_start,self.self.edge_element.self.edge_end)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument edge_edge_start is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def edge_edge_end():
		def fget( self ):
			attribute_eval = boolean_choose(self.self.orientation,self.self.edge_element.self.edge_end,self.self.edge_element.self.edge_start)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument edge_edge_end is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.ORIENTED_EDGE'  ==  TYPEOF(self.self.edge_element)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY person #
####################
class person(BaseEntityClass):
	'''Entity person definition.

	:param id
	:type id:identifier

	:param last_name
	:type last_name:label

	:param first_name
	:type first_name:label

	:param middle_names
	:type middle_names:LIST(1,None,'STRING', scope = schema_scope)

	:param prefix_titles
	:type prefix_titles:LIST(1,None,'STRING', scope = schema_scope)

	:param suffix_titles
	:type suffix_titles:LIST(1,None,'STRING', scope = schema_scope)
	'''
	def __init__( self , id,last_name,first_name,middle_names,prefix_titles,suffix_titles, ):
		self.id = id
		self.last_name = last_name
		self.first_name = first_name
		self.middle_names = middle_names
		self.prefix_titles = prefix_titles
		self.suffix_titles = suffix_titles

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def last_name():
		def fget( self ):
			return self._last_name
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._last_name = label(value)
				else:
					self._last_name = value
			else:
				self._last_name = value
		return property(**locals())

	@apply
	def first_name():
		def fget( self ):
			return self._first_name
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._first_name = label(value)
				else:
					self._first_name = value
			else:
				self._first_name = value
		return property(**locals())

	@apply
	def middle_names():
		def fget( self ):
			return self._middle_names
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,LIST(1,None,'STRING', scope = schema_scope)):
					self._middle_names = LIST(value)
				else:
					self._middle_names = value
			else:
				self._middle_names = value
		return property(**locals())

	@apply
	def prefix_titles():
		def fget( self ):
			return self._prefix_titles
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,LIST(1,None,'STRING', scope = schema_scope)):
					self._prefix_titles = LIST(value)
				else:
					self._prefix_titles = value
			else:
				self._prefix_titles = value
		return property(**locals())

	@apply
	def suffix_titles():
		def fget( self ):
			return self._suffix_titles
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,LIST(1,None,'STRING', scope = schema_scope)):
					self._suffix_titles = LIST(value)
				else:
					self._suffix_titles = value
			else:
				self._suffix_titles = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (EXISTS(self.last_name)  or  EXISTS(self.first_name))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY document #
####################
class document(BaseEntityClass):
	'''Entity document definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text

	:param kind
	:type kind:document_type
	'''
	def __init__( self , id,name,description,kind, ):
		self.id = id
		self.name = name
		self.description = description
		self.kind = kind

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def kind():
		def fget( self ):
			return self._kind
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument kind is mantatory and can not be set to None')
			if not check_type(value,document_type):
				self._kind = document_type(value)
			else:
				self._kind = value
		return property(**locals())

####################
 # ENTITY document_with_class #
####################
class document_with_class(document):
	'''Entity document_with_class definition.

	:param class_
	:type class_:identifier
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__kind , class_, ):
		document.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__kind , )
		self.class_ = class_

	@apply
	def class_():
		def fget( self ):
			return self._class_
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument class_ is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._class_ = identifier(value)
			else:
				self._class_ = value
		return property(**locals())

####################
 # ENTITY conversion_based_unit #
####################
class conversion_based_unit(named_unit):
	'''Entity conversion_based_unit definition.

	:param name
	:type name:label

	:param conversion_factor
	:type conversion_factor:measure_with_unit
	'''
	def __init__( self , inherited0__dimensions , name,conversion_factor, ):
		named_unit.__init__(self , inherited0__dimensions , )
		self.name = name
		self.conversion_factor = conversion_factor

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def conversion_factor():
		def fget( self ):
			return self._conversion_factor
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument conversion_factor is mantatory and can not be set to None')
			if not check_type(value,measure_with_unit):
				self._conversion_factor = measure_with_unit(value)
			else:
				self._conversion_factor = value
		return property(**locals())

####################
 # ENTITY point #
####################
class point(geometric_representation_item):
	'''Entity point definition.
	'''
	def __init__( self , inherited0__name ,  ):
		geometric_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY point_on_surface #
####################
class point_on_surface(point):
	'''Entity point_on_surface definition.

	:param basis_surface
	:type basis_surface:surface

	:param point_parameter_u
	:type point_parameter_u:parameter_value

	:param point_parameter_v
	:type point_parameter_v:parameter_value
	'''
	def __init__( self , inherited0__name , basis_surface,point_parameter_u,point_parameter_v, ):
		point.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.point_parameter_u = point_parameter_u
		self.point_parameter_v = point_parameter_v

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def point_parameter_u():
		def fget( self ):
			return self._point_parameter_u
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument point_parameter_u is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._point_parameter_u = parameter_value(value)
			else:
				self._point_parameter_u = value
		return property(**locals())

	@apply
	def point_parameter_v():
		def fget( self ):
			return self._point_parameter_v
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument point_parameter_v is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._point_parameter_v = parameter_value(value)
			else:
				self._point_parameter_v = value
		return property(**locals())

####################
 # ENTITY product_definition_formation #
####################
class product_definition_formation(BaseEntityClass):
	'''Entity product_definition_formation definition.

	:param id
	:type id:identifier

	:param description
	:type description:text

	:param of_product
	:type of_product:product
	'''
	def __init__( self , id,description,of_product, ):
		self.id = id
		self.description = description
		self.of_product = of_product

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def of_product():
		def fget( self ):
			return self._of_product
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument of_product is mantatory and can not be set to None')
			if not check_type(value,product):
				self._of_product = product(value)
			else:
				self._of_product = value
		return property(**locals())

####################
 # ENTITY person_and_organization_assignment #
####################
class person_and_organization_assignment(BaseEntityClass):
	'''Entity person_and_organization_assignment definition.

	:param assigned_person_and_organization
	:type assigned_person_and_organization:person_and_organization

	:param role
	:type role:person_and_organization_role
	'''
	def __init__( self , assigned_person_and_organization,role, ):
		self.assigned_person_and_organization = assigned_person_and_organization
		self.role = role

	@apply
	def assigned_person_and_organization():
		def fget( self ):
			return self._assigned_person_and_organization
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_person_and_organization is mantatory and can not be set to None')
			if not check_type(value,person_and_organization):
				self._assigned_person_and_organization = person_and_organization(value)
			else:
				self._assigned_person_and_organization = value
		return property(**locals())

	@apply
	def role():
		def fget( self ):
			return self._role
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument role is mantatory and can not be set to None')
			if not check_type(value,person_and_organization_role):
				self._role = person_and_organization_role(value)
			else:
				self._role = value
		return property(**locals())

####################
 # ENTITY cc_design_person_and_organization_assignment #
####################
class cc_design_person_and_organization_assignment(person_and_organization_assignment):
	'''Entity cc_design_person_and_organization_assignment definition.

	:param items
	:type items:SET(1,None,'person_organization_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_person_and_organization , inherited1__role , items, ):
		person_and_organization_assignment.__init__(self , inherited0__assigned_person_and_organization , inherited1__role , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'person_organization_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = cc_design_person_and_organization_correlation(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY offset_curve_3d #
####################
class offset_curve_3d(curve):
	'''Entity offset_curve_3d definition.

	:param basis_curve
	:type basis_curve:curve

	:param distance
	:type distance:length_measure

	:param self_intersect
	:type self_intersect:LOGICAL

	:param ref_direction
	:type ref_direction:direction
	'''
	def __init__( self , inherited0__name , basis_curve,distance,self_intersect,ref_direction, ):
		curve.__init__(self , inherited0__name , )
		self.basis_curve = basis_curve
		self.distance = distance
		self.self_intersect = self_intersect
		self.ref_direction = ref_direction

	@apply
	def basis_curve():
		def fget( self ):
			return self._basis_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._basis_curve = curve(value)
			else:
				self._basis_curve = value
		return property(**locals())

	@apply
	def distance():
		def fget( self ):
			return self._distance
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument distance is mantatory and can not be set to None')
			if not check_type(value,length_measure):
				self._distance = length_measure(value)
			else:
				self._distance = value
		return property(**locals())

	@apply
	def self_intersect():
		def fget( self ):
			return self._self_intersect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument self_intersect is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._self_intersect = LOGICAL(value)
			else:
				self._self_intersect = value
		return property(**locals())

	@apply
	def ref_direction():
		def fget( self ):
			return self._ref_direction
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument ref_direction is mantatory and can not be set to None')
			if not check_type(value,direction):
				self._ref_direction = direction(value)
			else:
				self._ref_direction = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ((self.basis_curve.self.dim  ==  3)  and  (self.ref_direction.self.dim  ==  3))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY approval #
####################
class approval(BaseEntityClass):
	'''Entity approval definition.

	:param status
	:type status:approval_status

	:param level
	:type level:label
	'''
	def __init__( self , status,level, ):
		self.status = status
		self.level = level

	@apply
	def status():
		def fget( self ):
			return self._status
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument status is mantatory and can not be set to None')
			if not check_type(value,approval_status):
				self._status = approval_status(value)
			else:
				self._status = value
		return property(**locals())

	@apply
	def level():
		def fget( self ):
			return self._level
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument level is mantatory and can not be set to None')
			if not check_type(value,label):
				self._level = label(value)
			else:
				self._level = value
		return property(**locals())

####################
 # ENTITY composite_curve #
####################
class composite_curve(bounded_curve):
	'''Entity composite_curve definition.

	:param segments
	:type segments:LIST(1,None,'composite_curve_segment', scope = schema_scope)

	:param self_intersect
	:type self_intersect:LOGICAL

	:param n_segments
	:type n_segments:INTEGER

	:param closed_curve
	:type closed_curve:LOGICAL
	'''
	def __init__( self , inherited0__name , segments,self_intersect, ):
		bounded_curve.__init__(self , inherited0__name , )
		self.segments = segments
		self.self_intersect = self_intersect

	@apply
	def segments():
		def fget( self ):
			return self._segments
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument segments is mantatory and can not be set to None')
			if not check_type(value,LIST(1,None,'composite_curve_segment', scope = schema_scope)):
				self._segments = LIST(value)
			else:
				self._segments = value
		return property(**locals())

	@apply
	def self_intersect():
		def fget( self ):
			return self._self_intersect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument self_intersect is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._self_intersect = LOGICAL(value)
			else:
				self._self_intersect = value
		return property(**locals())

	@apply
	def n_segments():
		def fget( self ):
			attribute_eval = SIZEOF(self.segments)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument n_segments is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def closed_curve():
		def fget( self ):
			attribute_eval = (self.segments[self.n_segments].self.transition  !=  discontinuous)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument closed_curve is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ((( not self.closed_curve)  and  (SIZEOF(None)  ==  1))  or  (self.closed_curve  and  (SIZEOF(None)  ==  0)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY composite_curve_on_surface #
####################
class composite_curve_on_surface(composite_curve):
	'''Entity composite_curve_on_surface definition.

	:param basis_surface
	:type basis_surface:SET(0,2,'surface', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__segments , inherited2__self_intersect ,  ):
		composite_curve.__init__(self , inherited0__name , inherited1__segments , inherited2__self_intersect , )

	@apply
	def basis_surface():
		def fget( self ):
			attribute_eval = get_basis_surface(self)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument basis_surface is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.basis_surface)  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = constraints_composite_curve_on_surface(self)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY boundary_curve #
####################
class boundary_curve(composite_curve_on_surface):
	'''Entity boundary_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__segments , inherited2__self_intersect ,  ):
		composite_curve_on_surface.__init__(self , inherited0__name , inherited1__segments , inherited2__self_intersect , )
	def wr1(self):
		eval_wr1_wr = self.self.composite_curve.self.closed_curve
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY representation_context #
####################
class representation_context(BaseEntityClass):
	'''Entity representation_context definition.

	:param context_identifier
	:type context_identifier:identifier

	:param context_type
	:type context_type:text

	:param representations_in_context
	:type representations_in_context:SET(1,None,'representation', scope = schema_scope)
	'''
	def __init__( self , context_identifier,context_type, ):
		self.context_identifier = context_identifier
		self.context_type = context_type

	@apply
	def context_identifier():
		def fget( self ):
			return self._context_identifier
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument context_identifier is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._context_identifier = identifier(value)
			else:
				self._context_identifier = value
		return property(**locals())

	@apply
	def context_type():
		def fget( self ):
			return self._context_type
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument context_type is mantatory and can not be set to None')
			if not check_type(value,text):
				self._context_type = text(value)
			else:
				self._context_type = value
		return property(**locals())

	@apply
	def representations_in_context():
		def fget( self ):
			return self._representations_in_context
		def fset( self, value ):
		# INVERSE argument
			raise AssertionError('Argument representations_in_context is INVERSE. It is computed and can not be set to any value')
		return property(**locals())

####################
 # ENTITY geometric_representation_context #
####################
class geometric_representation_context(representation_context):
	'''Entity geometric_representation_context definition.

	:param coordinate_space_dimension
	:type coordinate_space_dimension:dimension_count
	'''
	def __init__( self , inherited0__context_identifier , inherited1__context_type , coordinate_space_dimension, ):
		representation_context.__init__(self , inherited0__context_identifier , inherited1__context_type , )
		self.coordinate_space_dimension = coordinate_space_dimension

	@apply
	def coordinate_space_dimension():
		def fget( self ):
			return self._coordinate_space_dimension
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument coordinate_space_dimension is mantatory and can not be set to None')
			if not check_type(value,dimension_count):
				self._coordinate_space_dimension = dimension_count(value)
			else:
				self._coordinate_space_dimension = value
		return property(**locals())

####################
 # ENTITY action_status #
####################
class action_status(BaseEntityClass):
	'''Entity action_status definition.

	:param status
	:type status:label

	:param assigned_action
	:type assigned_action:executed_action
	'''
	def __init__( self , status,assigned_action, ):
		self.status = status
		self.assigned_action = assigned_action

	@apply
	def status():
		def fget( self ):
			return self._status
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument status is mantatory and can not be set to None')
			if not check_type(value,label):
				self._status = label(value)
			else:
				self._status = value
		return property(**locals())

	@apply
	def assigned_action():
		def fget( self ):
			return self._assigned_action
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_action is mantatory and can not be set to None')
			if not check_type(value,executed_action):
				self._assigned_action = executed_action(value)
			else:
				self._assigned_action = value
		return property(**locals())

####################
 # ENTITY application_context #
####################
class application_context(BaseEntityClass):
	'''Entity application_context definition.

	:param application
	:type application:text

	:param context_elements
	:type context_elements:SET(1,None,'application_context_element', scope = schema_scope)
	'''
	def __init__( self , application, ):
		self.application = application

	@apply
	def application():
		def fget( self ):
			return self._application
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument application is mantatory and can not be set to None')
			if not check_type(value,text):
				self._application = text(value)
			else:
				self._application = value
		return property(**locals())

	@apply
	def context_elements():
		def fget( self ):
			return self._context_elements
		def fset( self, value ):
		# INVERSE argument
			raise AssertionError('Argument context_elements is INVERSE. It is computed and can not be set to any value')
		return property(**locals())

####################
 # ENTITY change_request #
####################
class change_request(action_request_assignment):
	'''Entity change_request definition.

	:param items
	:type items:SET(1,None,'change_request_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_action_request , items, ):
		action_request_assignment.__init__(self , inherited0__assigned_action_request , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'change_request_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY date_and_time #
####################
class date_and_time(BaseEntityClass):
	'''Entity date_and_time definition.

	:param date_component
	:type date_component:date

	:param time_component
	:type time_component:local_time
	'''
	def __init__( self , date_component,time_component, ):
		self.date_component = date_component
		self.time_component = time_component

	@apply
	def date_component():
		def fget( self ):
			return self._date_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument date_component is mantatory and can not be set to None')
			if not check_type(value,date):
				self._date_component = date(value)
			else:
				self._date_component = value
		return property(**locals())

	@apply
	def time_component():
		def fget( self ):
			return self._time_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument time_component is mantatory and can not be set to None')
			if not check_type(value,local_time):
				self._time_component = local_time(value)
			else:
				self._time_component = value
		return property(**locals())

####################
 # ENTITY approval_date_time #
####################
class approval_date_time(BaseEntityClass):
	'''Entity approval_date_time definition.

	:param date_time
	:type date_time:date_time_select

	:param dated_approval
	:type dated_approval:approval
	'''
	def __init__( self , date_time,dated_approval, ):
		self.date_time = date_time
		self.dated_approval = dated_approval

	@apply
	def date_time():
		def fget( self ):
			return self._date_time
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument date_time is mantatory and can not be set to None')
			if not check_type(value,date_time_select):
				self._date_time = date_time_select(value)
			else:
				self._date_time = value
		return property(**locals())

	@apply
	def dated_approval():
		def fget( self ):
			return self._dated_approval
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument dated_approval is mantatory and can not be set to None')
			if not check_type(value,approval):
				self._dated_approval = approval(value)
			else:
				self._dated_approval = value
		return property(**locals())

####################
 # ENTITY approval_role #
####################
class approval_role(BaseEntityClass):
	'''Entity approval_role definition.

	:param role
	:type role:label
	'''
	def __init__( self , role, ):
		self.role = role

	@apply
	def role():
		def fget( self ):
			return self._role
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument role is mantatory and can not be set to None')
			if not check_type(value,label):
				self._role = label(value)
			else:
				self._role = value
		return property(**locals())

####################
 # ENTITY application_context_element #
####################
class application_context_element(BaseEntityClass):
	'''Entity application_context_element definition.

	:param name
	:type name:label

	:param frame_of_reference
	:type frame_of_reference:application_context
	'''
	def __init__( self , name,frame_of_reference, ):
		self.name = name
		self.frame_of_reference = frame_of_reference

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def frame_of_reference():
		def fget( self ):
			return self._frame_of_reference
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument frame_of_reference is mantatory and can not be set to None')
			if not check_type(value,application_context):
				self._frame_of_reference = application_context(value)
			else:
				self._frame_of_reference = value
		return property(**locals())

####################
 # ENTITY product_context #
####################
class product_context(application_context_element):
	'''Entity product_context definition.

	:param discipline_type
	:type discipline_type:label
	'''
	def __init__( self , inherited0__name , inherited1__frame_of_reference , discipline_type, ):
		application_context_element.__init__(self , inherited0__name , inherited1__frame_of_reference , )
		self.discipline_type = discipline_type

	@apply
	def discipline_type():
		def fget( self ):
			return self._discipline_type
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument discipline_type is mantatory and can not be set to None')
			if not check_type(value,label):
				self._discipline_type = label(value)
			else:
				self._discipline_type = value
		return property(**locals())

####################
 # ENTITY elementary_surface #
####################
class elementary_surface(surface):
	'''Entity elementary_surface definition.

	:param position
	:type position:axis2_placement_3d
	'''
	def __init__( self , inherited0__name , position, ):
		surface.__init__(self , inherited0__name , )
		self.position = position

	@apply
	def position():
		def fget( self ):
			return self._position
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument position is mantatory and can not be set to None')
			if not check_type(value,axis2_placement_3d):
				self._position = axis2_placement_3d(value)
			else:
				self._position = value
		return property(**locals())

####################
 # ENTITY spherical_surface #
####################
class spherical_surface(elementary_surface):
	'''Entity spherical_surface definition.

	:param radius
	:type radius:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , radius, ):
		elementary_surface.__init__(self , inherited0__name , inherited1__position , )
		self.radius = radius

	@apply
	def radius():
		def fget( self ):
			return self._radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument radius is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._radius = positive_length_measure(value)
			else:
				self._radius = value
		return property(**locals())

####################
 # ENTITY application_protocol_definition #
####################
class application_protocol_definition(BaseEntityClass):
	'''Entity application_protocol_definition definition.

	:param status
	:type status:label

	:param application_interpreted_model_schema_name
	:type application_interpreted_model_schema_name:label

	:param application_protocol_year
	:type application_protocol_year:year_number

	:param application
	:type application:application_context
	'''
	def __init__( self , status,application_interpreted_model_schema_name,application_protocol_year,application, ):
		self.status = status
		self.application_interpreted_model_schema_name = application_interpreted_model_schema_name
		self.application_protocol_year = application_protocol_year
		self.application = application

	@apply
	def status():
		def fget( self ):
			return self._status
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument status is mantatory and can not be set to None')
			if not check_type(value,label):
				self._status = label(value)
			else:
				self._status = value
		return property(**locals())

	@apply
	def application_interpreted_model_schema_name():
		def fget( self ):
			return self._application_interpreted_model_schema_name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument application_interpreted_model_schema_name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._application_interpreted_model_schema_name = label(value)
			else:
				self._application_interpreted_model_schema_name = value
		return property(**locals())

	@apply
	def application_protocol_year():
		def fget( self ):
			return self._application_protocol_year
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument application_protocol_year is mantatory and can not be set to None')
			if not check_type(value,year_number):
				self._application_protocol_year = year_number(value)
			else:
				self._application_protocol_year = value
		return property(**locals())

	@apply
	def application():
		def fget( self ):
			return self._application
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument application is mantatory and can not be set to None')
			if not check_type(value,application_context):
				self._application = application_context(value)
			else:
				self._application = value
		return property(**locals())

####################
 # ENTITY specified_higher_usage_occurrence #
####################
class specified_higher_usage_occurrence(assembly_component_usage):
	'''Entity specified_higher_usage_occurrence definition.

	:param upper_usage
	:type upper_usage:assembly_component_usage

	:param next_usage
	:type next_usage:next_assembly_usage_occurrence
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , upper_usage,next_usage, ):
		assembly_component_usage.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , )
		self.upper_usage = upper_usage
		self.next_usage = next_usage

	@apply
	def upper_usage():
		def fget( self ):
			return self._upper_usage
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument upper_usage is mantatory and can not be set to None')
			if not check_type(value,assembly_component_usage):
				self._upper_usage = assembly_component_usage(value)
			else:
				self._upper_usage = value
		return property(**locals())

	@apply
	def next_usage():
		def fget( self ):
			return self._next_usage
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument next_usage is mantatory and can not be set to None')
			if not check_type(value,next_assembly_usage_occurrence):
				self._next_usage = next_assembly_usage_occurrence(value)
			else:
				self._next_usage = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self  !=  self.upper_usage)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (self.self.product_definition_relationship.self.relating_product_definition  ==  self.upper_usage.self.relating_product_definition)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (self.self.product_definition_relationship.self.related_product_definition  ==  self.next_usage.self.related_product_definition)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (self.upper_usage.self.related_product_definition  ==  self.next_usage.self.relating_product_definition)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = ( not ('CONFIG_CONTROL_DESIGN.PROMISSORY_USAGE_OCCURRENCE'  ==  TYPEOF(self.upper_usage)))
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr


####################
 # ENTITY product_definition_formation_with_specified_source #
####################
class product_definition_formation_with_specified_source(product_definition_formation):
	'''Entity product_definition_formation_with_specified_source definition.

	:param make_or_buy
	:type make_or_buy:source
	'''
	def __init__( self , inherited0__id , inherited1__description , inherited2__of_product , make_or_buy, ):
		product_definition_formation.__init__(self , inherited0__id , inherited1__description , inherited2__of_product , )
		self.make_or_buy = make_or_buy

	@apply
	def make_or_buy():
		def fget( self ):
			return self._make_or_buy
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument make_or_buy is mantatory and can not be set to None')
			if not check_type(value,source):
				self._make_or_buy = source(value)
			else:
				self._make_or_buy = value
		return property(**locals())

####################
 # ENTITY action_request_solution #
####################
class action_request_solution(BaseEntityClass):
	'''Entity action_request_solution definition.

	:param method
	:type method:action_method

	:param request
	:type request:versioned_action_request
	'''
	def __init__( self , method,request, ):
		self.method = method
		self.request = request

	@apply
	def method():
		def fget( self ):
			return self._method
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument method is mantatory and can not be set to None')
			if not check_type(value,action_method):
				self._method = action_method(value)
			else:
				self._method = value
		return property(**locals())

	@apply
	def request():
		def fget( self ):
			return self._request
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument request is mantatory and can not be set to None')
			if not check_type(value,versioned_action_request):
				self._request = versioned_action_request(value)
			else:
				self._request = value
		return property(**locals())

####################
 # ENTITY uncertainty_measure_with_unit #
####################
class uncertainty_measure_with_unit(measure_with_unit):
	'''Entity uncertainty_measure_with_unit definition.

	:param name
	:type name:label

	:param description
	:type description:text
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component , name,description, ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
		self.name = name
		self.description = description

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = valid_measure_value(self.self.measure_with_unit.self.value_component)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY edge_based_wireframe_model #
####################
class edge_based_wireframe_model(geometric_representation_item):
	'''Entity edge_based_wireframe_model definition.

	:param ebwm_boundary
	:type ebwm_boundary:SET(1,None,'connected_edge_set', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , ebwm_boundary, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.ebwm_boundary = ebwm_boundary

	@apply
	def ebwm_boundary():
		def fget( self ):
			return self._ebwm_boundary
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument ebwm_boundary is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'connected_edge_set', scope = schema_scope)):
				self._ebwm_boundary = SET(value)
			else:
				self._ebwm_boundary = value
		return property(**locals())

####################
 # ENTITY path #
####################
class path(topological_representation_item):
	'''Entity path definition.

	:param edge_list
	:type edge_list:LIST(1,None,'oriented_edge', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , edge_list, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.edge_list = edge_list

	@apply
	def edge_list():
		def fget( self ):
			return self._edge_list
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument edge_list is mantatory and can not be set to None')
			if not check_type(value,LIST(1,None,'oriented_edge', scope = schema_scope)):
				self._edge_list = LIST(value)
			else:
				self._edge_list = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = path_head_to_tail(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY connected_face_set #
####################
class connected_face_set(topological_representation_item):
	'''Entity connected_face_set definition.

	:param cfs_faces
	:type cfs_faces:SET(1,None,'face', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , cfs_faces, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.cfs_faces = cfs_faces

	@apply
	def cfs_faces():
		def fget( self ):
			return self._cfs_faces
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument cfs_faces is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'face', scope = schema_scope)):
				self._cfs_faces = SET(value)
			else:
				self._cfs_faces = value
		return property(**locals())

####################
 # ENTITY open_shell #
####################
class open_shell(connected_face_set):
	'''Entity open_shell definition.
	'''
	def __init__( self , inherited0__name , inherited1__cfs_faces ,  ):
		connected_face_set.__init__(self , inherited0__name , inherited1__cfs_faces , )

####################
 # ENTITY oriented_open_shell #
####################
class oriented_open_shell(open_shell):
	'''Entity oriented_open_shell definition.

	:param open_shell_element
	:type open_shell_element:open_shell

	:param orientation
	:type orientation:BOOLEAN

	:param connected_face_set_cfs_faces
	:type connected_face_set_cfs_faces:SET(1,None,'face', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__cfs_faces , open_shell_element,orientation, ):
		open_shell.__init__(self , inherited0__name , inherited1__cfs_faces , )
		self.open_shell_element = open_shell_element
		self.orientation = orientation

	@apply
	def open_shell_element():
		def fget( self ):
			return self._open_shell_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument open_shell_element is mantatory and can not be set to None')
			if not check_type(value,open_shell):
				self._open_shell_element = open_shell(value)
			else:
				self._open_shell_element = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def connected_face_set_cfs_faces():
		def fget( self ):
			attribute_eval = conditional_reverse(self.self.orientation,self.self.open_shell_element.self.cfs_faces)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument connected_face_set_cfs_faces is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.ORIENTED_OPEN_SHELL'  ==  TYPEOF(self.self.open_shell_element)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY solid_angle_unit #
####################
class solid_angle_unit(named_unit):
	'''Entity solid_angle_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  0)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY coordinated_universal_time_offset #
####################
class coordinated_universal_time_offset(BaseEntityClass):
	'''Entity coordinated_universal_time_offset definition.

	:param hour_offset
	:type hour_offset:hour_in_day

	:param minute_offset
	:type minute_offset:minute_in_hour

	:param sense
	:type sense:ahead_or_behind
	'''
	def __init__( self , hour_offset,minute_offset,sense, ):
		self.hour_offset = hour_offset
		self.minute_offset = minute_offset
		self.sense = sense

	@apply
	def hour_offset():
		def fget( self ):
			return self._hour_offset
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument hour_offset is mantatory and can not be set to None')
			if not check_type(value,hour_in_day):
				self._hour_offset = hour_in_day(value)
			else:
				self._hour_offset = value
		return property(**locals())

	@apply
	def minute_offset():
		def fget( self ):
			return self._minute_offset
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,minute_in_hour):
					self._minute_offset = minute_in_hour(value)
				else:
					self._minute_offset = value
			else:
				self._minute_offset = value
		return property(**locals())

	@apply
	def sense():
		def fget( self ):
			return self._sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument sense is mantatory and can not be set to None')
			if not check_type(value,ahead_or_behind):
				self._sense = ahead_or_behind(value)
			else:
				self._sense = value
		return property(**locals())

####################
 # ENTITY curve_replica #
####################
class curve_replica(curve):
	'''Entity curve_replica definition.

	:param parent_curve
	:type parent_curve:curve

	:param transformation
	:type transformation:cartesian_transformation_operator
	'''
	def __init__( self , inherited0__name , parent_curve,transformation, ):
		curve.__init__(self , inherited0__name , )
		self.parent_curve = parent_curve
		self.transformation = transformation

	@apply
	def parent_curve():
		def fget( self ):
			return self._parent_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument parent_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._parent_curve = curve(value)
			else:
				self._parent_curve = value
		return property(**locals())

	@apply
	def transformation():
		def fget( self ):
			return self._transformation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transformation is mantatory and can not be set to None')
			if not check_type(value,cartesian_transformation_operator):
				self._transformation = cartesian_transformation_operator(value)
			else:
				self._transformation = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.transformation.self.dim  ==  self.parent_curve.self.dim)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = acyclic_curve_replica(self,self.parent_curve)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY quasi_uniform_surface #
####################
class quasi_uniform_surface(b_spline_surface):
	'''Entity quasi_uniform_surface definition.
	'''
	def __init__( self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect ,  ):
		b_spline_surface.__init__(self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , )

####################
 # ENTITY surface_curve #
####################
class surface_curve(curve):
	'''Entity surface_curve definition.

	:param curve_3d
	:type curve_3d:curve

	:param associated_geometry
	:type associated_geometry:LIST(1,2,'pcurve_or_surface', scope = schema_scope)

	:param master_representation
	:type master_representation:preferred_surface_curve_representation

	:param basis_surface
	:type basis_surface:SET(1,2,'surface', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , curve_3d,associated_geometry,master_representation, ):
		curve.__init__(self , inherited0__name , )
		self.curve_3d = curve_3d
		self.associated_geometry = associated_geometry
		self.master_representation = master_representation

	@apply
	def curve_3d():
		def fget( self ):
			return self._curve_3d
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument curve_3d is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._curve_3d = curve(value)
			else:
				self._curve_3d = value
		return property(**locals())

	@apply
	def associated_geometry():
		def fget( self ):
			return self._associated_geometry
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument associated_geometry is mantatory and can not be set to None')
			if not check_type(value,LIST(1,2,'pcurve_or_surface', scope = schema_scope)):
				self._associated_geometry = LIST(value)
			else:
				self._associated_geometry = value
		return property(**locals())

	@apply
	def master_representation():
		def fget( self ):
			return self._master_representation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument master_representation is mantatory and can not be set to None')
			if not check_type(value,preferred_surface_curve_representation):
				self._master_representation = preferred_surface_curve_representation(value)
			else:
				self._master_representation = value
		return property(**locals())

	@apply
	def basis_surface():
		def fget( self ):
			attribute_eval = get_basis_surface(self)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument basis_surface is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.curve_3d.self.dim  ==  3)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(self.associated_geometry[1]))  or  (self.master_representation  !=  pcurve_s1))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(self.associated_geometry[2]))  or  (self.master_representation  !=  pcurve_s2))
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = ( not ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(self.curve_3d)))
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY action_request_status #
####################
class action_request_status(BaseEntityClass):
	'''Entity action_request_status definition.

	:param status
	:type status:label

	:param assigned_request
	:type assigned_request:versioned_action_request
	'''
	def __init__( self , status,assigned_request, ):
		self.status = status
		self.assigned_request = assigned_request

	@apply
	def status():
		def fget( self ):
			return self._status
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument status is mantatory and can not be set to None')
			if not check_type(value,label):
				self._status = label(value)
			else:
				self._status = value
		return property(**locals())

	@apply
	def assigned_request():
		def fget( self ):
			return self._assigned_request
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_request is mantatory and can not be set to None')
			if not check_type(value,versioned_action_request):
				self._assigned_request = versioned_action_request(value)
			else:
				self._assigned_request = value
		return property(**locals())

####################
 # ENTITY founded_item #
####################
class founded_item(BaseEntityClass):
	'''Entity founded_item definition.
	'''
	# This class does not define any attribute.
	pass

####################
 # ENTITY composite_curve_segment #
####################
class composite_curve_segment(founded_item):
	'''Entity composite_curve_segment definition.

	:param transition
	:type transition:transition_code

	:param same_sense
	:type same_sense:BOOLEAN

	:param parent_curve
	:type parent_curve:curve

	:param using_curves
	:type using_curves:BAG(1,None,'composite_curve', scope = schema_scope)
	'''
	def __init__( self , transition,same_sense,parent_curve, ):
		founded_item.__init__(self , )
		self.transition = transition
		self.same_sense = same_sense
		self.parent_curve = parent_curve

	@apply
	def transition():
		def fget( self ):
			return self._transition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transition is mantatory and can not be set to None')
			if not check_type(value,transition_code):
				self._transition = transition_code(value)
			else:
				self._transition = value
		return property(**locals())

	@apply
	def same_sense():
		def fget( self ):
			return self._same_sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument same_sense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._same_sense = BOOLEAN(value)
			else:
				self._same_sense = value
		return property(**locals())

	@apply
	def parent_curve():
		def fget( self ):
			return self._parent_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument parent_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._parent_curve = curve(value)
			else:
				self._parent_curve = value
		return property(**locals())

	@apply
	def using_curves():
		def fget( self ):
			return self._using_curves
		def fset( self, value ):
		# INVERSE argument
			raise AssertionError('Argument using_curves is INVERSE. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.BOUNDED_CURVE'  ==  TYPEOF(self.parent_curve))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY reparametrised_composite_curve_segment #
####################
class reparametrised_composite_curve_segment(composite_curve_segment):
	'''Entity reparametrised_composite_curve_segment definition.

	:param param_length
	:type param_length:parameter_value
	'''
	def __init__( self , inherited0__transition , inherited1__same_sense , inherited2__parent_curve , param_length, ):
		composite_curve_segment.__init__(self , inherited0__transition , inherited1__same_sense , inherited2__parent_curve , )
		self.param_length = param_length

	@apply
	def param_length():
		def fget( self ):
			return self._param_length
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument param_length is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._param_length = parameter_value(value)
			else:
				self._param_length = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.param_length  >  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY representation_relationship #
####################
class representation_relationship(BaseEntityClass):
	'''Entity representation_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param rep_1
	:type rep_1:representation

	:param rep_2
	:type rep_2:representation
	'''
	def __init__( self , name,description,rep_1,rep_2, ):
		self.name = name
		self.description = description
		self.rep_1 = rep_1
		self.rep_2 = rep_2

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def rep_1():
		def fget( self ):
			return self._rep_1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument rep_1 is mantatory and can not be set to None')
			if not check_type(value,representation):
				self._rep_1 = representation(value)
			else:
				self._rep_1 = value
		return property(**locals())

	@apply
	def rep_2():
		def fget( self ):
			return self._rep_2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument rep_2 is mantatory and can not be set to None')
			if not check_type(value,representation):
				self._rep_2 = representation(value)
			else:
				self._rep_2 = value
		return property(**locals())

####################
 # ENTITY representation_relationship_with_transformation #
####################
class representation_relationship_with_transformation(representation_relationship):
	'''Entity representation_relationship_with_transformation definition.

	:param transformation_operator
	:type transformation_operator:transformation
	'''
	def __init__( self , inherited0__name , inherited1__description , inherited2__rep_1 , inherited3__rep_2 , transformation_operator, ):
		representation_relationship.__init__(self , inherited0__name , inherited1__description , inherited2__rep_1 , inherited3__rep_2 , )
		self.transformation_operator = transformation_operator

	@apply
	def transformation_operator():
		def fget( self ):
			return self._transformation_operator
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transformation_operator is mantatory and can not be set to None')
			if not check_type(value,transformation):
				self._transformation_operator = transformation(value)
			else:
				self._transformation_operator = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.representation_relationship.self.rep_1.self.context_of_items  !=  self.self.representation_relationship.self.rep_2.self.context_of_items)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY person_and_organization_role #
####################
class person_and_organization_role(BaseEntityClass):
	'''Entity person_and_organization_role definition.

	:param name
	:type name:label
	'''
	def __init__( self , name, ):
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

####################
 # ENTITY quasi_uniform_curve #
####################
class quasi_uniform_curve(b_spline_curve):
	'''Entity quasi_uniform_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect ,  ):
		b_spline_curve.__init__(self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , )

####################
 # ENTITY swept_surface #
####################
class swept_surface(surface):
	'''Entity swept_surface definition.

	:param swept_curve
	:type swept_curve:curve
	'''
	def __init__( self , inherited0__name , swept_curve, ):
		surface.__init__(self , inherited0__name , )
		self.swept_curve = swept_curve

	@apply
	def swept_curve():
		def fget( self ):
			return self._swept_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument swept_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._swept_curve = curve(value)
			else:
				self._swept_curve = value
		return property(**locals())

####################
 # ENTITY property_definition #
####################
class property_definition(BaseEntityClass):
	'''Entity property_definition definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param definition
	:type definition:characterized_definition
	'''
	def __init__( self , name,description,definition, ):
		self.name = name
		self.description = description
		self.definition = definition

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def definition():
		def fget( self ):
			return self._definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument definition is mantatory and can not be set to None')
			if not check_type(value,characterized_definition):
				self._definition = characterized_definition(value)
			else:
				self._definition = value
		return property(**locals())

####################
 # ENTITY global_uncertainty_assigned_context #
####################
class global_uncertainty_assigned_context(representation_context):
	'''Entity global_uncertainty_assigned_context definition.

	:param uncertainty
	:type uncertainty:SET(1,None,'uncertainty_measure_with_unit', scope = schema_scope)
	'''
	def __init__( self , inherited0__context_identifier , inherited1__context_type , uncertainty, ):
		representation_context.__init__(self , inherited0__context_identifier , inherited1__context_type , )
		self.uncertainty = uncertainty

	@apply
	def uncertainty():
		def fget( self ):
			return self._uncertainty
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument uncertainty is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'uncertainty_measure_with_unit', scope = schema_scope)):
				self._uncertainty = SET(value)
			else:
				self._uncertainty = value
		return property(**locals())

####################
 # ENTITY organization_relationship #
####################
class organization_relationship(BaseEntityClass):
	'''Entity organization_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param relating_organization
	:type relating_organization:organization

	:param related_organization
	:type related_organization:organization
	'''
	def __init__( self , name,description,relating_organization,related_organization, ):
		self.name = name
		self.description = description
		self.relating_organization = relating_organization
		self.related_organization = related_organization

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def relating_organization():
		def fget( self ):
			return self._relating_organization
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument relating_organization is mantatory and can not be set to None')
			if not check_type(value,organization):
				self._relating_organization = organization(value)
			else:
				self._relating_organization = value
		return property(**locals())

	@apply
	def related_organization():
		def fget( self ):
			return self._related_organization
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument related_organization is mantatory and can not be set to None')
			if not check_type(value,organization):
				self._related_organization = organization(value)
			else:
				self._related_organization = value
		return property(**locals())

####################
 # ENTITY parabola #
####################
class parabola(conic):
	'''Entity parabola definition.

	:param focal_dist
	:type focal_dist:length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , focal_dist, ):
		conic.__init__(self , inherited0__name , inherited1__position , )
		self.focal_dist = focal_dist

	@apply
	def focal_dist():
		def fget( self ):
			return self._focal_dist
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument focal_dist is mantatory and can not be set to None')
			if not check_type(value,length_measure):
				self._focal_dist = length_measure(value)
			else:
				self._focal_dist = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.focal_dist  !=  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY rectangular_composite_surface #
####################
class rectangular_composite_surface(bounded_surface):
	'''Entity rectangular_composite_surface definition.

	:param segments
	:type segments:LIST(1,None,LIST(1,None,'surface_patch', scope = schema_scope))

	:param n_u
	:type n_u:INTEGER

	:param n_v
	:type n_v:INTEGER
	'''
	def __init__( self , inherited0__name , segments, ):
		bounded_surface.__init__(self , inherited0__name , )
		self.segments = segments

	@apply
	def segments():
		def fget( self ):
			return self._segments
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument segments is mantatory and can not be set to None')
			if not check_type(value,LIST(1,None,LIST(1,None,'surface_patch', scope = schema_scope))):
				self._segments = LIST(value)
			else:
				self._segments = value
		return property(**locals())

	@apply
	def n_u():
		def fget( self ):
			attribute_eval = SIZEOF(self.segments)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument n_u is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def n_v():
		def fget( self ):
			attribute_eval = SIZEOF(self.segments[1])
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument n_v is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ([]  ==  None)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = constraints_rectangular_composite_surface(self)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY lot_effectivity #
####################
class lot_effectivity(effectivity):
	'''Entity lot_effectivity definition.

	:param effectivity_lot_id
	:type effectivity_lot_id:identifier

	:param effectivity_lot_size
	:type effectivity_lot_size:measure_with_unit
	'''
	def __init__( self , inherited0__id , effectivity_lot_id,effectivity_lot_size, ):
		effectivity.__init__(self , inherited0__id , )
		self.effectivity_lot_id = effectivity_lot_id
		self.effectivity_lot_size = effectivity_lot_size

	@apply
	def effectivity_lot_id():
		def fget( self ):
			return self._effectivity_lot_id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument effectivity_lot_id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._effectivity_lot_id = identifier(value)
			else:
				self._effectivity_lot_id = value
		return property(**locals())

	@apply
	def effectivity_lot_size():
		def fget( self ):
			return self._effectivity_lot_size
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument effectivity_lot_size is mantatory and can not be set to None')
			if not check_type(value,measure_with_unit):
				self._effectivity_lot_size = measure_with_unit(value)
			else:
				self._effectivity_lot_size = value
		return property(**locals())

####################
 # ENTITY surface_of_linear_extrusion #
####################
class surface_of_linear_extrusion(swept_surface):
	'''Entity surface_of_linear_extrusion definition.

	:param extrusion_axis
	:type extrusion_axis:vector
	'''
	def __init__( self , inherited0__name , inherited1__swept_curve , extrusion_axis, ):
		swept_surface.__init__(self , inherited0__name , inherited1__swept_curve , )
		self.extrusion_axis = extrusion_axis

	@apply
	def extrusion_axis():
		def fget( self ):
			return self._extrusion_axis
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument extrusion_axis is mantatory and can not be set to None')
			if not check_type(value,vector):
				self._extrusion_axis = vector(value)
			else:
				self._extrusion_axis = value
		return property(**locals())

####################
 # ENTITY shell_based_surface_model #
####################
class shell_based_surface_model(geometric_representation_item):
	'''Entity shell_based_surface_model definition.

	:param sbsm_boundary
	:type sbsm_boundary:SET(1,None,'shell', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , sbsm_boundary, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.sbsm_boundary = sbsm_boundary

	@apply
	def sbsm_boundary():
		def fget( self ):
			return self._sbsm_boundary
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument sbsm_boundary is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'shell', scope = schema_scope)):
				self._sbsm_boundary = SET(value)
			else:
				self._sbsm_boundary = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = constraints_geometry_shell_based_surface_model(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY uniform_curve #
####################
class uniform_curve(b_spline_curve):
	'''Entity uniform_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect ,  ):
		b_spline_curve.__init__(self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , )

####################
 # ENTITY bezier_curve #
####################
class bezier_curve(b_spline_curve):
	'''Entity bezier_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect ,  ):
		b_spline_curve.__init__(self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , )

####################
 # ENTITY loop #
####################
class loop(topological_representation_item):
	'''Entity loop definition.
	'''
	def __init__( self , inherited0__name ,  ):
		topological_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY edge_loop #
####################
class edge_loop(loop,path):
	'''Entity edge_loop definition.

	:param ne
	:type ne:INTEGER
	'''
	def __init__( self , inherited0__name , inherited1__name , inherited2__edge_list ,  ):
		loop.__init__(self , inherited0__name , )
		path.__init__(self , inherited1__name , inherited2__edge_list , )

	@apply
	def ne():
		def fget( self ):
			attribute_eval = SIZEOF(self.self.path.self.edge_list)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument ne is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.path.self.edge_list[1].self.edge_start  ==  self.self.path.self.edge_list[self.ne].self.edge_end)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY date #
####################
class date(BaseEntityClass):
	'''Entity date definition.

	:param year_component
	:type year_component:year_number
	'''
	def __init__( self , year_component, ):
		self.year_component = year_component

	@apply
	def year_component():
		def fget( self ):
			return self._year_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument year_component is mantatory and can not be set to None')
			if not check_type(value,year_number):
				self._year_component = year_number(value)
			else:
				self._year_component = value
		return property(**locals())

####################
 # ENTITY calendar_date #
####################
class calendar_date(date):
	'''Entity calendar_date definition.

	:param day_component
	:type day_component:day_in_month_number

	:param month_component
	:type month_component:month_in_year_number
	'''
	def __init__( self , inherited0__year_component , day_component,month_component, ):
		date.__init__(self , inherited0__year_component , )
		self.day_component = day_component
		self.month_component = month_component

	@apply
	def day_component():
		def fget( self ):
			return self._day_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument day_component is mantatory and can not be set to None')
			if not check_type(value,day_in_month_number):
				self._day_component = day_in_month_number(value)
			else:
				self._day_component = value
		return property(**locals())

	@apply
	def month_component():
		def fget( self ):
			return self._month_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument month_component is mantatory and can not be set to None')
			if not check_type(value,month_in_year_number):
				self._month_component = month_in_year_number(value)
			else:
				self._month_component = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = valid_calendar_date(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY toroidal_surface #
####################
class toroidal_surface(elementary_surface):
	'''Entity toroidal_surface definition.

	:param major_radius
	:type major_radius:positive_length_measure

	:param minor_radius
	:type minor_radius:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , major_radius,minor_radius, ):
		elementary_surface.__init__(self , inherited0__name , inherited1__position , )
		self.major_radius = major_radius
		self.minor_radius = minor_radius

	@apply
	def major_radius():
		def fget( self ):
			return self._major_radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument major_radius is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._major_radius = positive_length_measure(value)
			else:
				self._major_radius = value
		return property(**locals())

	@apply
	def minor_radius():
		def fget( self ):
			return self._minor_radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument minor_radius is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._minor_radius = positive_length_measure(value)
			else:
				self._minor_radius = value
		return property(**locals())

####################
 # ENTITY promissory_usage_occurrence #
####################
class promissory_usage_occurrence(assembly_component_usage):
	'''Entity promissory_usage_occurrence definition.
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator ,  ):
		assembly_component_usage.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , inherited5__reference_designator , )

####################
 # ENTITY approval_assignment #
####################
class approval_assignment(BaseEntityClass):
	'''Entity approval_assignment definition.

	:param assigned_approval
	:type assigned_approval:approval
	'''
	def __init__( self , assigned_approval, ):
		self.assigned_approval = assigned_approval

	@apply
	def assigned_approval():
		def fget( self ):
			return self._assigned_approval
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_approval is mantatory and can not be set to None')
			if not check_type(value,approval):
				self._assigned_approval = approval(value)
			else:
				self._assigned_approval = value
		return property(**locals())

####################
 # ENTITY configuration_item #
####################
class configuration_item(BaseEntityClass):
	'''Entity configuration_item definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text

	:param item_concept
	:type item_concept:product_concept

	:param purpose
	:type purpose:label
	'''
	def __init__( self , id,name,description,item_concept,purpose, ):
		self.id = id
		self.name = name
		self.description = description
		self.item_concept = item_concept
		self.purpose = purpose

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,text):
					self._description = text(value)
				else:
					self._description = value
			else:
				self._description = value
		return property(**locals())

	@apply
	def item_concept():
		def fget( self ):
			return self._item_concept
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument item_concept is mantatory and can not be set to None')
			if not check_type(value,product_concept):
				self._item_concept = product_concept(value)
			else:
				self._item_concept = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,label):
					self._purpose = label(value)
				else:
					self._purpose = value
			else:
				self._purpose = value
		return property(**locals())

####################
 # ENTITY contract_assignment #
####################
class contract_assignment(BaseEntityClass):
	'''Entity contract_assignment definition.

	:param assigned_contract
	:type assigned_contract:contract
	'''
	def __init__( self , assigned_contract, ):
		self.assigned_contract = assigned_contract

	@apply
	def assigned_contract():
		def fget( self ):
			return self._assigned_contract
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_contract is mantatory and can not be set to None')
			if not check_type(value,contract):
				self._assigned_contract = contract(value)
			else:
				self._assigned_contract = value
		return property(**locals())

####################
 # ENTITY vector #
####################
class vector(geometric_representation_item):
	'''Entity vector definition.

	:param orientation
	:type orientation:direction

	:param magnitude
	:type magnitude:length_measure
	'''
	def __init__( self , inherited0__name , orientation,magnitude, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.orientation = orientation
		self.magnitude = magnitude

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,direction):
				self._orientation = direction(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def magnitude():
		def fget( self ):
			return self._magnitude
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument magnitude is mantatory and can not be set to None')
			if not check_type(value,length_measure):
				self._magnitude = length_measure(value)
			else:
				self._magnitude = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.magnitude  >=  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY pcurve #
####################
class pcurve(curve):
	'''Entity pcurve definition.

	:param basis_surface
	:type basis_surface:surface

	:param reference_to_curve
	:type reference_to_curve:definitional_representation
	'''
	def __init__( self , inherited0__name , basis_surface,reference_to_curve, ):
		curve.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.reference_to_curve = reference_to_curve

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def reference_to_curve():
		def fget( self ):
			return self._reference_to_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument reference_to_curve is mantatory and can not be set to None')
			if not check_type(value,definitional_representation):
				self._reference_to_curve = definitional_representation(value)
			else:
				self._reference_to_curve = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.reference_to_curve.self.representation.self.items)  ==  1)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = ('CONFIG_CONTROL_DESIGN.CURVE'  ==  TYPEOF(self.reference_to_curve.self.representation.self.items[1]))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (self.reference_to_curve.self.representation.self.items[1].self.geometric_representation_item.self.dim  ==  2)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr


####################
 # ENTITY bounded_pcurve #
####################
class bounded_pcurve(pcurve,bounded_curve):
	'''Entity bounded_pcurve definition.
	'''
	def __init__( self , inherited0__name , inherited1__basis_surface , inherited2__reference_to_curve , inherited3__name ,  ):
		pcurve.__init__(self , inherited0__name , inherited1__basis_surface , inherited2__reference_to_curve , )
		bounded_curve.__init__(self , inherited3__name , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.BOUNDED_CURVE'  ==  TYPEOF(self.self.pcurve.self.reference_to_curve.self.items[1]))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY intersection_curve #
####################
class intersection_curve(surface_curve):
	'''Entity intersection_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation ,  ):
		surface_curve.__init__(self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.self.surface_curve.self.associated_geometry)  ==  2)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (associated_surface(self.self.surface_curve.self.associated_geometry[1])  !=  associated_surface(self.self.surface_curve.self.associated_geometry[2]))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY trimmed_curve #
####################
class trimmed_curve(bounded_curve):
	'''Entity trimmed_curve definition.

	:param basis_curve
	:type basis_curve:curve

	:param trim_1
	:type trim_1:SET(1,2,'trimming_select', scope = schema_scope)

	:param trim_2
	:type trim_2:SET(1,2,'trimming_select', scope = schema_scope)

	:param sense_agreement
	:type sense_agreement:BOOLEAN

	:param master_representation
	:type master_representation:trimming_preference
	'''
	def __init__( self , inherited0__name , basis_curve,trim_1,trim_2,sense_agreement,master_representation, ):
		bounded_curve.__init__(self , inherited0__name , )
		self.basis_curve = basis_curve
		self.trim_1 = trim_1
		self.trim_2 = trim_2
		self.sense_agreement = sense_agreement
		self.master_representation = master_representation

	@apply
	def basis_curve():
		def fget( self ):
			return self._basis_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._basis_curve = curve(value)
			else:
				self._basis_curve = value
		return property(**locals())

	@apply
	def trim_1():
		def fget( self ):
			return self._trim_1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument trim_1 is mantatory and can not be set to None')
			if not check_type(value,SET(1,2,'trimming_select', scope = schema_scope)):
				self._trim_1 = SET(value)
			else:
				self._trim_1 = value
		return property(**locals())

	@apply
	def trim_2():
		def fget( self ):
			return self._trim_2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument trim_2 is mantatory and can not be set to None')
			if not check_type(value,SET(1,2,'trimming_select', scope = schema_scope)):
				self._trim_2 = SET(value)
			else:
				self._trim_2 = value
		return property(**locals())

	@apply
	def sense_agreement():
		def fget( self ):
			return self._sense_agreement
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument sense_agreement is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._sense_agreement = BOOLEAN(value)
			else:
				self._sense_agreement = value
		return property(**locals())

	@apply
	def master_representation():
		def fget( self ):
			return self._master_representation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument master_representation is mantatory and can not be set to None')
			if not check_type(value,trimming_preference):
				self._master_representation = trimming_preference(value)
			else:
				self._master_representation = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ((HIINDEX(self.trim_1)  ==  1)  or  (TYPEOF(self.trim_1[1])  !=  TYPEOF(self.trim_1[2])))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = ((HIINDEX(self.trim_2)  ==  1)  or  (TYPEOF(self.trim_2[1])  !=  TYPEOF(self.trim_2[2])))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY product_definition_context #
####################
class product_definition_context(application_context_element):
	'''Entity product_definition_context definition.

	:param life_cycle_stage
	:type life_cycle_stage:label
	'''
	def __init__( self , inherited0__name , inherited1__frame_of_reference , life_cycle_stage, ):
		application_context_element.__init__(self , inherited0__name , inherited1__frame_of_reference , )
		self.life_cycle_stage = life_cycle_stage

	@apply
	def life_cycle_stage():
		def fget( self ):
			return self._life_cycle_stage
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument life_cycle_stage is mantatory and can not be set to None')
			if not check_type(value,label):
				self._life_cycle_stage = label(value)
			else:
				self._life_cycle_stage = value
		return property(**locals())

####################
 # ENTITY bounded_surface_curve #
####################
class bounded_surface_curve(surface_curve,bounded_curve):
	'''Entity bounded_surface_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation , inherited4__name ,  ):
		surface_curve.__init__(self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation , )
		bounded_curve.__init__(self , inherited4__name , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.BOUNDED_CURVE'  ==  TYPEOF(self.self.surface_curve.self.curve_3d))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY item_defined_transformation #
####################
class item_defined_transformation(BaseEntityClass):
	'''Entity item_defined_transformation definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param transform_item_1
	:type transform_item_1:representation_item

	:param transform_item_2
	:type transform_item_2:representation_item
	'''
	def __init__( self , name,description,transform_item_1,transform_item_2, ):
		self.name = name
		self.description = description
		self.transform_item_1 = transform_item_1
		self.transform_item_2 = transform_item_2

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def transform_item_1():
		def fget( self ):
			return self._transform_item_1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transform_item_1 is mantatory and can not be set to None')
			if not check_type(value,representation_item):
				self._transform_item_1 = representation_item(value)
			else:
				self._transform_item_1 = value
		return property(**locals())

	@apply
	def transform_item_2():
		def fget( self ):
			return self._transform_item_2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transform_item_2 is mantatory and can not be set to None')
			if not check_type(value,representation_item):
				self._transform_item_2 = representation_item(value)
			else:
				self._transform_item_2 = value
		return property(**locals())

####################
 # ENTITY action_method #
####################
class action_method(BaseEntityClass):
	'''Entity action_method definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param consequence
	:type consequence:text

	:param purpose
	:type purpose:text
	'''
	def __init__( self , name,description,consequence,purpose, ):
		self.name = name
		self.description = description
		self.consequence = consequence
		self.purpose = purpose

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def consequence():
		def fget( self ):
			return self._consequence
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument consequence is mantatory and can not be set to None')
			if not check_type(value,text):
				self._consequence = text(value)
			else:
				self._consequence = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument purpose is mantatory and can not be set to None')
			if not check_type(value,text):
				self._purpose = text(value)
			else:
				self._purpose = value
		return property(**locals())

####################
 # ENTITY product_category_relationship #
####################
class product_category_relationship(BaseEntityClass):
	'''Entity product_category_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param category
	:type category:product_category

	:param sub_category
	:type sub_category:product_category
	'''
	def __init__( self , name,description,category,sub_category, ):
		self.name = name
		self.description = description
		self.category = category
		self.sub_category = sub_category

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def category():
		def fget( self ):
			return self._category
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument category is mantatory and can not be set to None')
			if not check_type(value,product_category):
				self._category = product_category(value)
			else:
				self._category = value
		return property(**locals())

	@apply
	def sub_category():
		def fget( self ):
			return self._sub_category
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument sub_category is mantatory and can not be set to None')
			if not check_type(value,product_category):
				self._sub_category = product_category(value)
			else:
				self._sub_category = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = acyclic_product_category_relationship(self,[self.self.sub_category])
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY plane_angle_measure_with_unit #
####################
class plane_angle_measure_with_unit(measure_with_unit):
	'''Entity plane_angle_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.PLANE_ANGLE_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY vertex #
####################
class vertex(topological_representation_item):
	'''Entity vertex definition.
	'''
	def __init__( self , inherited0__name ,  ):
		topological_representation_item.__init__(self , inherited0__name , )

####################
 # ENTITY representation_map #
####################
class representation_map(BaseEntityClass):
	'''Entity representation_map definition.

	:param mapping_origin
	:type mapping_origin:representation_item

	:param mapped_representation
	:type mapped_representation:representation

	:param map_usage
	:type map_usage:SET(1,None,'mapped_item', scope = schema_scope)
	'''
	def __init__( self , mapping_origin,mapped_representation, ):
		self.mapping_origin = mapping_origin
		self.mapped_representation = mapped_representation

	@apply
	def mapping_origin():
		def fget( self ):
			return self._mapping_origin
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument mapping_origin is mantatory and can not be set to None')
			if not check_type(value,representation_item):
				self._mapping_origin = representation_item(value)
			else:
				self._mapping_origin = value
		return property(**locals())

	@apply
	def mapped_representation():
		def fget( self ):
			return self._mapped_representation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument mapped_representation is mantatory and can not be set to None')
			if not check_type(value,representation):
				self._mapped_representation = representation(value)
			else:
				self._mapped_representation = value
		return property(**locals())

	@apply
	def map_usage():
		def fget( self ):
			return self._map_usage
		def fset( self, value ):
		# INVERSE argument
			raise AssertionError('Argument map_usage is INVERSE. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = item_in_context(self.self.mapping_origin,self.self.mapped_representation.self.context_of_items)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY product_definition_effectivity #
####################
class product_definition_effectivity(effectivity):
	'''Entity product_definition_effectivity definition.

	:param usage
	:type usage:product_definition_relationship
	'''
	def __init__( self , inherited0__id , usage, ):
		effectivity.__init__(self , inherited0__id , )
		self.usage = usage

	@apply
	def usage():
		def fget( self ):
			return self._usage
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument usage is mantatory and can not be set to None')
			if not check_type(value,product_definition_relationship):
				self._usage = product_definition_relationship(value)
			else:
				self._usage = value
		return property(**locals())

####################
 # ENTITY configuration_effectivity #
####################
class configuration_effectivity(product_definition_effectivity):
	'''Entity configuration_effectivity definition.

	:param configuration
	:type configuration:configuration_design
	'''
	def __init__( self , inherited0__id , inherited1__usage , configuration, ):
		product_definition_effectivity.__init__(self , inherited0__id , inherited1__usage , )
		self.configuration = configuration

	@apply
	def configuration():
		def fget( self ):
			return self._configuration
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument configuration is mantatory and can not be set to None')
			if not check_type(value,configuration_design):
				self._configuration = configuration_design(value)
			else:
				self._configuration = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.PRODUCT_DEFINITION_USAGE'  ==  TYPEOF(self.self.product_definition_effectivity.self.usage))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY ellipse #
####################
class ellipse(conic):
	'''Entity ellipse definition.

	:param semi_axis_1
	:type semi_axis_1:positive_length_measure

	:param semi_axis_2
	:type semi_axis_2:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , semi_axis_1,semi_axis_2, ):
		conic.__init__(self , inherited0__name , inherited1__position , )
		self.semi_axis_1 = semi_axis_1
		self.semi_axis_2 = semi_axis_2

	@apply
	def semi_axis_1():
		def fget( self ):
			return self._semi_axis_1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument semi_axis_1 is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._semi_axis_1 = positive_length_measure(value)
			else:
				self._semi_axis_1 = value
		return property(**locals())

	@apply
	def semi_axis_2():
		def fget( self ):
			return self._semi_axis_2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument semi_axis_2 is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._semi_axis_2 = positive_length_measure(value)
			else:
				self._semi_axis_2 = value
		return property(**locals())

####################
 # ENTITY context_dependent_unit #
####################
class context_dependent_unit(named_unit):
	'''Entity context_dependent_unit definition.

	:param name
	:type name:label
	'''
	def __init__( self , inherited0__dimensions , name, ):
		named_unit.__init__(self , inherited0__dimensions , )
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

####################
 # ENTITY alternate_product_relationship #
####################
class alternate_product_relationship(BaseEntityClass):
	'''Entity alternate_product_relationship definition.

	:param name
	:type name:label

	:param definition
	:type definition:text

	:param alternate
	:type alternate:product

	:param base
	:type base:product

	:param basis
	:type basis:text
	'''
	def __init__( self , name,definition,alternate,base,basis, ):
		self.name = name
		self.definition = definition
		self.alternate = alternate
		self.base = base
		self.basis = basis

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def definition():
		def fget( self ):
			return self._definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument definition is mantatory and can not be set to None')
			if not check_type(value,text):
				self._definition = text(value)
			else:
				self._definition = value
		return property(**locals())

	@apply
	def alternate():
		def fget( self ):
			return self._alternate
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument alternate is mantatory and can not be set to None')
			if not check_type(value,product):
				self._alternate = product(value)
			else:
				self._alternate = value
		return property(**locals())

	@apply
	def base():
		def fget( self ):
			return self._base
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument base is mantatory and can not be set to None')
			if not check_type(value,product):
				self._base = product(value)
			else:
				self._base = value
		return property(**locals())

	@apply
	def basis():
		def fget( self ):
			return self._basis
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis is mantatory and can not be set to None')
			if not check_type(value,text):
				self._basis = text(value)
			else:
				self._basis = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.alternate  !=  self.base)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY document_type #
####################
class document_type(BaseEntityClass):
	'''Entity document_type definition.

	:param product_data_type
	:type product_data_type:label
	'''
	def __init__( self , product_data_type, ):
		self.product_data_type = product_data_type

	@apply
	def product_data_type():
		def fget( self ):
			return self._product_data_type
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument product_data_type is mantatory and can not be set to None')
			if not check_type(value,label):
				self._product_data_type = label(value)
			else:
				self._product_data_type = value
		return property(**locals())

####################
 # ENTITY document_reference #
####################
class document_reference(BaseEntityClass):
	'''Entity document_reference definition.

	:param assigned_document
	:type assigned_document:document

	:param source
	:type source:label
	'''
	def __init__( self , assigned_document,source, ):
		self.assigned_document = assigned_document
		self.source = source

	@apply
	def assigned_document():
		def fget( self ):
			return self._assigned_document
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_document is mantatory and can not be set to None')
			if not check_type(value,document):
				self._assigned_document = document(value)
			else:
				self._assigned_document = value
		return property(**locals())

	@apply
	def source():
		def fget( self ):
			return self._source
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument source is mantatory and can not be set to None')
			if not check_type(value,label):
				self._source = label(value)
			else:
				self._source = value
		return property(**locals())

####################
 # ENTITY mechanical_context #
####################
class mechanical_context(product_context):
	'''Entity mechanical_context definition.
	'''
	def __init__( self , inherited0__name , inherited1__frame_of_reference , inherited2__discipline_type ,  ):
		product_context.__init__(self , inherited0__name , inherited1__frame_of_reference , inherited2__discipline_type , )
	def wr1(self):
		eval_wr1_wr = (self.self.discipline_type  ==  'mechanical')
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY shell_based_wireframe_model #
####################
class shell_based_wireframe_model(geometric_representation_item):
	'''Entity shell_based_wireframe_model definition.

	:param sbwm_boundary
	:type sbwm_boundary:SET(1,None,'shell', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , sbwm_boundary, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.sbwm_boundary = sbwm_boundary

	@apply
	def sbwm_boundary():
		def fget( self ):
			return self._sbwm_boundary
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument sbwm_boundary is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'shell', scope = schema_scope)):
				self._sbwm_boundary = SET(value)
			else:
				self._sbwm_boundary = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = constraints_geometry_shell_based_wireframe_model(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY contract #
####################
class contract(BaseEntityClass):
	'''Entity contract definition.

	:param name
	:type name:label

	:param purpose
	:type purpose:text

	:param kind
	:type kind:contract_type
	'''
	def __init__( self , name,purpose,kind, ):
		self.name = name
		self.purpose = purpose
		self.kind = kind

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument purpose is mantatory and can not be set to None')
			if not check_type(value,text):
				self._purpose = text(value)
			else:
				self._purpose = value
		return property(**locals())

	@apply
	def kind():
		def fget( self ):
			return self._kind
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument kind is mantatory and can not be set to None')
			if not check_type(value,contract_type):
				self._kind = contract_type(value)
			else:
				self._kind = value
		return property(**locals())

####################
 # ENTITY dimensional_exponents #
####################
class dimensional_exponents(BaseEntityClass):
	'''Entity dimensional_exponents definition.

	:param length_exponent
	:type length_exponent:REAL

	:param mass_exponent
	:type mass_exponent:REAL

	:param time_exponent
	:type time_exponent:REAL

	:param electric_current_exponent
	:type electric_current_exponent:REAL

	:param thermodynamic_temperature_exponent
	:type thermodynamic_temperature_exponent:REAL

	:param amount_of_substance_exponent
	:type amount_of_substance_exponent:REAL

	:param luminous_intensity_exponent
	:type luminous_intensity_exponent:REAL
	'''
	def __init__( self , length_exponent,mass_exponent,time_exponent,electric_current_exponent,thermodynamic_temperature_exponent,amount_of_substance_exponent,luminous_intensity_exponent, ):
		self.length_exponent = length_exponent
		self.mass_exponent = mass_exponent
		self.time_exponent = time_exponent
		self.electric_current_exponent = electric_current_exponent
		self.thermodynamic_temperature_exponent = thermodynamic_temperature_exponent
		self.amount_of_substance_exponent = amount_of_substance_exponent
		self.luminous_intensity_exponent = luminous_intensity_exponent

	@apply
	def length_exponent():
		def fget( self ):
			return self._length_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument length_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._length_exponent = REAL(value)
			else:
				self._length_exponent = value
		return property(**locals())

	@apply
	def mass_exponent():
		def fget( self ):
			return self._mass_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument mass_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._mass_exponent = REAL(value)
			else:
				self._mass_exponent = value
		return property(**locals())

	@apply
	def time_exponent():
		def fget( self ):
			return self._time_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument time_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._time_exponent = REAL(value)
			else:
				self._time_exponent = value
		return property(**locals())

	@apply
	def electric_current_exponent():
		def fget( self ):
			return self._electric_current_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument electric_current_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._electric_current_exponent = REAL(value)
			else:
				self._electric_current_exponent = value
		return property(**locals())

	@apply
	def thermodynamic_temperature_exponent():
		def fget( self ):
			return self._thermodynamic_temperature_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument thermodynamic_temperature_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._thermodynamic_temperature_exponent = REAL(value)
			else:
				self._thermodynamic_temperature_exponent = value
		return property(**locals())

	@apply
	def amount_of_substance_exponent():
		def fget( self ):
			return self._amount_of_substance_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument amount_of_substance_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._amount_of_substance_exponent = REAL(value)
			else:
				self._amount_of_substance_exponent = value
		return property(**locals())

	@apply
	def luminous_intensity_exponent():
		def fget( self ):
			return self._luminous_intensity_exponent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument luminous_intensity_exponent is mantatory and can not be set to None')
			if not check_type(value,REAL):
				self._luminous_intensity_exponent = REAL(value)
			else:
				self._luminous_intensity_exponent = value
		return property(**locals())

####################
 # ENTITY start_request #
####################
class start_request(action_request_assignment):
	'''Entity start_request definition.

	:param items
	:type items:SET(1,None,'start_request_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_action_request , items, ):
		action_request_assignment.__init__(self , inherited0__assigned_action_request , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'start_request_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY cc_design_specification_reference #
####################
class cc_design_specification_reference(document_reference):
	'''Entity cc_design_specification_reference definition.

	:param items
	:type items:SET(1,None,'specified_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_document , inherited1__source , items, ):
		document_reference.__init__(self , inherited0__assigned_document , inherited1__source , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'specified_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY supplied_part_relationship #
####################
class supplied_part_relationship(product_definition_relationship):
	'''Entity supplied_part_relationship definition.
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition ,  ):
		product_definition_relationship.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , )

####################
 # ENTITY context_dependent_shape_representation #
####################
class context_dependent_shape_representation(BaseEntityClass):
	'''Entity context_dependent_shape_representation definition.

	:param representation_relation
	:type representation_relation:shape_representation_relationship

	:param represented_product_relation
	:type represented_product_relation:product_definition_shape
	'''
	def __init__( self , representation_relation,represented_product_relation, ):
		self.representation_relation = representation_relation
		self.represented_product_relation = represented_product_relation

	@apply
	def representation_relation():
		def fget( self ):
			return self._representation_relation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument representation_relation is mantatory and can not be set to None')
			if not check_type(value,shape_representation_relationship):
				self._representation_relation = shape_representation_relationship(value)
			else:
				self._representation_relation = value
		return property(**locals())

	@apply
	def represented_product_relation():
		def fget( self ):
			return self._represented_product_relation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument represented_product_relation is mantatory and can not be set to None')
			if not check_type(value,product_definition_shape):
				self._represented_product_relation = product_definition_shape(value)
			else:
				self._represented_product_relation = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.PRODUCT_DEFINITION_RELATIONSHIP'  ==  TYPEOF(self.self.represented_product_relation.self.definition))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY degenerate_toroidal_surface #
####################
class degenerate_toroidal_surface(toroidal_surface):
	'''Entity degenerate_toroidal_surface definition.

	:param select_outer
	:type select_outer:BOOLEAN
	'''
	def __init__( self , inherited0__name , inherited1__position , inherited2__major_radius , inherited3__minor_radius , select_outer, ):
		toroidal_surface.__init__(self , inherited0__name , inherited1__position , inherited2__major_radius , inherited3__minor_radius , )
		self.select_outer = select_outer

	@apply
	def select_outer():
		def fget( self ):
			return self._select_outer
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument select_outer is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._select_outer = BOOLEAN(value)
			else:
				self._select_outer = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.major_radius  <  self.minor_radius)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY ordinal_date #
####################
class ordinal_date(date):
	'''Entity ordinal_date definition.

	:param day_component
	:type day_component:day_in_year_number
	'''
	def __init__( self , inherited0__year_component , day_component, ):
		date.__init__(self , inherited0__year_component , )
		self.day_component = day_component

	@apply
	def day_component():
		def fget( self ):
			return self._day_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument day_component is mantatory and can not be set to None')
			if not check_type(value,day_in_year_number):
				self._day_component = day_in_year_number(value)
			else:
				self._day_component = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (((( not leap_year(self.self.year_component))  and  (1  <=  self.day_component))  and  (self.day_component  <=  365))  or  ((leap_year(self.self.year_component)  and  (1  <=  self.day_component))  and  (self.day_component  <=  366)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY face_outer_bound #
####################
class face_outer_bound(face_bound):
	'''Entity face_outer_bound definition.
	'''
	def __init__( self , inherited0__name , inherited1__bound , inherited2__orientation ,  ):
		face_bound.__init__(self , inherited0__name , inherited1__bound , inherited2__orientation , )

####################
 # ENTITY mass_measure_with_unit #
####################
class mass_measure_with_unit(measure_with_unit):
	'''Entity mass_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.MASS_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY brep_with_voids #
####################
class brep_with_voids(manifold_solid_brep):
	'''Entity brep_with_voids definition.

	:param voids
	:type voids:SET(1,None,'oriented_closed_shell', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__outer , voids, ):
		manifold_solid_brep.__init__(self , inherited0__name , inherited1__outer , )
		self.voids = voids

	@apply
	def voids():
		def fget( self ):
			return self._voids
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument voids is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'oriented_closed_shell', scope = schema_scope)):
				self._voids = SET(value)
			else:
				self._voids = value
		return property(**locals())

####################
 # ENTITY week_of_year_and_day_date #
####################
class week_of_year_and_day_date(date):
	'''Entity week_of_year_and_day_date definition.

	:param week_component
	:type week_component:week_in_year_number

	:param day_component
	:type day_component:day_in_week_number
	'''
	def __init__( self , inherited0__year_component , week_component,day_component, ):
		date.__init__(self , inherited0__year_component , )
		self.week_component = week_component
		self.day_component = day_component

	@apply
	def week_component():
		def fget( self ):
			return self._week_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument week_component is mantatory and can not be set to None')
			if not check_type(value,week_in_year_number):
				self._week_component = week_in_year_number(value)
			else:
				self._week_component = value
		return property(**locals())

	@apply
	def day_component():
		def fget( self ):
			return self._day_component
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,day_in_week_number):
					self._day_component = day_in_week_number(value)
				else:
					self._day_component = value
			else:
				self._day_component = value
		return property(**locals())

####################
 # ENTITY point_on_curve #
####################
class point_on_curve(point):
	'''Entity point_on_curve definition.

	:param basis_curve
	:type basis_curve:curve

	:param point_parameter
	:type point_parameter:parameter_value
	'''
	def __init__( self , inherited0__name , basis_curve,point_parameter, ):
		point.__init__(self , inherited0__name , )
		self.basis_curve = basis_curve
		self.point_parameter = point_parameter

	@apply
	def basis_curve():
		def fget( self ):
			return self._basis_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_curve is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._basis_curve = curve(value)
			else:
				self._basis_curve = value
		return property(**locals())

	@apply
	def point_parameter():
		def fget( self ):
			return self._point_parameter
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument point_parameter is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._point_parameter = parameter_value(value)
			else:
				self._point_parameter = value
		return property(**locals())

####################
 # ENTITY shell_based_wireframe_shape_representation #
####################
class shell_based_wireframe_shape_representation(shape_representation):
	'''Entity shell_based_wireframe_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >=  1)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr

	def wr8(self):
		eval_wr8_wr = (SIZEOF(None)  ==  0)
		if not eval_wr8_wr:
			raise AssertionError('Rule wr8 violated')
		else:
			return eval_wr8_wr

	def wr9(self):
		eval_wr9_wr = (SIZEOF(None)  ==  0)
		if not eval_wr9_wr:
			raise AssertionError('Rule wr9 violated')
		else:
			return eval_wr9_wr

	def wr10(self):
		eval_wr10_wr = (SIZEOF(None)  ==  0)
		if not eval_wr10_wr:
			raise AssertionError('Rule wr10 violated')
		else:
			return eval_wr10_wr

	def wr11(self):
		eval_wr11_wr = (SIZEOF(None)  ==  0)
		if not eval_wr11_wr:
			raise AssertionError('Rule wr11 violated')
		else:
			return eval_wr11_wr

	def wr12(self):
		eval_wr12_wr = (SIZEOF(None)  ==  0)
		if not eval_wr12_wr:
			raise AssertionError('Rule wr12 violated')
		else:
			return eval_wr12_wr

	def wr13(self):
		eval_wr13_wr = (self.self.context_of_items.self.geometric_representation_context.self.coordinate_space_dimension  ==  3)
		if not eval_wr13_wr:
			raise AssertionError('Rule wr13 violated')
		else:
			return eval_wr13_wr


####################
 # ENTITY face #
####################
class face(topological_representation_item):
	'''Entity face definition.

	:param bounds
	:type bounds:SET(1,None,'face_bound', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , bounds, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.bounds = bounds

	@apply
	def bounds():
		def fget( self ):
			return self._bounds
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument bounds is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'face_bound', scope = schema_scope)):
				self._bounds = SET(value)
			else:
				self._bounds = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not mixed_loop_type_set(list_to_set(list_face_loops(self))))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  <=  1)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY face_surface #
####################
class face_surface(face,geometric_representation_item):
	'''Entity face_surface definition.

	:param face_geometry
	:type face_geometry:surface

	:param same_sense
	:type same_sense:BOOLEAN
	'''
	def __init__( self , inherited0__name , inherited1__bounds , inherited2__name , face_geometry,same_sense, ):
		face.__init__(self , inherited0__name , inherited1__bounds , )
		geometric_representation_item.__init__(self , inherited2__name , )
		self.face_geometry = face_geometry
		self.same_sense = same_sense

	@apply
	def face_geometry():
		def fget( self ):
			return self._face_geometry
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument face_geometry is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._face_geometry = surface(value)
			else:
				self._face_geometry = value
		return property(**locals())

	@apply
	def same_sense():
		def fget( self ):
			return self._same_sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument same_sense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._same_sense = BOOLEAN(value)
			else:
				self._same_sense = value
		return property(**locals())

####################
 # ENTITY oriented_face #
####################
class oriented_face(face):
	'''Entity oriented_face definition.

	:param face_element
	:type face_element:face

	:param orientation
	:type orientation:BOOLEAN

	:param face_bounds
	:type face_bounds:SET(1,None,'face_bound', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__bounds , face_element,orientation, ):
		face.__init__(self , inherited0__name , inherited1__bounds , )
		self.face_element = face_element
		self.orientation = orientation

	@apply
	def face_element():
		def fget( self ):
			return self._face_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument face_element is mantatory and can not be set to None')
			if not check_type(value,face):
				self._face_element = face(value)
			else:
				self._face_element = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def face_bounds():
		def fget( self ):
			attribute_eval = conditional_reverse(self.self.orientation,self.self.face_element.self.bounds)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument face_bounds is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.ORIENTED_FACE'  ==  TYPEOF(self.self.face_element)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY surface_of_revolution #
####################
class surface_of_revolution(swept_surface):
	'''Entity surface_of_revolution definition.

	:param axis_position
	:type axis_position:axis1_placement

	:param axis_line
	:type axis_line:line
	'''
	def __init__( self , inherited0__name , inherited1__swept_curve , axis_position, ):
		swept_surface.__init__(self , inherited0__name , inherited1__swept_curve , )
		self.axis_position = axis_position

	@apply
	def axis_position():
		def fget( self ):
			return self._axis_position
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument axis_position is mantatory and can not be set to None')
			if not check_type(value,axis1_placement):
				self._axis_position = axis1_placement(value)
			else:
				self._axis_position = value
		return property(**locals())

	@apply
	def axis_line():
		def fget( self ):
			attribute_eval = ((self.dummy_gri  ==  curve())  ==  line(self.axis_position.self.location,self.dummy_gri  ==  vector(self.axis_position.self.z,1)))
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument axis_line is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

####################
 # ENTITY advanced_brep_shape_representation #
####################
class advanced_brep_shape_representation(shape_representation):
	'''Entity advanced_brep_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >  0)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr


####################
 # ENTITY edge_curve #
####################
class edge_curve(edge,geometric_representation_item):
	'''Entity edge_curve definition.

	:param edge_geometry
	:type edge_geometry:curve

	:param same_sense
	:type same_sense:BOOLEAN
	'''
	def __init__( self , inherited0__name , inherited1__edge_start , inherited2__edge_end , inherited3__name , edge_geometry,same_sense, ):
		edge.__init__(self , inherited0__name , inherited1__edge_start , inherited2__edge_end , )
		geometric_representation_item.__init__(self , inherited3__name , )
		self.edge_geometry = edge_geometry
		self.same_sense = same_sense

	@apply
	def edge_geometry():
		def fget( self ):
			return self._edge_geometry
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument edge_geometry is mantatory and can not be set to None')
			if not check_type(value,curve):
				self._edge_geometry = curve(value)
			else:
				self._edge_geometry = value
		return property(**locals())

	@apply
	def same_sense():
		def fget( self ):
			return self._same_sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument same_sense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._same_sense = BOOLEAN(value)
			else:
				self._same_sense = value
		return property(**locals())

####################
 # ENTITY point_replica #
####################
class point_replica(point):
	'''Entity point_replica definition.

	:param parent_pt
	:type parent_pt:point

	:param transformation
	:type transformation:cartesian_transformation_operator
	'''
	def __init__( self , inherited0__name , parent_pt,transformation, ):
		point.__init__(self , inherited0__name , )
		self.parent_pt = parent_pt
		self.transformation = transformation

	@apply
	def parent_pt():
		def fget( self ):
			return self._parent_pt
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument parent_pt is mantatory and can not be set to None')
			if not check_type(value,point):
				self._parent_pt = point(value)
			else:
				self._parent_pt = value
		return property(**locals())

	@apply
	def transformation():
		def fget( self ):
			return self._transformation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transformation is mantatory and can not be set to None')
			if not check_type(value,cartesian_transformation_operator):
				self._transformation = cartesian_transformation_operator(value)
			else:
				self._transformation = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.transformation.self.dim  ==  self.parent_pt.self.dim)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = acyclic_point_replica(self,self.parent_pt)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY product #
####################
class product(BaseEntityClass):
	'''Entity product definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text

	:param frame_of_reference
	:type frame_of_reference:SET(1,None,'product_context', scope = schema_scope)
	'''
	def __init__( self , id,name,description,frame_of_reference, ):
		self.id = id
		self.name = name
		self.description = description
		self.frame_of_reference = frame_of_reference

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def frame_of_reference():
		def fget( self ):
			return self._frame_of_reference
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument frame_of_reference is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'product_context', scope = schema_scope)):
				self._frame_of_reference = SET(value)
			else:
				self._frame_of_reference = value
		return property(**locals())

####################
 # ENTITY shape_aspect_relationship #
####################
class shape_aspect_relationship(BaseEntityClass):
	'''Entity shape_aspect_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param relating_shape_aspect
	:type relating_shape_aspect:shape_aspect

	:param related_shape_aspect
	:type related_shape_aspect:shape_aspect
	'''
	def __init__( self , name,description,relating_shape_aspect,related_shape_aspect, ):
		self.name = name
		self.description = description
		self.relating_shape_aspect = relating_shape_aspect
		self.related_shape_aspect = related_shape_aspect

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def relating_shape_aspect():
		def fget( self ):
			return self._relating_shape_aspect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument relating_shape_aspect is mantatory and can not be set to None')
			if not check_type(value,shape_aspect):
				self._relating_shape_aspect = shape_aspect(value)
			else:
				self._relating_shape_aspect = value
		return property(**locals())

	@apply
	def related_shape_aspect():
		def fget( self ):
			return self._related_shape_aspect
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument related_shape_aspect is mantatory and can not be set to None')
			if not check_type(value,shape_aspect):
				self._related_shape_aspect = shape_aspect(value)
			else:
				self._related_shape_aspect = value
		return property(**locals())

####################
 # ENTITY rectangular_trimmed_surface #
####################
class rectangular_trimmed_surface(bounded_surface):
	'''Entity rectangular_trimmed_surface definition.

	:param basis_surface
	:type basis_surface:surface

	:param u1
	:type u1:parameter_value

	:param u2
	:type u2:parameter_value

	:param v1
	:type v1:parameter_value

	:param v2
	:type v2:parameter_value

	:param usense
	:type usense:BOOLEAN

	:param vsense
	:type vsense:BOOLEAN
	'''
	def __init__( self , inherited0__name , basis_surface,u1,u2,v1,v2,usense,vsense, ):
		bounded_surface.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.u1 = u1
		self.u2 = u2
		self.v1 = v1
		self.v2 = v2
		self.usense = usense
		self.vsense = vsense

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def u1():
		def fget( self ):
			return self._u1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u1 is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._u1 = parameter_value(value)
			else:
				self._u1 = value
		return property(**locals())

	@apply
	def u2():
		def fget( self ):
			return self._u2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u2 is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._u2 = parameter_value(value)
			else:
				self._u2 = value
		return property(**locals())

	@apply
	def v1():
		def fget( self ):
			return self._v1
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v1 is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._v1 = parameter_value(value)
			else:
				self._v1 = value
		return property(**locals())

	@apply
	def v2():
		def fget( self ):
			return self._v2
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v2 is mantatory and can not be set to None')
			if not check_type(value,parameter_value):
				self._v2 = parameter_value(value)
			else:
				self._v2 = value
		return property(**locals())

	@apply
	def usense():
		def fget( self ):
			return self._usense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument usense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._usense = BOOLEAN(value)
			else:
				self._usense = value
		return property(**locals())

	@apply
	def vsense():
		def fget( self ):
			return self._vsense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument vsense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._vsense = BOOLEAN(value)
			else:
				self._vsense = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.u1  !=  self.u2)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (self.v1  !=  self.v2)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (((('CONFIG_CONTROL_DESIGN.ELEMENTARY_SURFACE'  ==  TYPEOF(self.basis_surface))  and  ( not ('CONFIG_CONTROL_DESIGN.PLANE'  ==  TYPEOF(self.basis_surface))))  or  ('CONFIG_CONTROL_DESIGN.SURFACE_OF_REVOLUTION'  ==  TYPEOF(self.basis_surface)))  or  (self.usense  ==  (self.u2  >  self.u1)))
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = ((('CONFIG_CONTROL_DESIGN.SPHERICAL_SURFACE'  ==  TYPEOF(self.basis_surface))  or  ('CONFIG_CONTROL_DESIGN.TOROIDAL_SURFACE'  ==  TYPEOF(self.basis_surface)))  or  (self.vsense  ==  (self.v2  >  self.v1)))
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY plane #
####################
class plane(elementary_surface):
	'''Entity plane definition.
	'''
	def __init__( self , inherited0__name , inherited1__position ,  ):
		elementary_surface.__init__(self , inherited0__name , inherited1__position , )

####################
 # ENTITY action_assignment #
####################
class action_assignment(BaseEntityClass):
	'''Entity action_assignment definition.

	:param assigned_action
	:type assigned_action:action
	'''
	def __init__( self , assigned_action, ):
		self.assigned_action = assigned_action

	@apply
	def assigned_action():
		def fget( self ):
			return self._assigned_action
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_action is mantatory and can not be set to None')
			if not check_type(value,action):
				self._assigned_action = action(value)
			else:
				self._assigned_action = value
		return property(**locals())

####################
 # ENTITY change #
####################
class change(action_assignment):
	'''Entity change definition.

	:param items
	:type items:SET(1,None,'work_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_action , items, ):
		action_assignment.__init__(self , inherited0__assigned_action , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'work_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY circle #
####################
class circle(conic):
	'''Entity circle definition.

	:param radius
	:type radius:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , radius, ):
		conic.__init__(self , inherited0__name , inherited1__position , )
		self.radius = radius

	@apply
	def radius():
		def fget( self ):
			return self._radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument radius is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._radius = positive_length_measure(value)
			else:
				self._radius = value
		return property(**locals())

####################
 # ENTITY line #
####################
class line(curve):
	'''Entity line definition.

	:param pnt
	:type pnt:cartesian_point

	:param dir
	:type dir:vector
	'''
	def __init__( self , inherited0__name , pnt,dir, ):
		curve.__init__(self , inherited0__name , )
		self.pnt = pnt
		self.dir = dir

	@apply
	def pnt():
		def fget( self ):
			return self._pnt
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument pnt is mantatory and can not be set to None')
			if not check_type(value,cartesian_point):
				self._pnt = cartesian_point(value)
			else:
				self._pnt = value
		return property(**locals())

	@apply
	def dir():
		def fget( self ):
			return self._dir
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument dir is mantatory and can not be set to None')
			if not check_type(value,vector):
				self._dir = vector(value)
			else:
				self._dir = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.dir.self.dim  ==  self.pnt.self.dim)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY property_definition_representation #
####################
class property_definition_representation(BaseEntityClass):
	'''Entity property_definition_representation definition.

	:param definition
	:type definition:property_definition

	:param used_representation
	:type used_representation:representation
	'''
	def __init__( self , definition,used_representation, ):
		self.definition = definition
		self.used_representation = used_representation

	@apply
	def definition():
		def fget( self ):
			return self._definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument definition is mantatory and can not be set to None')
			if not check_type(value,property_definition):
				self._definition = property_definition(value)
			else:
				self._definition = value
		return property(**locals())

	@apply
	def used_representation():
		def fget( self ):
			return self._used_representation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument used_representation is mantatory and can not be set to None')
			if not check_type(value,representation):
				self._used_representation = representation(value)
			else:
				self._used_representation = value
		return property(**locals())

####################
 # ENTITY geometric_set #
####################
class geometric_set(geometric_representation_item):
	'''Entity geometric_set definition.

	:param elements
	:type elements:SET(1,None,'geometric_set_select', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , elements, ):
		geometric_representation_item.__init__(self , inherited0__name , )
		self.elements = elements

	@apply
	def elements():
		def fget( self ):
			return self._elements
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument elements is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'geometric_set_select', scope = schema_scope)):
				self._elements = SET(value)
			else:
				self._elements = value
		return property(**locals())

####################
 # ENTITY geometric_curve_set #
####################
class geometric_curve_set(geometric_set):
	'''Entity geometric_curve_set definition.
	'''
	def __init__( self , inherited0__name , inherited1__elements ,  ):
		geometric_set.__init__(self , inherited0__name , inherited1__elements , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY personal_address #
####################
class personal_address(address):
	'''Entity personal_address definition.

	:param people
	:type people:SET(1,None,'person', scope = schema_scope)

	:param description
	:type description:text
	'''
	def __init__( self , inherited0__internal_location , inherited1__street_number , inherited2__street , inherited3__postal_box , inherited4__town , inherited5__region , inherited6__postal_code , inherited7__country , inherited8__facsimile_number , inherited9__telephone_number , inherited10__electronic_mail_address , inherited11__telex_number , people,description, ):
		address.__init__(self , inherited0__internal_location , inherited1__street_number , inherited2__street , inherited3__postal_box , inherited4__town , inherited5__region , inherited6__postal_code , inherited7__country , inherited8__facsimile_number , inherited9__telephone_number , inherited10__electronic_mail_address , inherited11__telex_number , )
		self.people = people
		self.description = description

	@apply
	def people():
		def fget( self ):
			return self._people
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument people is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'person', scope = schema_scope)):
				self._people = SET(value)
			else:
				self._people = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY document_relationship #
####################
class document_relationship(BaseEntityClass):
	'''Entity document_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param relating_document
	:type relating_document:document

	:param related_document
	:type related_document:document
	'''
	def __init__( self , name,description,relating_document,related_document, ):
		self.name = name
		self.description = description
		self.relating_document = relating_document
		self.related_document = related_document

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def relating_document():
		def fget( self ):
			return self._relating_document
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument relating_document is mantatory and can not be set to None')
			if not check_type(value,document):
				self._relating_document = document(value)
			else:
				self._relating_document = value
		return property(**locals())

	@apply
	def related_document():
		def fget( self ):
			return self._related_document
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument related_document is mantatory and can not be set to None')
			if not check_type(value,document):
				self._related_document = document(value)
			else:
				self._related_document = value
		return property(**locals())

####################
 # ENTITY outer_boundary_curve #
####################
class outer_boundary_curve(boundary_curve):
	'''Entity outer_boundary_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__segments , inherited2__self_intersect ,  ):
		boundary_curve.__init__(self , inherited0__name , inherited1__segments , inherited2__self_intersect , )

####################
 # ENTITY shape_representation_relationship #
####################
class shape_representation_relationship(representation_relationship):
	'''Entity shape_representation_relationship definition.
	'''
	def __init__( self , inherited0__name , inherited1__description , inherited2__rep_1 , inherited3__rep_2 ,  ):
		representation_relationship.__init__(self , inherited0__name , inherited1__description , inherited2__rep_1 , inherited3__rep_2 , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.SHAPE_REPRESENTATION'  ==  (TYPEOF(self.self.representation_relationship.self.rep_1)  +  TYPEOF(self.self.representation_relationship.self.rep_2)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY assembly_component_usage_substitute #
####################
class assembly_component_usage_substitute(BaseEntityClass):
	'''Entity assembly_component_usage_substitute definition.

	:param name
	:type name:label

	:param definition
	:type definition:text

	:param base
	:type base:assembly_component_usage

	:param substitute
	:type substitute:assembly_component_usage
	'''
	def __init__( self , name,definition,base,substitute, ):
		self.name = name
		self.definition = definition
		self.base = base
		self.substitute = substitute

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def definition():
		def fget( self ):
			return self._definition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument definition is mantatory and can not be set to None')
			if not check_type(value,text):
				self._definition = text(value)
			else:
				self._definition = value
		return property(**locals())

	@apply
	def base():
		def fget( self ):
			return self._base
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument base is mantatory and can not be set to None')
			if not check_type(value,assembly_component_usage):
				self._base = assembly_component_usage(value)
			else:
				self._base = value
		return property(**locals())

	@apply
	def substitute():
		def fget( self ):
			return self._substitute
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument substitute is mantatory and can not be set to None')
			if not check_type(value,assembly_component_usage):
				self._substitute = assembly_component_usage(value)
			else:
				self._substitute = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.base.self.relating_product_definition  ==  self.substitute.self.relating_product_definition)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (self.base  !=  self.substitute)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY degenerate_pcurve #
####################
class degenerate_pcurve(point):
	'''Entity degenerate_pcurve definition.

	:param basis_surface
	:type basis_surface:surface

	:param reference_to_curve
	:type reference_to_curve:definitional_representation
	'''
	def __init__( self , inherited0__name , basis_surface,reference_to_curve, ):
		point.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.reference_to_curve = reference_to_curve

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def reference_to_curve():
		def fget( self ):
			return self._reference_to_curve
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument reference_to_curve is mantatory and can not be set to None')
			if not check_type(value,definitional_representation):
				self._reference_to_curve = definitional_representation(value)
			else:
				self._reference_to_curve = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.reference_to_curve.self.representation.self.items)  ==  1)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = ('CONFIG_CONTROL_DESIGN.CURVE'  ==  TYPEOF(self.reference_to_curve.self.representation.self.items[1]))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (self.reference_to_curve.self.representation.self.items[1].self.geometric_representation_item.self.dim  ==  2)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr


####################
 # ENTITY evaluated_degenerate_pcurve #
####################
class evaluated_degenerate_pcurve(degenerate_pcurve):
	'''Entity evaluated_degenerate_pcurve definition.

	:param equivalent_point
	:type equivalent_point:cartesian_point
	'''
	def __init__( self , inherited0__name , inherited1__basis_surface , inherited2__reference_to_curve , equivalent_point, ):
		degenerate_pcurve.__init__(self , inherited0__name , inherited1__basis_surface , inherited2__reference_to_curve , )
		self.equivalent_point = equivalent_point

	@apply
	def equivalent_point():
		def fget( self ):
			return self._equivalent_point
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument equivalent_point is mantatory and can not be set to None')
			if not check_type(value,cartesian_point):
				self._equivalent_point = cartesian_point(value)
			else:
				self._equivalent_point = value
		return property(**locals())

####################
 # ENTITY solid_angle_measure_with_unit #
####################
class solid_angle_measure_with_unit(measure_with_unit):
	'''Entity solid_angle_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.SOLID_ANGLE_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY connected_edge_set #
####################
class connected_edge_set(topological_representation_item):
	'''Entity connected_edge_set definition.

	:param ces_edges
	:type ces_edges:SET(1,None,'edge', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , ces_edges, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.ces_edges = ces_edges

	@apply
	def ces_edges():
		def fget( self ):
			return self._ces_edges
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument ces_edges is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'edge', scope = schema_scope)):
				self._ces_edges = SET(value)
			else:
				self._ces_edges = value
		return property(**locals())

####################
 # ENTITY action #
####################
class action(BaseEntityClass):
	'''Entity action definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param chosen_method
	:type chosen_method:action_method
	'''
	def __init__( self , name,description,chosen_method, ):
		self.name = name
		self.description = description
		self.chosen_method = chosen_method

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def chosen_method():
		def fget( self ):
			return self._chosen_method
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument chosen_method is mantatory and can not be set to None')
			if not check_type(value,action_method):
				self._chosen_method = action_method(value)
			else:
				self._chosen_method = value
		return property(**locals())

####################
 # ENTITY executed_action #
####################
class executed_action(action):
	'''Entity executed_action definition.
	'''
	def __init__( self , inherited0__name , inherited1__description , inherited2__chosen_method ,  ):
		action.__init__(self , inherited0__name , inherited1__description , inherited2__chosen_method , )

####################
 # ENTITY directed_action #
####################
class directed_action(executed_action):
	'''Entity directed_action definition.

	:param directive
	:type directive:action_directive
	'''
	def __init__( self , inherited0__name , inherited1__description , inherited2__chosen_method , directive, ):
		executed_action.__init__(self , inherited0__name , inherited1__description , inherited2__chosen_method , )
		self.directive = directive

	@apply
	def directive():
		def fget( self ):
			return self._directive
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument directive is mantatory and can not be set to None')
			if not check_type(value,action_directive):
				self._directive = action_directive(value)
			else:
				self._directive = value
		return property(**locals())

####################
 # ENTITY organizational_project #
####################
class organizational_project(BaseEntityClass):
	'''Entity organizational_project definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param responsible_organizations
	:type responsible_organizations:SET(1,None,'organization', scope = schema_scope)
	'''
	def __init__( self , name,description,responsible_organizations, ):
		self.name = name
		self.description = description
		self.responsible_organizations = responsible_organizations

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def responsible_organizations():
		def fget( self ):
			return self._responsible_organizations
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument responsible_organizations is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'organization', scope = schema_scope)):
				self._responsible_organizations = SET(value)
			else:
				self._responsible_organizations = value
		return property(**locals())

####################
 # ENTITY date_time_role #
####################
class date_time_role(BaseEntityClass):
	'''Entity date_time_role definition.

	:param name
	:type name:label
	'''
	def __init__( self , name, ):
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

####################
 # ENTITY curve_bounded_surface #
####################
class curve_bounded_surface(bounded_surface):
	'''Entity curve_bounded_surface definition.

	:param basis_surface
	:type basis_surface:surface

	:param boundaries
	:type boundaries:SET(1,None,'boundary_curve', scope = schema_scope)

	:param implicit_outer
	:type implicit_outer:BOOLEAN
	'''
	def __init__( self , inherited0__name , basis_surface,boundaries,implicit_outer, ):
		bounded_surface.__init__(self , inherited0__name , )
		self.basis_surface = basis_surface
		self.boundaries = boundaries
		self.implicit_outer = implicit_outer

	@apply
	def basis_surface():
		def fget( self ):
			return self._basis_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument basis_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._basis_surface = surface(value)
			else:
				self._basis_surface = value
		return property(**locals())

	@apply
	def boundaries():
		def fget( self ):
			return self._boundaries
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument boundaries is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'boundary_curve', scope = schema_scope)):
				self._boundaries = SET(value)
			else:
				self._boundaries = value
		return property(**locals())

	@apply
	def implicit_outer():
		def fget( self ):
			return self._implicit_outer
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument implicit_outer is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._implicit_outer = BOOLEAN(value)
			else:
				self._implicit_outer = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not (self.implicit_outer  and  ('CONFIG_CONTROL_DESIGN.OUTER_BOUNDARY_CURVE'  ==  TYPEOF(self.boundaries))))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (( not self.implicit_outer)  or  ('CONFIG_CONTROL_DESIGN.BOUNDED_SURFACE'  ==  TYPEOF(self.basis_surface)))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  <=  1)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY closed_shell #
####################
class closed_shell(connected_face_set):
	'''Entity closed_shell definition.
	'''
	def __init__( self , inherited0__name , inherited1__cfs_faces ,  ):
		connected_face_set.__init__(self , inherited0__name , inherited1__cfs_faces , )

####################
 # ENTITY design_make_from_relationship #
####################
class design_make_from_relationship(product_definition_relationship):
	'''Entity design_make_from_relationship definition.
	'''
	def __init__( self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition ,  ):
		product_definition_relationship.__init__(self , inherited0__id , inherited1__name , inherited2__description , inherited3__relating_product_definition , inherited4__related_product_definition , )

####################
 # ENTITY definitional_representation #
####################
class definitional_representation(representation):
	'''Entity definitional_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.PARAMETRIC_REPRESENTATION_CONTEXT'  ==  TYPEOF(self.self.representation.self.context_of_items))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY product_definition_shape #
####################
class product_definition_shape(property_definition):
	'''Entity product_definition_shape definition.
	'''
	def __init__( self , inherited0__name , inherited1__description , inherited2__definition ,  ):
		property_definition.__init__(self , inherited0__name , inherited1__description , inherited2__definition , )
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.SHAPE_DEFINITION'  ==  TYPEOF(self.self.property_definition.self.definition)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY si_unit #
####################
class si_unit(named_unit):
	'''Entity si_unit definition.

	:param prefix
	:type prefix:si_prefix

	:param name
	:type name:si_unit_name

	:param named_unit_dimensions
	:type named_unit_dimensions:dimensional_exponents
	'''
	def __init__( self , inherited0__dimensions , prefix,name, ):
		named_unit.__init__(self , inherited0__dimensions , )
		self.prefix = prefix
		self.name = name

	@apply
	def prefix():
		def fget( self ):
			return self._prefix
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,si_prefix):
					self._prefix = si_prefix(value)
				else:
					self._prefix = value
			else:
				self._prefix = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,si_unit_name):
				self._name = si_unit_name(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def named_unit_dimensions():
		def fget( self ):
			attribute_eval = dimensions_for_si_unit(self.self.name)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument named_unit_dimensions is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

####################
 # ENTITY bezier_surface #
####################
class bezier_surface(b_spline_surface):
	'''Entity bezier_surface definition.
	'''
	def __init__( self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect ,  ):
		b_spline_surface.__init__(self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , )

####################
 # ENTITY certification_assignment #
####################
class certification_assignment(BaseEntityClass):
	'''Entity certification_assignment definition.

	:param assigned_certification
	:type assigned_certification:certification
	'''
	def __init__( self , assigned_certification, ):
		self.assigned_certification = assigned_certification

	@apply
	def assigned_certification():
		def fget( self ):
			return self._assigned_certification
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_certification is mantatory and can not be set to None')
			if not check_type(value,certification):
				self._assigned_certification = certification(value)
			else:
				self._assigned_certification = value
		return property(**locals())

####################
 # ENTITY start_work #
####################
class start_work(action_assignment):
	'''Entity start_work definition.

	:param items
	:type items:SET(1,None,'work_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_action , items, ):
		action_assignment.__init__(self , inherited0__assigned_action , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'work_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY contract_type #
####################
class contract_type(BaseEntityClass):
	'''Entity contract_type definition.

	:param description
	:type description:label
	'''
	def __init__( self , description, ):
		self.description = description

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,label):
				self._description = label(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY b_spline_curve_with_knots #
####################
class b_spline_curve_with_knots(b_spline_curve):
	'''Entity b_spline_curve_with_knots definition.

	:param knot_multiplicities
	:type knot_multiplicities:LIST(2,None,'INTEGER', scope = schema_scope)

	:param knots
	:type knots:LIST(2,None,'REAL', scope = schema_scope)

	:param knot_spec
	:type knot_spec:knot_type

	:param upper_index_on_knots
	:type upper_index_on_knots:INTEGER
	'''
	def __init__( self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , knot_multiplicities,knots,knot_spec, ):
		b_spline_curve.__init__(self , inherited0__name , inherited1__degree , inherited2__control_points_list , inherited3__curve_form , inherited4__closed_curve , inherited5__self_intersect , )
		self.knot_multiplicities = knot_multiplicities
		self.knots = knots
		self.knot_spec = knot_spec

	@apply
	def knot_multiplicities():
		def fget( self ):
			return self._knot_multiplicities
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument knot_multiplicities is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'INTEGER', scope = schema_scope)):
				self._knot_multiplicities = LIST(value)
			else:
				self._knot_multiplicities = value
		return property(**locals())

	@apply
	def knots():
		def fget( self ):
			return self._knots
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument knots is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'REAL', scope = schema_scope)):
				self._knots = LIST(value)
			else:
				self._knots = value
		return property(**locals())

	@apply
	def knot_spec():
		def fget( self ):
			return self._knot_spec
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument knot_spec is mantatory and can not be set to None')
			if not check_type(value,knot_type):
				self._knot_spec = knot_type(value)
			else:
				self._knot_spec = value
		return property(**locals())

	@apply
	def upper_index_on_knots():
		def fget( self ):
			attribute_eval = SIZEOF(self.knots)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument upper_index_on_knots is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = constraints_param_b_spline(self.degree,self.upper_index_on_knots,self.upper_index_on_control_points,self.knot_multiplicities,self.knots)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(self.knot_multiplicities)  ==  self.upper_index_on_knots)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY cc_design_approval #
####################
class cc_design_approval(approval_assignment):
	'''Entity cc_design_approval definition.

	:param items
	:type items:SET(1,None,'approved_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_approval , items, ):
		approval_assignment.__init__(self , inherited0__assigned_approval , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'approved_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY edge_based_wireframe_shape_representation #
####################
class edge_based_wireframe_shape_representation(shape_representation):
	'''Entity edge_based_wireframe_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >=  1)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr

	def wr8(self):
		eval_wr8_wr = (SIZEOF(None)  ==  0)
		if not eval_wr8_wr:
			raise AssertionError('Rule wr8 violated')
		else:
			return eval_wr8_wr

	def wr9(self):
		eval_wr9_wr = (self.self.context_of_items.self.geometric_representation_context.self.coordinate_space_dimension  ==  3)
		if not eval_wr9_wr:
			raise AssertionError('Rule wr9 violated')
		else:
			return eval_wr9_wr


####################
 # ENTITY geometrically_bounded_wireframe_shape_representation #
####################
class geometrically_bounded_wireframe_shape_representation(shape_representation):
	'''Entity geometrically_bounded_wireframe_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >=  1)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr


####################
 # ENTITY product_concept #
####################
class product_concept(BaseEntityClass):
	'''Entity product_concept definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text

	:param market_context
	:type market_context:product_concept_context
	'''
	def __init__( self , id,name,description,market_context, ):
		self.id = id
		self.name = name
		self.description = description
		self.market_context = market_context

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def market_context():
		def fget( self ):
			return self._market_context
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument market_context is mantatory and can not be set to None')
			if not check_type(value,product_concept_context):
				self._market_context = product_concept_context(value)
			else:
				self._market_context = value
		return property(**locals())

####################
 # ENTITY cc_design_contract #
####################
class cc_design_contract(contract_assignment):
	'''Entity cc_design_contract definition.

	:param items
	:type items:SET(1,None,'contracted_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_contract , items, ):
		contract_assignment.__init__(self , inherited0__assigned_contract , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'contracted_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY seam_curve #
####################
class seam_curve(surface_curve):
	'''Entity seam_curve definition.
	'''
	def __init__( self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation ,  ):
		surface_curve.__init__(self , inherited0__name , inherited1__curve_3d , inherited2__associated_geometry , inherited3__master_representation , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(self.self.surface_curve.self.associated_geometry)  ==  2)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (associated_surface(self.self.surface_curve.self.associated_geometry[1])  ==  associated_surface(self.self.surface_curve.self.associated_geometry[2]))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(self.self.surface_curve.self.associated_geometry[1]))
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(self.self.surface_curve.self.associated_geometry[2]))
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY axis2_placement_3d #
####################
class axis2_placement_3d(placement):
	'''Entity axis2_placement_3d definition.

	:param axis
	:type axis:direction

	:param ref_direction
	:type ref_direction:direction

	:param p
	:type p:LIST(3,3,'direction', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__location , axis,ref_direction, ):
		placement.__init__(self , inherited0__name , inherited1__location , )
		self.axis = axis
		self.ref_direction = ref_direction

	@apply
	def axis():
		def fget( self ):
			return self._axis
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._axis = direction(value)
				else:
					self._axis = value
			else:
				self._axis = value
		return property(**locals())

	@apply
	def ref_direction():
		def fget( self ):
			return self._ref_direction
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,direction):
					self._ref_direction = direction(value)
				else:
					self._ref_direction = value
			else:
				self._ref_direction = value
		return property(**locals())

	@apply
	def p():
		def fget( self ):
			attribute_eval = build_axes(self.axis,self.ref_direction)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument p is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.self.placement.self.location.self.dim  ==  3)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (( not EXISTS(self.axis))  or  (self.axis.self.dim  ==  3))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (( not EXISTS(self.ref_direction))  or  (self.ref_direction.self.dim  ==  3))
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = ((( not EXISTS(self.axis))  or  ( not EXISTS(self.ref_direction)))  or  (cross_product(self.axis,self.ref_direction).self.magnitude  >  0))
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY rational_b_spline_surface #
####################
class rational_b_spline_surface(b_spline_surface):
	'''Entity rational_b_spline_surface definition.

	:param weights_data
	:type weights_data:LIST(2,None,LIST(2,None,'REAL', scope = schema_scope))

	:param weights
	:type weights:ARRAY(0,u_upper,ARRAY(0,v_upper,'REAL', scope = schema_scope))
	'''
	def __init__( self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , weights_data, ):
		b_spline_surface.__init__(self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , )
		self.weights_data = weights_data

	@apply
	def weights_data():
		def fget( self ):
			return self._weights_data
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument weights_data is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,LIST(2,None,'REAL', scope = schema_scope))):
				self._weights_data = LIST(value)
			else:
				self._weights_data = value
		return property(**locals())

	@apply
	def weights():
		def fget( self ):
			attribute_eval = make_array_of_array(self.weights_data,0,self.u_upper,0,self.v_upper)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument weights is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ((SIZEOF(self.weights_data)  ==  SIZEOF(self.self.b_spline_surface.self.control_points_list))  and  (SIZEOF(self.weights_data[1])  ==  SIZEOF(self.self.b_spline_surface.self.control_points_list[1])))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = surface_weights_positive(self)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY configuration_design #
####################
class configuration_design(BaseEntityClass):
	'''Entity configuration_design definition.

	:param configuration
	:type configuration:configuration_item

	:param design
	:type design:product_definition_formation
	'''
	def __init__( self , configuration,design, ):
		self.configuration = configuration
		self.design = design

	@apply
	def configuration():
		def fget( self ):
			return self._configuration
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument configuration is mantatory and can not be set to None')
			if not check_type(value,configuration_item):
				self._configuration = configuration_item(value)
			else:
				self._configuration = value
		return property(**locals())

	@apply
	def design():
		def fget( self ):
			return self._design
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument design is mantatory and can not be set to None')
			if not check_type(value,product_definition_formation):
				self._design = product_definition_formation(value)
			else:
				self._design = value
		return property(**locals())

####################
 # ENTITY design_context #
####################
class design_context(product_definition_context):
	'''Entity design_context definition.
	'''
	def __init__( self , inherited0__name , inherited1__frame_of_reference , inherited2__life_cycle_stage ,  ):
		product_definition_context.__init__(self , inherited0__name , inherited1__frame_of_reference , inherited2__life_cycle_stage , )
	def wr1(self):
		eval_wr1_wr = (self.self.life_cycle_stage  ==  'design')
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY product_definition #
####################
class product_definition(BaseEntityClass):
	'''Entity product_definition definition.

	:param id
	:type id:identifier

	:param description
	:type description:text

	:param formation
	:type formation:product_definition_formation

	:param frame_of_reference
	:type frame_of_reference:product_definition_context
	'''
	def __init__( self , id,description,formation,frame_of_reference, ):
		self.id = id
		self.description = description
		self.formation = formation
		self.frame_of_reference = frame_of_reference

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument id is mantatory and can not be set to None')
			if not check_type(value,identifier):
				self._id = identifier(value)
			else:
				self._id = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def formation():
		def fget( self ):
			return self._formation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument formation is mantatory and can not be set to None')
			if not check_type(value,product_definition_formation):
				self._formation = product_definition_formation(value)
			else:
				self._formation = value
		return property(**locals())

	@apply
	def frame_of_reference():
		def fget( self ):
			return self._frame_of_reference
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument frame_of_reference is mantatory and can not be set to None')
			if not check_type(value,product_definition_context):
				self._frame_of_reference = product_definition_context(value)
			else:
				self._frame_of_reference = value
		return property(**locals())

####################
 # ENTITY product_definition_with_associated_documents #
####################
class product_definition_with_associated_documents(product_definition):
	'''Entity product_definition_with_associated_documents definition.

	:param documentation_ids
	:type documentation_ids:SET(1,None,'document', scope = schema_scope)
	'''
	def __init__( self , inherited0__id , inherited1__description , inherited2__formation , inherited3__frame_of_reference , documentation_ids, ):
		product_definition.__init__(self , inherited0__id , inherited1__description , inherited2__formation , inherited3__frame_of_reference , )
		self.documentation_ids = documentation_ids

	@apply
	def documentation_ids():
		def fget( self ):
			return self._documentation_ids
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument documentation_ids is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'document', scope = schema_scope)):
				self._documentation_ids = SET(value)
			else:
				self._documentation_ids = value
		return property(**locals())

####################
 # ENTITY organization #
####################
class organization(BaseEntityClass):
	'''Entity organization definition.

	:param id
	:type id:identifier

	:param name
	:type name:label

	:param description
	:type description:text
	'''
	def __init__( self , id,name,description, ):
		self.id = id
		self.name = name
		self.description = description

	@apply
	def id():
		def fget( self ):
			return self._id
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,identifier):
					self._id = identifier(value)
				else:
					self._id = value
			else:
				self._id = value
		return property(**locals())

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY cc_design_certification #
####################
class cc_design_certification(certification_assignment):
	'''Entity cc_design_certification definition.

	:param items
	:type items:SET(1,None,'certified_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_certification , items, ):
		certification_assignment.__init__(self , inherited0__assigned_certification , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'certified_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY b_spline_surface_with_knots #
####################
class b_spline_surface_with_knots(b_spline_surface):
	'''Entity b_spline_surface_with_knots definition.

	:param u_multiplicities
	:type u_multiplicities:LIST(2,None,'INTEGER', scope = schema_scope)

	:param v_multiplicities
	:type v_multiplicities:LIST(2,None,'INTEGER', scope = schema_scope)

	:param u_knots
	:type u_knots:LIST(2,None,'REAL', scope = schema_scope)

	:param v_knots
	:type v_knots:LIST(2,None,'REAL', scope = schema_scope)

	:param knot_spec
	:type knot_spec:knot_type

	:param knot_u_upper
	:type knot_u_upper:INTEGER

	:param knot_v_upper
	:type knot_v_upper:INTEGER
	'''
	def __init__( self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , u_multiplicities,v_multiplicities,u_knots,v_knots,knot_spec, ):
		b_spline_surface.__init__(self , inherited0__name , inherited1__u_degree , inherited2__v_degree , inherited3__control_points_list , inherited4__surface_form , inherited5__u_closed , inherited6__v_closed , inherited7__self_intersect , )
		self.u_multiplicities = u_multiplicities
		self.v_multiplicities = v_multiplicities
		self.u_knots = u_knots
		self.v_knots = v_knots
		self.knot_spec = knot_spec

	@apply
	def u_multiplicities():
		def fget( self ):
			return self._u_multiplicities
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_multiplicities is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'INTEGER', scope = schema_scope)):
				self._u_multiplicities = LIST(value)
			else:
				self._u_multiplicities = value
		return property(**locals())

	@apply
	def v_multiplicities():
		def fget( self ):
			return self._v_multiplicities
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_multiplicities is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'INTEGER', scope = schema_scope)):
				self._v_multiplicities = LIST(value)
			else:
				self._v_multiplicities = value
		return property(**locals())

	@apply
	def u_knots():
		def fget( self ):
			return self._u_knots
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_knots is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'REAL', scope = schema_scope)):
				self._u_knots = LIST(value)
			else:
				self._u_knots = value
		return property(**locals())

	@apply
	def v_knots():
		def fget( self ):
			return self._v_knots
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_knots is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'REAL', scope = schema_scope)):
				self._v_knots = LIST(value)
			else:
				self._v_knots = value
		return property(**locals())

	@apply
	def knot_spec():
		def fget( self ):
			return self._knot_spec
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument knot_spec is mantatory and can not be set to None')
			if not check_type(value,knot_type):
				self._knot_spec = knot_type(value)
			else:
				self._knot_spec = value
		return property(**locals())

	@apply
	def knot_u_upper():
		def fget( self ):
			attribute_eval = SIZEOF(self.u_knots)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument knot_u_upper is DERIVED. It is computed and can not be set to any value')
		return property(**locals())

	@apply
	def knot_v_upper():
		def fget( self ):
			attribute_eval = SIZEOF(self.v_knots)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument knot_v_upper is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = constraints_param_b_spline(self.self.b_spline_surface.self.u_degree,self.knot_u_upper,self.self.b_spline_surface.self.u_upper,self.u_multiplicities,self.u_knots)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = constraints_param_b_spline(self.self.b_spline_surface.self.v_degree,self.knot_v_upper,self.self.b_spline_surface.self.v_upper,self.v_multiplicities,self.v_knots)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(self.u_multiplicities)  ==  self.knot_u_upper)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(self.v_multiplicities)  ==  self.knot_v_upper)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr


####################
 # ENTITY certification_type #
####################
class certification_type(BaseEntityClass):
	'''Entity certification_type definition.

	:param description
	:type description:label
	'''
	def __init__( self , description, ):
		self.description = description

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,label):
				self._description = label(value)
			else:
				self._description = value
		return property(**locals())

####################
 # ENTITY oriented_path #
####################
class oriented_path(path):
	'''Entity oriented_path definition.

	:param path_element
	:type path_element:path

	:param orientation
	:type orientation:BOOLEAN

	:param path_edge_list
	:type path_edge_list:LIST(1,None,'oriented_edge', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__edge_list , path_element,orientation, ):
		path.__init__(self , inherited0__name , inherited1__edge_list , )
		self.path_element = path_element
		self.orientation = orientation

	@apply
	def path_element():
		def fget( self ):
			return self._path_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument path_element is mantatory and can not be set to None')
			if not check_type(value,path):
				self._path_element = path(value)
			else:
				self._path_element = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def path_edge_list():
		def fget( self ):
			attribute_eval = conditional_reverse(self.self.orientation,self.self.path_element.self.edge_list)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument path_edge_list is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.ORIENTED_PATH'  ==  TYPEOF(self.self.path_element)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY security_classification #
####################
class security_classification(BaseEntityClass):
	'''Entity security_classification definition.

	:param name
	:type name:label

	:param purpose
	:type purpose:text

	:param security_level
	:type security_level:security_classification_level
	'''
	def __init__( self , name,purpose,security_level, ):
		self.name = name
		self.purpose = purpose
		self.security_level = security_level

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def purpose():
		def fget( self ):
			return self._purpose
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument purpose is mantatory and can not be set to None')
			if not check_type(value,text):
				self._purpose = text(value)
			else:
				self._purpose = value
		return property(**locals())

	@apply
	def security_level():
		def fget( self ):
			return self._security_level
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument security_level is mantatory and can not be set to None')
			if not check_type(value,security_classification_level):
				self._security_level = security_classification_level(value)
			else:
				self._security_level = value
		return property(**locals())

####################
 # ENTITY vertex_loop #
####################
class vertex_loop(loop):
	'''Entity vertex_loop definition.

	:param loop_vertex
	:type loop_vertex:vertex
	'''
	def __init__( self , inherited0__name , loop_vertex, ):
		loop.__init__(self , inherited0__name , )
		self.loop_vertex = loop_vertex

	@apply
	def loop_vertex():
		def fget( self ):
			return self._loop_vertex
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument loop_vertex is mantatory and can not be set to None')
			if not check_type(value,vertex):
				self._loop_vertex = vertex(value)
			else:
				self._loop_vertex = value
		return property(**locals())

####################
 # ENTITY approval_status #
####################
class approval_status(BaseEntityClass):
	'''Entity approval_status definition.

	:param name
	:type name:label
	'''
	def __init__( self , name, ):
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

####################
 # ENTITY cartesian_point #
####################
class cartesian_point(point):
	'''Entity cartesian_point definition.

	:param coordinates
	:type coordinates:LIST(1,3,'REAL', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , coordinates, ):
		point.__init__(self , inherited0__name , )
		self.coordinates = coordinates

	@apply
	def coordinates():
		def fget( self ):
			return self._coordinates
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument coordinates is mantatory and can not be set to None')
			if not check_type(value,LIST(1,3,'REAL', scope = schema_scope)):
				self._coordinates = LIST(value)
			else:
				self._coordinates = value
		return property(**locals())

####################
 # ENTITY date_and_time_assignment #
####################
class date_and_time_assignment(BaseEntityClass):
	'''Entity date_and_time_assignment definition.

	:param assigned_date_and_time
	:type assigned_date_and_time:date_and_time

	:param role
	:type role:date_time_role
	'''
	def __init__( self , assigned_date_and_time,role, ):
		self.assigned_date_and_time = assigned_date_and_time
		self.role = role

	@apply
	def assigned_date_and_time():
		def fget( self ):
			return self._assigned_date_and_time
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_date_and_time is mantatory and can not be set to None')
			if not check_type(value,date_and_time):
				self._assigned_date_and_time = date_and_time(value)
			else:
				self._assigned_date_and_time = value
		return property(**locals())

	@apply
	def role():
		def fget( self ):
			return self._role
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument role is mantatory and can not be set to None')
			if not check_type(value,date_time_role):
				self._role = date_time_role(value)
			else:
				self._role = value
		return property(**locals())

####################
 # ENTITY parametric_representation_context #
####################
class parametric_representation_context(representation_context):
	'''Entity parametric_representation_context definition.
	'''
	def __init__( self , inherited0__context_identifier , inherited1__context_type ,  ):
		representation_context.__init__(self , inherited0__context_identifier , inherited1__context_type , )

####################
 # ENTITY product_concept_context #
####################
class product_concept_context(application_context_element):
	'''Entity product_concept_context definition.

	:param market_segment_type
	:type market_segment_type:label
	'''
	def __init__( self , inherited0__name , inherited1__frame_of_reference , market_segment_type, ):
		application_context_element.__init__(self , inherited0__name , inherited1__frame_of_reference , )
		self.market_segment_type = market_segment_type

	@apply
	def market_segment_type():
		def fget( self ):
			return self._market_segment_type
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument market_segment_type is mantatory and can not be set to None')
			if not check_type(value,label):
				self._market_segment_type = label(value)
			else:
				self._market_segment_type = value
		return property(**locals())

####################
 # ENTITY surface_patch #
####################
class surface_patch(founded_item):
	'''Entity surface_patch definition.

	:param parent_surface
	:type parent_surface:bounded_surface

	:param u_transition
	:type u_transition:transition_code

	:param v_transition
	:type v_transition:transition_code

	:param u_sense
	:type u_sense:BOOLEAN

	:param v_sense
	:type v_sense:BOOLEAN

	:param using_surfaces
	:type using_surfaces:BAG(1,None,'rectangular_composite_surface', scope = schema_scope)
	'''
	def __init__( self , parent_surface,u_transition,v_transition,u_sense,v_sense, ):
		founded_item.__init__(self , )
		self.parent_surface = parent_surface
		self.u_transition = u_transition
		self.v_transition = v_transition
		self.u_sense = u_sense
		self.v_sense = v_sense

	@apply
	def parent_surface():
		def fget( self ):
			return self._parent_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument parent_surface is mantatory and can not be set to None')
			if not check_type(value,bounded_surface):
				self._parent_surface = bounded_surface(value)
			else:
				self._parent_surface = value
		return property(**locals())

	@apply
	def u_transition():
		def fget( self ):
			return self._u_transition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_transition is mantatory and can not be set to None')
			if not check_type(value,transition_code):
				self._u_transition = transition_code(value)
			else:
				self._u_transition = value
		return property(**locals())

	@apply
	def v_transition():
		def fget( self ):
			return self._v_transition
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_transition is mantatory and can not be set to None')
			if not check_type(value,transition_code):
				self._v_transition = transition_code(value)
			else:
				self._v_transition = value
		return property(**locals())

	@apply
	def u_sense():
		def fget( self ):
			return self._u_sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument u_sense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._u_sense = BOOLEAN(value)
			else:
				self._u_sense = value
		return property(**locals())

	@apply
	def v_sense():
		def fget( self ):
			return self._v_sense
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument v_sense is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._v_sense = BOOLEAN(value)
			else:
				self._v_sense = value
		return property(**locals())

	@apply
	def using_surfaces():
		def fget( self ):
			return self._using_surfaces
		def fset( self, value ):
		# INVERSE argument
			raise AssertionError('Argument using_surfaces is INVERSE. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.CURVE_BOUNDED_SURFACE'  ==  TYPEOF(self.parent_surface)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY length_unit #
####################
class length_unit(named_unit):
	'''Entity length_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  1)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY shape_aspect #
####################
class shape_aspect(BaseEntityClass):
	'''Entity shape_aspect definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param of_shape
	:type of_shape:product_definition_shape

	:param product_definitional
	:type product_definitional:LOGICAL
	'''
	def __init__( self , name,description,of_shape,product_definitional, ):
		self.name = name
		self.description = description
		self.of_shape = of_shape
		self.product_definitional = product_definitional

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def of_shape():
		def fget( self ):
			return self._of_shape
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument of_shape is mantatory and can not be set to None')
			if not check_type(value,product_definition_shape):
				self._of_shape = product_definition_shape(value)
			else:
				self._of_shape = value
		return property(**locals())

	@apply
	def product_definitional():
		def fget( self ):
			return self._product_definitional
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument product_definitional is mantatory and can not be set to None')
			if not check_type(value,LOGICAL):
				self._product_definitional = LOGICAL(value)
			else:
				self._product_definitional = value
		return property(**locals())

####################
 # ENTITY volume_measure_with_unit #
####################
class volume_measure_with_unit(measure_with_unit):
	'''Entity volume_measure_with_unit definition.
	'''
	def __init__( self , inherited0__value_component , inherited1__unit_component ,  ):
		measure_with_unit.__init__(self , inherited0__value_component , inherited1__unit_component , )
	def wr1(self):
		eval_wr1_wr = ('CONFIG_CONTROL_DESIGN.VOLUME_UNIT'  ==  TYPEOF(self.self.measure_with_unit.self.unit_component))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY advanced_face #
####################
class advanced_face(face_surface):
	'''Entity advanced_face definition.
	'''
	def __init__( self , inherited0__name , inherited1__bounds , inherited2__name , inherited3__face_geometry , inherited4__same_sense ,  ):
		face_surface.__init__(self , inherited0__name , inherited1__bounds , inherited2__name , inherited3__face_geometry , inherited4__same_sense , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(['CONFIG_CONTROL_DESIGN.ELEMENTARY_SURFACE','CONFIG_CONTROL_DESIGN.B_SPLINE_SURFACE','CONFIG_CONTROL_DESIGN.SWEPT_SURFACE']  *  TYPEOF(self.face_geometry))  ==  1)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  ==  0)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (( not ('CONFIG_CONTROL_DESIGN.SWEPT_SURFACE'  ==  TYPEOF(self.face_geometry)))  or  (SIZEOF(['CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.CONIC','CONFIG_CONTROL_DESIGN.POLYLINE','CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE']  *  TYPEOF(self.face_geometry.self.swept_surface.self.swept_curve))  ==  1))
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr

	def wr8(self):
		eval_wr8_wr = (SIZEOF(None)  ==  0)
		if not eval_wr8_wr:
			raise AssertionError('Rule wr8 violated')
		else:
			return eval_wr8_wr

	def wr9(self):
		eval_wr9_wr = (SIZEOF(None)  ==  0)
		if not eval_wr9_wr:
			raise AssertionError('Rule wr9 violated')
		else:
			return eval_wr9_wr

	def wr10(self):
		eval_wr10_wr = (((( not ('CONFIG_CONTROL_DESIGN.SWEPT_SURFACE'  ==  TYPEOF(self.face_geometry)))  or  ( not ('CONFIG_CONTROL_DESIGN.POLYLINE'  ==  TYPEOF(self.face_geometry.self.swept_surface.self.swept_curve))))  or  (SIZEOF(self.face_geometry.self.swept_surface.self.swept_curve.self.polyline.self.points)  >=  3))  and  (SIZEOF(None)  ==  0))
		if not eval_wr10_wr:
			raise AssertionError('Rule wr10 violated')
		else:
			return eval_wr10_wr


####################
 # ENTITY security_classification_level #
####################
class security_classification_level(BaseEntityClass):
	'''Entity security_classification_level definition.

	:param name
	:type name:label
	'''
	def __init__( self , name, ):
		self.name = name

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

####################
 # ENTITY approval_relationship #
####################
class approval_relationship(BaseEntityClass):
	'''Entity approval_relationship definition.

	:param name
	:type name:label

	:param description
	:type description:text

	:param relating_approval
	:type relating_approval:approval

	:param related_approval
	:type related_approval:approval
	'''
	def __init__( self , name,description,relating_approval,related_approval, ):
		self.name = name
		self.description = description
		self.relating_approval = relating_approval
		self.related_approval = related_approval

	@apply
	def name():
		def fget( self ):
			return self._name
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument name is mantatory and can not be set to None')
			if not check_type(value,label):
				self._name = label(value)
			else:
				self._name = value
		return property(**locals())

	@apply
	def description():
		def fget( self ):
			return self._description
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument description is mantatory and can not be set to None')
			if not check_type(value,text):
				self._description = text(value)
			else:
				self._description = value
		return property(**locals())

	@apply
	def relating_approval():
		def fget( self ):
			return self._relating_approval
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument relating_approval is mantatory and can not be set to None')
			if not check_type(value,approval):
				self._relating_approval = approval(value)
			else:
				self._relating_approval = value
		return property(**locals())

	@apply
	def related_approval():
		def fget( self ):
			return self._related_approval
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument related_approval is mantatory and can not be set to None')
			if not check_type(value,approval):
				self._related_approval = approval(value)
			else:
				self._related_approval = value
		return property(**locals())

####################
 # ENTITY polyline #
####################
class polyline(bounded_curve):
	'''Entity polyline definition.

	:param points
	:type points:LIST(2,None,'cartesian_point', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , points, ):
		bounded_curve.__init__(self , inherited0__name , )
		self.points = points

	@apply
	def points():
		def fget( self ):
			return self._points
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument points is mantatory and can not be set to None')
			if not check_type(value,LIST(2,None,'cartesian_point', scope = schema_scope)):
				self._points = LIST(value)
			else:
				self._points = value
		return property(**locals())

####################
 # ENTITY approval_person_organization #
####################
class approval_person_organization(BaseEntityClass):
	'''Entity approval_person_organization definition.

	:param person_organization
	:type person_organization:person_organization_select

	:param authorized_approval
	:type authorized_approval:approval

	:param role
	:type role:approval_role
	'''
	def __init__( self , person_organization,authorized_approval,role, ):
		self.person_organization = person_organization
		self.authorized_approval = authorized_approval
		self.role = role

	@apply
	def person_organization():
		def fget( self ):
			return self._person_organization
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument person_organization is mantatory and can not be set to None')
			if not check_type(value,person_organization_select):
				self._person_organization = person_organization_select(value)
			else:
				self._person_organization = value
		return property(**locals())

	@apply
	def authorized_approval():
		def fget( self ):
			return self._authorized_approval
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument authorized_approval is mantatory and can not be set to None')
			if not check_type(value,approval):
				self._authorized_approval = approval(value)
			else:
				self._authorized_approval = value
		return property(**locals())

	@apply
	def role():
		def fget( self ):
			return self._role
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument role is mantatory and can not be set to None')
			if not check_type(value,approval_role):
				self._role = approval_role(value)
			else:
				self._role = value
		return property(**locals())

####################
 # ENTITY surface_replica #
####################
class surface_replica(surface):
	'''Entity surface_replica definition.

	:param parent_surface
	:type parent_surface:surface

	:param transformation
	:type transformation:cartesian_transformation_operator_3d
	'''
	def __init__( self , inherited0__name , parent_surface,transformation, ):
		surface.__init__(self , inherited0__name , )
		self.parent_surface = parent_surface
		self.transformation = transformation

	@apply
	def parent_surface():
		def fget( self ):
			return self._parent_surface
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument parent_surface is mantatory and can not be set to None')
			if not check_type(value,surface):
				self._parent_surface = surface(value)
			else:
				self._parent_surface = value
		return property(**locals())

	@apply
	def transformation():
		def fget( self ):
			return self._transformation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument transformation is mantatory and can not be set to None')
			if not check_type(value,cartesian_transformation_operator_3d):
				self._transformation = cartesian_transformation_operator_3d(value)
			else:
				self._transformation = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = acyclic_surface_replica(self,self.parent_surface)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY security_classification_assignment #
####################
class security_classification_assignment(BaseEntityClass):
	'''Entity security_classification_assignment definition.

	:param assigned_security_classification
	:type assigned_security_classification:security_classification
	'''
	def __init__( self , assigned_security_classification, ):
		self.assigned_security_classification = assigned_security_classification

	@apply
	def assigned_security_classification():
		def fget( self ):
			return self._assigned_security_classification
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument assigned_security_classification is mantatory and can not be set to None')
			if not check_type(value,security_classification):
				self._assigned_security_classification = security_classification(value)
			else:
				self._assigned_security_classification = value
		return property(**locals())

####################
 # ENTITY cc_design_security_classification #
####################
class cc_design_security_classification(security_classification_assignment):
	'''Entity cc_design_security_classification definition.

	:param items
	:type items:SET(1,None,'classified_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_security_classification , items, ):
		security_classification_assignment.__init__(self , inherited0__assigned_security_classification , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'classified_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())

####################
 # ENTITY faceted_brep_shape_representation #
####################
class faceted_brep_shape_representation(shape_representation):
	'''Entity faceted_brep_shape_representation definition.
	'''
	def __init__( self , inherited0__name , inherited1__items , inherited2__context_of_items ,  ):
		shape_representation.__init__(self , inherited0__name , inherited1__items , inherited2__context_of_items , )
	def wr1(self):
		eval_wr1_wr = (SIZEOF(None)  ==  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = (SIZEOF(None)  >  0)
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr

	def wr3(self):
		eval_wr3_wr = (SIZEOF(None)  ==  0)
		if not eval_wr3_wr:
			raise AssertionError('Rule wr3 violated')
		else:
			return eval_wr3_wr

	def wr4(self):
		eval_wr4_wr = (SIZEOF(None)  ==  0)
		if not eval_wr4_wr:
			raise AssertionError('Rule wr4 violated')
		else:
			return eval_wr4_wr

	def wr5(self):
		eval_wr5_wr = (SIZEOF(None)  ==  0)
		if not eval_wr5_wr:
			raise AssertionError('Rule wr5 violated')
		else:
			return eval_wr5_wr

	def wr6(self):
		eval_wr6_wr = (SIZEOF(None)  ==  0)
		if not eval_wr6_wr:
			raise AssertionError('Rule wr6 violated')
		else:
			return eval_wr6_wr

	def wr7(self):
		eval_wr7_wr = (SIZEOF(None)  ==  0)
		if not eval_wr7_wr:
			raise AssertionError('Rule wr7 violated')
		else:
			return eval_wr7_wr


####################
 # ENTITY document_usage_constraint #
####################
class document_usage_constraint(BaseEntityClass):
	'''Entity document_usage_constraint definition.

	:param source
	:type source:document

	:param subject_element
	:type subject_element:label

	:param subject_element_value
	:type subject_element_value:text
	'''
	def __init__( self , source,subject_element,subject_element_value, ):
		self.source = source
		self.subject_element = subject_element
		self.subject_element_value = subject_element_value

	@apply
	def source():
		def fget( self ):
			return self._source
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument source is mantatory and can not be set to None')
			if not check_type(value,document):
				self._source = document(value)
			else:
				self._source = value
		return property(**locals())

	@apply
	def subject_element():
		def fget( self ):
			return self._subject_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument subject_element is mantatory and can not be set to None')
			if not check_type(value,label):
				self._subject_element = label(value)
			else:
				self._subject_element = value
		return property(**locals())

	@apply
	def subject_element_value():
		def fget( self ):
			return self._subject_element_value
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument subject_element_value is mantatory and can not be set to None')
			if not check_type(value,text):
				self._subject_element_value = text(value)
			else:
				self._subject_element_value = value
		return property(**locals())

####################
 # ENTITY vertex_point #
####################
class vertex_point(vertex,geometric_representation_item):
	'''Entity vertex_point definition.

	:param vertex_geometry
	:type vertex_geometry:point
	'''
	def __init__( self , inherited0__name , inherited1__name , vertex_geometry, ):
		vertex.__init__(self , inherited0__name , )
		geometric_representation_item.__init__(self , inherited1__name , )
		self.vertex_geometry = vertex_geometry

	@apply
	def vertex_geometry():
		def fget( self ):
			return self._vertex_geometry
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument vertex_geometry is mantatory and can not be set to None')
			if not check_type(value,point):
				self._vertex_geometry = point(value)
			else:
				self._vertex_geometry = value
		return property(**locals())

####################
 # ENTITY cc_design_date_and_time_assignment #
####################
class cc_design_date_and_time_assignment(date_and_time_assignment):
	'''Entity cc_design_date_and_time_assignment definition.

	:param items
	:type items:SET(1,None,'date_time_item', scope = schema_scope)
	'''
	def __init__( self , inherited0__assigned_date_and_time , inherited1__role , items, ):
		date_and_time_assignment.__init__(self , inherited0__assigned_date_and_time , inherited1__role , )
		self.items = items

	@apply
	def items():
		def fget( self ):
			return self._items
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument items is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'date_time_item', scope = schema_scope)):
				self._items = SET(value)
			else:
				self._items = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = cc_design_date_time_correlation(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY oriented_closed_shell #
####################
class oriented_closed_shell(closed_shell):
	'''Entity oriented_closed_shell definition.

	:param closed_shell_element
	:type closed_shell_element:closed_shell

	:param orientation
	:type orientation:BOOLEAN

	:param connected_face_set_cfs_faces
	:type connected_face_set_cfs_faces:SET(1,None,'face', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__cfs_faces , closed_shell_element,orientation, ):
		closed_shell.__init__(self , inherited0__name , inherited1__cfs_faces , )
		self.closed_shell_element = closed_shell_element
		self.orientation = orientation

	@apply
	def closed_shell_element():
		def fget( self ):
			return self._closed_shell_element
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument closed_shell_element is mantatory and can not be set to None')
			if not check_type(value,closed_shell):
				self._closed_shell_element = closed_shell(value)
			else:
				self._closed_shell_element = value
		return property(**locals())

	@apply
	def orientation():
		def fget( self ):
			return self._orientation
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument orientation is mantatory and can not be set to None')
			if not check_type(value,BOOLEAN):
				self._orientation = BOOLEAN(value)
			else:
				self._orientation = value
		return property(**locals())

	@apply
	def connected_face_set_cfs_faces():
		def fget( self ):
			attribute_eval = conditional_reverse(self.self.orientation,self.self.closed_shell_element.self.cfs_faces)
			return attribute_eval
		def fset( self, value ):
		# DERIVED argument
			raise AssertionError('Argument connected_face_set_cfs_faces is DERIVED. It is computed and can not be set to any value')
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not ('CONFIG_CONTROL_DESIGN.ORIENTED_CLOSED_SHELL'  ==  TYPEOF(self.self.closed_shell_element)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY person_and_organization #
####################
class person_and_organization(BaseEntityClass):
	'''Entity person_and_organization definition.

	:param the_person
	:type the_person:person

	:param the_organization
	:type the_organization:organization
	'''
	def __init__( self , the_person,the_organization, ):
		self.the_person = the_person
		self.the_organization = the_organization

	@apply
	def the_person():
		def fget( self ):
			return self._the_person
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument the_person is mantatory and can not be set to None')
			if not check_type(value,person):
				self._the_person = person(value)
			else:
				self._the_person = value
		return property(**locals())

	@apply
	def the_organization():
		def fget( self ):
			return self._the_organization
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument the_organization is mantatory and can not be set to None')
			if not check_type(value,organization):
				self._the_organization = organization(value)
			else:
				self._the_organization = value
		return property(**locals())

####################
 # ENTITY cylindrical_surface #
####################
class cylindrical_surface(elementary_surface):
	'''Entity cylindrical_surface definition.

	:param radius
	:type radius:positive_length_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , radius, ):
		elementary_surface.__init__(self , inherited0__name , inherited1__position , )
		self.radius = radius

	@apply
	def radius():
		def fget( self ):
			return self._radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument radius is mantatory and can not be set to None')
			if not check_type(value,positive_length_measure):
				self._radius = positive_length_measure(value)
			else:
				self._radius = value
		return property(**locals())

####################
 # ENTITY local_time #
####################
class local_time(BaseEntityClass):
	'''Entity local_time definition.

	:param hour_component
	:type hour_component:hour_in_day

	:param minute_component
	:type minute_component:minute_in_hour

	:param second_component
	:type second_component:second_in_minute

	:param zone
	:type zone:coordinated_universal_time_offset
	'''
	def __init__( self , hour_component,minute_component,second_component,zone, ):
		self.hour_component = hour_component
		self.minute_component = minute_component
		self.second_component = second_component
		self.zone = zone

	@apply
	def hour_component():
		def fget( self ):
			return self._hour_component
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument hour_component is mantatory and can not be set to None')
			if not check_type(value,hour_in_day):
				self._hour_component = hour_in_day(value)
			else:
				self._hour_component = value
		return property(**locals())

	@apply
	def minute_component():
		def fget( self ):
			return self._minute_component
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,minute_in_hour):
					self._minute_component = minute_in_hour(value)
				else:
					self._minute_component = value
			else:
				self._minute_component = value
		return property(**locals())

	@apply
	def second_component():
		def fget( self ):
			return self._second_component
		def fset( self, value ):
			if value != None: # OPTIONAL attribute
				if not check_type(value,second_in_minute):
					self._second_component = second_in_minute(value)
				else:
					self._second_component = value
			else:
				self._second_component = value
		return property(**locals())

	@apply
	def zone():
		def fget( self ):
			return self._zone
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument zone is mantatory and can not be set to None')
			if not check_type(value,coordinated_universal_time_offset):
				self._zone = coordinated_universal_time_offset(value)
			else:
				self._zone = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = valid_time(self)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY mass_unit #
####################
class mass_unit(named_unit):
	'''Entity mass_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  0)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  1))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY vertex_shell #
####################
class vertex_shell(topological_representation_item):
	'''Entity vertex_shell definition.

	:param vertex_shell_extent
	:type vertex_shell_extent:vertex_loop
	'''
	def __init__( self , inherited0__name , vertex_shell_extent, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.vertex_shell_extent = vertex_shell_extent

	@apply
	def vertex_shell_extent():
		def fget( self ):
			return self._vertex_shell_extent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument vertex_shell_extent is mantatory and can not be set to None')
			if not check_type(value,vertex_loop):
				self._vertex_shell_extent = vertex_loop(value)
			else:
				self._vertex_shell_extent = value
		return property(**locals())

####################
 # ENTITY poly_loop #
####################
class poly_loop(loop,geometric_representation_item):
	'''Entity poly_loop definition.

	:param polygon
	:type polygon:LIST(3,None,'cartesian_point', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , inherited1__name , polygon, ):
		loop.__init__(self , inherited0__name , )
		geometric_representation_item.__init__(self , inherited1__name , )
		self.polygon = polygon

	@apply
	def polygon():
		def fget( self ):
			return self._polygon
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument polygon is mantatory and can not be set to None')
			if not check_type(value,LIST(3,None,'cartesian_point', scope = schema_scope)):
				self._polygon = LIST(value)
			else:
				self._polygon = value
		return property(**locals())

####################
 # ENTITY wire_shell #
####################
class wire_shell(topological_representation_item):
	'''Entity wire_shell definition.

	:param wire_shell_extent
	:type wire_shell_extent:SET(1,None,'loop', scope = schema_scope)
	'''
	def __init__( self , inherited0__name , wire_shell_extent, ):
		topological_representation_item.__init__(self , inherited0__name , )
		self.wire_shell_extent = wire_shell_extent

	@apply
	def wire_shell_extent():
		def fget( self ):
			return self._wire_shell_extent
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument wire_shell_extent is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'loop', scope = schema_scope)):
				self._wire_shell_extent = SET(value)
			else:
				self._wire_shell_extent = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = ( not mixed_loop_type_set(self.wire_shell_extent))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY area_unit #
####################
class area_unit(named_unit):
	'''Entity area_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  2)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY mapped_item #
####################
class mapped_item(representation_item):
	'''Entity mapped_item definition.

	:param mapping_source
	:type mapping_source:representation_map

	:param mapping_target
	:type mapping_target:representation_item
	'''
	def __init__( self , inherited0__name , mapping_source,mapping_target, ):
		representation_item.__init__(self , inherited0__name , )
		self.mapping_source = mapping_source
		self.mapping_target = mapping_target

	@apply
	def mapping_source():
		def fget( self ):
			return self._mapping_source
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument mapping_source is mantatory and can not be set to None')
			if not check_type(value,representation_map):
				self._mapping_source = representation_map(value)
			else:
				self._mapping_source = value
		return property(**locals())

	@apply
	def mapping_target():
		def fget( self ):
			return self._mapping_target
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument mapping_target is mantatory and can not be set to None')
			if not check_type(value,representation_item):
				self._mapping_target = representation_item(value)
			else:
				self._mapping_target = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = acyclic_mapped_representation(using_representations(self),[self])
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY shape_definition_representation #
####################
class shape_definition_representation(property_definition_representation):
	'''Entity shape_definition_representation definition.
	'''
	def __init__( self , inherited0__definition , inherited1__used_representation ,  ):
		property_definition_representation.__init__(self , inherited0__definition , inherited1__used_representation , )
	def wr1(self):
		eval_wr1_wr = (('CONFIG_CONTROL_DESIGN.SHAPE_DEFINITION'  ==  TYPEOF(self.self.definition.self.definition))  or  ('CONFIG_CONTROL_DESIGN.PRODUCT_DEFINITION_SHAPE'  ==  TYPEOF(self.self.definition)))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr

	def wr2(self):
		eval_wr2_wr = ('CONFIG_CONTROL_DESIGN.SHAPE_REPRESENTATION'  ==  TYPEOF(self.self.used_representation))
		if not eval_wr2_wr:
			raise AssertionError('Rule wr2 violated')
		else:
			return eval_wr2_wr


####################
 # ENTITY volume_unit #
####################
class volume_unit(named_unit):
	'''Entity volume_unit definition.
	'''
	def __init__( self , inherited0__dimensions ,  ):
		named_unit.__init__(self , inherited0__dimensions , )
	def wr1(self):
		eval_wr1_wr = (((((((self.self.named_unit.self.dimensions.self.length_exponent  ==  3)  and  (self.self.named_unit.self.dimensions.self.mass_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.time_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.electric_current_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.thermodynamic_temperature_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.amount_of_substance_exponent  ==  0))  and  (self.self.named_unit.self.dimensions.self.luminous_intensity_exponent  ==  0))
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY conical_surface #
####################
class conical_surface(elementary_surface):
	'''Entity conical_surface definition.

	:param radius
	:type radius:length_measure

	:param semi_angle
	:type semi_angle:plane_angle_measure
	'''
	def __init__( self , inherited0__name , inherited1__position , radius,semi_angle, ):
		elementary_surface.__init__(self , inherited0__name , inherited1__position , )
		self.radius = radius
		self.semi_angle = semi_angle

	@apply
	def radius():
		def fget( self ):
			return self._radius
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument radius is mantatory and can not be set to None')
			if not check_type(value,length_measure):
				self._radius = length_measure(value)
			else:
				self._radius = value
		return property(**locals())

	@apply
	def semi_angle():
		def fget( self ):
			return self._semi_angle
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument semi_angle is mantatory and can not be set to None')
			if not check_type(value,plane_angle_measure):
				self._semi_angle = plane_angle_measure(value)
			else:
				self._semi_angle = value
		return property(**locals())
	def wr1(self):
		eval_wr1_wr = (self.radius  >=  0)
		if not eval_wr1_wr:
			raise AssertionError('Rule wr1 violated')
		else:
			return eval_wr1_wr


####################
 # ENTITY global_unit_assigned_context #
####################
class global_unit_assigned_context(representation_context):
	'''Entity global_unit_assigned_context definition.

	:param units
	:type units:SET(1,None,'unit', scope = schema_scope)
	'''
	def __init__( self , inherited0__context_identifier , inherited1__context_type , units, ):
		representation_context.__init__(self , inherited0__context_identifier , inherited1__context_type , )
		self.units = units

	@apply
	def units():
		def fget( self ):
			return self._units
		def fset( self, value ):
		# Mandatory argument
			if value==None:
				raise AssertionError('Argument units is mantatory and can not be set to None')
			if not check_type(value,SET(1,None,'unit', scope = schema_scope)):
				self._units = SET(value)
			else:
				self._units = value
		return property(**locals())

####################
 # FUNCTION build_2axes #
####################
def build_2axes(ref_direction,):
	'''
	:param ref_direction
	:type ref_direction:direction
	'''
	return [d,orthogonal_complement(d)]

####################
 # FUNCTION item_in_context #
####################
def item_in_context(item,cntxt,):
	'''
	:param item
	:type item:representation_item
	:param cntxt
	:type cntxt:representation_context
	'''
	if (SIZEOF(USEDIN(item,'CONFIG_CONTROL_DESIGN.REPRESENTATION.ITEMS')  *  cntxt.representations_in_context)  >  0):
		return TRUE
	else:
		y = None
		if (SIZEOF(y)  >  0):
			for  i in range(1,HIINDEX(y),1):
				if (item_in_context(y[i],cntxt)):
					return TRUE
	return FALSE

####################
 # FUNCTION gbsf_check_point #
####################
def gbsf_check_point(pnt,):
	'''
	:param pnt
	:type pnt:point
	'''
	if ('CONFIG_CONTROL_DESIGN.CARTESIAN_POINT'  ==  TYPEOF(pnt)):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.POINT_ON_CURVE'  ==  TYPEOF(pnt)):
			return gbsf_check_curve(pnt.point_on_curve.basis_curve)
		else:
			if ('CONFIG_CONTROL_DESIGN.POINT_ON_SURFACE'  ==  TYPEOF(pnt)):
				return gbsf_check_surface(pnt.point_on_surface.basis_surface)
			else:
				if ('CONFIG_CONTROL_DESIGN.DEGENERATE_PCURVE'  ==  TYPEOF(pnt)):
					return gbsf_check_curve(pnt.degenerate_pcurve.reference_to_curve.representation.items[1])  and  gbsf_check_surface(pnt.degenerate_pcurve.basis_surface)
	return FALSE

####################
 # FUNCTION build_axes #
####################
def build_axes(axis,ref_direction,):
	'''
	:param axis
	:type axis:direction
	:param ref_direction
	:type ref_direction:direction
	'''
	d1 = NVL(normalise(axis),dummy_gri  ==  direction([0,0,1]))
	d2 = first_proj_axis(d1,ref_direction)
	return [d2,normalise(cross_product(d1,d2)).orientation,d1]

####################
 # FUNCTION edge_reversed #
####################
def edge_reversed(an_edge,):
	'''
	:param an_edge
	:type an_edge:edge
	'''
	if ('CONFIG_CONTROL_DESIGN.ORIENTED_EDGE'  ==  TYPEOF(an_edge)):
		the_reverse = (dummy_tri  ==  edge(an_edge.edge_end,an_edge.edge_start))  ==  oriented_edge(an_edge.oriented_edge.edge_element, not an_edge.oriented_edge.orientation)
	else:
		the_reverse = (dummy_tri  ==  edge(an_edge.edge_end,an_edge.edge_start))  ==  oriented_edge(an_edge,FALSE)
	return the_reverse

####################
 # FUNCTION cc_design_person_and_organization_correlation #
####################
def cc_design_person_and_organization_correlation(e,):
	'''
	:param e
	:type e:cc_design_person_and_organization_assignment
	'''
	po_role = e.person_and_organization_assignment.role.name
	case_selector = po_role
	if  case_selector == 'request_recipient':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'initiator':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'creator':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'part_supplier':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'design_supplier':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'design_owner':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'configuration_manager':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'contractor':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'classification_officer':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	else:
		return TRUE
	return TRUE

####################
 # FUNCTION constraints_composite_curve_on_surface #
####################
def constraints_composite_curve_on_surface(c,):
	'''
	:param c
	:type c:composite_curve_on_surface
	'''
	for  k in range(1,n_segments,1):
		if ((( not ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(c.composite_curve.segments[k].parent_curve)))  and  ( not ('CONFIG_CONTROL_DESIGN.SURFACE_CURVE'  ==  TYPEOF(c.composite_curve.segments[k].parent_curve))))  and  ( not ('CONFIG_CONTROL_DESIGN.COMPOSITE_CURVE_ON_SURFACE'  ==  TYPEOF(c.composite_curve.segments[k].parent_curve)))):
			return FALSE
	return TRUE

####################
 # FUNCTION acyclic_mapped_representation #
####################
def acyclic_mapped_representation(parent_set,children_set,):
	'''
	:param parent_set
	:type parent_set:(null)
	:param children_set
	:type children_set:(null)
	'''
	x = None
	if (SIZEOF(x)  >  0):
		for  i in range(1,HIINDEX(x),1):
			if (x[i].mapped_item.mapping_source.mapped_representation  ==  parent_set):
				return FALSE
			if ( not acyclic_mapped_representation(parent_set  +  x[i].mapped_item.mapping_source.mapped_representation,x[i].mapped_item.mapping_source.mapped_representation.items)):
				return FALSE
	x = children_set - x
	if (SIZEOF(x)  >  0):
		for  i in range(1,HIINDEX(x),1):
			y = None
			if ( not acyclic_mapped_representation(parent_set,y)):
				return FALSE
	return TRUE

####################
 # FUNCTION conditional_reverse #
####################
def conditional_reverse(p,an_item,):
	'''
	:param p
	:type p:BOOLEAN
	:param an_item
	:type an_item:reversible_topology
	'''
	if (p):
		return an_item
	else:
		return topology_reversed(an_item)

####################
 # FUNCTION valid_measure_value #
####################
def valid_measure_value(m,):
	'''
	:param m
	:type m:measure_value
	'''
	if ('REAL'  ==  TYPEOF(m)):
		return m  >  0
	else:
		if ('INTEGER'  ==  TYPEOF(m)):
			return m  >  0
		else:
			return TRUE

####################
 # FUNCTION gbsf_check_curve #
####################
def gbsf_check_curve(cv,):
	'''
	:param cv
	:type cv:curve
	'''
	if (SIZEOF(['CONFIG_CONTROL_DESIGN.BOUNDED_CURVE','CONFIG_CONTROL_DESIGN.CONIC','CONFIG_CONTROL_DESIGN.CURVE_REPLICA','CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D']  *  TYPEOF(cv))  >  1):
		return FALSE
	else:
		if (SIZEOF(['CONFIG_CONTROL_DESIGN.CIRCLE','CONFIG_CONTROL_DESIGN.ELLIPSE']  *  TYPEOF(cv))  ==  1):
			return TRUE
		else:
			if ((('CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE'  ==  TYPEOF(cv))  and  (cv.b_spline_curve.self_intersect  ==  FALSE))  or  (cv.b_spline_curve.self_intersect  ==  UNKNOWN)):
				return TRUE
			else:
				if ((('CONFIG_CONTROL_DESIGN.COMPOSITE_CURVE'  ==  TYPEOF(cv))  and  (cv.composite_curve.self_intersect  ==  FALSE))  or  (cv.composite_curve.self_intersect  ==  UNKNOWN)):
					return SIZEOF(None)  ==  0
				else:
					if ('CONFIG_CONTROL_DESIGN.CURVE_REPLICA'  ==  TYPEOF(cv)):
						return gbsf_check_curve(cv.curve_replica.parent_curve)
					else:
						if ((('CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D'  ==  TYPEOF(cv))  and  ((cv.offset_curve_3d.self_intersect  ==  FALSE)  or  (cv.offset_curve_3d.self_intersect  ==  UNKNOWN)))  and  ( not ('CONFIG_CONTROL_DESIGN.POLYLINE'  ==  TYPEOF(cv.basis_curve)))):
							return gbsf_check_curve(cv.offset_curve_3d.basis_curve)
						else:
							if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(cv)):
								return gbsf_check_curve(cv.pcurve.reference_to_curve.representation.items[1])  and  gbsf_check_surface(cv.pcurve.basis_surface)
							else:
								if ('CONFIG_CONTROL_DESIGN.POLYLINE'  ==  TYPEOF(cv)):
									if (SIZEOF(cv.polyline.points)  >=  3):
										return TRUE
								else:
									if ('CONFIG_CONTROL_DESIGN.SURFACE_CURVE'  ==  TYPEOF(cv)):
										if (gbsf_check_curve(cv.surface_curve.curve_3d)):
											for  i in range(1,SIZEOF(cv.surface_curve.associated_geometry),1):
												if ('CONFIG_CONTROL_DESIGN.SURFACE'  ==  TYPEOF(cv.surface_curve.associated_geometry[i])):
													if ( not gbsf_check_surface(cv.surface_curve.associated_geometry[i])):
														return FALSE
												else:
													if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(cv.surface_curve.associated_geometry[i])):
														if ( not gbsf_check_curve(cv.surface_curve.associated_geometry[i])):
															return FALSE
											return TRUE
									else:
										if ('CONFIG_CONTROL_DESIGN.TRIMMED_CURVE'  ==  TYPEOF(cv)):
											if (SIZEOF(['CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.PARABOLA','CONFIG_CONTROL_DESIGN.HYPERBOLA']  *  TYPEOF(cv.trimmed_curve.basis_curve))  ==  1):
												return TRUE
											else:
												return gbsf_check_curve(cv.trimmed_curve.basis_curve)
	return FALSE

####################
 # FUNCTION unique_version_change_order #
####################
def unique_version_change_order(c,):
	'''
	:param c
	:type c:action
	'''
	for  i in range(1,SIZEOF(ords.requests),1):
		assign = assign  +  None
	for  k in range(1,SIZEOF(assign),1):
		versions = versions  +  assign[k].items
	return SIZEOF(None)  ==  0

####################
 # FUNCTION base_axis #
####################
def base_axis(dim,axis1,axis2,axis3,):
	'''
	:param dim
	:type dim:INTEGER
	:param axis1
	:type axis1:direction
	:param axis2
	:type axis2:direction
	:param axis3
	:type axis3:direction
	'''
	if (dim  ==  3):
		d1 = NVL(normalise(axis3),dummy_gri  ==  direction([0,0,1]))
		d2 = first_proj_axis(d1,axis1)
		u = [d2,second_proj_axis(d1,d2,axis2),d1]
	else:
		if (EXISTS(axis1)):
			d1 = normalise(axis1)
			u = [d1,orthogonal_complement(d1)]
			if (EXISTS(axis2)):
				factor = dot_product(axis2,u[2])
				if (factor  <  0):
					u[2].direction_ratios[1] = -u[2].direction_ratios[1]
					u[2].direction_ratios[2] = -u[2].direction_ratios[2]
		else:
			if (EXISTS(axis2)):
				d1 = normalise(axis2)
				u = [orthogonal_complement(d1),d1]
				u[1].direction_ratios[1] = -u[1].direction_ratios[1]
				u[1].direction_ratios[2] = -u[1].direction_ratios[2]
			else:
				u = [dummy_gri  ==  direction([1,0]),dummy_gri  ==  direction([0,1])]
	return u

####################
 # FUNCTION get_basis_surface #
####################
def get_basis_surface(c,):
	'''
	:param c
	:type c:curve_on_surface
	'''
	surfs = []
	if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(c)):
		surfs = [c.pcurve.basis_surface]
	else:
		if ('CONFIG_CONTROL_DESIGN.SURFACE_CURVE'  ==  TYPEOF(c)):
			n = SIZEOF(c.surface_curve.associated_geometry)
			for  i in range(1,n,1):
				surfs = surfs  +  associated_surface(c.surface_curve.associated_geometry[i])
	if ('CONFIG_CONTROL_DESIGN.COMPOSITE_CURVE_ON_SURFACE'  ==  TYPEOF(c)):
		n = SIZEOF(c.composite_curve.segments)
		surfs = get_basis_surface(c.composite_curve.segments[1].parent_curve)
		if (n  >  1):
			for  i in range(2,n,1):
				surfs = surfs  *  get_basis_surface(c.composite_curve.segments[i].parent_curve)
	return surfs

####################
 # FUNCTION cc_design_date_time_correlation #
####################
def cc_design_date_time_correlation(e,):
	'''
	:param e
	:type e:cc_design_date_and_time_assignment
	'''
	dt_role = e.date_and_time_assignment.role.name
	case_selector = dt_role
	if  case_selector == 'creation_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'request_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'release_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'start_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'sign_off_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'contract_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'certification_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'classification_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	elif case_selector == 'declassification_date':
		if (SIZEOF(e.items)  !=  SIZEOF(None)):
			return FALSE
	else:
		return TRUE
	return TRUE

####################
 # FUNCTION list_face_loops #
####################
def list_face_loops(f,):
	'''
	:param f
	:type f:face
	'''
	for  i in range(1,SIZEOF(f.bounds),1):
		loops = loops  +  f.bounds[i].bound
	return loops

####################
 # FUNCTION list_of_topology_reversed #
####################
def list_of_topology_reversed(a_list,):
	'''
	:param a_list
	:type a_list:list_of_reversible_topology_item
	'''
	the_reverse = []
	for  i in range(1,SIZEOF(a_list),1):
		the_reverse = topology_reversed(a_list[i])  +  the_reverse
	return the_reverse

####################
 # FUNCTION msf_curve_check #
####################
def msf_curve_check(cv,):
	'''
	:param cv
	:type cv:curve
	'''
	if (SIZEOF(['CONFIG_CONTROL_DESIGN.BOUNDED_CURVE','CONFIG_CONTROL_DESIGN.CONIC','CONFIG_CONTROL_DESIGN.CURVE_REPLICA','CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D']  *  TYPEOF(cv))  >  1):
		return FALSE
	else:
		if ((('CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE'  ==  TYPEOF(cv))  and  (cv.b_spline_curve.self_intersect  ==  FALSE))  or  (cv.b_spline_curve.self_intersect  ==  UNKNOWN)):
			return TRUE
		else:
			if (SIZEOF(['CONFIG_CONTROL_DESIGN.CONIC','CONFIG_CONTROL_DESIGN.LINE']  *  TYPEOF(cv))  ==  1):
				return TRUE
			else:
				if ('CONFIG_CONTROL_DESIGN.CURVE_REPLICA'  ==  TYPEOF(cv)):
					return msf_curve_check(cv.curve_replica.parent_curve)
				else:
					if ((('CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D'  ==  TYPEOF(cv))  and  ((cv.offset_curve_3d.self_intersect  ==  FALSE)  or  (cv.offset_curve_3d.self_intersect  ==  UNKNOWN)))  and  ( not ('CONFIG_CONTROL_DESIGN.POLYLINE'  ==  TYPEOF(cv.basis_curve)))):
						return msf_curve_check(cv.offset_curve_3d.basis_curve)
					else:
						if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(cv)):
							return msf_curve_check(cv.pcurve.reference_to_curve.representation.items[1])  and  msf_surface_check(cv.pcurve.basis_surface)
						else:
							if ('CONFIG_CONTROL_DESIGN.SURFACE_CURVE'  ==  TYPEOF(cv)):
								if (msf_curve_check(cv.surface_curve.curve_3d)):
									for  i in range(1,SIZEOF(cv.surface_curve.associated_geometry),1):
										if ('CONFIG_CONTROL_DESIGN.SURFACE'  ==  TYPEOF(cv.surface_curve.associated_geometry[i])):
											if ( not msf_surface_check(cv.surface_curve.associated_geometry[i])):
												return FALSE
										else:
											if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(cv.surface_curve.associated_geometry[i])):
												if ( not msf_curve_check(cv.surface_curve.associated_geometry[i])):
													return FALSE
									return TRUE
							else:
								if ('CONFIG_CONTROL_DESIGN.POLYLINE'  ==  TYPEOF(cv)):
									if (SIZEOF(cv.polyline.points)  >=  3):
										return TRUE
	return FALSE

####################
 # FUNCTION shell_reversed #
####################
def shell_reversed(a_shell,):
	'''
	:param a_shell
	:type a_shell:shell
	'''
	if ('CONFIG_CONTROL_DESIGN.OPEN_SHELL'  ==  TYPEOF(a_shell)):
		return open_shell_reversed(a_shell)
	else:
		if ('CONFIG_CONTROL_DESIGN.CLOSED_SHELL'  ==  TYPEOF(a_shell)):
			return closed_shell_reversed(a_shell)
		else:
			return  None

####################
 # FUNCTION topology_reversed #
####################
def topology_reversed(an_item,):
	'''
	:param an_item
	:type an_item:reversible_topology
	'''
	if ('CONFIG_CONTROL_DESIGN.EDGE'  ==  TYPEOF(an_item)):
		return edge_reversed(an_item)
	if ('CONFIG_CONTROL_DESIGN.PATH'  ==  TYPEOF(an_item)):
		return path_reversed(an_item)
	if ('CONFIG_CONTROL_DESIGN.FACE_BOUND'  ==  TYPEOF(an_item)):
		return face_bound_reversed(an_item)
	if ('CONFIG_CONTROL_DESIGN.FACE'  ==  TYPEOF(an_item)):
		return face_reversed(an_item)
	if ('CONFIG_CONTROL_DESIGN.SHELL'  ==  TYPEOF(an_item)):
		return shell_reversed(an_item)
	if ('SET'  ==  TYPEOF(an_item)):
		return set_of_topology_reversed(an_item)
	if ('LIST'  ==  TYPEOF(an_item)):
		return list_of_topology_reversed(an_item)
	return  None

####################
 # FUNCTION first_proj_axis #
####################
def first_proj_axis(z_axis,arg,):
	'''
	:param z_axis
	:type z_axis:direction
	:param arg
	:type arg:direction
	'''
	if ( not EXISTS(z_axis)):
		return  None
	else:
		z = normalise(z_axis)
		if ( not EXISTS(arg)):
			if (z.direction_ratios  !=  [1,0,0]):
				v = dummy_gri  ==  direction([1,0,0])
			else:
				v = dummy_gri  ==  direction([0,1,0])
		else:
			if (arg.dim  !=  3):
				return  None
			if (cross_product(arg,z).magnitude  ==  0):
				return  None
			else:
				v = normalise(arg)
		x_vec = scalar_times_vector(dot_product(v,z),z)
		x_axis = vector_difference(v,x_vec).orientation
		x_axis = normalise(x_axis)
	return x_axis

####################
 # FUNCTION orthogonal_complement #
####################
def orthogonal_complement(vec,):
	'''
	:param vec
	:type vec:direction
	'''
	if ((vec.dim  !=  2)  or  ( not EXISTS(vec))):
		return  None
	else:
		result = dummy_gri  ==  direction([-vec.direction_ratios[2],vec.direction_ratios[1]])
		return result

####################
 # FUNCTION make_array_of_array #
####################
def make_array_of_array(lis,low1,u1,low2,u2,):
	'''
	:param lis
	:type lis:(null)
	:param low1
	:type low1:INTEGER
	:param u1
	:type u1:INTEGER
	:param low2
	:type low2:INTEGER
	:param u2
	:type u2:INTEGER
	'''
	if (((u1 - low1)  +  1)  !=  SIZEOF(lis)):
		return  None
	if (((u2 - low2)  +  1)  !=  SIZEOF(lis[1])):
		return  None
	res = [list_to_array(lis[1],low2,u2),(u1 - low1)  +  1]
	for  i in range(2,HIINDEX(lis),1):
		if (((u2 - low2)  +  1)  !=  SIZEOF(lis[i])):
			return  None
		res[(low1  +  i) - 1] = list_to_array(lis[i],low2,u2)
	return res

####################
 # FUNCTION second_proj_axis #
####################
def second_proj_axis(z_axis,x_axis,arg,):
	'''
	:param z_axis
	:type z_axis:direction
	:param x_axis
	:type x_axis:direction
	:param arg
	:type arg:direction
	'''
	if ( not EXISTS(arg)):
		v = dummy_gri  ==  direction([0,1,0])
	else:
		v = arg
	temp = scalar_times_vector(dot_product(v,z_axis),z_axis)
	y_axis = vector_difference(v,temp)
	temp = scalar_times_vector(dot_product(v,x_axis),x_axis)
	y_axis = vector_difference(y_axis,temp)
	y_axis = normalise(y_axis)
	return y_axis.orientation

####################
 # FUNCTION bag_to_set #
####################
def bag_to_set(the_bag,):
	'''
	:param the_bag
	:type the_bag:(null)
	'''
	if (SIZEOF(the_bag)  >  0):
		for  i in range(1,HIINDEX(the_bag),1):
			the_set = the_set  +  the_bag[i]
	return the_set

####################
 # FUNCTION valid_wireframe_edge_curve #
####################
def valid_wireframe_edge_curve(crv,):
	'''
	:param crv
	:type crv:curve
	'''
	if (SIZEOF(['CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.CONIC','CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE','CONFIG_CONTROL_DESIGN.POLYLINE']  *  TYPEOF(crv))  ==  1):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.CURVE_REPLICA'  ==  TYPEOF(crv)):
			return valid_wireframe_edge_curve(crv.curve_replica.parent_curve)
		else:
			if ('CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D'  ==  TYPEOF(crv)):
				return valid_wireframe_edge_curve(crv.offset_curve_3d.basis_curve)
	return FALSE

####################
 # FUNCTION acyclic_product_category_relationship #
####################
def acyclic_product_category_relationship(relation,children,):
	'''
	:param relation
	:type relation:product_category_relationship
	:param children
	:type children:(null)
	'''
	for  i in range(1,HIINDEX(children),1):
		if (relation.category  ==  children[i]):
			return FALSE
	x = bag_to_set(USEDIN(relation.category,'CONFIG_CONTROL_DESIGN.'  +  'PRODUCT_CATEGORY_RELATIONSHIP.SUB_CATEGORY'))
	local_children = children  +  relation.category
	if (SIZEOF(x)  >  0):
		for  i in range(1,HIINDEX(x),1):
			if ( not acyclic_product_category_relationship(x[i],local_children)):
				return FALSE
	return TRUE

####################
 # FUNCTION surface_weights_positive #
####################
def surface_weights_positive(b,):
	'''
	:param b
	:type b:rational_b_spline_surface
	'''
	for  i in range(0,b.u_upper,1):
		for  j in range(0,b.v_upper,1):
			if (b.weights[i][j]  <=  0):
				result = FALSE
				return result
	return result

####################
 # FUNCTION vector_difference #
####################
def vector_difference(arg1,arg2,):
	'''
	:param arg1
	:type arg1:vector_or_direction
	:param arg2
	:type arg2:vector_or_direction
	'''
	if ((( not EXISTS(arg1))  or  ( not EXISTS(arg2)))  or  (arg1.dim  !=  arg2.dim)):
		return  None
	else:
		# begin/end block
		if ('CONFIG_CONTROL_DESIGN.VECTOR'  ==  TYPEOF(arg1)):
			mag1 = arg1.magnitude
			vec1 = arg1.orientation
		else:
			mag1 = 1
			vec1 = arg1
		if ('CONFIG_CONTROL_DESIGN.VECTOR'  ==  TYPEOF(arg2)):
			mag2 = arg2.magnitude
			vec2 = arg2.orientation
		else:
			mag2 = 1
			vec2 = arg2
		vec1 = normalise(vec1)
		vec2 = normalise(vec2)
		ndim = SIZEOF(vec1.direction_ratios)
		mag = 0
		res = dummy_gri  ==  direction(vec1.direction_ratios)
		for  i in range(1,ndim,1):
			res.direction_ratios[i] = (mag1  *  vec1.direction_ratios[i])  +  (mag2  *  vec2.direction_ratios[i])
			mag = mag  +  (res.direction_ratios[i]  *  res.direction_ratios[i])
		if (mag  >  0):
			result = dummy_gri  ==  vector(res,SQRT(mag))
		else:
			result = dummy_gri  ==  vector(vec1,0)
	return result

####################
 # FUNCTION acyclic_product_definition_relationship #
####################
def acyclic_product_definition_relationship(relation,relatives,specific_relation,):
	'''
	:param relation
	:type relation:product_definition_relationship
	:param relatives
	:type relatives:(null)
	:param specific_relation
	:type specific_relation:STRING
	'''
	if (relation.relating_product_definition  ==  relatives):
		return FALSE
	x = None
	for  i in range(1,HIINDEX(x),1):
		if ( not acyclic_product_definition_relationship(x[i],relatives  +  relation.relating_product_definition,specific_relation)):
			return FALSE
	return TRUE

####################
 # FUNCTION constraints_geometry_shell_based_wireframe_model #
####################
def constraints_geometry_shell_based_wireframe_model(m,):
	'''
	:param m
	:type m:shell_based_wireframe_model
	'''
	for  j in range(1,SIZEOF(m.sbwm_boundary),1):
		if (( not ('CONFIG_CONTROL_DESIGN.WIRE_SHELL'  ==  TYPEOF(m.sbwm_boundary[j])))  and  ( not ('CONFIG_CONTROL_DESIGN.VERTEX_SHELL'  ==  TYPEOF(m.sbwm_boundary[j])))):
			result = FALSE
			return result
	return result

####################
 # FUNCTION list_to_set #
####################
def list_to_set(l,):
	'''
	:param l
	:type l:(null)
	'''
	for  i in range(1,SIZEOF(l),1):
		s = s  +  l[i]
	return s

####################
 # FUNCTION valid_calendar_date #
####################
def valid_calendar_date(date,):
	'''
	:param date
	:type date:calendar_date
	'''
	if ( not ((1  <=  date.day_component)  and  (date.day_component  <=  31))):
		return FALSE
	case_selector = date.month_component
	if  case_selector == 4:
		return (1  <=  date.day_component)  and  (date.day_component  <=  30)
	elif case_selector == 6:
		return (1  <=  date.day_component)  and  (date.day_component  <=  30)
	elif case_selector == 9:
		return (1  <=  date.day_component)  and  (date.day_component  <=  30)
	elif case_selector == 11:
		return (1  <=  date.day_component)  and  (date.day_component  <=  30)
	elif case_selector == 2:
		# begin/end block
		if (leap_year(date.year_component)):
			return (1  <=  date.day_component)  and  (date.day_component  <=  29)
		else:
			return (1  <=  date.day_component)  and  (date.day_component  <=  28)
	else:
		return TRUE

####################
 # FUNCTION valid_wireframe_vertex_point #
####################
def valid_wireframe_vertex_point(pnt,):
	'''
	:param pnt
	:type pnt:point
	'''
	if ('CONFIG_CONTROL_DESIGN.CARTESIAN_POINT'  ==  TYPEOF(pnt)):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.POINT_REPLICA'  ==  TYPEOF(pnt)):
			return valid_wireframe_vertex_point(pnt.point_replica.parent_pt)
	return FALSE

####################
 # FUNCTION list_to_array #
####################
def list_to_array(lis,low,u,):
	'''
	:param lis
	:type lis:(null)
	:param low
	:type low:INTEGER
	:param u
	:type u:INTEGER
	'''
	n = SIZEOF(lis)
	if (n  !=  ((u - low)  +  1)):
		return  None
	else:
		res = [lis[1],n]
		for  i in range(2,n,1):
			res[(low  +  i) - 1] = lis[i]
		return res

####################
 # FUNCTION using_items #
####################
def using_items(item,checked_items,):
	'''
	:param item
	:type item:founded_item_select
	:param checked_items
	:type checked_items:(null)
	'''
	result_items = []
	new_check_items = checked_items  +  item
	next_items = None
	if (SIZEOF(next_items)  >  0):
		for  i in range(1,HIINDEX(next_items),1):
			if ( not (next_items[i]  ==  new_check_items)):
				result_items = (result_items  +  next_items[i])  +  using_items(next_items[i],new_check_items)
	return result_items

####################
 # FUNCTION constraints_geometry_shell_based_surface_model #
####################
def constraints_geometry_shell_based_surface_model(m,):
	'''
	:param m
	:type m:shell_based_surface_model
	'''
	for  j in range(1,SIZEOF(m.sbsm_boundary),1):
		if (( not ('CONFIG_CONTROL_DESIGN.OPEN_SHELL'  ==  TYPEOF(m.sbsm_boundary[j])))  and  ( not ('CONFIG_CONTROL_DESIGN.CLOSED_SHELL'  ==  TYPEOF(m.sbsm_boundary[j])))):
			result = FALSE
			return result
	return result

####################
 # FUNCTION face_bound_reversed #
####################
def face_bound_reversed(a_face_bound,):
	'''
	:param a_face_bound
	:type a_face_bound:face_bound
	'''
	if ('CONFIG_CONTROL_DESIGN.FACE_OUTER_BOUND'  ==  TYPEOF(a_face_bound)):
		the_reverse = (dummy_tri  ==  face_bound(a_face_bound.face_bound.bound, not a_face_bound.face_bound.orientation))  ==  face_outer_bound()
	else:
		the_reverse = dummy_tri  ==  face_bound(a_face_bound.bound, not a_face_bound.orientation)
	return the_reverse

####################
 # FUNCTION set_of_topology_reversed #
####################
def set_of_topology_reversed(a_set,):
	'''
	:param a_set
	:type a_set:set_of_reversible_topology_item
	'''
	the_reverse = []
	for  i in range(1,SIZEOF(a_set),1):
		the_reverse = the_reverse  +  topology_reversed(a_set[i])
	return the_reverse

####################
 # FUNCTION dimension_of #
####################
def dimension_of(item,):
	'''
	:param item
	:type item:geometric_representation_item
	'''
	x = using_representations(item)
	y = x[1].context_of_items
	return y.geometric_representation_context.coordinate_space_dimension

####################
 # FUNCTION scalar_times_vector #
####################
def scalar_times_vector(scalar,vec,):
	'''
	:param scalar
	:type scalar:REAL
	:param vec
	:type vec:vector_or_direction
	'''
	if (( not EXISTS(scalar))  or  ( not EXISTS(vec))):
		return  None
	else:
		if ('CONFIG_CONTROL_DESIGN.VECTOR'  ==  TYPEOF(vec)):
			v = dummy_gri  ==  direction(vec.orientation.direction_ratios)
			mag = scalar  *  vec.magnitude
		else:
			v = dummy_gri  ==  direction(vec.direction_ratios)
			mag = scalar
		if (mag  <  0):
			for  i in range(1,SIZEOF(v.direction_ratios),1):
				v.direction_ratios[i] = -v.direction_ratios[i]
			mag = -mag
		result = dummy_gri  ==  vector(normalise(v),mag)
	return result

####################
 # FUNCTION dimensions_for_si_unit #
####################
def dimensions_for_si_unit(n,):
	'''
	:param n
	:type n:si_unit_name
	'''
	case_selector = n
	if  case_selector == metre:
		return dimensional_exponents(1,0,0,0,0,0,0)
	elif case_selector == gram:
		return dimensional_exponents(0,1,0,0,0,0,0)
	elif case_selector == second:
		return dimensional_exponents(0,0,1,0,0,0,0)
	elif case_selector == ampere:
		return dimensional_exponents(0,0,0,1,0,0,0)
	elif case_selector == kelvin:
		return dimensional_exponents(0,0,0,0,1,0,0)
	elif case_selector == mole:
		return dimensional_exponents(0,0,0,0,0,1,0)
	elif case_selector == candela:
		return dimensional_exponents(0,0,0,0,0,0,1)
	elif case_selector == radian:
		return dimensional_exponents(0,0,0,0,0,0,0)
	elif case_selector == steradian:
		return dimensional_exponents(0,0,0,0,0,0,0)
	elif case_selector == hertz:
		return dimensional_exponents(0,0,-1,0,0,0,0)
	elif case_selector == newton:
		return dimensional_exponents(1,1,-2,0,0,0,0)
	elif case_selector == pascal:
		return dimensional_exponents(-1,1,-2,0,0,0,0)
	elif case_selector == joule:
		return dimensional_exponents(2,1,-2,0,0,0,0)
	elif case_selector == watt:
		return dimensional_exponents(2,1,-3,0,0,0,0)
	elif case_selector == coulomb:
		return dimensional_exponents(0,0,1,1,0,0,0)
	elif case_selector == volt:
		return dimensional_exponents(2,1,-3,-1,0,0,0)
	elif case_selector == farad:
		return dimensional_exponents(-2,-1,4,1,0,0,0)
	elif case_selector == ohm:
		return dimensional_exponents(2,1,-3,-2,0,0,0)
	elif case_selector == siemens:
		return dimensional_exponents(-2,-1,3,2,0,0,0)
	elif case_selector == weber:
		return dimensional_exponents(2,1,-2,-1,0,0,0)
	elif case_selector == tesla:
		return dimensional_exponents(0,1,-2,-1,0,0,0)
	elif case_selector == henry:
		return dimensional_exponents(2,1,-2,-2,0,0,0)
	elif case_selector == degree_celsius:
		return dimensional_exponents(0,0,0,0,1,0,0)
	elif case_selector == lumen:
		return dimensional_exponents(0,0,0,0,0,0,1)
	elif case_selector == lux:
		return dimensional_exponents(-2,0,0,0,0,0,1)
	elif case_selector == becquerel:
		return dimensional_exponents(0,0,-1,0,0,0,0)
	elif case_selector == gray:
		return dimensional_exponents(2,0,-2,0,0,0,0)
	elif case_selector == sievert:
		return dimensional_exponents(2,0,-2,0,0,0,0)

####################
 # FUNCTION assembly_shape_is_defined #
####################
def assembly_shape_is_defined(assy,schma,):
	'''
	:param assy
	:type assy:next_assembly_usage_occurrence
	:param schma
	:type schma:STRING
	'''
	pr1_set = bag_to_set(USEDIN(assy.related_product_definition,schma  +  '.PROPERTY_DEFINITION.DEFINITION'))
	for  i in range(1,HIINDEX(pr1_set),1):
		sdr_set = sdr_set  +  None
	pdrel_set = bag_to_set(USEDIN(assy.related_product_definition,(schma  +  '.PRODUCT_DEFINITION_RELATIONSHIP.')  +  'RELATED_PRODUCT_DEFINITION'))
	for  j in range(1,HIINDEX(pdrel_set),1):
		pr2_set = pr2_set  +  USEDIN(pdrel_set[j],schma  +  '.PROPERTY_DEFINITION.DEFINITION')
	for  i in range(1,HIINDEX(pr2_set),1):
		sdr_set = sdr_set  +  None
	if (SIZEOF(sdr_set)  >  0):
		for  i in range(1,HIINDEX(sdr_set),1):
			srr_set = None
			if (SIZEOF(srr_set)  >  0):
				for  j in range(1,HIINDEX(srr_set),1):
					if (SIZEOF(None  *  None)  >=  1):
						if (SIZEOF(None)  >  0):
							return FALSE
	return TRUE

####################
 # FUNCTION open_shell_reversed #
####################
def open_shell_reversed(a_shell,):
	'''
	:param a_shell
	:type a_shell:open_shell
	'''
	if ('CONFIG_CONTROL_DESIGN.ORIENTED_OPEN_SHELL'  ==  TYPEOF(a_shell)):
		the_reverse = ((dummy_tri  ==  connected_face_set(a_shell.connected_face_set.cfs_faces))  ==  open_shell())  ==  oriented_open_shell(a_shell.oriented_open_shell.open_shell_element, not a_shell.oriented_open_shell.orientation)
	else:
		the_reverse = ((dummy_tri  ==  connected_face_set(a_shell.connected_face_set.cfs_faces))  ==  open_shell())  ==  oriented_open_shell(a_shell,FALSE)
	return the_reverse

####################
 # FUNCTION acyclic_surface_replica #
####################
def acyclic_surface_replica(rep,parent,):
	'''
	:param rep
	:type rep:surface_replica
	:param parent
	:type parent:surface
	'''
	if ( not ('CONFIG_CONTROL_DESIGN.SURFACE_REPLICA'  ==  TYPEOF(parent))):
		return TRUE
	if (parent  ==  rep):
		return FALSE
	else:
		return acyclic_surface_replica(rep,parent.surface_replica.parent_surface)

####################
 # FUNCTION gbsf_check_surface #
####################
def gbsf_check_surface(sf,):
	'''
	:param sf
	:type sf:surface
	'''
	if ((('CONFIG_CONTROL_DESIGN.B_SPLINE_SURFACE'  ==  TYPEOF(sf))  and  (sf.b_spline_surface.self_intersect  ==  FALSE))  or  (sf.b_spline_surface.self_intersect  ==  UNKNOWN)):
		return TRUE
	else:
		if (SIZEOF(['CONFIG_CONTROL_DESIGN.SPHERICAL_SURFACE','CONFIG_CONTROL_DESIGN.TOROIDAL_SURFACE']  *  TYPEOF(sf))  ==  1):
			return TRUE
		else:
			if ('CONFIG_CONTROL_DESIGN.CURVE_BOUNDED_SURFACE'  ==  TYPEOF(sf)):
				if (SIZEOF(['CONFIG_CONTROL_DESIGN.CONICAL_SURFACE','CONFIG_CONTROL_DESIGN.CYLINDRICAL_SURFACE','CONFIG_CONTROL_DESIGN.PLANE']  *  TYPEOF(sf.curve_bounded_surface.basis_surface))  ==  1):
					return SIZEOF(None)  ==  0
				else:
					if (gbsf_check_surface(sf.curve_bounded_surface.basis_surface)):
						return SIZEOF(None)  ==  0
			else:
				if ((('CONFIG_CONTROL_DESIGN.OFFSET_SURFACE'  ==  TYPEOF(sf))  and  (sf.offset_surface.self_intersect  ==  FALSE))  or  (sf.offset_surface.self_intersect  ==  UNKNOWN)):
					return gbsf_check_surface(sf.offset_surface.basis_surface)
				else:
					if ('CONFIG_CONTROL_DESIGN.RECTANGULAR_COMPOSITE_SURFACE'  ==  TYPEOF(sf)):
						for  i in range(1,SIZEOF(sf.rectangular_composite_surface.segments),1):
							for  j in range(1,SIZEOF(sf.rectangular_composite_surface.segments[i]),1):
								if ( not gbsf_check_surface(sf.rectangular_composite_surface.segments[i][j].parent_surface)):
									return FALSE
						return TRUE
					else:
						if ('CONFIG_CONTROL_DESIGN.RECTANGULAR_TRIMMED_SURFACE'  ==  TYPEOF(sf)):
							if (SIZEOF(['CONFIG_CONTROL_DESIGN.CONICAL_SURFACE','CONFIG_CONTROL_DESIGN.CYLINDRICAL_SURFACE','CONFIG_CONTROL_DESIGN.PLANE']  *  TYPEOF(sf.rectangular_trimmed_surface.basis_surface))  ==  1):
								return TRUE
							else:
								return gbsf_check_surface(sf.rectangular_trimmed_surface.basis_surface)
						else:
							if ('CONFIG_CONTROL_DESIGN.SURFACE_REPLICA'  ==  TYPEOF(sf)):
								return gbsf_check_surface(sf.surface_replica.parent_surface)
							else:
								if ('CONFIG_CONTROL_DESIGN.SWEPT_SURFACE'  ==  TYPEOF(sf)):
									return gbsf_check_curve(sf.swept_surface.swept_curve)
	return FALSE

####################
 # FUNCTION msf_surface_check #
####################
def msf_surface_check(surf,):
	'''
	:param surf
	:type surf:surface
	'''
	if ('CONFIG_CONTROL_DESIGN.ELEMENTARY_SURFACE'  ==  TYPEOF(surf)):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.SWEPT_SURFACE'  ==  TYPEOF(surf)):
			return msf_curve_check(surf.swept_surface.swept_curve)
		else:
			if ((('CONFIG_CONTROL_DESIGN.OFFSET_SURFACE'  ==  TYPEOF(surf))  and  (surf.offset_surface.self_intersect  ==  FALSE))  or  (surf.offset_surface.self_intersect  ==  UNKNOWN)):
				return msf_surface_check(surf.offset_surface.basis_surface)
			else:
				if ('CONFIG_CONTROL_DESIGN.SURFACE_REPLICA'  ==  TYPEOF(surf)):
					return msf_surface_check(surf.surface_replica.parent_surface)
				else:
					if ((('CONFIG_CONTROL_DESIGN.B_SPLINE_SURFACE'  ==  TYPEOF(surf))  and  (surf.b_spline_surface.self_intersect  ==  FALSE))  or  (surf.b_spline_surface.self_intersect  ==  UNKNOWN)):
						return TRUE
	return FALSE

####################
 # FUNCTION normalise #
####################
def normalise(arg,):
	'''
	:param arg
	:type arg:vector_or_direction
	'''
	if ( not EXISTS(arg)):
		result =  None
	else:
		ndim = arg.dim
		if ('CONFIG_CONTROL_DESIGN.VECTOR'  ==  TYPEOF(arg)):
			# begin/end block
			v = dummy_gri  ==  direction(arg.orientation.direction_ratios)
			if (arg.magnitude  ==  0):
				return  None
			else:
				vec = dummy_gri  ==  vector(v,1)
		else:
			v = dummy_gri  ==  direction(arg.direction_ratios)
		mag = 0
		for  i in range(1,ndim,1):
			mag = mag  +  (v.direction_ratios[i]  *  v.direction_ratios[i])
		if (mag  >  0):
			mag = SQRT(mag)
			for  i in range(1,ndim,1):
				v.direction_ratios[i] = v.direction_ratios[i] / mag
			if ('CONFIG_CONTROL_DESIGN.VECTOR'  ==  TYPEOF(arg)):
				vec.orientation = v
				result = vec
			else:
				result = v
		else:
			return  None
	return result

####################
 # FUNCTION msb_shells #
####################
def msb_shells(brep,):
	'''
	:param brep
	:type brep:manifold_solid_brep
	'''
	if (SIZEOF(None)  >=  1):
		return brep.brep_with_voids.voids  +  brep.outer
	else:
		return [brep.outer]

####################
 # FUNCTION mixed_loop_type_set #
####################
def mixed_loop_type_set(l,):
	'''
	:param l
	:type l:(null)
	'''
	if (SIZEOF(l)  <=  1):
		return FALSE
	poly_loop_type = 'CONFIG_CONTROL_DESIGN.POLY_LOOP'  ==  TYPEOF(l[1])
	for  i in range(2,SIZEOF(l),1):
		if (('CONFIG_CONTROL_DESIGN.POLY_LOOP'  ==  TYPEOF(l[i]))  !=  poly_loop_type):
			return TRUE
	return FALSE

####################
 # FUNCTION derive_dimensional_exponents #
####################
def derive_dimensional_exponents(x,):
	'''
	:param x
	:type x:unit
	'''
	result = x.dimensions
	return result

####################
 # FUNCTION curve_weights_positive #
####################
def curve_weights_positive(b,):
	'''
	:param b
	:type b:rational_b_spline_curve
	'''
	for  i in range(0,b.upper_index_on_control_points,1):
		if (b.weights[i]  <=  0):
			result = FALSE
			return result
	return result

####################
 # FUNCTION valid_geometrically_bounded_wf_point #
####################
def valid_geometrically_bounded_wf_point(pnt,):
	'''
	:param pnt
	:type pnt:point
	'''
	if ('CONFIG_CONTROL_DESIGN.CARTESIAN_POINT'  ==  TYPEOF(pnt)):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.POINT_ON_CURVE'  ==  TYPEOF(pnt)):
			return valid_geometrically_bounded_wf_curve(pnt.point_on_curve.basis_curve)
		else:
			if ('CONFIG_CONTROL_DESIGN.POINT_REPLICA'  ==  TYPEOF(pnt)):
				return valid_geometrically_bounded_wf_point(pnt.point_replica.parent_pt)
	return FALSE

####################
 # FUNCTION path_head_to_tail #
####################
def path_head_to_tail(a_path,):
	'''
	:param a_path
	:type a_path:path
	'''
	n = SIZEOF(a_path.edge_list)
	for  i in range(2,n,1):
		p = p  and  (a_path.edge_list[i - 1].edge_end  ==  a_path.edge_list[i].edge_start)
	return p

####################
 # FUNCTION path_reversed #
####################
def path_reversed(a_path,):
	'''
	:param a_path
	:type a_path:path
	'''
	if ('CONFIG_CONTROL_DESIGN.ORIENTED_PATH'  ==  TYPEOF(a_path)):
		the_reverse = (dummy_tri  ==  path(list_of_topology_reversed(a_path.edge_list)))  ==  oriented_path(a_path.oriented_path.path_element, not a_path.oriented_path.orientation)
	else:
		the_reverse = (dummy_tri  ==  path(list_of_topology_reversed(a_path.edge_list)))  ==  oriented_path(a_path,FALSE)
	return the_reverse

####################
 # FUNCTION leap_year #
####################
def leap_year(year,):
	'''
	:param year
	:type year:INTEGER
	'''
	if ((((year  %  4)  ==  0)  and  ((year  %  100)  !=  0))  or  ((year  %  400)  ==  0)):
		return TRUE
	else:
		return FALSE

####################
 # FUNCTION face_reversed #
####################
def face_reversed(a_face,):
	'''
	:param a_face
	:type a_face:face
	'''
	if ('CONFIG_CONTROL_DESIGN.ORIENTED_FACE'  ==  TYPEOF(a_face)):
		the_reverse = (dummy_tri  ==  face(set_of_topology_reversed(a_face.bounds)))  ==  oriented_face(a_face.oriented_face.face_element, not a_face.oriented_face.orientation)
	else:
		the_reverse = (dummy_tri  ==  face(set_of_topology_reversed(a_face.bounds)))  ==  oriented_face(a_face,FALSE)
	return the_reverse

####################
 # FUNCTION constraints_param_b_spline #
####################
def constraints_param_b_spline(degree,up_knots,up_cp,knot_mult,knots,):
	'''
	:param degree
	:type degree:INTEGER
	:param up_knots
	:type up_knots:INTEGER
	:param up_cp
	:type up_cp:INTEGER
	:param knot_mult
	:type knot_mult:(null)
	:param knots
	:type knots:(null)
	'''
	sum = knot_mult[1]
	for  i in range(2,up_knots,1):
		sum = sum  +  knot_mult[i]
	if ((((degree  <  1)  or  (up_knots  <  2))  or  (up_cp  <  degree))  or  (sum  !=  ((degree  +  up_cp)  +  2))):
		result = FALSE
		return result
	k = knot_mult[1]
	if ((k  <  1)  or  (k  >  (degree  +  1))):
		result = FALSE
		return result
	for  i in range(2,up_knots,1):
		if ((knot_mult[i]  <  1)  or  (knots[i]  <=  knots[i - 1])):
			result = FALSE
			return result
		k = knot_mult[i]
		if ((i  <  up_knots)  and  (k  >  degree)):
			result = FALSE
			return result
		if ((i  ==  up_knots)  and  (k  >  (degree  +  1))):
			result = FALSE
			return result
	return result

####################
 # FUNCTION using_representations #
####################
def using_representations(item,):
	'''
	:param item
	:type item:founded_item_select
	'''
	results = []
	result_bag = USEDIN(item,'CONFIG_CONTROL_DESIGN.REPRESENTATION.ITEMS')
	if (SIZEOF(result_bag)  >  0):
		for  i in range(1,HIINDEX(result_bag),1):
			results = results  +  result_bag[i]
	intermediate_items = using_items(item,[])
	if (SIZEOF(intermediate_items)  >  0):
		for  i in range(1,HIINDEX(intermediate_items),1):
			result_bag = USEDIN(intermediate_items[i],'CONFIG_CONTROL_DESIGN.REPRESENTATION.ITEMS')
			if (SIZEOF(result_bag)  >  0):
				for  j in range(1,HIINDEX(result_bag),1):
					results = results  +  result_bag[j]
	return results

####################
 # FUNCTION associated_surface #
####################
def associated_surface(arg,):
	'''
	:param arg
	:type arg:pcurve_or_surface
	'''
	if ('CONFIG_CONTROL_DESIGN.PCURVE'  ==  TYPEOF(arg)):
		surf = arg.basis_surface
	else:
		surf = arg
	return surf

####################
 # FUNCTION acyclic_point_replica #
####################
def acyclic_point_replica(rep,parent,):
	'''
	:param rep
	:type rep:point_replica
	:param parent
	:type parent:point
	'''
	if ( not ('CONFIG_CONTROL_DESIGN.POINT_REPLICA'  ==  TYPEOF(parent))):
		return TRUE
	if (parent  ==  rep):
		return FALSE
	else:
		return acyclic_point_replica(rep,parent.point_replica.parent_pt)

####################
 # FUNCTION cross_product #
####################
def cross_product(arg1,arg2,):
	'''
	:param arg1
	:type arg1:direction
	:param arg2
	:type arg2:direction
	'''
	if (((( not EXISTS(arg1))  or  (arg1.dim  ==  2))  or  ( not EXISTS(arg2)))  or  (arg2.dim  ==  2)):
		return  None
	else:
		# begin/end block
		v1 = normalise(arg1).direction_ratios
		v2 = normalise(arg2).direction_ratios
		res = dummy_gri  ==  direction([(v1[2]  *  v2[3]) - (v1[3]  *  v2[2]),(v1[3]  *  v2[1]) - (v1[1]  *  v2[3]),(v1[1]  *  v2[2]) - (v1[2]  *  v2[1])])
		mag = 0
		for  i in range(1,3,1):
			mag = mag  +  (res.direction_ratios[i]  *  res.direction_ratios[i])
		if (mag  >  0):
			result = dummy_gri  ==  vector(res,SQRT(mag))
		else:
			result = dummy_gri  ==  vector(arg1,0)
		return result

####################
 # FUNCTION valid_units #
####################
def valid_units(m,):
	'''
	:param m
	:type m:measure_with_unit
	'''
	if ('CONFIG_CONTROL_DESIGN.LENGTH_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(1,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.MASS_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,1,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.TIME_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,1,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.ELECTRIC_CURRENT_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,1,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.THERMODYNAMIC_TEMPERATURE_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,1,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.AMOUNT_OF_SUBSTANCE_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,1,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.LUMINOUS_INTENSITY_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,0,1)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.PLANE_ANGLE_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.SOLID_ANGLE_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.AREA_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(2,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.VOLUME_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(3,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.RATIO_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.POSITIVE_LENGTH_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(1,0,0,0,0,0,0)):
			return FALSE
	if ('CONFIG_CONTROL_DESIGN.POSITIVE_PLANE_ANGLE_MEASURE'  ==  TYPEOF(m.value_component)):
		if (derive_dimensional_exponents(m.unit_component)  !=  dimensional_exponents(0,0,0,0,0,0,0)):
			return FALSE
	return TRUE

####################
 # FUNCTION constraints_rectangular_composite_surface #
####################
def constraints_rectangular_composite_surface(s,):
	'''
	:param s
	:type s:rectangular_composite_surface
	'''
	for  i in range(1,s.n_u,1):
		for  j in range(1,s.n_v,1):
			if ( not (('CONFIG_CONTROL_DESIGN.B_SPLINE_SURFACE'  ==  TYPEOF(s.segments[i][j].parent_surface))  or  ('CONFIG_CONTROL_DESIGN.RECTANGULAR_TRIMMED_SURFACE'  ==  TYPEOF(s.segments[i][j].parent_surface)))):
				return FALSE
	for  i in range(1,s.n_u - 1,1):
		for  j in range(1,s.n_v,1):
			if (s.segments[i][j].u_transition  ==  discontinuous):
				return FALSE
	for  i in range(1,s.n_u,1):
		for  j in range(1,s.n_v - 1,1):
			if (s.segments[i][j].v_transition  ==  discontinuous):
				return FALSE
	return TRUE

####################
 # FUNCTION closed_shell_reversed #
####################
def closed_shell_reversed(a_shell,):
	'''
	:param a_shell
	:type a_shell:closed_shell
	'''
	if ('CONFIG_CONTROL_DESIGN.ORIENTED_CLOSED_SHELL'  ==  TYPEOF(a_shell)):
		the_reverse = ((dummy_tri  ==  connected_face_set(a_shell.connected_face_set.cfs_faces))  ==  closed_shell())  ==  oriented_closed_shell(a_shell.oriented_closed_shell.closed_shell_element, not a_shell.oriented_closed_shell.orientation)
	else:
		the_reverse = ((dummy_tri  ==  connected_face_set(a_shell.connected_face_set.cfs_faces))  ==  closed_shell())  ==  oriented_closed_shell(a_shell,FALSE)
	return the_reverse

####################
 # FUNCTION boolean_choose #
####################
def boolean_choose(b,choice1,choice2,):
	'''
	:param b
	:type b:BOOLEAN
	:param choice1
	:type choice1:(null)
	:param choice2
	:type choice2:(null)
	'''
	if (b):
		return choice1
	else:
		return choice2

####################
 # FUNCTION valid_time #
####################
def valid_time(time,):
	'''
	:param time
	:type time:local_time
	'''
	if (EXISTS(time.second_component)):
		return EXISTS(time.minute_component)
	else:
		return TRUE

####################
 # FUNCTION valid_geometrically_bounded_wf_curve #
####################
def valid_geometrically_bounded_wf_curve(crv,):
	'''
	:param crv
	:type crv:curve
	'''
	if (SIZEOF(['CONFIG_CONTROL_DESIGN.POLYLINE','CONFIG_CONTROL_DESIGN.B_SPLINE_CURVE','CONFIG_CONTROL_DESIGN.ELLIPSE','CONFIG_CONTROL_DESIGN.CIRCLE']  *  TYPEOF(crv))  ==  1):
		return TRUE
	else:
		if ('CONFIG_CONTROL_DESIGN.TRIMMED_CURVE'  ==  TYPEOF(crv)):
			if (SIZEOF(['CONFIG_CONTROL_DESIGN.LINE','CONFIG_CONTROL_DESIGN.PARABOLA','CONFIG_CONTROL_DESIGN.HYPERBOLA']  *  TYPEOF(crv.trimmed_curve.basis_curve))  ==  1):
				return TRUE
			else:
				return valid_geometrically_bounded_wf_curve(crv.trimmed_curve.basis_curve)
		else:
			if ('CONFIG_CONTROL_DESIGN.OFFSET_CURVE_3D'  ==  TYPEOF(crv)):
				return valid_geometrically_bounded_wf_curve(crv.offset_curve_3d.basis_curve)
			else:
				if ('CONFIG_CONTROL_DESIGN.CURVE_REPLICA'  ==  TYPEOF(crv)):
					return valid_geometrically_bounded_wf_curve(crv.curve_replica.parent_curve)
				else:
					if ('CONFIG_CONTROL_DESIGN.COMPOSITE_CURVE'  ==  TYPEOF(crv)):
						return SIZEOF(None)  ==  0
	return FALSE

####################
 # FUNCTION dot_product #
####################
def dot_product(arg1,arg2,):
	'''
	:param arg1
	:type arg1:direction
	:param arg2
	:type arg2:direction
	'''
	if (( not EXISTS(arg1))  or  ( not EXISTS(arg2))):
		scalar =  None
	else:
		if (arg1.dim  !=  arg2.dim):
			scalar =  None
		else:
			# begin/end block
			vec1 = normalise(arg1)
			vec2 = normalise(arg2)
			ndim = arg1.dim
			scalar = 0
			for  i in range(1,ndim,1):
				scalar = scalar  +  (vec1.direction_ratios[i]  *  vec2.direction_ratios[i])
	return scalar

####################
 # FUNCTION acyclic_curve_replica #
####################
def acyclic_curve_replica(rep,parent,):
	'''
	:param rep
	:type rep:curve_replica
	:param parent
	:type parent:curve
	'''
	if ( not ('CONFIG_CONTROL_DESIGN.CURVE_REPLICA'  ==  TYPEOF(parent))):
		return TRUE
	if (parent  ==  rep):
		return FALSE
	else:
		return acyclic_curve_replica(rep,parent.curve_replica.parent_curve)

####################
 # RULE change_request_requires_approval #
####################
change_request_requires_approval = Rule()

####################
 # RULE restrict_date_time_role #
####################
restrict_date_time_role = Rule()

####################
 # RULE versioned_action_request_requires_status #
####################
versioned_action_request_requires_status = Rule()

####################
 # RULE acu_requires_security_classification #
####################
acu_requires_security_classification = Rule()

####################
 # RULE no_shape_for_supplied_part #
####################
no_shape_for_supplied_part = Rule()

####################
 # RULE dependent_instantiable_person_and_organization_role #
####################
dependent_instantiable_person_and_organization_role = Rule()

####################
 # RULE product_definition_requires_date_time #
####################
product_definition_requires_date_time = Rule()

####################
 # RULE compatible_dimension #
####################
compatible_dimension = Rule()

####################
 # RULE product_version_requires_approval #
####################
product_version_requires_approval = Rule()

####################
 # RULE change_requires_approval #
####################
change_requires_approval = Rule()

####################
 # RULE product_requires_version #
####################
product_requires_version = Rule()

####################
 # RULE product_definition_requires_person_organization #
####################
product_definition_requires_person_organization = Rule()

####################
 # RULE product_concept_requires_configuration_item #
####################
product_concept_requires_configuration_item = Rule()

####################
 # RULE certification_requires_date_time #
####################
certification_requires_date_time = Rule()

####################
 # RULE certification_requires_approval #
####################
certification_requires_approval = Rule()

####################
 # RULE subtype_mandatory_effectivity #
####################
subtype_mandatory_effectivity = Rule()

####################
 # RULE versioned_action_request_requires_solution #
####################
versioned_action_request_requires_solution = Rule()

####################
 # RULE effectivity_requires_approval #
####################
effectivity_requires_approval = Rule()

####################
 # RULE unique_version_change_order_rule #
####################
unique_version_change_order_rule = Rule()

####################
 # RULE dependent_instantiable_named_unit #
####################
dependent_instantiable_named_unit = Rule()

####################
 # RULE subtype_mandatory_product_definition_formation #
####################
subtype_mandatory_product_definition_formation = Rule()

####################
 # RULE approval_requires_approval_person_organization #
####################
approval_requires_approval_person_organization = Rule()

####################
 # RULE approvals_are_assigned #
####################
approvals_are_assigned = Rule()

####################
 # RULE start_work_requires_approval #
####################
start_work_requires_approval = Rule()

####################
 # RULE approval_person_organization_constraints #
####################
approval_person_organization_constraints = Rule()

####################
 # RULE configuration_item_requires_approval #
####################
configuration_item_requires_approval = Rule()

####################
 # RULE contract_requires_person_organization #
####################
contract_requires_person_organization = Rule()

####################
 # RULE dependent_instantiable_date_time_role #
####################
dependent_instantiable_date_time_role = Rule()

####################
 # RULE restrict_product_category_value #
####################
restrict_product_category_value = Rule()

####################
 # RULE start_work_requires_date_time #
####################
start_work_requires_date_time = Rule()

####################
 # RULE product_requires_product_category #
####################
product_requires_product_category = Rule()

####################
 # RULE dependent_instantiable_representation_item #
####################
dependent_instantiable_representation_item = Rule()

####################
 # RULE change_request_requires_person_organization #
####################
change_request_requires_person_organization = Rule()

####################
 # RULE product_definition_requires_approval #
####################
product_definition_requires_approval = Rule()

####################
 # RULE subtype_mandatory_representation_context #
####################
subtype_mandatory_representation_context = Rule()

####################
 # RULE security_classification_requires_date_time #
####################
security_classification_requires_date_time = Rule()

####################
 # RULE security_classification_optional_date_time #
####################
security_classification_optional_date_time = Rule()

####################
 # RULE as_required_quantity #
####################
as_required_quantity = Rule()

####################
 # RULE start_request_requires_approval #
####################
start_request_requires_approval = Rule()

####################
 # RULE geometric_representation_item_3d #
####################
geometric_representation_item_3d = Rule()

####################
 # RULE application_context_requires_ap_definition #
####################
application_context_requires_ap_definition = Rule()

####################
 # RULE subtype_mandatory_representation #
####################
subtype_mandatory_representation = Rule()

####################
 # RULE change_requires_date_time #
####################
change_requires_date_time = Rule()

####################
 # RULE dependent_instantiable_action_directive #
####################
dependent_instantiable_action_directive = Rule()

####################
 # RULE restrict_security_classification_level #
####################
restrict_security_classification_level = Rule()

####################
 # RULE approval_requires_approval_date_time #
####################
approval_requires_approval_date_time = Rule()

####################
 # RULE subtype_mandatory_product_definition_usage #
####################
subtype_mandatory_product_definition_usage = Rule()

####################
 # RULE restrict_approval_status #
####################
restrict_approval_status = Rule()

####################
 # RULE change_request_requires_date_time #
####################
change_request_requires_date_time = Rule()

####################
 # RULE dependent_instantiable_contract_type #
####################
dependent_instantiable_contract_type = Rule()

####################
 # RULE contract_requires_approval #
####################
contract_requires_approval = Rule()

####################
 # RULE restrict_document_type #
####################
restrict_document_type = Rule()

####################
 # RULE dependent_instantiable_certification_type #
####################
dependent_instantiable_certification_type = Rule()

####################
 # RULE design_context_for_property #
####################
design_context_for_property = Rule()

####################
 # RULE product_version_requires_person_organization #
####################
product_version_requires_person_organization = Rule()

####################
 # RULE dependent_instantiable_approval_status #
####################
dependent_instantiable_approval_status = Rule()

####################
 # RULE subtype_mandatory_shape_representation #
####################
subtype_mandatory_shape_representation = Rule()

####################
 # RULE dependent_instantiable_date #
####################
dependent_instantiable_date = Rule()

####################
 # RULE configuration_item_requires_person_organization #
####################
configuration_item_requires_person_organization = Rule()

####################
 # RULE dependent_instantiable_document_type #
####################
dependent_instantiable_document_type = Rule()

####################
 # RULE restrict_contract_type #
####################
restrict_contract_type = Rule()

####################
 # RULE subtype_mandatory_product_context #
####################
subtype_mandatory_product_context = Rule()

####################
 # RULE dependent_instantiable_parametric_representation_context #
####################
dependent_instantiable_parametric_representation_context = Rule()

####################
 # RULE security_classification_requires_person_organization #
####################
security_classification_requires_person_organization = Rule()

####################
 # RULE dependent_instantiable_shape_representation #
####################
dependent_instantiable_shape_representation = Rule()

####################
 # RULE restrict_action_request_status #
####################
restrict_action_request_status = Rule()

####################
 # RULE restrict_certification_type #
####################
restrict_certification_type = Rule()

####################
 # RULE subtype_mandatory_action #
####################
subtype_mandatory_action = Rule()

####################
 # RULE product_requires_person_organization #
####################
product_requires_person_organization = Rule()

####################
 # RULE product_version_requires_security_classification #
####################
product_version_requires_security_classification = Rule()

####################
 # RULE document_to_product_definition #
####################
document_to_product_definition = Rule()

####################
 # RULE start_request_requires_date_time #
####################
start_request_requires_date_time = Rule()

####################
 # RULE dependent_instantiable_security_classification_level #
####################
dependent_instantiable_security_classification_level = Rule()

####################
 # RULE global_unit_assignment #
####################
global_unit_assignment = Rule()

####################
 # RULE restrict_person_organization_role #
####################
restrict_person_organization_role = Rule()

####################
 # RULE coordinated_assembly_and_shape #
####################
coordinated_assembly_and_shape = Rule()

####################
 # RULE start_request_requires_person_organization #
####################
start_request_requires_person_organization = Rule()

####################
 # RULE no_shape_for_make_from #
####################
no_shape_for_make_from = Rule()

####################
 # RULE approval_date_time_constraints #
####################
approval_date_time_constraints = Rule()

####################
 # RULE security_classification_requires_approval #
####################
security_classification_requires_approval = Rule()
