/* FIGARO'S PASSWORD MANAGER (FPM)
 * Copyright (C) 2000 John Conneely
 * 
 * FPM is open source / free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * FPM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * fpm.h
 */

#include <gtk/gtk.h>

/* CONSTANTS */
#define FPM_NUM_COL 	 3	 /* Number of columns in main CList */
#define FPM_COL_TITLE	 0
#define FPM_COL_URL	 1
#define FPM_COL_USER	 2
#define FPM_COL_DATA_POINTER	 3

#define FPM_MAX_DOUBLE_CLICK_TIME 0.8 /* In seconds */

#define FPM_PASSWORD_LEN 256
#define FPM_PRIVATE_LEN 40

#define FPM_BACKUP_NUM 20

#define DISPLAY_VERSION 	"0.71"
#define FULL_VERSION 		"00.71.00"
#define MIN_VERSION		"00.58.00"
#define ENCRYPT_VERSION		"00.23.00"

#define FPM_ALL_CAT_MSG		_("<ALL CATEGORIES>")
#define FPM_DEFAULT_CAT_MSG	_("<DEFAULTS>")

/* STRUCTURES */
typedef struct fpm_data_struct
{
  gchar *title;
  gchar *arg;
  gchar *user;
  gchar *notes;
  gchar *launcher;
  gchar password[FPM_PASSWORD_LEN*2+1];
  gchar *category;
  gint default_list;
} fpm_data;


typedef struct fpm_launcher_struct
{
  gchar *title;
  gchar *cmdline;
  gint copy_user;
  gint copy_password;
} fpm_launcher;

typedef struct fpm_ini_struct
{
    gboolean save_on_quit;
    gboolean save_on_change;
    gboolean save_on_add;
    gboolean save_on_delete;
    gboolean create_backup;
    gint number_backup_files;
    gchar *last_category;
    gint main_x;
    gint main_y;
    gint main_width;
    gint main_height;
    gint columns_width[3];
    gboolean search_match_case;
    gboolean search_in_title;
    gboolean search_in_url;
    gboolean search_in_user;
    gboolean search_in_notes;
    gboolean search_limit_category;
    gboolean enable_tray_icon;
    gboolean tr_always_visible;
    gboolean tr_auto_hide;
    gint tr_auto_hide_minutes;
    gboolean tr_auto_lock;
    gint tr_auto_lock_minutes;
} fpm_ini;

typedef struct fpm_state_struct
{
    gboolean minimized;
    gboolean locked;
    gboolean hide_timeout;
    gboolean lock_timeout;
    gboolean events;
} fpm_state;

extern GtkWidget* glb_win_app; 	 /* The main window for the application   */
extern GtkTreeView* glb_clist_main; /* Password CList on main window         */

extern GtkWidget* glb_win_misc;  /* Misc window, used for dialogs         */

extern GtkWidget* glb_win_edit;	 /* The edit window for a password item   */
extern GtkWidget* glb_win_import; /* The import window                    */
extern fpm_data* glb_edit_data;  /* The password item being edited now    */
extern gint glb_num_row;	 /* The total number of rows in the CList */
extern gint glb_cur_row;	 /* The last item clicked on in the CList */
extern gchar* glb_filename;	 /* The location of the pasword file.     */
extern gboolean glb_dirty;	 /* Have changes been made?		  */
extern GTimer* glb_timer_click;  /* Timer used to check for double clicks */
extern gint glb_click_count;     /* Click count used for double clicks    */
extern gboolean glb_click_btn;   /* Right button clicked -> context menu  */
extern gint glb_click_row;       /* Store row for first click on dblclick */
extern gboolean glb_minimized;	 /* Is fpm2 minimized?			  */
extern gboolean glb_locked;	 /* Is program locked?			  */
extern gboolean glb_timeout;	 /* Running idle check?			  */
extern gboolean glb_lock_timeout; /* Running lock check?		  */

extern GtkStatusIcon *glb_tray_icon; /* Tray icon */

extern gboolean glb_events;

extern gchar* new_salt;          /* Salt to use on next save.             */
extern gchar* old_salt;          /* Salt to used on last save.            */

extern void* old_context;
extern void* new_context;

extern char* vstring;
extern char* file_version;

extern GList *glb_pass_list;     /* A GList of fpm_data containing all items */

extern GCompareFunc glb_cmp;
extern GList *glb_cat_string_list;     /* A GList of strings, used to populate combos */
extern GList *glb_launcher_list; /* A list of ways we can launch a password */
extern GList *glb_launcher_string_list;     /* A GList of strings, used to populate combos */

extern gboolean glb_need_decrypt;
extern gboolean glb_using_defaults;

extern gchar* glb_last_category;

extern fpm_ini* glb_fpm_ini;	/* Store FPM settings. */

void
fpm_new_passitem(GtkWidget** win_edit_ptr, fpm_data** data_ptr);  

void
fpm_edit_passitem(GtkWidget** win_edit_ptr, fpm_data* data);

void
fpm_save_passitem(GtkWidget* win_edit, fpm_data* data);

char*
fpm_get_entry(GtkWidget* win, gchar* entry_name);

void
fpm_set_entry(GtkWidget* win, gchar* entry_name, char* text);

void
fpm_quit(void);

void
fpm_init(char* opt_file_name);

void
fpm_dialog_answer_delete(GtkWidget* widget, gint reply);

void
fpm_dialog_answer_save(GtkWidget* widget, gint reply);

void
fpm_select(gchar* text, gboolean use_clipboard);

void
fpm_select_password(fpm_data* data, gboolean use_clipboard);

void
fpm_double_click(fpm_data* data);

void
fpm_jump(fpm_data* data);

void
fpm_check_password(void);

void
fpm_set_password(void);

void
 fpm_clear_list(void);

void
fpm_clist_create_view(gchar* category); /* In fpm_clist.c */

void
fpm_clist_populate_cat_list(void);

void
fpm_clist_init(void);

void
fpm_check_view(gchar * category);

void
fpm_create_category_list(gint edit_flag);

gchar*
fpm_create_cmd_line(gchar* cmd, gchar* arg, gchar* user, gchar* pass);

void fpm_init_launchers(void);

void fpm_create_launcher_string_list(void);

void fpm_prefs_init(void);

void fpm_prefs_save_launcher(void);

void fpm_debug(gchar* msg);

void lock_fpm_file(gchar* glb_filename);

void unlock_fpm_file(void);

void fpm_dialog_answer_edit(GtkWidget* widget, gint reply);

void fpm_message(GtkWindow* win, gchar* message, GtkMessageType message_type);

void fpm_question(GtkWindow* win, gchar* message, GCallback callback);

void fpm_ini_load(void);

void fpm_ini_save(void);

void fpm_search(gchar *search_text, gboolean select_first);

void fpm_execute_shell(gchar *cmd);

void fpm_statusbar_push(gchar *message);

void fpm_tray_icon();

gboolean fpm_auto_hide();

void fpm_tr_toggle_win_app(gboolean force_hide);

void fpm_tr_cleanup();

gboolean fpm_lock();

gboolean fpm_window_check();
