# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4
#
# Flumotion - a streaming media server
# Copyright (C) 2004,2005,2006 Fluendo, S.L. (www.fluendo.com).
# All rights reserved.

# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.GPL" in the source distribution for more information.

# Licensees having purchased or holding a valid Flumotion Advanced
# Streaming Server license may use this file in accordance with the
# Flumotion Advanced Streaming Server Commercial License Agreement.
# See "LICENSE.Flumotion" in the source distribution for more information.

# Headers in this file shall remain intact.

import os
import sys

PYGTK_DIR = '/usr/lib/python2.4/site-packages'

PYGTK_BASE_REQ = '2.4.0'

GST_08_SUPPORTED = 'no'
PYGST_08_DIR = ''
PYGTK_08_REQ = '2.4.0'

GST_010_SUPPORTED = 'yes'
PYGST_010_DIR = '/home/thomas/gst/head/gst-python/pkgconfig/..'
PYGTK_010_REQ = '2.6.3'

def init_gobject():
    """
    I setup paths for pygtk from configure and
    make sure that the installed version of pygtk
    is sane enough to be usable by us
    """
    
    if not PYGTK_DIR in sys.path:
        sys.path.insert(0, PYGTK_DIR)

    try:
        import pygtk
        pygtk.require('2.0')

        import gobject
    except ImportError:
        raise SystemExit('ERROR: PyGTK could not be found')

    if gobject.pygtk_version < PYGTK_BASE_REQ.split('.'):
        raise SystemExit(
            'ERROR: PyGTK %s or higher is required' % PYGTK_BASE_REQ)

    # To be able to have other threads emitting signals connected
    # python callbacks we need to use the new PyGILThread_STATE API
    # Which in PyGTK 2.4.0 only can be turned on by using an
    # environment variable
    os.environ['PYGTK_USE_GIL_STATE_API'] = ''
    gobject.threads_init()

def init_gst():
    """
    I setup paths for gst-python from configure and
    make sure that the installed version of gst-python
    is sane enough to be usable by us
    """

    default_version = GST_010_SUPPORTED == 'yes' and '0.10' or '0.8'
    gst_version = os.getenv('FLU_GST_VERSION', default_version)

    if gst_version == '0.8':
        pygst_dir = PYGST_08_DIR
        pygtk_req = PYGTK_08_REQ
    elif gst_version == '0.10':
        pygst_dir = PYGST_010_DIR
        pygtk_req = PYGTK_010_REQ
    else:
        raise SystemExit(
            'ERROR: Invalid FLU_GST_VERSION: "%s" ("0.8" or "0.10" expected)'
            % gst_version)

    assert 'gobject' in sys.modules

    import gobject

    if gobject.pygtk_version < pygtk_req.split('.'):
        raise SystemExit(
            'ERROR: PyGTK %s or higher is required for FLU_GST_VERSION=%s'
            % (pygtk_req, gst_version))

    if pygst_dir != PYGTK_DIR:
        if pygst_dir in sys.path:
            sys.path.remove(pygst_dir)

        sys.path.insert(0, pygst_dir)
        
    if gst_version == '0.10':
        try:
            import pygst
            pygst.require('0.10')
        except ImportError:
            raise SystemExit('ERROR: Could not load gst-python 0.10')

    try:
        import gst
    except ImportError:
        raise SystemExit('ERROR: gst-python could not be found')
    
    if not (gst.pygst_version[1] == 8 and gst_version == '0.8'
            or gst.pygst_version[1] >= 10 and gst_version == '0.10'
            or gst.pygst_version[1] == 9 and gst.pygst_version[2] >= 7 
               and gst_version == '0.10'):
        raise SystemExit(
            'ERROR: Expected gst-python version %s in %s, but found %r'
            % (gst_version, pygst_dir, gst.pygst_version))
    
    # store our gst version for later logging
    from flumotion.configure import configure
    configure.gst_version = gst_version

def boot(path, gtk=False):
    from flumotion.twisted import compat

    init_gobject()
    init_gst()
    compat.install_reactor(gtk)

    from flumotion.twisted import reflect
    from flumotion.common import errors
    from flumotion.common import setup

    setup.setup()

    from flumotion.common import log
    log.logTwisted()

    main = reflect.namedAny(path)
    
    try:
        sys.exit(main(sys.argv))
    except errors.SystemError, e:
        print 'ERROR:', e
        sys.exit(1)
