/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

int check_events ( ) {

	SDL_Event event;
	int retval;
	
	retval = CONTINUE;

	while ( SDL_PollEvent ( &event ) ) {
		switch ( event.type ) {
			case SDL_KEYDOWN:
				switch ( event.key.keysym.sym ) {
					case SDLK_ESCAPE:
						retval |= EXIT;
						break;
					case SDLK_p:
						retval |= PAUSE;
						break;
					case SDLK_f:
						SDL_WM_ToggleFullScreen ( sdl_screen );
						break;
					case SDLK_b:
						retval |= TOGGLE_BLUR;
						break;
					case SDLK_w:
						retval |= TOGGLE_WAVEFREEZE;
						break;
					case SDLK_v:
						retval |= TOGGLE_VECTORFREEZE;
						break;
					case SDLK_c:
						retval |= TOGGLE_COLORFREEZE;
						break;
					case SDLK_m:
						retval |= TOGGLE_BEATMARK;
						break;
					default:
						break;
				}
		}
	}
	return ( retval );
}

