/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  File-Roller
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef FR_WINDOW_H
#define FR_WINDOW_H

#include <gtk/gtk.h>
#include "fr-archive.h"
#include "typedefs.h"


enum {
	COLUMN_NAME,
	COLUMN_TYPE,
	COLUMN_SIZE,
	COLUMN_TIME,
	COLUMN_PATH,
	NUMBER_OF_COLUMNS
};


typedef enum {
	FR_BATCH_ACTION_OPEN,
	FR_BATCH_ACTION_ADD,
	FR_BATCH_ACTION_OPEN_AND_ADD,
	FR_BATCH_ACTION_ADD_INTERACT,
	FR_BATCH_ACTION_EXTRACT,
	FR_BATCH_ACTION_EXTRACT_INTERACT,
	FR_BATCH_ACTION_QUIT,
} FRBatchAction;


typedef struct {
	FRBatchAction   action;
	void *          data;
	GFreeFunc       free_func;
} FRBatchActionDescription;


typedef struct {
        GtkWidget *      app;
	GtkWidget *      clist;
	GtkWidget *      statusbar;
	GtkWidget *      progress;

	GtkWidget *      location_bar;
	GtkWidget *      location_opt;
	GtkWidget *      up_button;

	GtkWidget *      up_arrows[5];
	GtkWidget *      down_arrows[5];

	FRArchive *      archive;
	gboolean         archive_present;
	gboolean         archive_new;        /* A new archive has been created
					      * but it doesn't contain any 
					      * file yet.  The real file will
					      * be created only when the user
					      * adds some file to the 
					      * archive.*/

	gchar *          archive_filename;
	gchar *          open_default_dir;    /* default directory to be used
					       * in the Open dialog. */
	gchar *          add_default_dir;     /* default directory to be used
					       * in the Add dialog. */
	gchar *          extract_default_dir; /* default directory to be used
					       * in the Extract dialog. */

	WindowSortMethod sort_method;
	GtkSortType      sort_type;

	WindowListMode   list_mode;
	gchar *          current_dir;

	guint            activity_timeout_handle;   /* activity timeout 
						     * handle. */
	gint             activity_ref;              /* when > 0 some activity
                                                     * is present. */
	gfloat           activity_progress;


	/* Menu items. */

	GtkWidget *      mitem_new_archive;
	GtkWidget *      mitem_open_archive;
	GtkWidget *      mitem_close;
	GtkWidget *      mitem_bookmarks;

	GtkWidget *      mitem_archive_prop;
	GtkWidget *      mitem_move_archive;
	GtkWidget *      mitem_copy_archive;
	GtkWidget *      mitem_rename_archive;
	GtkWidget *      mitem_delete_archive;

	GtkWidget *      mitem_view_flat;
	GtkWidget *      mitem_view_as_dir;
	GtkWidget *      mitem_sort[5];
	GtkWidget *      mitem_sort_reversed;

	GtkWidget *      mitem_add;
	GtkWidget *      mitem_delete;
	GtkWidget *      mitem_extract;
	GtkWidget *      mitem_view;
	GtkWidget *      mitem_open;
	GtkWidget *      mitem_stop;

	GtkWidget *      toolbar_new;
	GtkWidget *      toolbar_open;
	GtkWidget *      toolbar_add;
	GtkWidget *      toolbar_extract;
	GtkWidget *      toolbar_view;
	GtkWidget *      toolbar_stop;

	GtkWidget *      file_popup_menu;
	GtkWidget *      popupmenu_file[8];

	GtkTooltips *    bookmarks_tooltips;

	/* drag data */

	GList *  drag_file_list;        /* the list of files we are 
					 * dragging*/
	GList *  drag_file_list_names;  /* the list of files (only the name 
					 * without the path) of the
					 * files we are dragging.  Used 
					 * when dragging directories. */
	char *   drag_temp_dir;         /* the temporary directory used to
					 * extract the dragged files. */
	GList *  drag_temp_dirs;        /* the list of temporary directories
					 * used to extract dragged files.
					 * These directories will be deleted
					 * when the window is closed. */
	gboolean dragging_dirs;         /* whether we are dragging directories
					 * too .*/

	GList *  dropped_file_list;     /* the list of dropped files. */
	gboolean add_dropped_files;     /* whether we must add dropped files
					 * after creating an archive. */
	gboolean adding_dropped_files;  /* whether we are adding dropped 
					 * files. */
	gboolean update_dropped_files;  /* the update flag of the add 
					 * operation.  */

	/* non-interactive data */

	gboolean batch_mode;          /* whether we are in a non interactive
				       * mode. */
	GList *  batch_action_list;   /* FRActionDescription * elements */
	GList *  batch_action;        /* current action. */
} FRWindow;


FRWindow * window_new                       ();

void       window_close                     (FRWindow *window);

/* archive operations */

void       window_archive_new               (FRWindow *window, 
					     char *filename);

void       window_archive_open              (FRWindow *window, 
					     char *filename);

void       window_archive_reload            (FRWindow *window);

void       window_archive_rename            (FRWindow *window, 
					     char *filename);

void       window_archive_add_files         (FRWindow *window,
					     GList *file_list,
					     gboolean update);

void       window_archive_extract           (FRWindow *window,
					     GList * file_list,
					     char * extract_to_dir,
					     gboolean skip_older,
					     gboolean overwrite,
					     gboolean junk_paths);

void       window_archive_close             (FRWindow *window);

/**/

void       window_go_to_location            (FRWindow *window, 
					     char *path);

void       window_go_up_one_level           (FRWindow *window);

void       window_set_list_mode             (FRWindow *window, 
					     WindowListMode list_mode);

/**/

void       window_update_file_list          (FRWindow *window);

GList *    window_get_file_list_selection   (FRWindow *window, 
					     gboolean recursive,
					     gboolean * has_dirs);

GList *    window_get_file_list_pattern     (FRWindow *window,
					     gchar *pattern);

/**/

void       window_start_activity_mode       (FRWindow *window);

void       window_stop_activity_mode        (FRWindow *window);

/**/

void       window_view_file                 (FRWindow *window, 
					     gchar *file);

void       window_open_files                (FRWindow *window, 
					     gchar *command,
					     GList *file_list);

void       window_view_or_open_file         (FRWindow *window, 
					     gchar *file);

void       window_update_columns_visibility (FRWindow *window);

void       window_set_default_dir           (FRWindow *window,
					     gchar *default_dir);

/* batch mode procedures. */

void       window_batch_mode_clear            (FRWindow *window);
void       window_batch_mode_add_action       (FRWindow *window,
					       FRBatchAction action,
					       void *data,
					       GFreeFunc free_func);
void       window_batch_mode_start            (FRWindow *window);
void       window_batch_mode_stop             (FRWindow *window);

void       window_archive__open_extract_close (FRWindow *window, 
					       char *filename,
					       char *dest_dir);

void       window_archive__open_add_close     (FRWindow *window, 
					       char *archive,
					       GList *file_list);

#endif /* FR_WINDOW_H */
