/* mouse_button.c  */ 
/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/* For button presses and releases */ 
/*
 * $Log: mouse_button.c,v $
 * Revision 1.2  2000/12/06 20:56:02  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:31  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:30  moz
 * CVS Import
 *
 * Revision 1.11  2000/03/09 01:00:06  moz
 * stk_display_menu() cleanup.
 *
 * Revision 1.10  2000/03/07 21:44:30  moz
 * Compile fixes.
 *
 * Revision 1.9  2000/02/21 01:51:16  moz
 * Don't allow edit menu when editing_object.
 *
 * Revision 1.8  2000/02/18 01:16:16  moz
 * Compile fix.
 *
 * Revision 1.7  2000/01/31 01:05:34  moz
 * Update mouse_x,mouse_y.
 *
 * Revision 1.6  2000/01/26 18:18:48  moz
 * Added hook to unselect_polygon() for gc.
 *
 * Revision 1.5  1999/11/15 02:07:37  moz
 * Name change.
 *
 * Revision 1.4  1999/05/22 23:39:18  moz
 *  Pedantic ANSI.
 *
 * Revision 1.3  1999/05/19 17:08:52  moz
 * 1.0 Checkin.
 *
 * Revision 1.2  1999/04/27 16:55:47  moz
 * Enable/disable flip object as necessary.
 *
 * Revision 1.1  1999/03/30 00:05:28  moz
 * Initial revision
 *
 */    

#include "include/figurine.h"
#include "include/extern.h"

BEvent bev;
Time last_press[3] = { 0, 0, 0 }; 
extern int mouse_x;
extern int mouse_y;
void unselect_polygon(void);


/* Receivers of a bev must act as appropriate :

	If they receive a HELD, act as if the mouse was 
	being dragged with that button.
	
	If they receive a CLICKED, ignore the (always previously
	set) HELD mode, and move to CLICKED actions
	
	If they receive a RELEASED, end the HELD or CLICKED mode
	as appropriate
	*/ 

void 
handle_button_press(XEvent *report)
{
	List l; 
	List l2; 

	l = where_in_list(wins,report->xbutton.window);

	switch (l->type)
		{
		case RULER_X_WIN:
		case RULER_Y_WIN:
			WS(l)->grabbed = TRUE;
			break; 
		
		case DRAW_WIN:
			l2 = where_in_list(wins,WS(l)->parent);		

			if (report->xmotion.state & ControlMask)
				state.control_down = TRUE;
			else
				state.control_down = FALSE;

			if (report->xmotion.state & ShiftMask)
				state.shift_down = TRUE;
			else
				state.shift_down = FALSE;

			if (!state.editing_object)
				state.rubberon = TRUE; 

			/* Here's why we immediately send a HELD: We can't query
				server time on a motion event so we assume
				HELD instead. If they subsequently receive a CLICKED 
				after a HELD, they then accept that. A RELEASED is sent
				either way on releasing of the button.
				See client restrictions above. */ 
			
			bev.type = BUTTON_HELD;
			bev.x = report->xbutton.x;
			bev.y = report->xbutton.y;
			bev.button = report->xbutton.button;
			mouse_x = bev.x; 
			mouse_y = bev.y; 
			
			/* due to dumb way two-button mice represent a 2nd button Press 
				(Release 1, Press 2) we have to use a modifier for the other menu */  
			/* you also can't directly cancel whilst drawing a held line - our
				Release 1 is difficult to catch as a special case. Swines. */ 	 
			if (state.current_icon==POINTERICON && !state.editing_point && report->xbutton.button==Button3
				&& !state.editing_object && state.control_down && VIEW(l2)!=NULL)
				{
				Window w1; int x1,y1; int idum; uint indum;

				/* open up edit menu  */  
				if (VIEW(l2)->selected_object!=NULL)
					{
					stk_enable_menu_label(emw, 0);
					stk_enable_menu_label(emw, 1);
					stk_enable_menu_label(emw, 3);
					stk_enable_menu_label(emw, 5);
					stk_enable_menu_label(emw, 6);
					if (VIEW(l2)->selected_object->ob->type!=ELLIPSE &&
					    VIEW(l2)->selected_object->ob->type!=TEXT)
						{ 
						stk_enable_menu_label(emw,7); 
						stk_enable_menu_label(emw,8); 
						}
					else
						{
						stk_disable_menu_label(emw,7); 
						stk_disable_menu_label(emw,8); 
						};
					}
				else
					{
					stk_disable_menu_label(emw, 0);
					stk_disable_menu_label(emw, 1);
					stk_disable_menu_label(emw, 3);
					stk_disable_menu_label(emw, 5);
					stk_disable_menu_label(emw, 6);
					stk_disable_menu_label(emw, 7);
					stk_disable_menu_label(emw, 8);
					};

				XQueryPointer(display,RootWindow(display,screen),&w1,&w1,&x1,&y1,&idum, &idum, &indum);   
 				XUngrabPointer(display,CurrentTime); 

				stk_display_menu(VIEW(l2), emw, x1,y1, Button3);
					
				}
			else if (!state.editing_point && !state.editing_object && !state.busy_drawing && report->xbutton.button==Button3)
				{
				/* if you add something here, it probably needs to be in really_close_view() as well */  
				if (state.editing_text)
					unselect_text(VIEW(l2));

				if (state.compound_selected)
					unselect_compound(VIEW(l2));

				if (state.current_icon==ARCICON)
					unselect_arc(VIEW(l2));

				if (state.current_icon==POLYGONICON)
					unselect_polygon();

 				XUngrabPointer(display,CurrentTime); 
				stk_unselect_icon((signed)state.current_icon,float_menu); 
				stk_display_icon_menu(float_menu, RULER_PIXEL_SIZE + report->xbutton.x + VIEW(l2)->window.x - 30, 
				                                  RULER_PIXEL_SIZE + report->xbutton.y + VIEW(l2)->window.y - 30, FALSE, Button1);
				XFlush(display); 
				}
			else
				{
				/* otherwise it's a normal button event, pass it downwards  */  
				switch (state.current_icon)
					{
					case ARCICON:
						arc_button(&bev, VIEW(l2));
						break;

					case SPLINEICON: 
						spline_button(&bev, VIEW(l2));
						break;

					case POLYLINEICON:
						polyline_button(&bev,VIEW(l2));
						break;
						 
					case ELLIPSEICON:
					case BOXELLIPSEICON: 
						ellipse_button(&bev,VIEW(l2)); 
						break; 
						
					case ARCELLIPSEICON:
						arcellipse_button(&bev,VIEW(l2));
						break;

					case TEXTICON:
					case NODEICON: 
						text_button(&bev,VIEW(l2));
						break;

					case RECTANGLEICON:
						rectangle_button(&bev, VIEW(l2));
						break;

					case POLYGONICON:
						polygon_button(&bev, VIEW(l2));
						break;

					case POINTERICON:
						edit_button(&bev, VIEW(l2)); 
						break;

					default:
						break;
					}; 
				};	
			 
			switch (report->xbutton.button)
				{
				case Button1:
					last_press[0] = report->xbutton.time;  
					break;

				case Button2:
					last_press[1] = report->xbutton.time;  
					break;

				case Button3:
					last_press[2] = report->xbutton.time;  
					break;
				};
			break;

		};	

}

void 
handle_button_release(XEvent *report)
{ 
	Boolean clicked=0; 
	List l;
	List l2;


 	l = where_in_list(wins,report->xbutton.window);

	switch (l->type)
		{
		case RULER_X_WIN:
		case RULER_Y_WIN:
			WS(l)->grabbed = FALSE; 
			break;

		case DRAW_WIN:
			l2 = where_in_list(wins,WS(l)->parent);		
			 
			switch (report->xbutton.button)
				{
				case Button1:
					clicked = (report->xbutton.time - last_press[0]) < RELEASE_DEFAULTS_LATENCY; 
					last_press[0] = 0; 
					break;

				case Button2:
					clicked = (report->xbutton.time - last_press[1]) < RELEASE_DEFAULTS_LATENCY; 
					last_press[1] = 0; 
					break;

				case Button3:
					clicked = (report->xbutton.time - last_press[2]) < RELEASE_DEFAULTS_LATENCY; 
					last_press[2] = 0; 
					break; 
				}

			if (clicked)
				bev.type = BUTTON_CLICKED;
			else
				bev.type = BUTTON_RELEASED;
						 
			bev.x = report->xbutton.x;
			bev.y = report->xbutton.y;
			bev.button = report->xbutton.button;
			 
			if (state.editing_text || state.current_icon==TEXTICON || state.current_icon==NODEICON)
				text_button(&bev,VIEW(l2));
 			else if (state.current_icon==COMPOUNDICON) 
 				compound_button(&bev,VIEW(l2)); 
			else if (state.busy_drawing)
				{
				switch (state.current_icon)
					{
					case ARCICON:
						arc_button(&bev, VIEW(l2));
						break;

					case SPLINEICON:
						spline_button(&bev, VIEW(l2));
						break;

					case POLYLINEICON:
						polyline_button(&bev,VIEW(l2));
						break;
						 
					case ELLIPSEICON:
					case BOXELLIPSEICON: 
						ellipse_button(&bev,VIEW(l2));
						break; 
					
					case ARCELLIPSEICON:
						arcellipse_button(&bev,VIEW(l2));
						break;

					case RECTANGLEICON:
						rectangle_button(&bev, VIEW(l2));
						break;
				
					case POLYGONICON:
						polygon_button(&bev, VIEW(l2));
						break;
					default:
						v_error(state.current_icon);
						break; 
					};
			
				} 
			else /* we're not currently drawing */ 
				{
				if (state.current_icon==POINTERICON)
					edit_button(&bev,VIEW(l2));
				};
				 
		break;
			
		}; /* end switch */ 
				 
}
