#ifndef FIGURINE_STK_INTERNAL_H
#define FIGURINE_STK_INTERNAL_H

/* COPYRIGHT (C) 2000 THE VICTORIA UNIVERSITY OF MANCHESTER and John Levon
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version. 
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details. 
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA. 
 */
/*
 * $Log: stk_internal.h,v $
 * Revision 1.2  2000/12/06 20:56:08  moz
 * GPL stuff.
 *
 * Revision 1.1.1.1  2000/08/21 01:05:32  moz
 *
 *
 * Revision 1.1.1.1  2000/07/19 22:45:32  moz
 * CVS Import
 *
 * Revision 1.16  2000/03/09 01:06:25  moz
 * Compile fixes.
 *
 * Revision 1.15  2000/02/18 04:08:27  moz
 * Compile fixes.
 *
 * Revision 1.14  2000/01/26 18:26:17  moz
 * Add FIG_DEBUG_LIST_ALLOC.
 *
 * Revision 1.13  2000/01/25 01:38:30  moz
 * Removed border.
 *
 * Revision 1.12  2000/01/24 22:22:50  moz
 * Added stk_redraw_menu_labels().
 *
 * Revision 1.11  2000/01/21 11:21:25  moz
 * Use memwatch.
 *
 * Revision 1.10  1999/11/15 02:12:31  moz
 * Use enums where possible.
 *
 * Revision 1.9  1999/08/17 00:38:29  moz
 * Proto fix.
 *
 * Revision 1.8  1999/08/08 20:54:03  moz
 * Clean up structs.
 *
 * Revision 1.7  1999/05/23 00:28:12  moz
 * Pedantic changes.
 *
 * Revision 1.6  1999/05/22 23:39:55  moz
 *  Pedantic ANSI.
 *
 * Revision 1.5  1999/05/19 17:11:15  moz
 * 1.0 Checkin.
 *
 * Revision 1.4  1999/05/01 16:25:21  moz
 * Change of xpm.h location method.
 *
 * Revision 1.3  1999/04/22 22:17:54  moz
 * Define ulong
 *
 * Revision 1.2  1999/04/22 21:39:15  moz
 * X11/xpm.h -> xpm.h
 *
 * Revision 1.1  1999/03/30 00:10:16  moz
 * Initial revision
 *
 */

#include <X11/Xlib.h>
#ifdef HAVE_X11_XPM_H 
#  include <X11/xpm.h>
#else
#  ifdef HAVE_XPM_H
#    include <xpm.h>
#  else
#    include "xpm.h" 
#  endif 
#endif 

/* For maintainer */
#ifdef MEMWATCH
#include "memwatch.h"
#endif

#ifndef FIG_DEBUG_LIST_ALLOC
#define add_to_list(a,b,c,d) add_to_list0((a),(b),(c),(d))
#define add_to_list_neq(a,b,c,d) add_to_list_neq0((a),(b),(c),(d))
#else
#define add_to_list(a,b,c,d) add_to_list0((a),(b),(c),(d)); \
   fprintf(stderr, "figurine: add_to_list called from " __FILE__ " line %d\n", __LINE__)
#define add_to_list_neq(a,b,c,d) add_to_list_neq0((a),(b),(c),(d)); \
   fprintf(stderr, "figurine: add_to_list_neq called from " __FILE__ " line %d\n", __LINE__)
#endif
       
/* define ulong and uint  */  
#undef ulong
#define ulong unsigned long
#undef uint
#define uint unsigned int

/* defines used in finding in list  */  
enum { TOOL_WINDOW_TYPE=1, MENU_BAR_TYPE, SUB_MENU_TYPE, ICON_MENU_TYPE,
       BUTTON_TYPE, MESSAGE_TYPE, DIALOG_TYPE, MENU_BAR_ELEMENT_TYPE,
       ICON_TYPE, MENU_TYPE, MENU_ICON_TYPE, TOOLTIP, DIALOG_TITLE_TYPE,
       DIALOG_TEXT_LIST_TYPE, DIALOG_TEXT_SLIDER_TYPE, UP_ARROW_ICON,
       DOWN_ARROW_ICON, DIALOG_TEXT_ENTRY_TYPE, DIALOG_TEXT_ENTRY_ENTRY_TYPE,
       DIALOG_CHOICE_TYPE, DIALOG_RADIO_CHOICE_TYPE, DIALOG_VSLIDER_TYPE };
 
#define MENUBAR_MENUS_LIMIT 5 /* hard limit of five top-level menus on the bar  */
#define ICONPANEL_ICONS_LIMIT 15 /* hard limit of sixteen icons  */
#define MAX_MENUBAR_LABEL_SIZE 10 /* hard limit, strings are truncated  */ 
#define MAX_MENU_LABEL_SIZE 20 /* hard limit, strings are truncated  */ 
#define MENU_LABEL_LIMIT 20 /* hard limit of labels in menus */
 
#define STK_DC_PING 23  
#define RIGHT 1 
#define FAIL -1 
#define PIXEL_SPACING_BETWEEN_MENUBAR_LABELS 8 

/* useful dereferencers  */  
#define MENUBAR(a) ((stkInternalMenuBar *)(a)->data) 
#define MENU(a) ((stkInternalMenu *)(a)->data) 
#define TOOLWINDOW(a) ((WindowStruct *)(a)->data) 
#define ICON(a) ((stkInternalIcon *)(a)->data) 
#define ICONMENU(a) ((stkInternalIconMenu *)(a)->data) 
#define DIALOG(a) ((stkInternalDialog *)(a)->data)
#define DIALOGTITLE(a) ((stkInternalDialogTitle *)(a)->data) 
#define SLIDER(a) ((stkInternalDialogSlider *)(a)->data)
#define VSLIDER(a) ((stkInternalDialogVSlider *)(a)->data) 
#define TEXTLIST(a) ((stkInternalDialogTextList *)(a)->data)
#define TEXTENTRY(a) ((stkInternalDialogTextEntry *)(a)->data) 
#define CHOICE(a) ((stkInternalDialogChoice *)(a)->data) 
#define RCHOICE(a) ((stkInternalDialogRadioChoice *)(a)->data) 
#define BUTTON(a) ((stkInternalDialogButton *)(a)->data) 
#define CLOCKS_PER_MS   (CLOCKS_PER_SEC/1000) 
#define max(a,b) (((a)>(b)) ? (a) : (b))
#define min(a,b) (((a)<(b)) ? (a) : (b))
#define streq(a,b) (!strcmp((a),(b)))
#define REDRAW_ALL_WINDOW(a) (send_redraw((a),0,0,(int)(a)->w,(int)(a)->h))
#define SET_CLIP_WINDOW(g,l) (set_clip((g),0,0, (int)(l)->w, (int)(l)->h))

typedef struct _ListEl
   {
   unsigned long id;
   unsigned long type;
   void *data;
   struct _ListEl *next;
   struct _ListEl *prev;
   } ListEl;

typedef ListEl *List;

enum _Boolean { FALSE, TRUE };
typedef enum _Boolean Boolean;

typedef struct _WindowStruct
   {
   Window win;
   Window parent;
   int cursor_num;
   int x,y;
   uint w,h;
   XSizeHints *size_hints;
   XClassHint *class_hints;
   XWMHints *wm_hints;
   Boolean grabbed;
   GC gc;
   } WindowStruct;

typedef struct _VColour
   {
   char label[20];
   unsigned long colour;
   char name[10];
   int tag;
   } VColour;

typedef struct _stkInternalMenuLabel
	{
	char label[MAX_MENU_LABEL_SIZE];
	int tag;
	int x,y;
	uint w,h;
	Boolean selected;
	uint text_x, text_y;
	Boolean disabled; 
	} stkInternalMenuLabel;

typedef struct _stkInternalMenu
	{
	WindowStruct *parent_window; 
	WindowStruct window;
	uint relative_x;
	uint relative_y;
	stkInternalMenuLabel labels[MENU_LABEL_LIMIT];
	uint selected_label; 
	uint label_number; 
	void *call; /* this is set when a menu is not attached anywhere  */  
	} stkInternalMenu;

typedef struct _stkInternalMenuBarElement
	{
	char label[MAX_MENUBAR_LABEL_SIZE];
	int x;
	int y;
	uint w;
	uint h;
	uint text_x;
	uint text_y;
	Boolean selected; 
	Boolean child_menu_open; 
	stkInternalMenu *child_menu; 
	} stkInternalMenuBarElement;

typedef struct _stkInternalMenuBar 
	{
	WindowStruct *window;
	List elements;
	stkInternalMenuBarElement *current_menu_el; 
	stkInternalMenuBarElement *current_menu_sel; 
	} stkInternalMenuBar;
	 
/* for _stkInternalIcon  */ 
struct _stkInternalIconMenu;

typedef struct _stkInternalIcon
	{
	WindowStruct window;
	uint pixmap_w; 
	uint pixmap_h; 
	Boolean selected; 
	Boolean pressed; 
	int tag; 
	Pixmap actual_pixmap;
	Boolean pressable; 
	Boolean binary; 
	struct _stkInternalIconMenu *attached_icon_menu;
	char tooltip[30]; 
	/* signed because we used special -1 */  
	long colour; 
	} stkInternalIcon;

typedef struct _stkInternalIconPanel
	{
	int x,y;
	uint w,h;
	uint iconnum; 
	stkInternalIcon *icons[ICONPANEL_ICONS_LIMIT];
	} stkInternalIconPanel;
	 
typedef struct _stkInternalIconMenu
	{
	WindowStruct window;
	uint iconnum;
	stkInternalIcon *icons[ICONPANEL_ICONS_LIMIT];
	} stkInternalIconMenu;

/* for _stkInternalDialog  */  
struct _stkInternalDialogTextEntry;
struct _stkInternalDialogButton;

typedef struct _stkInternalDialog
	{
	WindowStruct window;
	List items;
	int next_x;
	int next_y;
	struct _stkInternalDialogTextEntry *focus; /* textentry element with keyboard focus  */  
	struct _stkInternalDialogButton *defaultbutton; /* return sends message for this stkInternalDialogButton  */  
	void *call; /* calling val, normally View *  */  
	} stkInternalDialog;

typedef struct _stkInternalDialogTitle
	{
	WindowStruct window;
	stkInternalDialog *dialog; 
	char text[200];
	} stkInternalDialogTitle;

typedef struct _stkInternalDialogTextList
	{
	WindowStruct window;
	stkInternalDialog *dialog;
	unsigned int shown_number; 
	unsigned int number;
	unsigned int start; 
	int selection; /* -1 for no selection */  
	char *strings; /* string , several nullterminated strings */
	long stringsize; 
	} stkInternalDialogTextList;
	 
typedef struct _stkInternalDialogSlider
	{
	WindowStruct window;
	stkInternalDialog *dialog; 
	char label[40]; 
	int label_x;
	int label_y;
	int slider_x;
	int slider_y;
	stkInternalDialogTextList *textlist; 
	int hjustification; /* elements with same value != 0 will appear on same line */  
	unsigned int top;
	unsigned int bottom;
	unsigned int position; /* position of top of slider bar */ 
	} stkInternalDialogSlider;

typedef struct _stkInternalDialogVSlider
	{
	WindowStruct window;
	stkInternalDialog *dialog;
	char label[40]; 
	char start[20];
	char end[20];
	double pos; /* relative position of slider 0<=pos<=1  */ 
	int hjustification;
	} stkInternalDialogVSlider;

typedef struct _stkInternalDialogTextEntry
	{
	WindowStruct window;
	WindowStruct text_window;
	stkInternalDialog *dialog;
	char label[40];
	char contents[200];
	int label_x;
	int label_y;
	int charpos; /* -1 if no cursor there */  
	int pos_x; /* pixel position of cursor  */  
	int hjustification;
	} stkInternalDialogTextEntry;
	
typedef struct _stkInternalDialogChoice
	{
	WindowStruct window;
	stkInternalDialog *dialog;
	char label[40];
	Boolean on; 
	int label_x;
	int label_y;
	int hjustification;
	Window radio; 
	} stkInternalDialogChoice;
	 
typedef struct _stkInternalDialogRadioChoice
	{
	WindowStruct window;
	stkInternalDialog *dialog;
	stkInternalDialogChoice *c1; 
	stkInternalDialogChoice *c2; 
	stkInternalDialogChoice *c3; 
	stkInternalDialogChoice *c4; 
	char label[40]; 
	int hjustification;
	} stkInternalDialogRadioChoice;
	 
typedef struct _stkInternalDialogButton
	{
	WindowStruct window;
	stkInternalDialog *dialog; 
	char label[15];
	int label_x;
	int label_y;
	int hjustification;
	Boolean pressed; 
	} stkInternalDialogButton;

/* prototypes  */

#ifdef PROTOTYPES 
List create_list(ulong, ulong, void *);
List add_to_list0(List, ulong, ulong, void *);
List add_to_list_neq0(List, ulong, ulong, void *);
void delete_list(List);
List delete_from_list(List, ulong);
Boolean is_in_list(List, ulong);
List where_in_list(List, ulong);
Boolean is_in_box(int, int, int, int, int, int);
void set_clip(GC, int, int, int, int);
void send_redraw(WindowStruct *, int, int, int, int);
Boolean stk_create_window(WindowStruct *, Window, uint, void *, Boolean);
void stk_outline(WindowStruct *, uint, uint, uint, uint);
void stk_inverse_outline(WindowStruct *, uint, uint, uint, uint);
void stk_thin_outline(WindowStruct *, uint, uint, uint, uint); 
void stk_redraw_menu_bar(void);
Boolean stk_keyboard(XKeyPressedEvent *); 
void stk_handle_motion(Window win, int, int);
void stk_handle_enter_notify(Window);
void stk_handle_leave_notify(Window);
void stk_handle_configure_notify(Window, int, int, int, int); 
void stk_handle_button_press(Window, int, int, uint); 
void stk_handle_button_release(Window, Time, int, int, uint);
void stk_internal_display_icon_menu(stkInternalIconMenu *, int, int); 
stkInternalIcon *stk_tag_to_icon(int,Window);
void stk_resize_icon_panel(uint); 
void stk_redraw_icon(stkInternalIcon *);
void stk_internal_display_menu(stkInternalMenu *); 
void stk_undisplay_menu(stkInternalMenu *); 
void stk_redraw_menu(stkInternalMenu *); 
void stk_redraw_menu_labels(stkInternalMenu *, int, int); 
void stk_select_menu(stkInternalMenuBar *, int, int); 
void stk_tooltip(Window, Boolean);
void stk_resize_dialog(stkInternalDialog *, long, long, long, long); 
void stk_redraw_dialog(stkInternalDialog *); 
void stk_redraw_dialog_title(stkInternalDialogTitle *); 
void stk_redraw_dialog_text_slider(stkInternalDialogSlider *); 
void stk_redraw_dialog_text_entry(stkInternalDialogTextEntry *); 
void stk_redraw_dialog_text_entry_entry(stkInternalDialogTextEntry *); 
void stk_redraw_dialog_text_list(stkInternalDialogTextList *); 
void stk_redraw_dialog_button(stkInternalDialogButton *); 
void stk_redraw_dialog_choice(stkInternalDialogChoice *); 
void stk_redraw_dialog_radio_choice(stkInternalDialogRadioChoice *); 
void stk_redraw_dialog_slider(stkInternalDialogVSlider *vp); 
#endif 

#endif
