/******************************************************************** 
   Copyright (C) 2000 Bassoukos Tassos <abas@aix.meng.auth.gr>
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later
   version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_MALLOC_H
#include <malloc.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif
#ifdef HAVE_SYS_SIGNAL_H
#include <sys/signal.h>
#endif
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <gnome.h>
#include <gtk/gtk.h>
#include <gtk/gtkprogressbar.h>

#include "bookmarks.h"
#include "tasks.h"
#include "threads.h"
#include "guiprefs.h"
#include "server.h"
#include "protocol.h"
#include "pixmap.h"
#include "hldat.h"
#include "main.h"
#include "guiutils.h"

GtkWidget *main_app;
GdkColormap *main_colormap;

static void connect_to(GtkWidget *widget,gpointer cbd){
  static Bookmark *old = NULL;
  Bookmark *c;
  if(!(c=bookmark_dialog(old,_("Connect to..."),main_app))) 
  	return;
  server_connect_to(old = c);
}

static void sbkmarks(GtkWidget *widget,gpointer cbd){
  show_bookmarks();
}
static void strackers(GtkWidget *widget,gpointer cbd){
  show_trackers();
}

static void about() {
  const gchar *authors[] = {
    N_("Tassos Bassoukos <abas@aix.meng.auth.gr>"),
    N_("Philippe Raoult <phir@gcu-squad.org>"),
    N_("Joaquim Fellmann <joaquim@hrnet.fr>"),
    NULL
  };
  gtk_widget_show(gnome_about_new ("Fidelio",VERSION,
				   _("Copyright 1999,2000 Bassoukos Tassos"),
				   (const gchar **)authors,
				   _("A GPL'ed Hotline client for GNOME"),NULL));
}

static GnomeUIInfo main_toolbar[] = {
  GNOMEUIINFO_ITEM_STOCK(N_("Connect..."),N_("Connect to a Hotline Server"),
			 connect_to,
			 HL_STOCK_PIXMAP_CONNECT),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_ITEM_STOCK(N_("Bookmarks"),N_("Manage Bookmarks"),
			 sbkmarks,
			 HL_STOCK_PIXMAP_BOOKMARKS),
  GNOMEUIINFO_ITEM_STOCK(N_("Trackers"),N_("Show Trackers"),
			 strackers,
			 HL_STOCK_PIXMAP_TRACKERS),
  GNOMEUIINFO_SEPARATOR,
  HOTLINE_UIITEM_STOCK(N_("Cancel All"),N_("Cancel all tasks"),
		       remove_all_tasks,HL_STOCK_PIXMAP_CANCEL_ALL,'A',GDK_CONTROL_MASK),
  GNOMEUIINFO_END
};

static GnomeUIInfo file_menu[] = {
  HOTLINE_UIITEM_STOCK(N_("Connect..."),N_("Connect to a Hotline Server"),
		       connect_to,HL_MENU HL_STOCK_PIXMAP_CONNECT,'C',GDK_CONTROL_MASK),
  GNOMEUIINFO_SEPARATOR,
  HOTLINE_UIITEM_STOCK(N_("_Bookmarks"),N_("Manage Bookmarks"),
		       sbkmarks,HL_MENU HL_STOCK_PIXMAP_BOOKMARKS,'B',GDK_CONTROL_MASK),
  HOTLINE_UIITEM_STOCK(N_("_Trackers"),N_("Show Trackers"),
		       strackers,HL_MENU HL_STOCK_PIXMAP_TRACKERS,'T',GDK_CONTROL_MASK),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_PREFERENCES_ITEM(open_prefs,NULL),
  GNOMEUIINFO_SEPARATOR,
  GNOMEUIINFO_MENU_EXIT_ITEM(gtk_main_quit,NULL),
  GNOMEUIINFO_END
};
static GnomeUIInfo help_menu[]={
  GNOMEUIINFO_MENU_ABOUT_ITEM(about,NULL),
  GNOMEUIINFO_END
};
static GnomeUIInfo windows_menu[]={
  GNOMEUIINFO_END
};
static GnomeUIInfo menubar[] = {
  GNOMEUIINFO_MENU_FILE_TREE(file_menu),
  GNOMEUIINFO_MENU_WINDOWS_TREE(windows_menu),
  GNOMEUIINFO_MENU_HELP_TREE(help_menu),
  GNOMEUIINFO_END
};

void set_cancel_task_widget_state(gboolean enabled){
  gtk_widget_set_sensitive(main_toolbar[5].widget,enabled);
}

int main(int argc, char *argv[]){
  GtkWidget *app,*task_list,*sr;
  
#ifdef LIBXML_TEST_VERSION
  LIBXML_TEST_VERSION;
#endif
  signal(SIGCHLD,SIG_IGN);
  if(!g_thread_supported())
    g_thread_init(NULL);  
#ifdef ENABLE_NLS
  bindtextdomain(PACKAGE, LOCALEDIR);
  textdomain(PACKAGE);
#endif
  gnome_init(PACKAGE, VERSION, argc, argv);
  
  gdk_rgb_init();
  app = gnome_app_new(PACKAGE "/Main",_("Fidelio: Hotline client"));
  gtk_window_set_default_size(GTK_WINDOW(app),500,300);
  guiprefs_add_window(GTK_WINDOW(app),"Main/Window/Size");
  gtk_signal_connect(GTK_OBJECT(app),"delete_event",
		     GTK_SIGNAL_FUNC(gtk_main_quit),NULL);

  main_app=app;
  main_colormap=gtk_widget_get_colormap(app);
  load_prefs();
  init_hotline_dat();
  pixmap_init();
  init_bookmarks();

  gnome_app_create_toolbar(GNOME_APP(app),main_toolbar);
  gnome_app_create_menus(GNOME_APP(app),menubar);

  task_list=new_task_widget();
  sr=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sr),task_list);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sr),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_AUTOMATIC);
  gnome_app_set_contents(GNOME_APP(app),sr);
  gtk_widget_show_all(sr);

  set_cancel_task_widget_state(FALSE);
  gtk_widget_show(app);

  signal(SIGPIPE,SIG_IGN);

  gtk_main();
  return 0;
}

/* ================================== */

typedef struct {
  char * name;
  GtkWidget *window;
} RegisteredWindow;

static GList *registered_windows=NULL;

static void front_window(GtkWidget *widget,RegisteredWindow *r){
  guiutils_raise_window(GTK_WINDOW(r->window));
}

static void refresh_windows(){
  GnomeUIInfo *w_menus;
  int i,size,accels=0;
  RegisteredWindow *r;

  gnome_app_remove_menus(GNOME_APP(main_app),_("Windows/"),10);
  size=g_list_length(registered_windows);
  if(size==0)
    return;
  w_menus=(GnomeUIInfo *)calloc(size+1,sizeof(GnomeUIInfo));
  w_menus[size].type=GNOME_APP_UI_ENDOFINFO;
  for(i=0;i<size;i++){
    r=(RegisteredWindow *)g_list_nth_data(registered_windows,i);
    w_menus[i].type=GNOME_APP_UI_ITEM;
    w_menus[i].label=r->name;
    w_menus[i].user_data=r;
    w_menus[i].moreinfo=(gpointer)front_window;
    w_menus[i].unused_data=NULL;
    w_menus[i].hint=NULL;
    w_menus[i].pixmap_type=GNOME_APP_PIXMAP_NONE;
    w_menus[i].pixmap_info=NULL;
    if(index(r->name,'_') || accels>8){
      w_menus[i].accelerator_key=0;
    } else {
      w_menus[i].accelerator_key='0'+((++accels)%10);
      w_menus[i].ac_mods=GDK_CONTROL_MASK;
    }
    w_menus[i].widget=NULL;
  }
  gnome_app_insert_menus(GNOME_APP(main_app),_("Windows/"),w_menus);
  free(w_menus);
}

static void registered_window_destroy(GtkWidget *w,gpointer b){
  RegisteredWindow *r=(RegisteredWindow *)b;
  registered_windows=g_list_remove(registered_windows,r);
  free(r);
  refresh_windows();
}

void register_window(GtkWidget *window,char *name){
  RegisteredWindow *r=(RegisteredWindow *)malloc(sizeof(RegisteredWindow));

  r->name=name;
  r->window=window;
  gtk_signal_connect(GTK_OBJECT(window),"destroy",
		     GTK_SIGNAL_FUNC(registered_window_destroy),
		     (gpointer)r);
  registered_windows=g_list_append(registered_windows,r);
  refresh_windows();
}
