#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 2002-2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fhist -binary functionality
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

no_result()
{
	set +x
	echo 'NO RESULT test of the fhist -binary functionality' 1>&2
	cd $here
	rm -rf $work
	exit 2
}
fail()
{
	set +x
	echo 'FAILED test of the fhist -binary functionality' 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 2; fi
mkdir $work
if test $? -ne 0 ; then exit 2; fi
cd $work
if test $? -ne 0 ; then no_result; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test the fhist -binary functionality
#
echo "one" > the-file
if test $? -ne 0 ; then no_result; fi
mkdir FHIST
if test $? -ne 0 ; then no_result; fi

$bin/fhist -create the-file -bin -r > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

echo "two" >> the-file
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -bin -r > LOG 2>&1
if test $? -ne 0 ; then cat LOG; no_result; fi

cat > the-file-bin.uue << 'fubar'
begin 644 the-file-bin-3
M;VYE"G1H:7,@:7,@82``($Y53`IT=V\*=&AI<R!L:6YE(&AA<R!N;W<@;F5W
$;&EN90``
`
end
fubar
if test $? -ne 0 ; then no_result; fi

uudecode the-file-bin.uue
if test $? -ne 0 ; then no_result; fi

cp the-file-bin-3 the-file
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -bin -r > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cat > ok << 'fubar'
fhist: installing "the-file" as edit 3 of module "the-file"
fhist: edit 3 of module "the-file" saved (inserts 2, deletes 0, matches 2)
fubar
if test $? -ne 0 ; then no_result; fi

diff ok LOG
if test $? -ne 0 ; then fail; fi

cat > ok << 'fubar'
B 3
one
this is a =00 NUL
two
this line has now newline=
fubar
if test $? -ne 0 ; then no_result; fi

diff ok FHIST/the-file.s
if test $? -ne 0 ; then fail; fi

cat > the-file-bin.uue << 'fubar'
begin 644 the-file-bin-4
M;VYE"G1H:7,@;&EN92!H87,@`"!T=V\@`"!.54QS"G1W;PIT:&ES(&QI;F4@
.:&%S(&YO(&YE=VQI;F4`
`
end
fubar
if test $? -ne 0 ; then no_result; fi

uudecode the-file-bin.uue
if test $? -ne 0 ; then no_result; fi

cp the-file-bin-4 the-file
if test $? -ne 0 ; then no_result; fi

$bin/fhist -update the-file -bin -r > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cat > ok << 'fubar'
fhist: installing "the-file" as edit 4 of module "the-file"
fhist: edit 4 of module "the-file" saved (inserts 2, deletes 2, matches 2)
fubar
if test $? -ne 0 ; then no_result; fi

diff ok LOG
if test $? -ne 0 ; then fail; fi

cat > ok << 'fubar'
B 4
one
this line has =00 two =00 NULs
two
this line has no newline=
fubar
if test $? -ne 0 ; then no_result; fi

diff ok FHIST/the-file.s
if test $? -ne 0 ; then fail; fi

#
# Now make sure we can reconstruct the various edits properly.
#
rm the-file
$bin/fhist the-file -e 3 -bin > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cmp the-file-bin-3 the-file
if test $? -ne 0 ; then fail; fi

rm the-file
$bin/fhist -e 4 the-file -bin > LOG 2>&1
if test $? -ne 0 ; then cat LOG; fail; fi

cmp the-file-bin-4 the-file
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
