/*
 * Copyright (C) 2000-2001 Chris Ross and Evan Webb
 * Copyright (C) 1999-2000 Chris Ross
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies of the Software, its documentation and marketing & publicity
 * materials, and acknowledgment shall be given in the documentation, materials
 * and software packages that this Software was used.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "ferite.h"

char *__ferite_lowercase( char *str )
{
   unsigned int i, strt = 0, in_quote = 0;
   char *tmpstr = NULL;

   FE_ENTER_FUNCTION;

   if( str )
   {
      tmpstr = fmalloc( strlen(str)+1 );
      memset( tmpstr, '\0', strlen(str)+1 );
      for( i = 0; i < strlen(str); i++ )
      {
		 if( str[i] == '\"' )
		   in_quote = (in_quote == 0 ? 1 : 0);
		 if( !in_quote )
		 {
			if( isupper(*(str+i)) )
			  tmpstr[strt++] = str[i]+32;
			else
			  tmpstr[strt++] = str[i];
		 }
		 else
		   tmpstr[strt++] = str[i];
      }
      strcpy( str, tmpstr );
      ffree(tmpstr);
      FE_LEAVE_FUNCTION( str );
   }
   FE_LEAVE_FUNCTION( NULL );
}

char *__ferite_strip_whitespace( char *str )
{
   unsigned int i, strt = 0, in_quote = 0;
   char *tmpstr = NULL;

   FE_ENTER_FUNCTION;

   if( str )
   {
      tmpstr = fmalloc( strlen(str)+1 );
      memset( tmpstr, '\0', strlen(str)+1 );
      for( i = 0; i < strlen(str); i++ )
      {
		 if( str[i] == '\"' )
		   in_quote = (in_quote == 0 ? 1 : 0);
		 if( in_quote || ! isspace(*(str+i)) )
		   tmpstr[strt++] = str[i];
      }
      strcpy( str, tmpstr );
      ffree(tmpstr);
      FE_LEAVE_FUNCTION( str );
   }
   FE_LEAVE_FUNCTION( NULL );
}

int __ferite_find_string( char *haystack, char *needle )
{
   FE_ENTER_FUNCTION;
   if(  strstr( haystack, needle ) != NULL )
   {
      FE_LEAVE_FUNCTION( strstr( haystack, needle ) - haystack );
   }
   FE_LEAVE_FUNCTION( -1 );
}

char *__ferite_copy_string( char *str, int start, int end )
{
   int i = 0;
   char *rstr = NULL;

   FE_ENTER_FUNCTION;
   if( str && (start <= end) && (end < (signed)strlen( str )) )
   {
      rstr = fmalloc( sizeof(char) * (end - start + 2) );
      for( i = start; i <= end && str[i] != '\0'; i++ )
		rstr[i-start] = str[i];
      rstr[end - start + 1] = '\0';
      FE_LEAVE_FUNCTION( rstr );
   }
   FE_LEAVE_FUNCTION( NULL );
}

/* Cuts out a substring starting at "start" up to but not
   including "end". Result needs to be freed.
*/
char *__ferite_delete_string( char *str, int start, int end )
{
   char *rstr = NULL;

   FE_ENTER_FUNCTION;
   if( str && (start <= end) && (end < (signed)strlen( str )) )
   {
      rstr = fcalloc( strlen(str) - (end - start) + 1, sizeof( char ) );
      strncpy( rstr, str, start );
      strcat( rstr, str+end );
      FE_LEAVE_FUNCTION( rstr );
   }
   FE_LEAVE_FUNCTION( NULL );
}

char *__ferite_insert_string( char *str, char *istr, int pos )
{
   char *rstr = NULL;

   FE_ENTER_FUNCTION;
   if( str && istr && pos >= 0 && pos <= (signed)strlen( str ))
   {
      rstr = fcalloc( strlen(str) + strlen(istr) + 1, sizeof( char ) );
      strncpy( rstr, str, pos );
      strcat( rstr, istr );
      strcat( rstr, str+pos );
      FE_LEAVE_FUNCTION( rstr );
   }
   FE_LEAVE_FUNCTION( NULL );
}

char *__ferite_replace_string( char *str, char *pattern, char *data )
{
   int i=0, start=0;
   char *rstr=NULL,*tmpbuf = NULL;

   FE_ENTER_FUNCTION;
   if( str && pattern && data )
   {
      /* empty string -- nothing to replace */
      if( !str[0] )
      {
		 FE_LEAVE_FUNCTION(  fstrdup(str) );
      }
      /* empty pattern -- nothing to replace */
      if( !pattern[0] )
      {
		 FE_LEAVE_FUNCTION(  fstrdup(str) );
      }

      if( !data[0] ) /* empty replacement -- string won't grow */
		rstr = fcalloc( strlen( str ) + 1, sizeof(char) );
      else /* none of the strings can have length zero now */
		rstr = fcalloc( strlen( str ) * strlen( pattern ) * strlen( data ), sizeof(char) );

      FUD(("replace_str: replace \"%s\" with \"%s\"\n", pattern, data ));
      while( ((i=__ferite_find_string( str+start, pattern ))+1) )
      {
		 strncat( rstr, str+start, i );
		 strcat( rstr, data );
		 start = i + start + strlen(pattern);
      }
      strcat( rstr, str + start );
      tmpbuf = fstrdup( rstr );
      ffree( rstr );
      FE_LEAVE_FUNCTION( tmpbuf );
   }
   FE_LEAVE_FUNCTION( NULL );
}

char *__ferite_strdup( char *str )
{
   char *tmpbuf = NULL;

   FE_ENTER_FUNCTION;
   if( str != NULL )
   {
      tmpbuf = (char *)fmalloc( strlen( str )+1 );
      strcpy( tmpbuf, str );
      FUD(("fstrdup: Copying %s to %p\n", str, tmpbuf ));
      FE_LEAVE_FUNCTION( tmpbuf );
   }
   FE_LEAVE_FUNCTION( NULL );
}

char *__ferite_stroflen(char c, int l)
{
   static char buf[1024];
   int i = 0;

   buf[0] = '\0';
   if( l > 0 )
   {
      while (l-- && l >= 0)
		buf[i++] = c;
      buf[i] = '\0';
   }
   return buf;
}

FeriteString *__ferite_str_new( int length )
{
   FeriteString *ptr = NULL;
   
   FE_ENTER_FUNCTION;
   ptr = fmalloc( sizeof( FeriteString ) );
   ptr->encoding = 0;
   ptr->length = length;
   ptr->data = fcalloc( length, sizeof(char) );
   FE_LEAVE_FUNCTION( ptr );
}

int __ferite_str_cmp( FeriteString *str1, FeriteString *str2 )
{
   int i = 0;
   
   FE_ENTER_FUNCTION;
   if( str1->length != str2->length ){
	  FE_LEAVE_FUNCTION( 0 );
   }
   for( i = 0; i < str1->length; i++ ){
	  if( str1->data[i] != str2->data[i] ){
		 FE_LEAVE_FUNCTION( 0 );
	  }
   }   
   FE_LEAVE_FUNCTION( 1 );
}

int __ferite_str_ncmp( FeriteString *str1, FeriteString *str2, int size )
{
   int i = 0;
   
   FE_ENTER_FUNCTION;
   if( str1->length != str2->length ){
	  FE_LEAVE_FUNCTION( 0 );
   }
   for( i = 0; i < str1->length && i < size; i++ ){
	  if( str1->data[i] != str2->data[i] ){
		 FE_LEAVE_FUNCTION( 0 );
	  }
   }   
   FE_LEAVE_FUNCTION( 1 );   
}

int __ferite_str_cpy( FeriteString *str1, FeriteString *str2 )
{
   int i = 0;
   
   FE_ENTER_FUNCTION;
   while( i < str1->length && i < str2->length ){
	  str1->data[i] = str2->data[i];
   }
   FE_LEAVE_FUNCTION(i);
}

int __ferite_str_ncpy( FeriteString *str1, FeriteString *str2, int size )
{
   int i = 0;
   
   FE_ENTER_FUNCTION;
   while( i < str1->length && i < str2->length && i < size ){
	  str1->data[i] = str2->data[i];
   }
   FE_LEAVE_FUNCTION(i);
}

/*
 * int __ferite_str_cat( FeriteString *str1, FeriteString *str2 );
 * int __ferite_str_ncat( FeriteString *str1, FeriteString *str2, int size );
 * int __ferite_str_find( FeriteString *str, char *token );
 * int __ferite_str_delete( FeriteString *str, int from, int to );
 * int __ferite_str_insert( FeriteString *str, FeriteString *data, int pos );
 * int __ferite_str_replace( FeriteString *str, FeriteString *what, FeriteString *with );
 * FeriteString *__ferite_str_dup( FeriteString *str );
 * FeriteString *__ferite_str_copy( FeriteString *str, int from, int to );
 */
