#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <string.h>

#include "../config.h"

#define LIB_OPEN void * __triton_low_open(const char *path)
#define LIB_SYM void * __triton_low_getsym(void *handle, const char *symbol)
#define LIB_CLOSE int __triton_low_close(void *handle)
#define LIB_INIT int __triton_low_init(void)
#define LIB_DEINIT void __triton_low_deinit(void)
#define LIB_ERROR const char * __triton_low_error(void)
#define LIB_EXT const char * __triton_low_module_ext(void)

#ifndef RTLD_LAZY
# define RTLD_LAZY      0x1
#endif

#ifndef RTLD_NOW
# define RTLD_NOW       0x2
#endif

#ifndef RTLD_LOCAL
# define RTLD_LOCAL     0x4
#endif

#ifndef RTLD_GLOBAL
# define RTLD_GLOBAL    0x8
#endif

#ifndef RTLD_NOLOAD
# define RTLD_NOLOAD    0x10
#endif

#ifndef RTLD_SHARED
# define RTLD_SHARED    0x20  /* not used, the default */
#endif

#ifndef RTLD_UNSHARED
# define RTLD_UNSHARED  0x40
#endif

#ifndef RTLD_NODELETE
# define RTLD_NODELETE  0x80
#endif

#ifndef RTLD_LAZY_UNDEF
# define RTLD_LAZY_UNDEF 0x100
#endif

void * __triton_low_open(const char *path);
void * __triton_low_getsym(void *handle, const char *symbol);
int __triton_low_close(void *handle);
int __triton_low_init(void);
void __triton_low_deinit(void);
const char * __triton_low_error(void);
const char * __triton_low_module_ext(void);
