//######################################## harp.dsp ######################################
// A simple smart phone based harp (if we dare to call it like that). 
//
// ## `SmartKeyboard` Use Strategy
//
// Since the sounds generated by this synth are very short, the strategy here is to take
// advantage of the polyphony capabilities of the iOSKeyboard architecture by creating
// a new voice every time a new key is pressed. Since the `SmartKeyboard` interface has a 
// large number of keys here (128), lots of sounds are generated when sliding a 
// finger across the keyboard.
//
// Author: Romain Michon (rmichon_at_ccrma_dot_stanford_dot_edu)
// 06/17/2016
//########################################################################################

import("stdfaust.lib");


//========================= Smart Keyboard Configuration ================================= 
// (8 keyboards with 16 keys configured as a pitch matrix.
//========================================================================================

declare interface "SmartKeyboard{
	'nKeyb':'8',
	'keyb0_nKeys':'16',
	'keyb1_nKeys':'16',
	'keyb2_nKeys':'16',
	'keyb3_nKeys':'16',
	'keyb4_nKeys':'16',
	'keyb5_nKeys':'16',
	'keyb6_nKeys':'16',
	'keyb7_nKeys':'16',
	'keyb0_lowestKey':'40',
	'keyb1_lowestKey':'45',
	'keyb2_lowestKey':'50',
	'keyb3_lowestKey':'55',
	'keyb4_lowestKey':'60',
	'keyb5_lowestKey':'65',
	'keyb6_lowestKey':'70',
	'keyb7_lowestKey':'75',
	'keyb0_showNotesName':'0',
	'keyb1_showNotesName':'0',
	'keyb2_showNotesName':'0',
	'keyb3_showNotesName':'0',
	'keyb4_showNotesName':'0',
	'keyb5_showNotesName':'0',
	'keyb6_showNotesName':'0',
	'keyb7_showNotesName':'0'
}";


//================================ Instrument Parameters =================================
// Creates the connection between the synth and the mobile device
//========================================================================================

// the string resonance in second is controlled by the x axis of the accelerometer
res = hslider("res[acc: 0 0 -10 0 10]",2,0.1,4,0.01);
// Smart Keyboard frequency parameter
freq = hslider("freq",400,50,2000,0.01);
// Smart Keyboard gate parameter
gate = button("gate");


//=================================== Parameters Mapping =================================
//========================================================================================

stringFreq = freq : si.polySmooth(gate,0.999,2);


//============================================ DSP =======================================
//========================================================================================

process = sy.combString(freq,res,gate);