/*
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "glue-shm.h"
#include "glue-gui-gtk.h"

#include "sig_boolean.h"
#include "sig_manage.h"

#include "zuse23_matrix_gui_gtk.h"

#define COMP		"zuse23_matrix"
#define COMP_(x)	zuse23_matrix_ ## x

struct cpssp {
	int dummy;
};

static void
cb_sw(GtkWidget *w, gpointer _sig)
{
	struct sig_boolean *sig = _sig;

	sig_boolean_set(sig, w,
			gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)));
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_sperr0,
	struct sig_boolean *port_sperr1,
	struct sig_boolean *port_sperr2,
	struct sig_boolean *port_sperr3,
	struct sig_boolean *port_sperr4,
	struct sig_boolean *port_sperr5,
	struct sig_boolean *port_sperr6,
	struct sig_boolean *port_sperr7,
	struct sig_boolean *port_sperr8,
	struct sig_boolean *port_sperr9,
	struct sig_boolean *port_sperr10,
	struct sig_boolean *port_sperr11,
	struct sig_boolean *port_sperr12,
	struct sig_boolean *port_sperr13,
	struct sig_boolean *port_sperr14,
	struct sig_boolean *port_sperr15
)
{
	struct cpssp *cpssp;
	GtkWidget *table;
	char text[256];
	GtkWidget *button;
	GtkWidget *label;
	struct sig_boolean *sig;
	int i;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	table = gtk_table_new(3, 16, TRUE);
	gtk_widget_show(table);

	for (i = 0; i < 16; i++) {
		sprintf(text, "<small><small>%d</small></small>", i * 512);
		label = gtk_label_new(text);
		gtk_label_set_markup(GTK_LABEL(label), text);
		gtk_widget_show(label);

		gtk_table_attach_defaults(GTK_TABLE(table), label,
				i, i + 1, 0, 1);

		sprintf(text, "<small><small>%d</small></small>", (i + 1) * 512);
		label = gtk_label_new(text);
		gtk_label_set_markup(GTK_LABEL(label), text);
		gtk_widget_show(label);

		gtk_table_attach_defaults(GTK_TABLE(table), label,
				i, i + 1, 1, 2);

		button = gtk_toggle_button_new();
		gtk_widget_show(button);

		switch (i) {
		case 0: sig = port_sperr0; break;
		case 1: sig = port_sperr1; break;
		case 2: sig = port_sperr2; break;
		case 3: sig = port_sperr3; break;
		case 4: sig = port_sperr4; break;
		case 5: sig = port_sperr5; break;
		case 6: sig = port_sperr6; break;
		case 7: sig = port_sperr7; break;
		case 8: sig = port_sperr8; break;
		case 9: sig = port_sperr9; break;
		case 10: sig = port_sperr10; break;
		case 11: sig = port_sperr11; break;
		case 12: sig = port_sperr12; break;
		case 13: sig = port_sperr13; break;
		case 14: sig = port_sperr14; break;
		case 15: sig = port_sperr15; break;
		default: assert(0);
		}
		sig_boolean_connect_out(sig, button, 0);
		g_signal_connect(button, "clicked", G_CALLBACK(cb_sw), sig);

		gtk_table_attach_defaults(GTK_TABLE(table), button,
				i, i + 1, 2, 3);

		if (i == 0
		 || i == 1) {
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button),
					TRUE);
		}
	}

	gui_gtk_comp_add(page, COMP, name, table, FALSE, FALSE, NULL);

	return cpssp;
}

void
zuse23_matrix_gui_gtk_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
zuse23_matrix_gui_gtk_suspend(void *_cpssp, FILE *fp)
{
}

void
zuse23_matrix_gui_gtk_resume(void *_cpssp, FILE *fp)
{
}
