/*
 * Copyright (C) 2007-2017 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define CONFIG_SEGMENT_LIMIT_CHECK	0

#ifdef STATE

struct {
	struct {
		seg_descr_t entry;
		udata_t base;
		uint32_t limit;
	} STATE_regs[12];
} NAME;

#endif /* STATE */
#ifdef EXPORT
/*forward*/ static void
NAME_(descr_set)(struct cpssp *cpssp, uint8_t sreg, seg_descr_t descr);
/*forward*/ static seg_descr_t
NAME_(descr_get)(struct cpssp *cpssp, uint8_t sreg);

/*forward*/ static int
NAME_(mx8)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint8_t *valp, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mr8)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, int w_test, uint8_t *valp,
	uint8_t usermode, uint16_t *errp);
/*forward*/ static int
NAME_(mw8)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint8_t val, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mx16)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint16_t *valp, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mr16)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, int w_test, uint16_t *valp,
	uint8_t usermode, uint16_t *errp);
/*forward*/ static int
NAME_(mw16)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint16_t val, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mx32)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint32_t *valp, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mr32)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, int w_test, uint32_t *valp,
	uint8_t usermode, uint16_t *errp);
/*forward*/ static int
NAME_(mw32)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint32_t val, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mr64)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, int w_test, uint64_t *valp,
	uint8_t usermode, uint16_t *errp);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
/*forward*/ static int
NAME_(mx64)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint64_t *valp, uint8_t usermode,
	uint16_t *errp);
/*forward*/ static int
NAME_(mw64)(struct cpssp *cpssp,
	uint32_t addr, uint8_t seg, uint64_t val, uint8_t usermode,
	uint16_t *errp);
#endif
#if ! CONFIG_INSPECTION
static void
NAME_(create)(struct cpssp *cpssp);
static void
NAME_(destroy)(struct cpssp *cpssp);
#endif /* CONFIG_INSPECTION */

#endif /* EXPORT */
#ifdef BEHAVIOR

static uint32_t
NAME_(_seg_limit)(uint64_t descr)
{
	uint32_t limit;
	uint32_t granularity;

	limit = (((descr >> 48) & 0xf) << 16) | ((descr & 0xffff) << 0);
	granularity = (descr >> 55) & 0x1;

	return (limit << (12 * granularity)) | (0xfff * granularity);
}

static udata_t
NAME_(_seg_base)(seg_descr_t descr)
{
	return 0
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
		| (((descr.entry[1] >> 0) & 0xffffffff) << 32)
#endif
		| (((descr.entry[0] >> 56) & 0xff) << 24)
		| (((descr.entry[0] >> 32) & 0xff) << 16)
		| (((descr.entry[0] >> 16) & 0xffff) << 0);
}

static void
NAME_(descr_set)(struct cpssp *cpssp, uint8_t sreg, seg_descr_t descr)
{
	STATE_SET(regs[sreg].base, NAME_(_seg_base)(descr));
	STATE_SET(regs[sreg].limit, NAME_(_seg_limit)(descr.entry[0]));
	STATE_SET(regs[sreg].entry.entry[0], descr.entry[0]);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_SET(regs[sreg].entry.entry[1], descr.entry[1]);
#endif
}

static seg_descr_t
NAME_(descr_get)(struct cpssp *cpssp, uint8_t sreg)
{
	seg_descr_t descr;

	descr.entry[0] = STATE_GET(regs[sreg].entry.entry[0]);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	descr.entry[1] = STATE_GET(regs[sreg].entry.entry[1]);
#endif

	return descr;
}

static int
NAME_(get_lin_addr)(
	struct cpssp *cpssp,
	uint32_t *laddrp,
	uint32_t addr,
	uint8_t seg,
	uint8_t data_size,
	uint16_t *errp
)
{
#if CONFIG_SEGMENT_LIMIT_CHECK
	/* Check segment limits for *all* segments. */
	if (STATE_GET(regs[seg].limit) < addr + data_size - 1) {
		fprintf(stderr, "WARNING: Limit check failed.\n");
		*laddrp = 0; /* Make gcc happy. */
		*errp = 0x0000;
		return 13;
	}
#else
	/* Check segment limits for %idt, %gdt, ...  segments only. */
	if (6 <= seg) {
		if (STATE_GET(regs[seg].limit) < addr + data_size - 1) {
			fprintf(stderr, "WARNING: Limit check failed.\n");
			*laddrp = 0; /* Make gcc happy. */
			*errp = 0x0000;
			return 13;
		}
	}
#endif

	*laddrp = addr + STATE_GET(regs[seg].base);

	return 0;
}

static int
NAME_(mx8)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint8_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 1, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umx8)(cpssp, laddr, usermode, valp, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mr8)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	int w_test,
	uint8_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 1, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umr8)(cpssp, laddr, usermode, valp, errp, w_test);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mw8)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint8_t val,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 1, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umw8)(cpssp, laddr, usermode, val, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mx16)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint16_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 2, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umx16)(cpssp, laddr, usermode, valp, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mr16)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	int w_test,
	uint16_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 2, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umr16)(cpssp, laddr, usermode, valp, errp, w_test);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mw16)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint16_t val,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 2, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umw16)(cpssp, laddr, usermode, val, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mx32)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint32_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 4, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umx32)(cpssp, laddr, usermode, valp, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mr32)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	int w_test,
	uint32_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 4, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umr32)(cpssp, laddr, usermode, valp, errp, w_test);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mw32)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint32_t val,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 4, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umw32)(cpssp, laddr, usermode, val, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mr64)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	int w_test,
	uint64_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 8, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umr64)(cpssp, laddr, usermode, valp, errp, w_test);
	if (ret) {
		return ret;
	}

	return 0;
}

#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
static int
NAME_(mx64)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint64_t *valp,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 8, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umx64)(cpssp, laddr, usermode, valp, errp);
	if (ret) {
		return ret;
	}

	return 0;
}

static int
NAME_(mw64)(
	struct cpssp *cpssp,
	uint32_t addr,
	uint8_t seg,
	uint64_t val,
	uint8_t usermode,
	uint16_t *errp
)
{
	uint32_t laddr;
	int ret;

	ret = NAME_(get_lin_addr)(cpssp, &laddr, addr, seg, 8, errp);
	if (ret) {
		return ret;
	}
	ret = DEFAULT_NAME_(umw64)(cpssp, laddr, usermode, val, errp);
	if (ret) {
		return ret;
	}

	return 0;
}
#endif

#if ! CONFIG_INSPECTION
static void
NAME_(create)(struct cpssp *cpssp)
{
	STATE_DECL("seg[ES].entry.entry[0]", regs[0].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[ES].entry.entry[1]", regs[0].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[ES].base", regs[0].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[ES].base", regs[0].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[ES].limit", regs[0].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[CS].entry.entry[0]", regs[1].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[CS].entry.entry[1]", regs[1].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[CS].base", regs[1].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[CS].base", regs[1].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[CS].limit", regs[1].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[SS].entry.entry[0]", regs[2].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[SS].entry.entry[1]", regs[2].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[SS].base", regs[2].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[SS].base", regs[2].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[SS].limit", regs[2].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[DS].entry.entry[0]", regs[3].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[DS].entry.entry[1]", regs[3].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[DS].base", regs[3].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[DS].base", regs[3].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[DS].limit", regs[3].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[FS].entry.entry[0]", regs[4].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[FS].entry.entry[1]", regs[4].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[FS].base", regs[4].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[FS].base", regs[4].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[FS].limit", regs[4].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[GS].entry.entry[0]", regs[5].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[GS].entry.entry[1]", regs[5].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[GS].base", regs[5].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[GS].base", regs[5].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[GS].limit", regs[5].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[LDT].entry.entry[0]", regs[6].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[LDT].entry.entry[1]", regs[6].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[LDT].base", regs[6].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[LDT].base", regs[6].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[LDT].limit", regs[6].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[TR].entry.entry[0]", regs[7].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[TR].entry.entry[1]", regs[7].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[TR].base", regs[7].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[TR].base", regs[7].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[TR].limit", regs[7].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[GDT].entry.entry[0]", regs[8].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[GDT].entry.entry[1]", regs[8].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[GDT].base", regs[8].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[GDT].base", regs[8].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[GDT].limit", regs[8].limit, DATA_TYPE_UINT32_T);

	STATE_DECL("seg[IDT].entry.entry[0]", regs[9].entry.entry[0], DATA_TYPE_UINT64_T);
#if defined CONFIG_CPU_LM_SUPPORT && CONFIG_CPU_LM_SUPPORT
	STATE_DECL("seg[IDT].entry.entry[1]", regs[9].entry.entry[1], DATA_TYPE_UINT64_T);
	STATE_DECL("seg[IDT].base", regs[9].base, DATA_TYPE_UINT64_T);
#else
	STATE_DECL("seg[IDT].base", regs[9].base, DATA_TYPE_UINT32_T);
#endif
	STATE_DECL("seg[IDT].limit", regs[9].limit, DATA_TYPE_UINT32_T);
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}
#endif /* CONFIG_INSPECTION */

#endif /* BEHAVIOR */

#undef CONFIG_SEGMENT_LIMIT_CHECK
