/*
 * $Id: chip_intel_8254.c,v 1.24 2009-06-03 11:34:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <inttypes.h> 
#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"
#include "glue-main.h"

#include "chip_intel_8254.h"

struct cpssp {
	/*
	 * Config
	 */

	/*
	 * Signals
	 */
	struct sig_boolean_or *port_out0;
	struct sig_boolean_or *port_out1;
	struct sig_boolean_or *port_out2;	

	/*
	 * State
	 */
	unsigned int state_power;

#define STATE

/* PIT */
#define NAME		chip_intel_8254_pit
#define NAME_(x)	chip_intel_8254_pit_ ## x
#define SNAME		"chip_intel_8254_pit"
#include "arch_pit.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef STATE
};

extern inline void
chip_intel_8254_pit_out_val_set(
	struct cpssp *cpssp,
	unsigned int ch,
	unsigned int val
)
{
	if (ch == 0) {
		sig_boolean_or_set(cpssp->port_out0, cpssp, val);
	} else if (ch == 1) {
		sig_boolean_or_set(cpssp->port_out1, cpssp, val);
	} else if (ch == 2) {
		sig_boolean_or_set(cpssp->port_out2, cpssp, val);
	} else {
		assert(0);
	}
}


static inline void
chip_intel_8254_pit_out_period_set(
	struct cpssp *cpssp,
	unsigned int ch,
	unsigned long long val
)
{
}

#define BEHAVIOR

#define NAME		chip_intel_8254_pit
#define NAME_(x)	chip_intel_8254_pit_ ## x
#define SNAME		"chip_intel_8254_pit"
#include "arch_pit.c"
#undef SNAME
#undef NAME_
#undef NAME

#undef BEHAVIOR

/* Not used. Just to use function chip_intel_8254_pit_timer_get. */
void
chip_intel_8254_dummy(void)
{
	chip_intel_8254_pit_timer_get((struct cpssp *) 0, 2);
}

static void
chip_intel_8254_power_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	cpssp->state_power = val;
}

static void
chip_intel_8254_n_reset_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_intel_8254_pit_reset(cpssp);
}

static void
chip_intel_8254_gate0_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	
	chip_intel_8254_pit_gate_set(cpssp, 0, val);
}

static void
chip_intel_8254_gate1_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	
	chip_intel_8254_pit_gate_set(cpssp, 1, val);
}

static void
chip_intel_8254_gate2_set(void *_css, unsigned int val)
{
	struct cpssp *cpssp = (struct cpssp *) _css;
	
	chip_intel_8254_pit_gate_set(cpssp, 2, val);
}
	
static int
chip_intel_8254_inb(void *_css, uint8_t *valp, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_intel_8254_pit_inb(cpssp, valp, port & 1);

	return 0;
}

static int
chip_intel_8254_outb(void *_css, uint8_t valp, unsigned long port)
{
	struct cpssp *cpssp = (struct cpssp *) _css;

	chip_intel_8254_pit_outb(cpssp, valp, port & 1);

	return 0;
}

void *
chip_intel_8254_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_power,
	struct sig_boolean *port_reset_hash_,
	struct sig_cs *port_cs,
	struct sig_isa_bus_main *port_bus,
	struct sig_boolean *port_gate0,
	struct sig_boolean *port_gate1,
	struct sig_boolean_or *port_gate2,
	struct sig_boolean_or *port_out0,
	struct sig_boolean_or *port_out1,
	struct sig_boolean_or *port_out2
)
{
	static const struct sig_boolean_funcs power_funcs = {
		.set = chip_intel_8254_power_set,
	};
	static const struct sig_boolean_funcs reset_hash__funcs = {
		.set = chip_intel_8254_n_reset_set,
	};
	static const struct sig_cs_funcs cs_funcs = {
		.readb = chip_intel_8254_inb,
		.writeb = chip_intel_8254_outb,
	};	
	static const struct sig_boolean_funcs gate0_funcs = {
		.set = chip_intel_8254_gate0_set,
	};
	static const struct sig_boolean_funcs gate1_funcs = {
		.set = chip_intel_8254_gate1_set,
	};
	static const struct sig_boolean_or_funcs gate2_funcs = {
		.set = chip_intel_8254_gate2_set,
	};
	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	chip_intel_8254_pit_init(cpssp);

	/* Out */
	cpssp->port_out0 = port_out0;
	sig_boolean_or_connect_out(port_out0, cpssp, 0);

	cpssp->port_out1 = port_out1;
	sig_boolean_or_connect_out(port_out1, cpssp, 0);

	cpssp->port_out2 = port_out2;
	sig_boolean_or_connect_out(port_out2, cpssp, 0);

	/* Call */
	sig_cs_connect(port_cs, cpssp, &cs_funcs);

	/* In */
	cpssp->state_power = 0;
	sig_boolean_connect_in(port_power, cpssp, &power_funcs);

	sig_boolean_connect_in(port_reset_hash_, cpssp, &reset_hash__funcs);

	sig_boolean_connect_in(port_gate0, cpssp, &gate0_funcs);

	sig_boolean_connect_in(port_gate1, cpssp, &gate1_funcs);

	sig_boolean_or_connect_in(port_gate2, cpssp, &gate2_funcs);

	return cpssp;
}

void
chip_intel_8254_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	free(cpssp);
}
