#!/bin/sh

set -e

WORK=/export/home.local/potyra/work

LIST=tests.list.$(hostname | sed -e s'/faui//')

if [ -e "$LIST" ]; then
	echo "Single experiment"
	exit 0
fi


make copy_files
for i in $LIST.*; do
	INSTANCE=$(echo $i | cut -d. -f4-)
	mkdir run-$INSTANCE
	cp $i \
		Makefile \
		run-tests.sh \
		gen_vhdl_faults.sh \
		test_bench.vhdl \
		simulation.setup \
		\
		run-$INSTANCE
	cd run-$INSTANCE
	cp $LIST.$INSTANCE $LIST
	echo "Created $LIST from $LIST.$INSTANCE"
	sed -e "s/image /image ..\\//" simulation.setup > simulation.setup.new
	sed -e "s/test-fi/..\\/test-fi/" \
		-e "s/install-Debian/..\\/install-Debian/" \
		Makefile >> Makefile.new
	sed -e "s/test-fi/..\\/test-fi/" gen_vhdl_faults.sh \
		> gen_vhdl_faults.sh.new
	mv simulation.setup.new simulation.setup
	mv Makefile.new Makefile
	mv gen_vhdl_faults.sh.new gen_vhdl_faults.sh
	chmod ugo+x gen_vhdl_faults.sh
	cd ..
done
