/******************************************************************************

	relay.h -- relayed connections
	Copyright (C) 2004  Wessel Dankers <wsl@uvt.nl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	$Id: relay.h 23144 2007-12-21 15:36:48Z wsl $
	$URL: https://infix.uvt.nl/its-id/trunk/sources/fair-0.5.1/src/relay.h $

******************************************************************************/

#ifndef _FAIR_RELAY_H
#define _FAIR_RELAY_H

#include <sys/types.h>
#include <sys/socket.h>

#include "fair.h"
#include "fd.h"
#include "conn.h"
#include "address.h"
#include "fdcopy.h"
#include "chrono.h"

typedef struct relay {
        unsigned long long int id;
        fd_t *src, *dst;
        fdcopy_t *from, *to;
        address_t *addr;
        chrono_t *cr;
        connector_t *cn;
        size_t attempts;
        address_string_t str_from;
        address_string_t str_to;
} relay_t;

extern unsigned int relay_count;
extern relay_t *relay_new(int, const struct sockaddr *, socklen_t);

#endif
