/*
 *
 * (C) 1998 Murat Deligonul
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  

 *
 */

#ifndef __IDENTD_H
#define __IDENTD_H

#include "linkedlist.h"
#include "ilist.h"

struct conn 
{
    char input_buff[100];
    int fd, bytes_in;
    time_t time;             /* Time connection was established */
};
    

static int  listen(unsigned short);
static int  listen_unix(const char * );
static int  accept_connection(int);
static int  accept_unix_connection(int);
static int  service(conn * );
static int  service_unix(conn *);
static int  reply(conn *);
static int  start_server(time_t);
static bool parse_cmdline(int, char **);
static void close_conn(conn *);
static void usage();
extern "C" void sighandler(int);

#endif
