;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
debug_strout:	or	si,si
		jz	debug_strout9
		cld
debug_strloop:	lodsb
		or	al,al
		jz	debug_strout8
		call	debug_tty_out
		jmp	short debug_strloop
debug_strout8:	call	debug_CRLF
debug_strout9:	ret

debug_hex2:	push	ax
		mov	cl,4
		shr	al,cl
		call	debug_hex1
		pop	ax
debug_hex1:	and	al,0x0F
		add	al,0x30
		cmp	al,0x3A
		jc	debug_tty_out
		add	al,7
debug_tty_out:	mov	ah,14
		int	VIDEOBIOS
		ret

debug_CRLF:	mov	al,CR
		call	debug_tty_out
		mov	al,LF
		jmp	short debug_tty_out

debug_SPC:	mov	al,' '
		call	debug_tty_out
		ret

debug_dump:	cld
debug_dump1:	push	cx
		mov	cx,16
		push	si
debug_dmpx:	lodsb
		push	cx
		call	debug_hex2
		pop	cx
		mov	al,' '
		call	debug_tty_out
		loop	debug_dmpx
		call	debug_SPC
		call	debug_SPC
		pop	si
		mov	cx,16
debug_dmpa:	lodsb
		cmp	al,' '
		jl	debug_ascpad
		cmp	al,'~'
		jg	debug_ascpad
		jmp	short debug_ascii
debug_ascpad:	mov	al,'.'
debug_ascii:	call	debug_tty_out
debug_dmpanxt:	loop	debug_dmpa
		call	debug_CRLF
		pop	cx
		loop	debug_dump1
		call	debug_CRLF
		ret

debug_fout:	pusha
		push	bx
		mov	ax,[debug_seq]
		push	ax
		call	byte2hex
		xchg	ah,al
		mov	[debug_outseq],ax
		pop	ax
		inc	ax
		mov	[debug_seq],ax
		;;;
		mov	dx,debug_fname		; filename
		xor	cx,cx			; file-mode
		mov	ah,0x3c			; create
		int	0x21
		jc	debug_fout9
		;;;
		mov	bx,ax
		or	bp,bp
		jz	debug_wrsec
		mov	dx,bp
		mov	cx,16
		call	debug_fwrite
debug_wrsec:	pop	dx			; buffer
		mov	cx,512			; length
		call	debug_fwrite
debug_fclose:	mov	ah,0x3e			; close
		int	0x21
debug_fout9:	popa
		ret

debug_fwrite:	push	bx
		mov	ah,0x40			; write
		int	0x21
		pop	bx
		ret

debug_fname:	db	"dout.0"
debug_outseq:	db	"xx",0
debug_seq:	dw	0
