'''
expEYES program
Author  : Ajith Kumar B.P, bpajith@gmail.com
License : GNU GPL version 3
'''
from Tkinter import *
import expeyes.eyes as eyes, expeyes.eyeplot as eyeplot


def get_tof():
	t = p.pulse2rtime(1,2)
	if t > 0:
		res.config(text = '%8.6f sec'%(t*1.0e-6))
	else:
		res.config(text = 'Error..')

p = eyes.open()
p.disable_actions()

root = Tk()
cf = Frame(root)
cf.pack(side=TOP,  fill = BOTH, expand = 1)

Label(cf,text = 'Connect Transmitter from OD1 to Ground').pack()
Label(cf,text = 'Connect Receiver from T15 to Ground').pack()
Label(cf,text = 'Keep them facing each other, at a known distance').pack()

b1 = Button(cf, text = 'Measure Time of Travel', command = get_tof)
b1.pack(side = TOP, anchor = N)
res = Label(cf, text = '')
res.pack(side = TOP, anchor = N)
b5 = Button(cf, text = 'QUIT', command = sys.exit)
b5.pack(side = TOP, anchor = N)

eyeplot.pop_image('pics/ultra-sound.png', 'Velocity of Sound, 40kHz')
root.title('Velocity of Sound')
root.mainloop()

