/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: fullengine.h
 */

#ifndef EVMS_FULLENGINE_H_INCLUDED
#define EVMS_FULLENGINE_H_INCLUDED 1

#include <dlist.h>

#include <frontend.h>
#include <plugin.h>

#define LOG_CRITICAL(msg, args...)              engine_write_log_entry(CRITICAL, "%s: " msg, __FUNCTION__ , ## args)
#define LOG_SERIOUS(msg, args...)               engine_write_log_entry(SERIOUS,  "%s: " msg, __FUNCTION__ , ## args)
#define LOG_ERROR(msg, args...)                 engine_write_log_entry(ERROR,    "%s: " msg, __FUNCTION__ , ## args)
#define LOG_WARNING(msg, args...)               engine_write_log_entry(WARNING,  "%s: " msg, __FUNCTION__ , ## args)
#define LOG_DEFAULT(msg, args...)               engine_write_log_entry(DEFAULT,  "%s: " msg, __FUNCTION__ , ## args)
#define LOG_DETAILS(msg, args...)               engine_write_log_entry(DETAILS,  "%s: " msg, __FUNCTION__ , ## args)
#define LOG_DEBUG(msg, args...)                 engine_write_log_entry(DEBUG,    "%s: " msg, __FUNCTION__ , ## args)

#define LOG_PROC_ENTRY()                        engine_write_log_entry(ENTRY_EXIT, "%s: Enter.\n", __FUNCTION__);

#define LOG_PROC_EXIT_INT(rc)                   engine_write_log_entry(ENTRY_EXIT, "%s: Exit.  Return value is %d.\n", __FUNCTION__, rc);
#define LOG_PROC_EXIT_UINT(rc)                  engine_write_log_entry(ENTRY_EXIT, "%s: Exit.  Return value is %u (0x%08x).\n", __FUNCTION__, rc, rc);
#define LOG_PROC_EXIT_PTR(ptr)                  engine_write_log_entry(ENTRY_EXIT, "%s: Exit.  Returned pointer is %p.\n", __FUNCTION__, ptr);
#define LOG_PROC_EXIT_BOOLEAN(result)           engine_write_log_entry(ENTRY_EXIT, "%s: Exit.  Result is %s.\n", __FUNCTION__, result ? "TRUE" : "FALSE");
#define LOG_PROC_EXIT_BOOLEAN_INT(result, rc)   engine_write_log_entry(ENTRY_EXIT, "%s: Exit.  Result is %s.  Return value is %d.\n", __FUNCTION__, result ? "TRUE" : "FALSE",rc);
#define LOG_PROC_EXIT_VOID()                    engine_write_log_entry(ENTRY_EXIT, "%s: Exit.\n", __FUNCTION__);

#define FEATURE_HEADER_SECTORS ((sizeof(evms_feature_header_t) + EVMS_VSECTOR_SIZE - 1) / EVMS_VSECTOR_SIZE)
#define EVMS_VOLUME_FEATURE_ID (SetPluginID(IBM_OEM_ID, EVMS_FEATURE, 0))

#define IS_EVMS_VOLUME(volume) ((volume->object->feature_header != NULL) || (volume->object->object_type == EVMS_OBJECT))

/* The name_list_entry_t structure is used to keep the registry of names. */
typedef struct name_list_entry_s {
    struct name_list_entry_s * next;
    char                     * name;
} name_list_entry_t;


#endif
