/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: thing.h
 */

#define SL_ICON_COLUMN        0
#define SL_SIZE_COLUMN        1
#define SL_MINMAX_SIZE_COLUMN 2
#define SL_DESC_COLUMN        3

/*
 * The following pieces of information are used in obtaining
 * additional extended information on a specific descriptor
 * that provides it.
 */

typedef struct field_details_s {
    gchar               *name;              /* the field descriptor name */
    gchar               *title;             /* the field title */
} field_details_t;
 
gint add_thing_to_selection_list (GtkCList *clist, object_handle_t handle, gboolean mark_selected);

void add_thing_as_selected_list_item (GtkCList *clist, gpointer handle);

GtkWidget* create_thing_details_window (object_handle_t handle, extended_info_array_t *extended_info,
                                        gchar *field_title);

void on_display_thing_details_menu_item_activate (GtkMenuItem *menuitem, gpointer handle);

void on_display_more_thing_details_button_clicked (GtkButton *button, field_details_t *field);

inline void bind_object_handle_to_toplevel_widget (GtkWidget *widget, object_handle_t object);

inline object_handle_t retrieve_object_handle_from_toplevel_widget (GtkWidget *widget);
