/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: remove_duplicates.c
 */

#ifndef _LVM_HELP_REMOVE_DUPLICATES_
#define _LVM_HELP_REMOVE_DUPLICATES_ 1

#include "translate_name.c"

/* Function: remove_duplicates
 *
 *	Copy the input array of strings to the output array, removing any
 *	duplicates in the process. This is intended to be used with the
 *	command line arguments, so we will just be copying pointers, not
 *	copying the whole strings. Return the number of duplicates found.
 *
 *	Obviously, the size of the output array must be equal to or greater
 *	than the input array.
 */
int remove_duplicates(	char	** input,
			char	** output,
			int	count )
{
	int duplicate = 0;
	int duplicates = 0;
	int i, j, k;

	// For each string in the input array, compare it with all strings
	// before it in the array. If no match is found, copy it to the
	// next spot in the output array.
	for ( i = 0, k = 0; i < count; i++ ) {
		for ( j = 0; j < i; j++ ) {
			if ( ! strcmp(input[i], input[j]) ) {
				duplicate = 1;
				duplicates++;
				printf("%s -- %s specified multiple times.\n", cmd, input[i]);
				break;
			}
		}
		if ( ! duplicate ) {
//			output[k++] = translate_dev_name(input[i]);
			output[k++] = input[i];
		}
		duplicate = 0;
	}

	return duplicates;
}

#endif

