/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: is_in_container.c
 */ 

#ifndef _LVM_HELP_IS_IN_CONTAINER_
#define _LVM_HELP_IS_IN_CONTAINER_ 1

/* Function: is_in_container
 *
 *	Verify that the specified segment is in the specified container.
 *	Return non-zero for success, 0 if not in container or error.
 */
int is_in_container(	object_handle_t	segment,
			object_handle_t	container )
{
	handle_object_info_t * segment_info;
	int rc;

	if ( (rc = evms_get_info(segment, &segment_info)) ) {
		printf("%s -- Error getting segment info (%d)\n", cmd, rc);
		return FALSE;
	}

	rc = ( segment_info->info.segment.consuming_container == container );

	evms_free(segment_info);
	return rc;
}

#endif

