/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: get_segment_handle.c
 */

#ifndef _LVM_HELP_GET_SEGMENT_HANDLE_
#define _LVM_HELP_GET_SEGMENT_HANDLE_ 1

#include "translate_name.c"

/* Function: get_segment_handle
 *
 *	Find the Engine handle for the specified name. Look through all disks,
 *	segments, and regions.
 */
int get_segment_handle(	char		* name,
			object_handle_t	* handle )
{
	int rc;

	name = translate_dev_name(name);

	if ( opts.verbose ) {
		printf("%s -- Searching for segment %s\n", cmd, name);
	}

	if ( (rc = evms_get_object_handle_for_name(DISK, name, handle)) ) {
		if ( (rc = evms_get_object_handle_for_name(SEGMENT, name, handle)) ) {
			if ( (rc = evms_get_object_handle_for_name(REGION, name, handle)) ) {
				printf("%s -- Could not find handle for segment %s\n", cmd, name);
				*handle = 0;
				return rc;
			}
		}
	}

	if ( opts.verbose ) {
		printf("%s -- Found segment %s at handle %u\n", cmd, name, *handle);
	}

	return 0;
}

#endif

