/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: lvmregmgr
 * File: lvm_io.h
 */ 

#ifndef _LVM_IO_H_
#define _LVM_IO_H_ 1

#include <byteswap.h>


#define READ( segment, lsn, count, buf )  ((segment->plugin->functions.plugin)->read(  segment, lsn, count, buf ))
#define WRITE(segment, lsn, count, buf )  ((segment->plugin->functions.plugin)->write( segment, lsn, count, buf ))
#define KILL_SECTORS(segment, lsn, count) ((segment->plugin->functions.plugin)->add_sectors_to_kill_list( segment, lsn, count ))

// Functions exported from lvm_io.c
extern inline u_int64_t bytes_to_sectors( u_int64_t bytes );
extern inline u_int64_t sectors_to_bytes( u_int64_t sectors );
extern inline long lvm_log2( long arg );

extern int lvm_read_pv(	storage_object_t	* segment,
			pv_disk_t		** pv );
extern int lvm_write_pv( lvm_physical_volume_t * pv_entry );
extern int lvm_erase_pv( storage_object_t * object );
extern int lvm_read_vg(	storage_object_t	* segment,
			pv_disk_t		* pv,
			vg_disk_t		** vg );
extern int lvm_write_vg( lvm_physical_volume_t * pv_entry );
extern int lvm_read_uuid_list(	storage_object_t	* segment,
				pv_disk_t		* pv,
				lvm_volume_group_t	* group );
extern int lvm_write_uuid_list( lvm_physical_volume_t * pv_entry );
extern int lvm_endian_convert_lvs( lvm_volume_group_t * group );
extern int lvm_read_lv_array( lvm_volume_group_t * group );
extern int lvm_write_lv_array( lvm_physical_volume_t * pv_entry );
extern int lvm_read_pe_map( lvm_physical_volume_t * pv_entry );
extern int lvm_write_pe_map( lvm_physical_volume_t * pv_entry );
extern int lvm_erase_group_metadata( lvm_physical_volume_t * pv_entry );
extern int lvm_zero_first_1k( lvm_logical_volume_t * volume );
extern int lvm_remap_sector(	lvm_logical_volume_t	* volume,
				lsn_t			org_sector,
				sector_count_t		size,
				lsn_t			* new_sector,
				sector_count_t		* new_size,
				lvm_physical_volume_t	** pv_entry );

#endif

