%token ACCOUNT END_ACCOUNT

%{
	#include <gtk/gtk.h>
	#include <stdio.h>
	#include <stdlib.h>

	#include "globals.h"
	#include "account.h"
	#include "value_pair.h"
	#include "service.h"

	extern void save_account_info(char *service, GList *pairs);
	extern int Line;
	#define accounterror(error) printf("Parse error on line %d: %s\n", Line, error );
	extern int accountlex();

%}

%union {
	GList * vals;
	value_pair * val;
	gchar * string;
	eb_local_account * acnt;
}

%token <string> IDENTIFIER
%token <string> STRING
%type <vals> account_list
%type <acnt> account
%type <vals> value_list
%type <val> key_pair
%%

start:
	account_list { accounts = $1; }
;

account_list:
	 	account account_list	{ $$ = g_list_append( $2, $1 ); }
	 |	EPSILON { $$ = 0; }

;

account:
	'<' ACCOUNT IDENTIFIER '>' value_list '<' END_ACCOUNT '>' 
	{
		{
			int id = get_service_id($3);

			$$ = eb_services[id].sc->read_local_account_config($5);
			$$->service_id = id;
			save_account_info($3, $5);
			/*eb_services[id].sc->login($$);*/
			/* value_pair_free($5); */
			g_free($3);
		}
	}
					
;

value_list:
		key_pair value_list { $$ = g_list_append( $2, $1 ); }
	|	EPSILON { $$ = 0; }

;

key_pair:
		IDENTIFIER '=' STRING
		{
			{
				value_pair * vp = g_new0( value_pair, 1 );
				strcpy( vp->key, $1 );
				strcpy( vp->value, $3 );

				free($1);
				free($3);
				$$ = vp;
			}
		}
;

EPSILON : ;
	


