/* msn_core.h  - prototypes for msn_core.c */
#ifndef MSN_CORE_H
#define MSN_CORE_H

class llist_data // inherit it
{};

class llist
{
  public:
  llist_data * data;
  llist * next;
  llist * prev;

  llist() { data=NULL; next=NULL; prev=NULL; }
  ~llist() { if(data!=NULL) { delete data; } if(next!=NULL) { delete next; } }
};

class char_data : public llist_data
{
  public:
  char * c;
  char_data(char * tc) { c=tc; }
  ~char_data() { if(c!=NULL) { delete c; } }
};

class userdata : public llist_data
{
  public:
  char * username;
  char * friendlyname;
  userdata() { username=friendlyname=NULL; }
  ~userdata() { if(username!=NULL) { delete username; } if(friendlyname!=NULL) { delete friendlyname; } }
};

class authdata
{};

class msnconn : public llist_data
{
  public:
  int sock; // Socket (durr...)
  int type; // one of the #defines below
  int ready;
  llist * users; // Users in this session - only for SB connections
  llist * callbacks;
  authdata * auth;

  msnconn() { users=NULL; callbacks=NULL; }
  ~msnconn()
  {
    if(users!=NULL) { delete users; }
    if(callbacks!=NULL) { delete callbacks; }
  }
};

#define CONN_NS 1 // Notification Server (also Dispatch, as it does exactly the same thing)
#define CONN_SB 2 // Switchboard Server

class authdata_NS : public authdata
{
  public:
  char * username;
  char * password;

  authdata_NS() { username=password=NULL; }
  ~authdata_NS() { if(username!=NULL) { delete username; delete password; } }
};

class authdata_SB : public authdata
{
  public:
  char * username;
  char * sessionID;
  char * cookie;
  char * rcpt;// recipient of the below
  char * msg; // to be sent as soon as connection is complete and someone joins
  void * tag; // for SB connections without an initial message

  authdata_SB() { username=sessionID=cookie=NULL; }
  ~authdata_SB()
  { if(username!=NULL) { delete username; delete sessionID; delete cookie; } }
};

class callback_data
{};

class callback : public llist_data
{
  public:
  int trid;
  void (*func)(struct msnconn * conn, int trid, char ** args, int numargs, callback_data * data);
  callback_data * data; // just gets passed
};

extern llist * connections;
extern msnconn * mainconn;
extern int next_trid;
extern char buf[]; // Used for anything temporary

void msn_init(msnconn * conn, char * username, char * password);

/*
        int msn_connect(msnconn * conn, char * server, int port);

        Purpose:        Initiates a connection to the MSN server
        Arguments:
          conn          Connection to connect with
          server        Server to connect to
          port          Port   "    "     "
        Return value:   None
*/
void msn_connect(msnconn * conn, char * server, int port);

void msn_invite_user(msnconn * conn, char * rcpt);

void msn_send_IM(msnconn * conn, char * rcpt, char * msg);

void msn_send_typing(msnconn * conn);

void msn_sync_lists(msnconn * conn, int version);

#define LST_FL  1
#define LST_RL  2
#define LST_AL  4
#define LST_BL  8

#define COMPLETE_BLP 16
#define COMPLETE_GTC 32

// Intermediate steps in synchronisation
class syncinfo : public callback_data
{
  public:

  llist * fl;
  llist * rl;
  llist * al;
  llist * bl;

  unsigned int complete;

  int serial;

  char blp;
  char gtc;

  syncinfo() { blp='A'; gtc='A'; fl=rl=al=bl=NULL; complete=0; serial=0; }
  ~syncinfo()
  {
    if(fl!=NULL) { delete fl; }
    if(rl!=NULL) { delete rl; }
    if(al!=NULL) { delete al; }
    if(bl!=NULL) { delete bl; }
  }
};

void msn_set_friendlyname(msnconn * conn, char * friendlyname);

void msn_sync_lists(msnconn * conn, int version);
void msn_add_to_list(msnconn * conn, char * list, char * user);
void msn_del_from_list(msnconn * conn, char * list, char * user);
void msn_set_GTC(msnconn * conn, char c);
void msn_set_BLP(msnconn * conn, char c);
void msn_syncdata(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);
void msn_check_rl(msnconn * conn, syncinfo * info);

void msn_connect_and_send(msnconn * nsconn, char * dest, char * msg);

void msn_set_state(msnconn * conn, char * state);

// Intermediate steps in switchboard connection:
class conninfo_SB : public callback_data
{
  public:
  authdata_SB * auth;
};

void msn_new_SB(msnconn * nsconn, void * tag);
void msn_request_SB(msnconn * nsconn, char * rcpt, char * msg, void * tag);

void msn_SBconn_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);
void msn_SBconn_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);

void msn_handle_incoming(int sock);

void msn_handle_close(int sock);

void msn_handle_default(msnconn * conn, char ** args, int numargs);

void msn_handle_MSG(msnconn * conn, char ** args, int numargs);

void msn_handle_NAK(msnconn * conn, char ** args, int numargs);

void msn_handle_JOI(msnconn * conn, char ** args, int numargs);

void msn_handle_BYE(msnconn * conn, char ** args, int numargs);

void msn_handle_RNG(msnconn * conn, char ** args, int numargs);

void msn_handle_statechange(msnconn * conn, char ** args, int numargs);

void msn_handle_ADD(msnconn * conn, char ** args, int numargs);

void msn_handle_REM(msnconn * conn, char ** args, int numargs);

void msn_handle_BLP(msnconn * conn, char ** args, int numargs);

void msn_handle_GTC(msnconn * conn, char ** args, int numargs);

void msn_handle_REA(msnconn * conn, char ** args, int numargs);

void msn_handle_OUT(msnconn * conn, char ** args, int numargs);



// Intermediate steps in connection:
class connectinfo : public callback_data
{
  public:
  char * username;
  char * password;
  connectinfo() { username=password=NULL; }
  ~connectinfo()
  { if(username!=NULL) { delete username; } if(password!=NULL) { delete password; } }
};

void msn_connect_2(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);
void msn_connect_3(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);
void msn_connect_4(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);

// Connecting to switchboards:
void msn_SB_ans(msnconn * conn, int trid, char ** args, int numargs, callback_data * data);

#endif // MSN_CORE_H
