/*
 * server.h: header for server.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: server.h,v 1.7 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _SERVER_H_
#define _SERVER_H_
  
/* config.h is needed to get COMPAT_27 */
#include "irc_std.h"
#include "config.h"
#include "whois.h" /* for WhoisQueue */

struct notify_stru;

/*
 * type definition to distinguish different
 * server versions
 */
#ifdef COMPAT_27
#define Server2_7	0
#endif
#define Server2_8	1
#define Server2_9	2
#define Server2_10	3
#define Server_u2_8	4
#define Server_u2_9	5
#define Server_u2_10	6
#define Server_u3_0	7

/* Server: a structure for the server_list */
typedef	struct
{
	char	*name;			/* the name of the server */
	char	*itsname;		/* the server's idea of its name */
	char	*password;		/* password for that server */
	int	port;			/* port number on that server */
	char	*nickname;		/* nickname for this server */
	char	*away;			/* away message for this server */
	int	operator;		/* true if operator */
	int	version;		/* the version of the server -
					 * defined above */
	int	server2_8;		/* defined if we get an 001 numeric */
	char	*version_string;	/* what is says */
	int	whois;			/* true if server sends numeric 318 */
	int	flags;			/* Various flags */
	char	umode[27];		/* User mode */
	int	connected;		/* true if connection is assured */
	int	write;			/* write descriptor */
	int	read;			/* read descriptior */
	pid_t	pid;			/* process id of server */
	int	eof;			/* eof flag for server */
	int	motd;			/* motd flag (used in notice.c) */
	int	sent;			/* set if something has been sent,
					 * used for redirect */
	char	*buffer;		/* buffer of what dgets() doesn't get */
	WhoisQueue	*WQ_head;	/* WHOIS Queue head */
	WhoisQueue	*WQ_tail;	/* WHOIS Queue tail */
	WhoisStuff	whois_stuff;	/* Whois Queue current collection buffer */
	struct in_addr local_addr;      /* ip address of this connection */
	struct notify_stru *notify_list;	/* Notify list for this server */
}	Server;

typedef	unsigned	short	ServerType;

extern	void	add_to_server_list _((char *, int, char *, char *, int));
extern	void	build_server_list _((char *));
extern	int	connect_to_server _((char *, int, int));
extern	int	connect_to_server_by_refnum _((int, int));
extern	void	get_connected _((int));
extern	int	read_server_file _((void));
extern	void	display_server_list _((void));
extern	int	server_list_size _((void));
extern	void	send_to_server _((const char *, ...));

extern	WhoisStuff	*get_server_whois_stuff _((int));
extern	WhoisQueue	*get_server_qhead _((int));
extern	WhoisQueue	*get_server_qtail _((int));

extern	int	attempting_to_connect;
extern	int	number_of_servers;
extern	int	connected_to_server;
extern	int	never_connected;
extern	int	using_server_process;
extern	int	primary_server;
extern	int	from_server;
extern	int	last_server;
extern	char	*connect_next_nick;
extern	int	parsing_server_index;

extern	void	server _((char *, char *, char *));
extern	char	*get_server_nickname _((int));
extern	char	*get_server_name _((int));
extern	char	*get_server_itsname _((int));
extern	void	set_server_flag _((int, int, int));
extern	int	find_in_server_list _((char *, int));
extern	char	*create_server_list _((void));
extern	void	set_server_motd _((int, int));
extern	int	get_server_motd _((int));
extern	int	get_server_operator _((int));
extern	int	get_server_version _((int));
extern	void	close_server _((int, char *));
extern	void	MarkAllAway _((char *, char *, char *));
extern	int	is_server_connected _((int));
extern	void	flush_server _((void));
extern	void	set_server2_8 _((int, int));
extern	int	get_server2_8 _((int));
extern	int	get_server_flag _((int, int));
extern	void	set_server_operator _((int, int));
extern	void	server_is_connected _((int, int));
extern	int	parse_server_index _((char *));
extern	void	parse_server_info _((char *, char **, char **, char **));
extern	void	set_server_bits _((fd_set *));
extern	void	set_server_itsname _((int, char *));
extern	void	set_server_version _((int, int));
extern	int	is_server_open _((int));
extern	int	get_server_port _((int));
extern	char	*set_server_password _((int, char *));
extern	void	set_server_nickname _((int, char *));
extern	void	set_server_qhead _((int, WhoisQueue *));
extern	void	set_server_qtail _((int, WhoisQueue *));
extern	void	close_all_server _((void));
extern	void	disconnectcmd _((char *, char *, char *));
extern	char 	*get_umode _((int));
extern	int	find_server_refnum _((char *, char **));

/* server_list: the list of servers that the user can connect to,etc */
extern	Server	*server_list;
extern	const char	*umodes;

/*
 * Each server has a "flags" member, which is a long.
 * That means it probably has at least 32 bits in it.
 * 26 of those bits are reserved for the 26 possible
 * user modes, and the 32nd bit is reserved for the
 * current status of the connection.
 */
#define USER_MODES	0x0001

/* These are stricly for informational purposes.  DO NOT USE THEM! */
#if 0
#define USER_MODE_A	USER_MODES << 0
#define USER_MODE_B	USER_MODES << 1
#define	USER_MODE_C	USER_MODES << 2 
#define	USER_MODE_D	USER_MODES << 3 
#define USER_MODE_E	USER_MODES << 4 
#define USER_MODE_F	USER_MODES << 5 
#define USER_MODE_G	USER_MODES << 6 
#define USER_MODE_H	USER_MODES << 7 
#define	USER_MODE_I	USER_MODES << 8 
#define	USER_MODE_J	USER_MODES << 9 
#define USER_MODE_K	USER_MODES << 10 
#define USER_MODE_L	USER_MODES << 11 
#define USER_MODE_M	USER_MODES << 12 
#define USER_MODE_N	USER_MODES << 13 
#define USER_MODE_O	USER_MODES << 14 
#define USER_MODE_P	USER_MODES << 15 
#define USER_MODE_Q	USER_MODES << 16 
#define USER_MODE_R	USER_MODES << 17 
#define	USER_MODE_S	USER_MODES << 18 
#define USER_MODE_T	USER_MODES << 19 
#define USER_MODE_U	USER_MODES << 20 
#define USER_MODE_V	USER_MODES << 21 
#define	USER_MODE_W	USER_MODES << 22 
#define	USER_MODE_X	USER_MODES << 23 
#define	USER_MODE_Y	USER_MODES << 24 
#define	USER_MODE_Z	USER_MODES << 25 
#endif

#define CLOSING_SERVER	USER_MODES << 31

#endif /* _SERVER_H_ */
