#include <glib.h>
#include "entity.h"


static void
system_elements_render (ENode * node)
{
    GSList *list;
    GSList *tmp;
    ENode *root;
    ENode *dyna;

    /* This gets all the currently loaded elements */
    list = element_list ();

    tmp = list;
    while (tmp) {
	EBuf *element = tmp->data;

	enode_attrib_quiet (node, element->str, ebuf_new_with_true ());

	tmp = tmp->next;
    }

    g_slist_free (list);

    /* Now we look at dynaloaded elements, and see * what we can find there. */
    root = enode_root_node ();
    dyna = enode_child (root, "dynaloaders");

    if (dyna) {
	list = enode_children (dyna, "dynaload-element");

	tmp = list;
	while (tmp) {
	    ENode *n = tmp->data;
	    gchar *val;

	    val = enode_attrib_str (n, "tag", NULL);
	    if (val) {
		enode_attrib_quiet (node, val, ebuf_new_with_true ());
	    }

	    tmp = tmp->next;
	}

	g_slist_free (list);
    }
}

void
system_elements_renderer_register (void)
{
    Element *element;

    element = g_new0 (Element, 1);
    element->render_func = system_elements_render;
    element->tag = "system-elements";
    element->description =
	"A list of supported system elements.  Each supported element will be set as an attribute of this node, with a value of true.";
    element_register (element);
}
