#!/usr/bin/env entity

<object default-lang="javascript">

  <!-- Include our ship, bullet, badguy renderers -->
  <include file="omega-race-tags.e"/>

  <system-elements/>

  <window name="main" title="Omega Race" ondelete="entity:quit"
   onbuttonpress="button_press_event" onkeypress="key_press_event"
   onkeyrelease="key_release_event" key-auto-repeat="false">
    <valign name="main" expand="true" width="640" height="480">
      <glarea expand="true" name="main">

        <!-- Make the border first -->
	<gl-line width="2" x1="0" y1="0" x2="100" y2="0" color="#ffffff"/>
	<gl-line width="2" x1="100" y1="0" x2="100" y2="100" color="#ffffff"/>
	<gl-line width="2" x1="100" y1="100" x2="0" y2="100" color="#ffffff"/>
	<gl-line width="2" x1="0" y1="100" x2="0" y2="0" color="#ffffff"/>

	<!-- Inner box -->
	<gl-line width="2" x1="25" y1="35" x2="75" y2="35" color="#ffffff"/>
	<gl-line width="2" x1="75" y1="35" x2="75" y2="65" color="#ffffff"/>
	<gl-line width="2" x1="75" y1="65" x2="25" y2="65" color="#ffffff"/>
	<gl-line width="2" x1="25" y1="65" x2="25" y2="35" color="#ffffff"/>
     
	<ship x="20" y="20" y-velocity="0" x-velocity="0" turning-speed="10" 
	 thrust-power="0.07" moving="true"/>
	<!-- Bad guys -->
      </glarea>
    </valign>
    <timer interval="10" action="update_gl"/>
    
    <?javascript

    if (enode ("system-elements").attrib.glarea != "true") {
	valign = enode ("valign").new_child ("halign");
	label = valign.new_child ("label");
	label.attrib.text = "The GL renderer for Entity is required to play.  Please install if you wish to use this application.";
	label.attrib.expand = "true";
    }

    function update_gl (node)
    {
	glarea = enode ("glarea.main");
	nodes = glarea.children_attrib ("moving", "true");
	for (i = 0; i < nodes.length; i++) {
	    nodes[i].attrib.update="true";
	}
	enode ("glarea.main").attrib.redraw = "true";
    }

    function button_press_event (node, button, x, y)
    {
	print ("button press event", x, y, button);
    }

    function key_press_event (node, keycode, keys)
    {
	//print ("key press event", keycode, keys);
	
	switch (keycode) {
	    case "Left":
		enode ("ship").attrib["rotate-left"] = "true";
		break;
	    case "Right":
		enode ("ship").attrib["rotate-right"] = "true";
		break;
	    case "Up":
		enode ("ship").attrib["thrust"] = "true";
		break;
	    case "Control_L":
		enode ("ship").attrib["fire"] = "true";
		break;
	    case "q":
		enode ("object").call ("entity:quit");
		break;
	}
    }

    function key_release_event (node, keycode, keys)
    {
	//print ("key press event", keycode, keys);
	switch (keycode) {
	    case "Left":
		enode ("ship").attrib["rotate-left"] = "false";
		break;
	    case "Right":
		enode ("ship").attrib["rotate-right"] = "false";
		break;
	    case "Up":
		enode ("ship").attrib["thrust"] = "false";
		break;
	}
    }

    ?>
	
  </window>
</object>


