/* tcl-embed.c */
static int tcl_arg_assert(gint good, gchar *func);
static ENode *tcl_node_get_object(ENode *node);
static char *tcl_enode_create_cmd_only(Tcl_Interp *interp, ENode *node);
static int tcl_enode_create_cmd(Tcl_Interp *interp, ENode *node);
static int tcl_enode_create_cmd_list(Tcl_Interp *interp, ENode *node);
static EBuf *tcl_ebuf_from_obj(gint argnum, gint objc, Tcl_Obj *const objv[]);
static char *tcl_str_from_obj(gint argnum, gint objc, Tcl_Obj *const objv[]);
static int tcl_int_from_obj(gint argnum, gint objc, Tcl_Obj *const objv[]);
static char *tcl_str_from_ebuf(EBuf *ebuf);
static int tcl_result_append(Tcl_Interp *interp, gchar *str);
static int tcl_result_append_element(Tcl_Interp *interp, gchar *str);
static int tcl_new_child(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_type(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_path(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_basename(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_description(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_parent(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_child(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_child_rx(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_children(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_children_rx(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_children_attrib(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_children_attrib_rx(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_call(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_common(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[], EBuf *(*func)(ENode *, gchar *, EBuf *));
static int tcl_attrib(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_quiet(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_is_true(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_list_set_attribs(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_supported_attribs(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_description(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_value_type(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attrib_possible_values(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_attribs_sync(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_set_kv(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_get_kv(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_destroy(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_destroy_children(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_get_xml(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_get_child_xml(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_append_xml(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_set_data(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_get_data(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_append_data(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_insert_data(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_delete_data(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_call_from_obj(ENode *node, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_enode_obj_cmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_enode_cmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static int tcl_source_cmd(ClientData clientData, Tcl_Interp *interp, int objc, Tcl_Obj *const objv[]);
static void tcl_thread_interp_create(etcl_thread_t *thread);
static etcl_thread_t *tcl_get_thread(ENode *node);
#if TCL_MAJOR_VERSION >= 8 && TCL_MINOR_VERSION >= 1
static Tcl_Obj *tcl_new_string_obj_with_ref_count(char *str, int len);
#endif
static EBuf *tcl_execute_function(ENode *node, gchar *function, GSList *args);
static void tcl_node_render(ENode *node);
static void tcl_node_destroy(ENode *node);
void tcl_init(RendererFlags flags);
