#include <entity.h>
#include <gnome.h>
#include <applet-widget.h>
#include <gtk-common.h>

static void
rendapplet_applet_ondestroy_callback (GtkWidget *widget, gpointer * data)
{
  ENode *node = (ENode *)data;
  gchar *function = NULL;
  
  function = enode_attrib_str (node, "ondelete", NULL);
  
  enode_call(node, function, "");
}

static void rendapplet_applet_destroy (ENode *node) {
  //bah.
}

static void
rendapplet_applet_pack (ENode * parent_node, ENode * child_node)
{
  GtkWidget *applet;

  applet = enode_get_kv (parent_node, "top-widget");

  rendgtk_box_pack (parent_node, child_node);
}

static void
rendapplet_applet_render (ENode * node)
{
  GtkWidget *applet;
  GtkWidget *vbox;

  EDEBUG(("applet", "creating applet widget.."));
  applet = applet_widget_new ("blah");
  EDEBUG(("applet", "realizing applet widget.."));
  gtk_widget_realize (applet);

  EDEBUG(("applet", "creating vbox  widget.."));
  vbox = gtk_vbox_new(FALSE, 0);
  EDEBUG(("applet", "adding vbox to applet widget.."));
  applet_widget_add (APPLET_WIDGET(applet), vbox);
  EDEBUG(("applet", "showing vbox .."));
  gtk_widget_show(vbox);

  EDEBUG(("applet", "setting node keys .."));
  enode_set_kv (node, "top-widget", applet);
  enode_set_kv (node, "bottom-widget", vbox);

  EDEBUG(("applet", "connection applet widget destroy signal  .."));
  gtk_signal_connect (GTK_OBJECT (applet), "destroy", 
		      GTK_SIGNAL_FUNC (rendapplet_applet_ondestroy_callback),
		      (gpointer)node);

  EDEBUG(("applet", "synching attribs  .."));
  enode_attribs_sync (node);

  EDEBUG(("applet", "showing applet widget  .."));
  gtk_widget_show(applet);

}

void
renderer_init (RendererFlags flags)
{
  Element *element;
  ElementAttr *e_attr;
  int entity_argc;
  char **entity_argv;    

  if (flags & RENDERER_INIT) {
    entity_argc = entity_get_argc();
    entity_argv = entity_get_argv();
    applet_widget_init ( entity_argv[0], "000", entity_argc, entity_argv, NULL, 0, 0);
  }

  if (!flags & RENDERER_REGISTER)
    return;

  element = g_new0 (Element, 1);
  element->tag = "applet";
  element->render_func = rendapplet_applet_render;
  element->destroy_func = rendapplet_applet_destroy;
  element->parent_func = rendapplet_applet_pack;
  element_register (element);

  e_attr = g_new0(ElementAttr, 1);
  e_attr->attribute = "appletname";
  e_attr->description = "";
  e_attr->value_desc = "string";
  element_register_attrib (element, e_attr);

}
