<object>
  <window height="250" ondelete="entity:exit" name="wireless stats" text="Wireless Stats" border="2" >

    <timer interval = "1000" action = "update_link_bar" />
    <valign expand="true">

    <halign>
    <label name="ipaddres" xalign="1" text="IP address:"/>
    <entry name="ip" expand="false" width="75" text="0.0.0.0" />
    <button border="2" name="set" label="Set" onclick="set_ip"/>
    </halign>

    <halign>
    <label name="link label" text = "Link quality:" />
    <progress name="quality" width="75" value="0.0" show-text="true"/>
    <label name="aval" text="0" />
    </halign>

    <label border="4" xalign="0" yalign="5" text="Link quality graph:"/>
    <graph name="dist" expand="true" fill="true" />

    <label border = "5" xalign="0" name="packets" text ="Discarded packets:  nwid=0 crypt=0 misc=0" />

    </valign>
    

    <perl name="perl functions">
       my $xval=0;
       my $set=0;
       my $ip_address;
      <![CDATA[
        sub update_link_bar
          {
            #ping the current ipaddress
            if ($ip_address && $set == 1)
              {
                 `ping -c 1 -s 1 $ip_address`;
              }
            else
              {
                return;
              }
            my $progress = enode("progress.quality");

            ##open the proc file
            open QAVG, "/proc/net/wireless" || die "sorry no /proc/net/wireless";
            $firstline=<QAVG>;
            $firstline=<QAVG>;
            $firstline=<QAVG>;
            close QAVG;

            ##Capture each data item
            my @qval = split " ", $firstline;

            #find a percentage value for the progress bar
            my $actual = $qval[2]/92;

            ##Update the discarded packets
            my $packet_label=enode("label.packets");
            $packet_label->attrib("text"=>"Discarded packets:  nwid=$qval[5] crypt=$qval[6] misc=$qval[7]");

            ##Update the progress bar
            enode ("label.aval")->attrib("text" => "$qval[2]");
            $progress->attrib("value" => "$actual");

            ##Update the graph
            my $graph = enode ("graph.dist");
            my $newpoint=qq!<graph-point name="a$xval" x="$xval" y="$qval[2]" color="blue">!;
            $graph->append_xml("$newpoint");

            $xval++;

            #print "graphing point $xval\n";

            if( $xval == 2) 
              {
                my $graphpoint = enode ("graph-point.a");
                $graphpoint->destroy();
              }

            if ($xval >= 550)
              {
                my $deathpoint = $xval-550;
                my $delchild = $graph->child("graph-point.a$deathpoint");
                $delchild->destroy();
                #print ("killing point $deathpoint\n");
              }
          }

	sub set_ip
          {
            my $fentry=enode("entry.ip");
            $ip_address=$fentry->attrib("text");
            $set=1;
          }
      ]]>
    </perl>

  </window>
</object>
