#ifndef __ENODE_SEARCH_H__
#define __ENODE_SEARCH_H__

/* Quick grab versions */
ENode *enode (gchar * path);
ENode *enode_rx (gchar * regex);
GSList *elist (gchar * search);
GSList *elist_rx (gchar * regex);

/* Returns immediate parent node if search is NULL, or will search * upwards
 * * if given search string, for type[.name] */
ENode *enode_parent (ENode * node, gchar * search);

/* Search for a child by name[.type] */
/* synonymous with enode (); */
ENode *enode_child (ENode * node, gchar * search);

/* Search for a child given regex on type.name.  Returns * First correct *
 * match */
/* synonymous with enode_rx (); */
ENode *enode_child_rx (ENode * node, gchar * regex);

/* Return list of children matching name[.type] * Giving search as NULL, *
 * provides list of immediate, $ * 1st level children */
/* synonymous with elist (); */
GSList *enode_children (ENode * node, gchar * search);

/* Search through children using regex on type.name, returning * a list of *
 * those that match */
/* synonymous with elist_rx (); */
GSList *enode_children_rx (ENode * node, gchar * regex);

/* Search the tree for children who have an attribute that * matches a *
 * specific value. */
GSList *enode_children_attrib (ENode * node, gchar * attrib, EBuf * value);

/* Search the tree for children who have an attribute that * matches a regex. 
 */
GSList *enode_children_attrib_rx (ENode * node, gchar * attrib, gchar * regex);

#endif				/* __ENODE_SEARCH_H__ */


